/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.ranker.comparator;

import com.valor.common.search.engine.facade.config.ComputeExpressConfig;
import com.valor.common.search.engine.ranker.comparator.FuncNaNToZero;
import com.valor.common.search.engine.ranker.comparator.FuncNormalValue;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.SearchHit;
import org.nfunk.jep.JEP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRankerComparator
implements Comparator<SearchHit> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public abstract void appendSysParams(Map<String, Object> var1);

    public abstract void prepareByConfig(List<ComputeExpressConfig> var1);

    public abstract float computeScore(SearchHit var1);

    public float getNewScore(Map<String, Number> jepParams, String express) {
        JEP jep = new JEP();
        jep.addStandardFunctions();
        jep.addFunction("FuncNormalValue", new FuncNormalValue());
        jep.addFunction("FuncNaNToZero", new FuncNaNToZero());
        for (Map.Entry<String, Number> entry : jepParams.entrySet()) {
            jep.addVariable(entry.getKey().toString(), entry.getValue());
        }
        jep.addStandardConstants();
        jep.parseExpression(express);
        if (!jep.hasError()) {
            Float ret;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("value:" + jep.getValue());
            }
            if ((ret = Float.valueOf((float)jep.getValue())).isNaN()) {
                return 0.0f;
            }
            return (float)jep.getValue();
        }
        throw new RuntimeException("eval new score   express error ", jep.getParser().generateParseException());
    }
}

