/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import org.lsmp.djep.vectorJep.VectorJep;
import org.lsmp.djepExamples.Console;

public class VectorConsole
extends Console {
    private static final long serialVersionUID = -2335406063822614650L;

    public static void main(String[] args) {
        VectorConsole c = new VectorConsole();
        c.run(args);
    }

    @Override
    public String getPrompt() {
        return "VectorJep > ";
    }

    @Override
    public void initialise() {
        this.j = new VectorJep();
        this.j.addStandardConstants();
        this.j.addStandardFunctions();
        this.j.addComplex();
        this.j.setAllowAssignment(true);
        this.j.setAllowUndeclared(true);
        this.j.setImplicitMul(true);
    }

    @Override
    public void printHelp() {
        super.printHelp();
        this.println("Dot product: [1,2,3].[4,5,6]");
        this.println("Cross product: [1,2,3]^^[4,5,6]");
        this.println("Matrix Multiplication: [[1,2],[3,4]]*[[1,2],[3,4]]");
        this.println("setEleMult: sets element by element mode for multiplication");
        this.println("setMatrixMult: sets matrix multiplication");
    }

    @Override
    public void printIntroText() {
        this.println("VectorJep: matrix and vector calculations in Jep");
        this.println("eg. [1,2,3].[4,5,6] [[1,2],[3,4]]*[1,0]");
        this.printStdHelp();
    }

    @Override
    public boolean testSpecialCommands(String command) {
        if (command.equals("setEleMult")) {
            ((VectorJep)this.j).setElementMultiply(true);
            return false;
        }
        if (command.equals("setMatrixMult")) {
            ((VectorJep)this.j).setElementMultiply(true);
            return false;
        }
        return true;
    }
}

