/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.facade;

import com.alibaba.fastjson.JSONArray;
import com.valor.common.search.engine.DefaultSearcher;
import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.SearchApiException;
import com.valor.common.search.engine.compensator.AbstractCompensator;
import com.valor.common.search.engine.compensator.Compensator;
import com.valor.common.search.engine.facade.config.BizConfig;
import com.valor.common.search.engine.facade.config.CompensatorConfig;
import com.valor.common.search.engine.facade.config.HighlightConfig;
import com.valor.common.search.engine.facade.config.InLineScoreRankerConfig;
import com.valor.common.search.engine.facade.config.InlineFilterConfig;
import com.valor.common.search.engine.facade.config.MatcherConfig;
import com.valor.common.search.engine.facade.config.PostRankerConfig;
import com.valor.common.search.engine.facade.config.TakeResultHandlerConfig;
import com.valor.common.search.engine.filter.GeneralFilter;
import com.valor.common.search.engine.filter.InlineFilter;
import com.valor.common.search.engine.handler.TakeResultHandler;
import com.valor.common.search.engine.matcher.AbstractMatcher;
import com.valor.common.search.engine.ranker.AbstractInlineScoreRanker;
import com.valor.common.search.engine.ranker.AbstractPostScoreRanker;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.StringUtils;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.RestHighLevelClient;

public class BizContainerBuilder {
    private RestHighLevelClient elasticSearchClient;
    private Map<String, Object> bizSysConfig = new HashMap<String, Object>();
    private String bizBuilderConfig = "";
    private Map<String, BizBuilder> bizBuilderMap = new HashMap<String, BizBuilder>();

    private BizContainerBuilder() {
    }

    public static BizContainerBuilder newInstance(Map<String, Object> bizSysConfig, RestHighLevelClient esClient) {
        return BizContainerBuilder.newInstance(BizContainerBuilder.readAllLines("/search-engine-app-config.json"), bizSysConfig, esClient);
    }

    public static BizContainerBuilder newInstance(String bizBuilderConfig, Map<String, Object> bizSysConfig, RestHighLevelClient esClient) {
        BizContainerBuilder instance = new BizContainerBuilder();
        instance.bizSysConfig.putAll(bizSysConfig);
        instance.bizBuilderConfig = bizBuilderConfig;
        instance.elasticSearchClient = esClient;
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readAllLines(String resource) {
        try (DataInputStream fin = new DataInputStream(BizContainerBuilder.class.getResourceAsStream(resource));){
            StringBuffer stringBuffer = new StringBuffer();
            String str = fin.readLine();
            while (str != null) {
                stringBuffer.append(str);
                str = fin.readLine();
            }
            String string = stringBuffer.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("read search-engine-app-config information failed!", e);
        }
    }

    public DefaultSearcher build(String bizName, String keywords, int fromIndex, int pageSize) {
        List bizConfigList = JSONArray.parseArray((String)this.bizBuilderConfig, BizConfig.class);
        for (BizConfig bizConfig : bizConfigList) {
            if (!bizConfig.getBizName().equalsIgnoreCase(bizName)) continue;
            BizBuilder bizBuilder = new BizBuilder();
            this.bizBuilderMap.put(bizName, bizBuilder);
            return bizBuilder.build(keywords, fromIndex, pageSize, bizConfig);
        }
        return null;
    }

    private class BizBuilder {
        private String bizName = "";
        private int fromIndex = 0;
        private int pageSize = 50;
        private RequestContext context;
        private BizConfig bizConfig;
        private Map<String, AbstractMatcher> hasBuildMatcherMap = new HashMap<String, AbstractMatcher>();
        private Map<String, AbstractPostScoreRanker> hasBuildPostRankerMap = new HashMap<String, AbstractPostScoreRanker>();
        private Map<String, AbstractInlineScoreRanker> hasBuildInLineScoreRankerMap = new HashMap<String, AbstractInlineScoreRanker>();
        private Map<String, InlineFilter> hasBuildInInLineFilterMap = new HashMap<String, InlineFilter>();
        private Map<String, Compensator> hasBuildCompensatorMap = new HashMap<String, Compensator>();

        private BizBuilder() {
        }

        public DefaultSearcher build(String keywords, int fromIndex, int pageSize, BizConfig bizConfig) {
            List<String> includeFields;
            List<String> excludeFields;
            HighlightConfig highlightConfig;
            this.fromIndex = fromIndex;
            this.pageSize = pageSize;
            DefaultSearcher defaultSearcher = new DefaultSearcher(BizContainerBuilder.this.elasticSearchClient, BizContainerBuilder.this.bizSysConfig.get("indexName").toString());
            this.context = defaultSearcher.prepareRequestContext(keywords, BizContainerBuilder.this.bizSysConfig.get("matchMainIndexFieldName").toString(), this.fromIndex, this.pageSize);
            this.bizConfig = bizConfig;
            this.bizName = bizConfig.getBizName();
            this.context.setBizSysConfig(BizContainerBuilder.this.bizSysConfig);
            int matcherFuzzyTermLetterLimit = Integer.parseInt(((Object)BizContainerBuilder.this.bizSysConfig.getOrDefault("matcherFuzzyTermLetterLimit", 20)).toString());
            int matcherWordTermLetterLimit = (int)((float)matcherFuzzyTermLetterLimit * 1.5f);
            int matcherSentenceLetterLimit = Integer.parseInt(((Object)BizContainerBuilder.this.bizSysConfig.getOrDefault("matcherSentenceLetterLimit", 512)).toString());
            if (!CollectionUtils.isEmpty(bizConfig.getMatchers())) {
                for (MatcherConfig matcherConfig : bizConfig.getMatchers()) {
                    AbstractMatcher matcher = this.buildMatcher(matcherConfig);
                    this.hasBuildMatcherMap.put(matcherConfig.getIdName(), matcher);
                    defaultSearcher.matcher(matcher);
                }
            } else {
                throw new SearchApiException("Matcher is empty in app-config ");
            }
            if (!CollectionUtils.isEmpty(this.hasBuildMatcherMap) && !CollectionUtils.isEmpty(this.hasBuildMatcherMap.values())) {
                for (AbstractMatcher matcher : this.hasBuildMatcherMap.values()) {
                    if (CollectionUtils.isEmpty(matcher.getMatcherConfig().getExclude())) continue;
                    for (String excludeMatcherName : matcher.getMatcherConfig().getExclude()) {
                        if (this.hasBuildMatcherMap.get(excludeMatcherName) == null) continue;
                        matcher.exclude(this.hasBuildMatcherMap.get(excludeMatcherName));
                    }
                }
            }
            if (!CollectionUtils.isEmpty(bizConfig.getPostRankers())) {
                for (PostRankerConfig postRankerConfig : bizConfig.getPostRankers()) {
                    AbstractPostScoreRanker abstractPostScoreRanker = this.buildPostRanker(postRankerConfig);
                    abstractPostScoreRanker.setBizSysConfig(BizContainerBuilder.this.bizSysConfig);
                    this.hasBuildPostRankerMap.put(postRankerConfig.getIdName(), abstractPostScoreRanker);
                    defaultSearcher.ranker(abstractPostScoreRanker);
                }
            }
            if (!CollectionUtils.isEmpty(bizConfig.getInLineScoreRankers())) {
                for (InLineScoreRankerConfig inLineScoreRankerConfig : bizConfig.getInLineScoreRankers()) {
                    AbstractInlineScoreRanker abstractInlineScoreRanker = this.buildInlineScoreRanker(inLineScoreRankerConfig);
                    this.hasBuildInLineScoreRankerMap.put(inLineScoreRankerConfig.getIdName(), abstractInlineScoreRanker);
                    defaultSearcher.ranker(abstractInlineScoreRanker);
                }
            }
            if (!CollectionUtils.isEmpty(bizConfig.getFilters())) {
                for (InlineFilterConfig inLintFilterConfig : bizConfig.getFilters()) {
                    InlineFilter inlineFilter = this.buildInlineFilters(inLintFilterConfig);
                    this.hasBuildInInLineFilterMap.put(inlineFilter.getFilterName(), inlineFilter);
                    if (inlineFilter instanceof GeneralFilter) {
                        GeneralFilter filter = (GeneralFilter)inlineFilter;
                        filter.prepareByConfig(inLintFilterConfig);
                    }
                    defaultSearcher.fillter(inlineFilter);
                }
            }
            if (!CollectionUtils.isEmpty(bizConfig.getCompensators())) {
                for (CompensatorConfig compensatorConfig : bizConfig.getCompensators()) {
                    AbstractCompensator compensator = this.buildCompensater(compensatorConfig);
                    this.hasBuildCompensatorMap.put(compensator.getName(), compensator);
                    defaultSearcher.compensator(compensator);
                }
            }
            if (bizConfig.getTakeResultHandler() != null) {
                TakeResultHandler takeResultHandler = this.buildTakeResaultHandler(bizConfig.getTakeResultHandler());
                takeResultHandler.setWantedSize(pageSize);
                defaultSearcher.addHandler(takeResultHandler);
            }
            if ((highlightConfig = bizConfig.getHighlight()) != null) {
                String openHighlight = BizContainerBuilder.this.bizSysConfig.getOrDefault("openHighlight", "").toString().trim();
                if ("true".equalsIgnoreCase(openHighlight)) {
                    defaultSearcher.enableHighlight();
                } else if ("false".equalsIgnoreCase(openHighlight)) {
                    defaultSearcher.disableHighlight();
                } else if (highlightConfig.isEnable()) {
                    defaultSearcher.enableHighlight();
                } else {
                    defaultSearcher.disableHighlight();
                }
                this.context.setHighlightExtFieldNameSuffix(highlightConfig.getExtFieldNameSuffix());
                HashSet bizSysHighLightFieldNames = new HashSet(JSONArray.parseArray((String)BizContainerBuilder.this.bizSysConfig.getOrDefault("highlightFieldsName", "[]").toString(), String.class));
                ArrayList<HighlightConfig.HighlightItemConfig> bizSysHighLightConfig = new ArrayList<HighlightConfig.HighlightItemConfig>();
                for (String fieldName : bizSysHighLightFieldNames) {
                    boolean found = false;
                    for (HighlightConfig.HighlightItemConfig highLightItemConfig : highlightConfig.getHighlightFieldNames()) {
                        if (!highLightItemConfig.getField().equalsIgnoreCase(fieldName)) continue;
                        found = true;
                    }
                    if (found) continue;
                    bizSysHighLightConfig.add(new HighlightConfig.HighlightItemConfig(fieldName, "unified"));
                }
                bizSysHighLightConfig.addAll(highlightConfig.getHighlightFieldNames());
                this.context.setHighLightItemConfigList(bizSysHighLightConfig);
                String highLightPreTag = highlightConfig.getPreTag();
                String highLightPostTag = highlightConfig.getPostTag();
                highLightPreTag = BizContainerBuilder.this.bizSysConfig.getOrDefault("highlightPreTag", highLightPreTag).toString();
                highLightPostTag = BizContainerBuilder.this.bizSysConfig.getOrDefault("highlightPostTag", highLightPostTag).toString();
                this.context.setHighlightPreTag(highLightPreTag);
                this.context.setHighlightPostTag(highLightPostTag);
                this.context.setDefaultHighlightType(highlightConfig.getDefaultType());
            }
            if (!CollectionUtils.isEmpty(excludeFields = bizConfig.getSourceField().get("exclude"))) {
                defaultSearcher.excludeSourceField((String[])excludeFields.stream().toArray(String[]::new));
            }
            if (!CollectionUtils.isEmpty(includeFields = bizConfig.getSourceField().get("include"))) {
                defaultSearcher.includeSourceField((String[])includeFields.stream().toArray(String[]::new));
            }
            return defaultSearcher;
        }

        private InlineFilter buildInlineFilters(InlineFilterConfig config) {
            InlineFilter filter = null;
            if (StringUtils.isEmpty(config.getFullClassName())) {
                throw new RuntimeException("InlineFilter class name must not empty!");
            }
            try {
                Class<?> clz = Class.forName(config.getFullClassName());
                filter = (InlineFilter)clz.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            return filter;
        }

        private AbstractInlineScoreRanker buildInlineScoreRanker(InLineScoreRankerConfig config) {
            AbstractInlineScoreRanker abstractInlineScoreRanker = null;
            if (StringUtils.isEmpty(config.getFullClassName())) {
                throw new RuntimeException("InLineScoreRanker class name must not empty!");
            }
            try {
                Class<?> clz = Class.forName(config.getFullClassName());
                abstractInlineScoreRanker = (AbstractInlineScoreRanker)clz.newInstance();
                abstractInlineScoreRanker.setContext(this.context);
                abstractInlineScoreRanker.prepareByConfig(config);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            return abstractInlineScoreRanker;
        }

        private TakeResultHandler buildTakeResaultHandler(TakeResultHandlerConfig config) {
            TakeResultHandler takeResultHandler = null;
            if (StringUtils.isEmpty(config.getFullClassName())) {
                throw new RuntimeException("TakeResultHandler class name must not empty!");
            }
            try {
                Class<?> clz = Class.forName(config.getFullClassName());
                takeResultHandler = (TakeResultHandler)clz.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            return takeResultHandler;
        }

        private AbstractPostScoreRanker buildPostRanker(PostRankerConfig config) {
            AbstractPostScoreRanker abstractPostScoreRanker = null;
            if (StringUtils.isEmpty(config.getFullClassName())) {
                throw new RuntimeException("PostRanker class name must not empty!");
            }
            try {
                Class<?> clz = Class.forName(config.getFullClassName());
                abstractPostScoreRanker = (AbstractPostScoreRanker)clz.newInstance();
                abstractPostScoreRanker.setContext(this.context);
                abstractPostScoreRanker.prepareByConfig(config);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            return abstractPostScoreRanker;
        }

        private AbstractMatcher buildMatcher(MatcherConfig config) {
            if (StringUtils.isEmpty(config.getFullClassName())) {
                throw new RuntimeException("matcher class name must not empty!");
            }
            AbstractMatcher matcher = null;
            try {
                Class<?> clz = Class.forName(config.getFullClassName());
                matcher = (AbstractMatcher)clz.newInstance();
                matcher.setContext(this.context);
                matcher.prepareByConfig(config);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            return matcher;
        }

        private AbstractCompensator buildCompensater(CompensatorConfig config) {
            if (StringUtils.isEmpty(config.getFullClassName())) {
                throw new RuntimeException("matcher class name must not empty!");
            }
            AbstractCompensator compensater = null;
            try {
                Class<?> clz = Class.forName(config.getFullClassName());
                compensater = (AbstractCompensator)clz.newInstance();
                compensater.setContext(this.context);
                compensater.prepareByConfig(config);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            return compensater;
        }
    }
}

