/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.facade;

import com.alibaba.fastjson.JSONObject;
import com.valor.common.search.engine.DefaultSearcher;
import com.valor.common.search.engine.HighlightFieldInfo;
import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.SearchApiException;
import com.valor.common.search.engine.SearchApiResponse;
import com.valor.common.search.engine.WrappedSearchResponse;
import com.valor.common.search.engine.aggs.TermsAggregation;
import com.valor.common.search.engine.facade.BizContainerBuilder;
import com.valor.common.search.engine.facade.Condition;
import com.valor.common.search.engine.facade.FuzzinessQueryMode;
import com.valor.common.search.engine.facade.Statistics;
import com.valor.common.search.engine.filter.CompositeFilter;
import com.valor.common.search.engine.filter.Filter;
import com.valor.common.search.engine.filter.FilterFuncEnum;
import com.valor.common.search.engine.filter.GeneralFilter;
import com.valor.common.search.engine.filter.InlineFilter;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.SearchUtils;
import com.valor.common.search.engine.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.keyvalue.DefaultKeyValue;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeliplatBizFacade {
    private static ExecutorService allSearchExecPool = null;
    private final RestHighLevelClient esClient;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Logger highlightLogger = LoggerFactory.getLogger((String)"HighlightLogger");

    public PeliplatBizFacade(RestHighLevelClient esClient) {
        this.esClient = esClient;
    }

    @Deprecated
    private Map<String, List<String>> readHighlightData(SearchHit hit, String preTag, String postTag) throws SearchApiException {
        try {
            Pattern pattern = Pattern.compile(preTag + postTag);
            Map highLightFieldMap = hit.getHighlightFields();
            HashMap<String, List<String>> itemMap = new HashMap<String, List<String>>();
            for (Map.Entry entry : highLightFieldMap.entrySet()) {
                ArrayList<String> content = new ArrayList<String>();
                for (Text t : ((HighlightField)entry.getValue()).getFragments()) {
                    String s = t.toString();
                    Matcher matcher = pattern.matcher(s);
                    while (matcher.find()) {
                        s = s.replaceAll(matcher.group(), "");
                    }
                    content.add(s);
                }
                itemMap.put((String)entry.getKey(), (List<String>)content);
            }
            return itemMap;
        }
        catch (Exception e) {
            throw new SearchApiException("Read elasticsearch data error.", e);
        }
    }

    private Map<Integer, List<String>> readMatcherQueries(WrappedSearchResponse wrappedResponse, int fromIndex, int length) {
        HashMap<Integer, List<String>> matcherQueriesMap = new HashMap<Integer, List<String>>();
        for (int index = fromIndex; index < fromIndex + length; ++index) {
            SearchHit hit = wrappedResponse.getHits().getHits()[index];
            matcherQueriesMap.put(index - fromIndex, CollectionUtils.arrayToList(hit.getMatchedQueries()));
        }
        return matcherQueriesMap;
    }

    private List<HighlightFieldInfo> covertHighlightInfo(SearchHit hit, String postTags, String preTags, RequestContext context, List<String> bizHighlightFieldNames) {
        ArrayList<HighlightFieldInfo> highlightList = new ArrayList<HighlightFieldInfo>();
        Map<String, Set<String>> querySentenceMatchedFieldNamesMap = context.getQuerySentenceMatchedFieldNamesMap();
        HashSet<String> matchedFieldNameSet = new HashSet<String>();
        for (String queriesName : hit.getMatchedQueries()) {
            Set<String> currentQueriesNameMatchedFieldNameSet = querySentenceMatchedFieldNamesMap.get(queriesName);
            if (currentQueriesNameMatchedFieldNameSet == null) continue;
            matchedFieldNameSet.addAll(currentQueriesNameMatchedFieldNameSet);
        }
        highlightList.addAll(this.execFindHighlightSourceFieldInfo(hit, matchedFieldNameSet, preTags, postTags, bizHighlightFieldNames));
        return new ArrayList<HighlightFieldInfo>(highlightList);
    }

    private List<HighlightFieldInfo> execFindHighlightSourceFieldInfo(SearchHit hit, Set<String> matchedFieldNameSet, String preTags, String postTags, List<String> bizHighlightFieldNames) {
        LinkedHashSet<HighlightFieldInfo> highlightList = new LinkedHashSet<HighlightFieldInfo>();
        Map highlightFieldMap = hit.getHighlightFields();
        for (Map.Entry entry : highlightFieldMap.entrySet()) {
            if (!matchedFieldNameSet.contains(entry.getKey())) continue;
            HighlightField item = (HighlightField)entry.getValue();
            boolean hitBizField = bizHighlightFieldNames.contains(item.getName());
            if (hitBizField) {
                for (Text highlightText : item.getFragments()) {
                    for (String fieldName : bizHighlightFieldNames) {
                        if (!item.getName().equalsIgnoreCase(fieldName)) continue;
                        Set<HighlightFieldInfo> curHitHighlightFieldInfos = this.findHighlightSourceByHitItem(hit, fieldName, true, highlightText, postTags, preTags, (String)entry.getKey());
                        if (CollectionUtils.isEmpty(curHitHighlightFieldInfos)) {
                            curHitHighlightFieldInfos = this.findHighlightSourceByHitItem(hit, fieldName, false, highlightText, postTags, preTags, (String)entry.getKey());
                        }
                        highlightList.addAll(curHitHighlightFieldInfos);
                    }
                }
                continue;
            }
            LinkedHashSet<HighlightFieldInfo> curHitHighlightFieldInfos = new LinkedHashSet<HighlightFieldInfo>();
            for (Text highlightText : item.getFragments()) {
                for (String fieldName : bizHighlightFieldNames) {
                    curHitHighlightFieldInfos.addAll(this.findHighlightSourceByHitItem(hit, fieldName, true, highlightText, postTags, preTags, (String)entry.getKey()));
                }
            }
            if (CollectionUtils.isEmpty(curHitHighlightFieldInfos)) {
                for (Text highlightText : item.getFragments()) {
                    for (String fieldName : bizHighlightFieldNames) {
                        curHitHighlightFieldInfos.addAll(this.findHighlightSourceByHitItem(hit, fieldName, false, highlightText, postTags, preTags, (String)entry.getKey()));
                    }
                }
            }
            highlightList.addAll(curHitHighlightFieldInfos);
        }
        return new ArrayList<HighlightFieldInfo>(highlightList);
    }

    private Set<HighlightFieldInfo> findHighlightSourceByHitItem(SearchHit hit, String sourceFieldName, boolean extractMatch, Text highlightText, String postTags, String preTags, String highlightedFieldName) {
        Object obj = hit.getSourceAsMap().get(sourceFieldName);
        String highlightSourceText = highlightText.toString().replaceAll(preTags, "").replaceAll(postTags, "");
        String mergedHighlightTagText = highlightText.toString().replaceAll(postTags + preTags, "");
        LinkedHashSet<HighlightFieldInfo> highlightList = new LinkedHashSet<HighlightFieldInfo>();
        if (obj instanceof List) {
            List targetFieldValues = (List)obj;
            for (int index = 0; index < targetFieldValues.size(); ++index) {
                HighlightFieldInfo highLightFieldInfo;
                if (extractMatch && ((String)targetFieldValues.get(index)).trim().equalsIgnoreCase(highlightSourceText)) {
                    highLightFieldInfo = new HighlightFieldInfo(sourceFieldName, mergedHighlightTagText, index, highlightSourceText, highlightedFieldName);
                    highlightList.add(highLightFieldInfo);
                    continue;
                }
                if (extractMatch || ((String)targetFieldValues.get(index)).trim().indexOf(highlightSourceText) < 0) continue;
                try {
                    highLightFieldInfo = new HighlightFieldInfo(sourceFieldName, ((String)targetFieldValues.get(index)).replaceAll(highlightSourceText, mergedHighlightTagText), index, highlightSourceText, highlightedFieldName);
                    highlightList.add(highLightFieldInfo);
                    continue;
                }
                catch (Exception e) {
                    HighlightFieldInfo highLightFieldInfo2 = new HighlightFieldInfo(sourceFieldName, ((String)targetFieldValues.get(index)).replace(highlightSourceText, mergedHighlightTagText), index, highlightSourceText, highlightedFieldName);
                    highlightList.add(highLightFieldInfo2);
                }
            }
        } else {
            String targetFieldValue = (String)obj;
            if (extractMatch && targetFieldValue.trim().equalsIgnoreCase(highlightSourceText)) {
                HighlightFieldInfo highLightFieldInfo = new HighlightFieldInfo(sourceFieldName, mergedHighlightTagText, 0, highlightSourceText, highlightedFieldName);
                highlightList.add(highLightFieldInfo);
            } else if (!extractMatch && targetFieldValue.trim().indexOf(highlightSourceText) >= 0) {
                HighlightFieldInfo highLightFieldInfo = new HighlightFieldInfo(sourceFieldName, mergedHighlightTagText, 0, highlightSourceText, highlightedFieldName);
                highlightList.add(highLightFieldInfo);
            }
        }
        return highlightList;
    }

    private List<HighlightFieldInfo> fineTunningHighLight(List<HighlightFieldInfo> highLightFieldInfos, RequestContext context) {
        String qStr = context.getQ();
        ArrayList words = new ArrayList(CollectionUtils.arrayToList(qStr.toLowerCase().trim().split("([\\s\\p{Zs}])+")));
        Pattern pattern = Pattern.compile(context.getHighlightPreTag() + ".*." + context.getHighlightPostTag());
        ArrayList<DefaultKeyValue> willSortList = new ArrayList<DefaultKeyValue>();
        for (HighlightFieldInfo mItem : highLightFieldInfos) {
            String hitText = mItem.getHitText();
            Matcher matcher = pattern.matcher(mItem.getHitText().toLowerCase());
            String finalHitText = mItem.getHitText();
            int wordFound = 0;
            while (matcher.find()) {
                Boolean removed;
                while ((removed = Boolean.valueOf(words.remove(matcher.group().replaceAll(context.getHighlightPostTag(), "").replaceAll(context.getHighlightPreTag(), "").trim().toLowerCase()))).booleanValue()) {
                    ++wordFound;
                }
            }
            willSortList.add(new DefaultKeyValue((Object)wordFound, (Object)mItem));
        }
        willSortList.sort((a, b) -> {
            int bKey;
            int aKey = (Integer)a.getKey();
            if (aKey == (bKey = ((Integer)b.getKey()).intValue())) {
                return 0;
            }
            if (aKey > bKey) {
                return 1;
            }
            return -1;
        });
        HighlightFieldInfo topHitScoreItem = (HighlightFieldInfo)((DefaultKeyValue)willSortList.get(0)).getValue();
        ArrayList<HighlightFieldInfo> finalHighLightInfos = new ArrayList<HighlightFieldInfo>(highLightFieldInfos);
        finalHighLightInfos.remove(topHitScoreItem);
        finalHighLightInfos.add(0, topHitScoreItem);
        return finalHighLightInfos;
    }

    private <T> SearchApiResponse<T> readRespData(WrappedSearchResponse wrappedResponse, int fromIndex, int dataSize, Class<T> indexDataClazz, RequestContext context, List<String> highLightFieldNameFromBizConfig, Map<String, Object> bizSysConfig) throws SearchApiException {
        try {
            SearchApiResponse apiResponse = new SearchApiResponse();
            List bizHighlightFieldNames = CollectionUtils.arrayToList(bizSysConfig.getOrDefault("search.engine.highlight-fields-name", "title,keywords").toString().split(","));
            apiResponse.setHitTotal(SearchUtils.getTotalHitsSize(wrappedResponse.getHits()));
            apiResponse.setTookTime(wrappedResponse.getTook().getMillis());
            apiResponse.setHitCount(wrappedResponse.getHits().getHits().length);
            String postTag = context.getHighlightPostTag();
            String preTag = context.getHighlightPreTag();
            LinkedHashMap originalHighlightMap = new LinkedHashMap();
            for (int index = fromIndex; index < fromIndex + dataSize; ++index) {
                SearchHit hit = wrappedResponse.getHits().getHits()[index];
                Map sourceMap = hit.getSourceAsMap();
                sourceMap.put("docId", hit.getId());
                sourceMap.put("score", Float.valueOf(hit.getScore()));
                sourceMap.put("matcherQueries", hit.getMatchedQueries());
                List<HighlightFieldInfo> highlightList = this.covertHighlightInfo(hit, postTag, preTag, context, bizHighlightFieldNames);
                this.readBizHighlightExtInfo(hit, highlightList, context);
                sourceMap.put("highlight", highlightList);
                Object item = JSONObject.parseObject((String)JSONObject.toJSONString((Object)sourceMap), indexDataClazz);
                apiResponse.getSource().add(item);
                if (!this.highlightLogger.isDebugEnabled()) continue;
                ArrayList highlightFields = new ArrayList(hit.getHighlightFields().size());
                for (Map.Entry highlightFieldEntry : hit.getHighlightFields().entrySet()) {
                    HashMap itemMap = new HashMap();
                    itemMap.put(highlightFieldEntry.getKey(), highlightFieldEntry.getValue());
                    highlightFields.add(itemMap);
                }
                originalHighlightMap.put(hit.getId(), highlightFields);
            }
            if (this.highlightLogger.isDebugEnabled()) {
                apiResponse.putAttatchment("highlightFields", originalHighlightMap);
            }
            return apiResponse;
        }
        catch (Exception e) {
            throw new SearchApiException("Read elasticsearch data error.", e);
        }
    }

    private void readBizHighlightExtInfo(SearchHit hit, List<HighlightFieldInfo> highlightList, RequestContext context) {
        for (HighlightFieldInfo highlightFieldInfo : highlightList) {
            if (hit.getSourceAsMap().get(highlightFieldInfo.getHitFieldName()) instanceof List) {
                List extFieldList = hit.getSourceAsMap().getOrDefault(highlightFieldInfo.getHitFieldName() + context.getHighlightExtFieldNameSuffix(), new ArrayList());
                if (extFieldList.size() < highlightFieldInfo.getHitIndex() + 1) continue;
                String extInfo = (String)extFieldList.get(highlightFieldInfo.getHitIndex());
                highlightFieldInfo.setExtInfo(extInfo);
                continue;
            }
            highlightFieldInfo.setExtInfo(hit.getSourceAsMap().getOrDefault(highlightFieldInfo.getHitFieldName() + context.getHighlightExtFieldNameSuffix(), "").toString());
        }
    }

    public <T> SearchApiResponse<T> matchSearch(int pageId, int pageSize, String keyword, List<String> marks, Class<T> indexDataClazz, Map<String, Object> bizSysConfig, List<Condition> excludeConditions, FuzzinessQueryMode fuzzinessQueryMode, boolean withTagCount) {
        SearchApiResponse<T> searchApiResponse = null;
        String bizName = "peliplat-search";
        if (marks.size() == 0 || marks.contains("all")) {
            try {
                if (pageId * pageSize > 100) {
                    return new SearchApiResponse();
                }
                searchApiResponse = this.matchSearchForUGCALL(pageId, keyword, pageSize, marks, indexDataClazz, bizSysConfig, excludeConditions, bizName);
            }
            catch (Exception e) {
                this.logger.error("Search params: pageId=" + pageId + "  pageSize=" + pageSize + "  keyword=" + keyword + "  marks=" + marks);
                this.logger.error(e.getMessage());
                throw new SearchApiException(e);
            }
        } else {
            searchApiResponse = this.matchSearchImpl(pageId, pageSize, keyword, marks, indexDataClazz, bizSysConfig, excludeConditions, bizName, fuzzinessQueryMode);
        }
        return searchApiResponse;
    }

    private <T> SearchApiResponse<T> matchSearchForUGCALL(int pageId, String keyword, int pageSize, List<String> marks, Class<T> indexDataClazz, Map<String, Object> bizSysConfig, List<Condition> excludeConditions, String bizName) throws ExecutionException, InterruptedException, NoSuchFieldException {
        bizSysConfig.put("fixPageSize", 100);
        SearchWork<T> metaSearchWork = new SearchWork<T>(1, 100, keyword, "meta", indexDataClazz, bizSysConfig, excludeConditions, bizName);
        SearchWork<T> articleSearchWork = new SearchWork<T>(1, 30, keyword, "article", indexDataClazz, bizSysConfig, excludeConditions, bizName);
        SearchWork<T> videoSearchWork = new SearchWork<T>(1, 30, keyword, "video", indexDataClazz, bizSysConfig, excludeConditions, bizName);
        SearchWork<T> userSearchWork = new SearchWork<T>(1, 30, keyword, "user", indexDataClazz, bizSysConfig, excludeConditions, bizName);
        Future<SearchApiResponse> meaSearchWorkFuture = allSearchExecPool.submit(metaSearchWork);
        Future<SearchApiResponse> articleSearchWorkFuture = allSearchExecPool.submit(articleSearchWork);
        Future<SearchApiResponse> videoSearchWorkFuture = allSearchExecPool.submit(videoSearchWork);
        Future<SearchApiResponse> userSearchWorkFuture = allSearchExecPool.submit(userSearchWork);
        SearchApiResponse metaResult = meaSearchWorkFuture.get();
        SearchApiResponse articleResult = articleSearchWorkFuture.get();
        SearchApiResponse videoResult = videoSearchWorkFuture.get();
        SearchApiResponse userResult = userSearchWorkFuture.get();
        List<WrapResponseItem<T>> metaList = this.wrap(metaResult);
        List<WrapResponseItem<T>> ugcList = this.reSortList(articleResult, videoResult, userResult);
        List<WrapResponseItem<T>> articleList = this.reSortList(articleResult);
        ArrayList finalList = new ArrayList();
        ArrayList<WrapResponseItem<T>> top3ArticleList = new ArrayList<WrapResponseItem<T>>();
        ArrayList<WrapResponseItem<T>> top7MetaList = new ArrayList<WrapResponseItem<T>>();
        ArrayList<WrapResponseItem<T>> top5UgcList = new ArrayList<WrapResponseItem<T>>();
        ArrayList<WrapResponseItem<T>> tailList = new ArrayList<WrapResponseItem<T>>();
        for (int pageIndex = 0; pageIndex < pageId; ++pageIndex) {
            int i;
            int i2;
            top3ArticleList = new ArrayList();
            for (i2 = 0; i2 < 3 && i2 < articleList.size(); ++i2) {
                top3ArticleList.add(articleList.get(i2));
            }
            articleList.removeAll(top3ArticleList);
            ugcList.removeAll(top3ArticleList);
            top7MetaList = new ArrayList();
            for (i2 = 0; i2 < 7 && i2 < metaList.size(); ++i2) {
                top7MetaList.add(metaList.get(i2));
            }
            metaList.removeAll(top7MetaList);
            top5UgcList = new ArrayList();
            for (i2 = 0; i2 < 5 && i2 < ugcList.size(); ++i2) {
                top5UgcList.add(ugcList.get(i2));
            }
            ugcList.removeAll(top5UgcList);
            articleList.removeAll(top5UgcList);
            tailList = new ArrayList();
            for (i2 = 0; i2 < 5 && i2 < metaList.size(); ++i2) {
                tailList.add(metaList.get(i2));
            }
            metaList.removeAll(tailList);
            int tailSize = pageSize - top7MetaList.size() - top3ArticleList.size() - top5UgcList.size() - tailList.size();
            for (i = 0; i < tailSize && i < metaList.size(); ++i) {
                tailList.add(metaList.get(i));
            }
            metaList.removeAll(tailList);
            tailSize = pageSize - top7MetaList.size() - top3ArticleList.size() - top5UgcList.size() - tailList.size();
            for (i = 0; i < tailSize && i < ugcList.size(); ++i) {
                tailList.add(ugcList.get(i));
            }
            articleList.removeAll(tailList);
            ugcList.removeAll(tailList);
        }
        finalList.addAll(top7MetaList);
        finalList.addAll(top3ArticleList);
        finalList.addAll(top5UgcList);
        finalList.addAll(tailList);
        SearchApiResponse searchApiResponse = new SearchApiResponse();
        searchApiResponse.setHitCount(finalList.size());
        LinkedHashSet finalSourceSet = new LinkedHashSet();
        for (WrapResponseItem item : finalList) {
            finalSourceSet.add(item.getObj());
        }
        searchApiResponse.setSource(finalSourceSet);
        searchApiResponse.setHitTotal(metaResult.getHitTotal() + articleResult.getHitTotal() + videoResult.getHitTotal() + userResult.getHitTotal());
        long tookTime = 0L;
        tookTime = metaResult.getTookTime() > tookTime ? metaResult.getTookTime() : tookTime;
        tookTime = articleResult.getTookTime() > tookTime ? metaResult.getTookTime() : tookTime;
        tookTime = videoResult.getTookTime() > tookTime ? metaResult.getTookTime() : tookTime;
        tookTime = userResult.getTookTime() > tookTime ? metaResult.getTookTime() : tookTime;
        searchApiResponse.setTookTime(tookTime);
        return searchApiResponse;
    }

    private <T> List<WrapResponseItem<T>> reSortList(SearchApiResponse<T> ... targetSets) throws NoSuchFieldException {
        ArrayList sameWordRankedList = new ArrayList();
        ArrayList sameWordLowCreditRankedList = new ArrayList();
        ArrayList otherRankedList = new ArrayList();
        ArrayList<WrapResponseItem<T>> sortedItemList = new ArrayList<WrapResponseItem<T>>();
        for (SearchApiResponse<T> set : targetSets) {
            for (Object obj : set.getSource()) {
                Object objRankerType = SearchUtils.getObject(obj, "rankerType");
                Object objNewScore = SearchUtils.getObject(obj, "newScore");
                String rankerType = "";
                float newScore = 0.0f;
                rankerType = objRankerType == null ? "other" : (String)objRankerType;
                if (objNewScore != null && !"".equalsIgnoreCase((String)objNewScore)) {
                    newScore = Float.parseFloat((String)objNewScore);
                }
                if ("sameWord".equalsIgnoreCase(rankerType)) {
                    sameWordRankedList.add(new WrapResponseItem(obj, newScore, rankerType));
                    continue;
                }
                if ("lowCreditSameWord".equalsIgnoreCase(rankerType)) {
                    sameWordLowCreditRankedList.add(new WrapResponseItem(obj, newScore, rankerType));
                    continue;
                }
                otherRankedList.add(new WrapResponseItem(obj, newScore, rankerType));
            }
        }
        sameWordRankedList.sort((a, b) -> {
            if (a.getNewScore() == b.getNewScore()) {
                return 0;
            }
            if (a.getNewScore() > b.getNewScore()) {
                return -1;
            }
            return 1;
        });
        sameWordLowCreditRankedList.sort((a, b) -> {
            if (a.getNewScore() == b.getNewScore()) {
                return 0;
            }
            if (a.getNewScore() > b.getNewScore()) {
                return -1;
            }
            return 1;
        });
        otherRankedList.sort((a, b) -> {
            if (a.getNewScore() == b.getNewScore()) {
                return 0;
            }
            if (a.getNewScore() > b.getNewScore()) {
                return -1;
            }
            return 1;
        });
        for (WrapResponseItem wrapResponseItem : sameWordRankedList) {
            sortedItemList.add(wrapResponseItem);
        }
        for (WrapResponseItem wrapResponseItem : sameWordLowCreditRankedList) {
            sortedItemList.add(wrapResponseItem);
        }
        for (WrapResponseItem wrapResponseItem : otherRankedList) {
            sortedItemList.add(wrapResponseItem);
        }
        return sortedItemList;
    }

    @Deprecated
    private <T> List<WrapResponseItem<T>> getTopList(SearchApiResponse<T> target, int wantedSize) throws NoSuchFieldException {
        ArrayList<WrapResponseItem<T>> wantedItemList = new ArrayList<WrapResponseItem<T>>();
        int count = 0;
        for (Object obj : target.getSource()) {
            if (count >= wantedSize) break;
            Object objRankerType = SearchUtils.getObject(obj, "rankerType");
            Object objNewScore = SearchUtils.getObject(obj, "newScore");
            String rankerType = "";
            float newScore = 0.0f;
            rankerType = objRankerType == null ? "other" : (String)objRankerType;
            if (objNewScore != null && !"".equalsIgnoreCase((String)objNewScore)) {
                newScore = Float.parseFloat((String)objNewScore);
            }
            wantedItemList.add(new WrapResponseItem(obj, newScore, rankerType));
            ++count;
        }
        return wantedItemList;
    }

    public <T> SearchApiResponse<T> strictMatchSearch(int pageId, int pageSize, String keyword, List<String> marks, Class<T> indexDataClazz, Map<String, Object> bizSysConfig, List<Condition> excludeConditions) {
        return this.matchSearchImpl(pageId, pageSize, keyword, marks, indexDataClazz, bizSysConfig, excludeConditions, "peliplat-search-strict-match", FuzzinessQueryMode.NO);
    }

    private <T> SearchApiResponse<T> matchSearchImpl(int pageId, int pageSize, String keyword, List<String> marks, Class<T> indexDataClazz, Map<String, Object> bizSysConfig, List<Condition> excludeConditions, String bizName, FuzzinessQueryMode fuzzinessQueryType) {
        if (StringUtils.isEmpty(keyword)) {
            return new SearchApiResponse();
        }
        int esFromIndex = 0;
        int esSize = pageSize;
        int fromIndex = 0;
        Map<String, Integer> pagingInfoMap = this.convertMatchSearchPagingToEsPaging(pageSize, pageId, bizSysConfig);
        if (CollectionUtils.isEmpty(pagingInfoMap)) {
            return new SearchApiResponse();
        }
        esFromIndex = pagingInfoMap.getOrDefault("esFromIndex", 0);
        esSize = pagingInfoMap.getOrDefault("esSize", 200);
        fromIndex = pagingInfoMap.getOrDefault("fromIndex", 0);
        boolean esBatchLoad = pagingInfoMap.getOrDefault("esBatchLoad", -1) >= 0;
        DefaultSearcher searcher = BizContainerBuilder.newInstance(bizSysConfig, this.esClient).build(bizName, keyword, esFromIndex, esSize);
        if (FuzzinessQueryMode.NO.equals((Object)fuzzinessQueryType) || FuzzinessQueryMode.AUTO.equals((Object)fuzzinessQueryType)) {
            searcher.getRequestContext().disableFuzziness();
        } else {
            searcher.getRequestContext().enableFuzziness();
        }
        this.prepareCondition(searcher, excludeConditions, FilterFuncEnum.NOTEQUAL);
        this.prepareMarks(searcher, marks, bizSysConfig);
        try {
            searcher.execute();
            if (FuzzinessQueryMode.AUTO.equals((Object)fuzzinessQueryType)) {
                Statistics.matchSearchInvoked1st();
                if (!this.checkHasAllMatchData(searcher.getRequestContext().getResponse().getHits().getHits())) {
                    searcher = BizContainerBuilder.newInstance(bizSysConfig, this.esClient).build(bizName, keyword, esFromIndex, esSize);
                    searcher.getRequestContext().enableFuzziness();
                    this.prepareCondition(searcher, excludeConditions, FilterFuncEnum.NOTEQUAL);
                    this.prepareMarks(searcher, marks, bizSysConfig);
                    searcher.execute();
                    Statistics.matchSearchInvoked2nd();
                }
            }
        }
        catch (Exception e) {
            throw new SearchApiException(e);
        }
        SearchApiResponse<T> esDataResponse = this.buildSearchResponse(searcher, indexDataClazz, bizSysConfig, esBatchLoad, fromIndex, pageSize);
        return esDataResponse;
    }

    private boolean checkHasAllMatchData(SearchHit[] hits) {
        for (SearchHit hit : hits) {
            for (String matchedStr : hit.getMatchedQueries()) {
                if (!matchedStr.toLowerCase().startsWith("entiretymatcher")) continue;
                return true;
            }
        }
        return false;
    }

    private <T> SearchApiResponse<T> buildSearchResponse(DefaultSearcher searcher, Class<T> indexDataClazz, Map<String, Object> bizSysConfig, boolean esBatchLoad, int fromIndex, int pageSize) {
        WrappedSearchResponse wrapedResponse = (WrappedSearchResponse)searcher.getRequestContext().getResponse();
        List highLightFieldNamesFromConfig = (List)bizSysConfig.get("highlightFieldsName");
        SearchApiResponse esDataResponse = new SearchApiResponse();
        esDataResponse.putAttatchment("matchFieldName", searcher.getRequestContext().getQueryMatcherMatchedFieldNameMap());
        if (esBatchLoad) {
            if (wrapedResponse.getHits().getHits().length < fromIndex) {
                esDataResponse.getSource().clear();
                esDataResponse.setHitCount(0L);
            } else {
                int takedDataSize = Math.min(pageSize, wrapedResponse.getHits().getHits().length - fromIndex);
                esDataResponse = this.readRespData(wrapedResponse, fromIndex, takedDataSize, indexDataClazz, searcher.getRequestContext(), highLightFieldNamesFromConfig, bizSysConfig);
                esDataResponse.setHitCount(takedDataSize);
                Map<Integer, List<String>> matcherQueries = this.readMatcherQueries(wrapedResponse, fromIndex, takedDataSize);
                if (this.highlightLogger.isDebugEnabled()) {
                    esDataResponse.putAttatchment("matcherNames", matcherQueries);
                    esDataResponse.putAttatchment("querySentenceMatchedFieldNames", searcher.getRequestContext().getQueryMatcherMatchedFieldNameMap());
                    esDataResponse.putAttatchment("highlightFieldName", searcher.getRequestContext().getQueryMatcherMatchedFieldNameMap());
                }
            }
        } else {
            Map<Integer, List<String>> matcherQueries = this.readMatcherQueries(wrapedResponse, 0, wrapedResponse.getHits().getHits().length);
            esDataResponse = this.readRespData(wrapedResponse, 0, wrapedResponse.getHits().getHits().length, indexDataClazz, searcher.getRequestContext(), highLightFieldNamesFromConfig, bizSysConfig);
            esDataResponse.setHitCount(wrapedResponse.getHits().getHits().length);
            if (this.highlightLogger.isDebugEnabled()) {
                esDataResponse.putAttatchment("matcherNames", matcherQueries);
                esDataResponse.putAttatchment("querySentenceMatchedFieldNames", searcher.getRequestContext().getQueryMatcherMatchedFieldNameMap());
                esDataResponse.putAttatchment("highlightFieldName", searcher.getRequestContext().getQueryMatcherMatchedFieldNameMap());
            }
        }
        return esDataResponse;
    }

    private <T> SearchApiResponse<T> instanceSearchImpl(int pageSize, String keyword, List<String> marks, Class<T> indexDataClazz, Map<String, Object> bizSysConfig, List<Condition> excludeConditions, String bizName, FuzzinessQueryMode fuzzinessQueryType) {
        if (StringUtils.isEmpty(keyword)) {
            return new SearchApiResponse();
        }
        if (pageSize > 100) {
            pageSize = 100;
        }
        if (pageSize <= 0) {
            pageSize = 10;
        }
        int esSize = 0;
        boolean esbatchLoad = false;
        if (pageSize <= 100) {
            esSize = 100;
            esbatchLoad = true;
        } else {
            esSize = pageSize;
        }
        DefaultSearcher searcher = BizContainerBuilder.newInstance(bizSysConfig, this.esClient).build(bizName, keyword, 0, esSize);
        this.prepareCondition(searcher, excludeConditions, FilterFuncEnum.NOTEQUAL);
        searcher.disableHighlight();
        this.prepareMarksForInstanceSearch(marks, searcher, bizSysConfig);
        try {
            if (FuzzinessQueryMode.AUTO.equals((Object)fuzzinessQueryType) || FuzzinessQueryMode.NO.equals((Object)fuzzinessQueryType)) {
                searcher.getRequestContext().disableFuzziness();
            } else {
                searcher.getRequestContext().enableFuzziness();
            }
            searcher.execute();
            if (FuzzinessQueryMode.AUTO.equals((Object)fuzzinessQueryType)) {
                Statistics.instantSearchInvoked1st();
                if (!this.checkHasAllMatchData(searcher.getRequestContext().getResponse().getHits().getHits())) {
                    searcher = BizContainerBuilder.newInstance(bizSysConfig, this.esClient).build(bizName, keyword, 0, esSize);
                    this.prepareCondition(searcher, excludeConditions, FilterFuncEnum.NOTEQUAL);
                    searcher.disableHighlight();
                    this.prepareMarksForInstanceSearch(marks, searcher, bizSysConfig);
                    searcher.getRequestContext().enableFuzziness();
                    searcher.execute();
                    Statistics.instantSearchInvoked2nd();
                }
            }
        }
        catch (Exception e) {
            throw new SearchApiException(e);
        }
        WrappedSearchResponse wrapedResponse = (WrappedSearchResponse)searcher.getRequestContext().getResponse();
        List highLightFieldNamesFromConfig = (List)bizSysConfig.get("highlightFieldsName");
        SearchApiResponse esDataResponse = new SearchApiResponse();
        if (wrapedResponse.getHits().getHits().length >= pageSize) {
            esDataResponse = this.readRespData(wrapedResponse, 0, pageSize, indexDataClazz, searcher.getRequestContext(), highLightFieldNamesFromConfig, bizSysConfig);
            esDataResponse.setHitCount(pageSize);
        } else if (wrapedResponse.getHits().getHits().length <= 0) {
            esDataResponse.getSource().clear();
            esDataResponse.setHitCount(0L);
        } else {
            esDataResponse = this.readRespData(wrapedResponse, 0, wrapedResponse.getHits().getHits().length, indexDataClazz, searcher.getRequestContext(), highLightFieldNamesFromConfig, bizSysConfig);
            esDataResponse.setHitCount(wrapedResponse.getHits().getHits().length);
        }
        return esDataResponse;
    }

    private void prepareMarksForInstanceSearch(List<String> marks, DefaultSearcher searcher, Map<String, Object> bizSysConfig) {
        if (!CollectionUtils.isEmpty(marks)) {
            searcher.getRequestContext().putMarks(marks);
            ArrayList<InlineFilter> filters = new ArrayList<InlineFilter>();
            for (String m : marks) {
                if (StringUtils.isEmpty(m)) continue;
                filters.add(new GeneralFilter(bizSysConfig.get("classifyFieldName").toString(), m, FilterFuncEnum.EQUAL, searcher.getRequestContext()));
            }
            if (!CollectionUtils.isEmpty(filters)) {
                CompositeFilter compositeFilter = new CompositeFilter(CompositeFilter.Func.OR, filters);
                searcher.fillter(compositeFilter);
            }
        }
    }

    public <T> SearchApiResponse<T> instanceSearch(int pageSize, String keyword, List<String> marks, Class<T> indexDataClazz, Map<String, Object> bizSysConfig, List<Condition> excludeConditions, FuzzinessQueryMode fuzzinessQueryMode) {
        return this.instanceSearchImpl(pageSize, keyword, marks, indexDataClazz, bizSysConfig, excludeConditions, "peliplat-search", fuzzinessQueryMode);
    }

    public <T> SearchApiResponse<T> strictInstanceSearch(int pageSize, String keyword, List<String> marks, Class<T> indexDataClazz, Map<String, Object> bizSysConfig, List<Condition> excludeConditions) {
        return this.instanceSearchImpl(pageSize, keyword, marks, indexDataClazz, bizSysConfig, excludeConditions, "peliplat-search-strict-match", FuzzinessQueryMode.NO);
    }

    public <T> SearchApiResponse<T> matchSearchForContentId(String keyword, List<String> marks, Class<T> indexDataClazz, Map<String, Object> bizSysConfig, List<Condition> excludeConditions) throws SearchApiException {
        if (StringUtils.isEmpty(keyword)) {
            return new SearchApiResponse();
        }
        DefaultSearcher searcher = BizContainerBuilder.newInstance(bizSysConfig, this.esClient).build("peliplat-search-by-content-id", keyword, 0, 20);
        this.prepareCondition(searcher, excludeConditions, FilterFuncEnum.NOTEQUAL);
        searcher.disableHighlight();
        if (!CollectionUtils.isEmpty(marks)) {
            searcher.getRequestContext().putMarks(marks);
            ArrayList<InlineFilter> filters = new ArrayList<InlineFilter>();
            for (String m : marks) {
                if (StringUtils.isEmpty(m)) continue;
                filters.add(new GeneralFilter(bizSysConfig.get("classifyFieldName").toString(), m, FilterFuncEnum.EQUAL, searcher.getRequestContext()));
            }
            if (!CollectionUtils.isEmpty(filters)) {
                CompositeFilter compositeFilter = new CompositeFilter(CompositeFilter.Func.OR, filters);
                searcher.fillter(compositeFilter);
            }
        }
        try {
            searcher.execute();
        }
        catch (Exception e) {
            throw new SearchApiException(e);
        }
        WrappedSearchResponse wrapedResponse = (WrappedSearchResponse)searcher.getRequestContext().getResponse();
        List highLightFieldNamesFromConfig = (List)bizSysConfig.get("highlightFieldsName");
        SearchApiResponse<T> esDataResponse = this.readRespData(wrapedResponse, 0, wrapedResponse.getHits().getHits().length, indexDataClazz, searcher.getRequestContext(), highLightFieldNamesFromConfig, bizSysConfig);
        return esDataResponse;
    }

    private Map<String, Long> matchCountImpl(String keyword, Map<String, Object> bizSysConfig, List<Condition> excludeConditions, String bizName, FuzzinessQueryMode fuzzinessQueryType) throws SearchApiException {
        return this.matchCountImpl(keyword, bizSysConfig, excludeConditions, bizName, fuzzinessQueryType, null);
    }

    private Map<String, Long> matchCountImpl(String keyword, Map<String, Object> bizSysConfig, List<Condition> excludeConditions, String bizName, FuzzinessQueryMode fuzzinessQueryType, List<String> marks) throws SearchApiException {
        if (StringUtils.isEmpty(keyword)) {
            return new HashMap<String, Long>();
        }
        DefaultSearcher searcher = BizContainerBuilder.newInstance(bizSysConfig, this.esClient).build(bizName, keyword, 0, 0);
        if (!CollectionUtils.isEmpty(marks)) {
            ArrayList<Condition> marksConditions = new ArrayList<Condition>();
            marksConditions.add(new Condition("mark", marks));
            this.prepareCondition(searcher, excludeConditions, FilterFuncEnum.EQUAL);
        }
        this.prepareCondition(searcher, excludeConditions, FilterFuncEnum.NOTEQUAL);
        if (fuzzinessQueryType == FuzzinessQueryMode.NO) {
            searcher.getRequestContext().disableFuzziness();
        } else if (fuzzinessQueryType == FuzzinessQueryMode.YES) {
            searcher.getRequestContext().enableFuzziness();
        } else {
            throw new SearchApiException("Invalid FuzzinessQueryMode :" + (Object)((Object)fuzzinessQueryType));
        }
        searcher.disableHighlight();
        TermsAggregation aggregation = new TermsAggregation(bizSysConfig.getOrDefault("classifyFieldName", "mark").toString(), 10);
        try {
            return searcher.executeCountAggs(aggregation);
        }
        catch (Exception e) {
            throw new SearchApiException(e);
        }
    }

    public Map<String, Long> matchCount(String keyword, Map<String, Object> bizSysConfig, List<Condition> excludeConditions, FuzzinessQueryMode fuzzinessQueryMode) throws SearchApiException {
        HashMap<String, Long> finalCountResult = new HashMap();
        if (fuzzinessQueryMode == null) {
            fuzzinessQueryMode = FuzzinessQueryMode.YES;
        }
        if (FuzzinessQueryMode.AUTO != fuzzinessQueryMode) {
            finalCountResult = this.matchCountImpl(keyword, bizSysConfig, excludeConditions, "peliplat-search", fuzzinessQueryMode, null);
        } else {
            Map<String, Long> entiretyMatcherCountResult = this.matchCountImpl(keyword, bizSysConfig, excludeConditions, "peliplat-count-entirety-matcher-only", FuzzinessQueryMode.NO);
            ArrayList<String> hasDataMarks = new ArrayList<String>();
            ArrayList<String> noneDataMarks = new ArrayList<String>();
            for (Map.Entry<String, Long> countItem : entiretyMatcherCountResult.entrySet()) {
                if (countItem.getValue() > 0L) {
                    hasDataMarks.add(countItem.getKey());
                    continue;
                }
                noneDataMarks.add(countItem.getKey());
            }
            Map<String, Long> noFuzzinessCountResult = null;
            Map<String, Long> fuzzinessCountResult = null;
            if (CollectionUtils.isEmpty(hasDataMarks) && CollectionUtils.isEmpty(noneDataMarks)) {
                fuzzinessCountResult = this.matchCountImpl(keyword, bizSysConfig, excludeConditions, "peliplat-search", FuzzinessQueryMode.YES, null);
                if (!CollectionUtils.isEmpty(fuzzinessCountResult)) {
                    finalCountResult.putAll(fuzzinessCountResult);
                }
            } else {
                if (!CollectionUtils.isEmpty(hasDataMarks) && !CollectionUtils.isEmpty(noFuzzinessCountResult = this.matchCountImpl(keyword, bizSysConfig, excludeConditions, "peliplat-search", FuzzinessQueryMode.NO, hasDataMarks))) {
                    for (String hasDataMark : hasDataMarks) {
                        finalCountResult.put(hasDataMark, noFuzzinessCountResult.get(hasDataMark));
                    }
                }
                if (!CollectionUtils.isEmpty(noneDataMarks) && !CollectionUtils.isEmpty(fuzzinessCountResult = this.matchCountImpl(keyword, bizSysConfig, excludeConditions, "peliplat-search", FuzzinessQueryMode.YES, noneDataMarks))) {
                    for (String noneDataMark : noneDataMarks) {
                        finalCountResult.put(noneDataMark, fuzzinessCountResult.get(noneDataMark));
                    }
                }
            }
            Statistics.matchCountByFuzzyAutoModeInvoked();
        }
        return finalCountResult;
    }

    public Map<String, Long> strictMatchCount(String keyword, Map<String, Object> bizSysConfig, List<Condition> excludeConditions) throws SearchApiException {
        return this.matchCountImpl(keyword, bizSysConfig, excludeConditions, "peliplat-search-strict-match", FuzzinessQueryMode.YES);
    }

    private void prepareMarks(DefaultSearcher searcher, List<String> marks, Map<String, Object> bizSysConfig) {
        if (!CollectionUtils.isEmpty(marks)) {
            searcher.getRequestContext().putMarks(marks);
            ArrayList<String> workMarks = new ArrayList<String>();
            if (marks.contains("meta")) {
                workMarks.clear();
                workMarks.add("movies");
                workMarks.add("series");
                workMarks.add("celebs");
            } else {
                workMarks.addAll(marks);
            }
            ArrayList<InlineFilter> filters = new ArrayList<InlineFilter>();
            for (String m : workMarks) {
                if (StringUtils.isEmpty(m)) continue;
                searcher.getRequestContext().putAttribute("classifyFieldName", bizSysConfig.get("classifyFieldName").toString());
                filters.add(new GeneralFilter(bizSysConfig.get("classifyFieldName").toString(), m, FilterFuncEnum.EQUAL, searcher.getRequestContext()));
            }
            if (!CollectionUtils.isEmpty(filters)) {
                CompositeFilter compositeFilter = new CompositeFilter(CompositeFilter.Func.OR, filters);
                searcher.fillter(compositeFilter);
            }
        }
    }

    private Map<String, Integer> convertMatchSearchPagingToEsPaging(int pageSize, int pageId, Map<String, Object> bizSysConfig) {
        int fixPageSize = Integer.parseInt(bizSysConfig.getOrDefault("fixPageSize", 200).toString());
        if (pageSize < 1) {
            pageSize = 20;
        } else if (pageSize > 1000) {
            pageSize = 1000;
        }
        if (pageId < 1) {
            pageId = 1;
        }
        int fromIndex = (pageId - 1) * pageSize;
        int size = pageSize;
        int esFromIndex = 0;
        int esSize = size;
        int esBatchLoad = -1;
        if (fromIndex > 10000) {
            return null;
        }
        if (fromIndex + pageSize > 10000) {
            esSize = size = 10000 - fromIndex;
            esFromIndex = 10000 - esSize;
        } else if (fromIndex + size <= fixPageSize) {
            esFromIndex = 0;
            esSize = fixPageSize;
            esBatchLoad = 1;
        } else {
            esFromIndex = fromIndex;
            esSize = size;
        }
        HashMap<String, Integer> retList = new HashMap<String, Integer>();
        retList.put("esFromIndex", esFromIndex);
        retList.put("esSize", esSize);
        retList.put("esBatchLoad", esBatchLoad);
        retList.put("fromIndex", fromIndex);
        return retList;
    }

    private void prepareCondition(DefaultSearcher searcher, List<Condition> excludeConditions, FilterFuncEnum op) {
        if (!CollectionUtils.isEmpty(excludeConditions)) {
            ArrayList<GeneralFilter> filters = new ArrayList<GeneralFilter>();
            for (Condition condition : excludeConditions) {
                filters.add(new GeneralFilter(condition.getFieldName(), condition.getValues().toArray(new String[condition.getValues().size()]), op));
            }
            if (filters.size() > 1) {
                CompositeFilter compositeFilter = new CompositeFilter((InlineFilter)filters.get(0), CompositeFilter.Func.OR);
                for (int index = 0; index < filters.size(); ++index) {
                    compositeFilter.append((InlineFilter)filters.get(index));
                }
                searcher.fillter(compositeFilter);
            } else {
                searcher.fillter((Filter)filters.get(0));
            }
        }
    }

    private <T> List<WrapResponseItem<T>> wrap(SearchApiResponse<T> targetSets) throws NoSuchFieldException {
        ArrayList sameWordRankedList = new ArrayList();
        ArrayList sameWordLowCreditRankedList = new ArrayList();
        ArrayList otherRankedList = new ArrayList();
        ArrayList<WrapResponseItem<T>> sortedItemList = new ArrayList<WrapResponseItem<T>>();
        for (Object obj : targetSets.getSource()) {
            Object object = SearchUtils.getObject(obj, "rankerType");
            Object objNewScore = SearchUtils.getObject(obj, "newScore");
            String rankerType = "";
            float newScore = 0.0f;
            rankerType = object == null ? "other" : (String)object;
            if (objNewScore != null && !"".equalsIgnoreCase((String)objNewScore)) {
                newScore = Float.parseFloat((String)objNewScore);
            }
            if (rankerType.equalsIgnoreCase("sameWord")) {
                sameWordRankedList.add(new WrapResponseItem(obj, newScore, rankerType));
                continue;
            }
            if (rankerType.equalsIgnoreCase("lowCreditSameWord")) {
                sameWordLowCreditRankedList.add(new WrapResponseItem(obj, newScore, rankerType));
                continue;
            }
            otherRankedList.add(new WrapResponseItem(obj, newScore, rankerType));
        }
        for (WrapResponseItem wrapResponseItem : sameWordRankedList) {
            sortedItemList.add(wrapResponseItem);
        }
        for (WrapResponseItem wrapResponseItem : sameWordLowCreditRankedList) {
            sortedItemList.add(wrapResponseItem);
        }
        for (WrapResponseItem wrapResponseItem : otherRankedList) {
            sortedItemList.add(wrapResponseItem);
        }
        return sortedItemList;
    }

    static {
        BasicThreadFactory namedThreadFactory = new BasicThreadFactory.Builder().namingPattern("ALL-Search-").build();
        allSearchExecPool = new ThreadPoolExecutor(5, 200, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), (ThreadFactory)namedThreadFactory, new ThreadPoolExecutor.AbortPolicy());
    }

    private class SearchWork<T>
    implements Callable<SearchApiResponse> {
        private String keyword;
        private int pageSize;
        private String mark;
        private int pageId;
        private Class<T> indexDataClazz;
        private Map<String, Object> bizSysConfig;
        private List<Condition> excludeConditions;
        private String bizName;

        public SearchWork(int pageId, int pageSize, String keyword, String mark, Class<T> indexDataClazz, Map<String, Object> bizSysConfig, List<Condition> excludeConditions, String bizName) {
            this.pageSize = pageSize;
            this.keyword = keyword;
            this.mark = mark;
            this.pageId = pageId;
            this.bizSysConfig = bizSysConfig;
            this.excludeConditions = excludeConditions;
            this.indexDataClazz = indexDataClazz;
            this.bizName = bizName;
        }

        @Override
        public SearchApiResponse<T> call() {
            ArrayList<String> marks = new ArrayList<String>();
            marks.add(this.mark);
            return PeliplatBizFacade.this.matchSearchImpl(this.pageId, this.pageSize, this.keyword, marks, this.indexDataClazz, this.bizSysConfig, this.excludeConditions, this.bizName, FuzzinessQueryMode.YES);
        }
    }

    private static class WrapResponseItem<T> {
        private T obj;
        private float newScore;
        private String rankerType;

        public WrapResponseItem(T obj, float newScore, String rankerType) {
            this.obj = obj;
            this.newScore = newScore;
            this.rankerType = rankerType;
        }

        public T getObj() {
            return this.obj;
        }

        public void setObj(T obj) {
            this.obj = obj;
        }

        public float getNewScore() {
            return this.newScore;
        }

        public void setNewScore(float newScore) {
            this.newScore = newScore;
        }

        public String getRankerType() {
            return this.rankerType;
        }

        public void setRankerType(String rankerType) {
            this.rankerType = rankerType;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof WrapResponseItem)) {
                return false;
            }
            WrapResponseItem targetItem = (WrapResponseItem)o;
            return targetItem.getObj().equals(this.obj);
        }

        public int hasCode() {
            return this.obj.hashCode();
        }
    }
}

