/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.filter;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.filter.AbstractSimilarityFilter;
import com.valor.common.search.engine.util.SearchUtils;
import com.valor.common.search.engine.util.StringUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;

public class PartialWordMatchFilter
extends AbstractSimilarityFilter {
    private String[] targetMatchName;
    private float rate = 0.33f;

    public PartialWordMatchFilter(RequestContext context, String ... targetMatchName) {
        this.context = context;
        this.targetMatchName = new String[targetMatchName.length];
        for (int index = 0; index < targetMatchName.length; ++index) {
            this.targetMatchName[index] = targetMatchName[index].toLowerCase();
        }
        this.matchFieldName = context.getAttribure("fuzzy_full_text_field");
        this.init();
    }

    public PartialWordMatchFilter(RequestContext context) {
        this.context = context;
        this.targetMatchName = new String[]{"PartialWordMatcher".toLowerCase()};
        this.matchFieldName = context.getAttribure("fuzzy_full_text_field");
        this.init();
    }

    public PartialWordMatchFilter(RequestContext context, float rate, String ... targetMatchName) {
        this.context = context;
        this.targetMatchName = new String[targetMatchName.length];
        for (int index = 0; index < targetMatchName.length; ++index) {
            this.targetMatchName[index] = targetMatchName[index].toLowerCase();
        }
        this.matchFieldName = context.getAttribure("fuzzy_full_text_field");
        this.rate = rate;
        this.init();
    }

    public PartialWordMatchFilter(RequestContext context, float rate) {
        this.context = context;
        this.targetMatchName = new String[]{"PartialWordMatcher".toLowerCase()};
        this.matchFieldName = context.getAttribure("fuzzy_full_text_field");
        this.rate = rate;
        this.init();
    }

    public PartialWordMatchFilter(RequestContext context, String matchedFieldName, String ... targetMatchName) {
        this.context = context;
        this.targetMatchName = new String[targetMatchName.length];
        for (int index = 0; index < targetMatchName.length; ++index) {
            this.targetMatchName[index] = targetMatchName[index].toLowerCase();
        }
        this.matchFieldName = matchedFieldName;
        this.init();
    }

    public PartialWordMatchFilter(RequestContext context, float rate, String matchedFieldName, String ... targetMatchName) {
        this.context = context;
        this.targetMatchName = new String[targetMatchName.length];
        for (int index = 0; index < targetMatchName.length; ++index) {
            this.targetMatchName[index] = targetMatchName[index].toLowerCase();
        }
        this.matchFieldName = matchedFieldName;
        this.rate = rate;
        this.init();
    }

    public PartialWordMatchFilter(RequestContext context, float rate, String matchedFieldName) {
        this.context = context;
        this.matchFieldName = matchedFieldName;
        this.targetMatchName = new String[]{"PartialWordMatcher".toLowerCase()};
        this.rate = rate;
        this.init();
    }

    private void init() {
    }

    @Override
    public void doFilter() throws RuntimeException {
        int i;
        String q = this.context.getQ();
        String aliasQ = "";
        if (!StringUtils.isEmpty(this.context.getAttribure("execute_partiword_query"))) {
            q = this.context.getAttribure("execute_partiword_query");
        }
        if (!StringUtils.isEmpty(this.context.getAttribure("execute_partiword_alis_query"))) {
            aliasQ = this.context.getAttribure("execute_partiword_alis_query").trim();
        }
        String[] newQs = q.toLowerCase().trim().split("([\\s\\p{Zs}])+");
        String[] newAliasQs = null;
        if (StringUtils.isEmpty(aliasQ)) {
            newAliasQs = aliasQ.toLowerCase().trim().split("([\\s\\p{Zs}])+");
        }
        boolean[] hitted = new boolean[newQs.length];
        HashSet<Integer> validHitDocIndexList = new HashSet<Integer>();
        HashSet<Integer> inValidHitDocIndexList = new HashSet<Integer>();
        SearchHits hits = this.context.getResponse().getHits();
        SearchHit[] hitDocs = hits.getHits();
        for (int index = 0; index < hitDocs.length; ++index) {
            if (!this.hasFuzzinessQuery(hitDocs[index].getMatchedQueries())) {
                validHitDocIndexList.add(index);
                continue;
            }
            for (int k = 0; k < hitted.length; ++k) {
                hitted[k] = false;
            }
            HighlightField matchFields = (HighlightField)hitDocs[index].getHighlightFields().get(this.matchFieldName);
            if (matchFields == null) {
                if (hitDocs[index].getHighlightFields().get(this.context.getAttribure("normal_full_text_field")) == null) continue;
                String[] matchedQueries = hitDocs[index].getMatchedQueries();
                for (int t = 0; t < matchedQueries.length; ++t) {
                    if (Arrays.binarySearch(this.targetMatchName, matchedQueries[t].toLowerCase()) < 0) continue;
                    matchedQueries[t] = "EntiretyMatcher";
                }
                hitDocs[index].matchedQueries(matchedQueries);
                validHitDocIndexList.add(index);
                continue;
            }
            Text[] texts = matchFields.fragments();
            boolean validHited = false;
            for (i = 0; i < texts.length; ++i) {
                String[] words;
                Text t = texts[i];
                String s = t.toString().toLowerCase();
                for (String hitWord : words = s.trim().split("([\\s\\p{Zs}])+")) {
                    Set<String> subSet = SearchUtils.findMatchStr(hitWord, this.context.getHighlightPreTag(), this.context.getHighlightPostTag());
                    String word = hitWord.replaceAll(this.context.getHighlightPostTag(), "").replaceAll(this.context.getHighlightPreTag(), "");
                    for (String sub : subSet) {
                        int j;
                        if (!((float)sub.length() * 100.0f / (float)word.length() >= this.rate * 100.0f)) continue;
                        sub = sub.replaceAll("-", "");
                        for (j = 0; j < newQs.length; ++j) {
                            if (newQs[j].indexOf(sub) == -1) continue;
                            hitted[j] = true;
                        }
                        if (StringUtils.isEmpty(newAliasQs)) continue;
                        for (j = 0; j < newAliasQs.length; ++j) {
                            if (newAliasQs[j].indexOf(sub) == -1) continue;
                            hitted[j] = true;
                        }
                    }
                }
                validHited = true;
                for (boolean b : hitted) {
                    if (b) continue;
                    validHited = false;
                    inValidHitDocIndexList.add(index);
                }
                if (!validHited) continue;
                validHitDocIndexList.add(index);
            }
        }
        Set<Integer> validHitDocIndexFromMinimuList = this.tryFilterByMinimuIndexField(inValidHitDocIndexList);
        validHitDocIndexList.addAll(validHitDocIndexFromMinimuList);
        SearchHit[] targetHitArray = new SearchHit[validHitDocIndexList.size()];
        int cIndex = 0;
        float maxScore = 0.0f;
        for (i = 0; i < hitDocs.length; ++i) {
            if (!validHitDocIndexList.contains(i)) continue;
            maxScore = maxScore > hitDocs[i].getScore() ? maxScore : hitDocs[i].getScore();
            targetHitArray[cIndex] = hitDocs[i];
            ++cIndex;
        }
        try {
            SearchUtils.replaceHits(hits, targetHitArray);
            int invalidCount = inValidHitDocIndexList.size();
            if (invalidCount > 0) {
                SearchUtils.replaceTotalHitsSize(hits, SearchUtils.getTotalHitsSize(hits) - (long)invalidCount);
                this.increaseInvalidDocCountBy(invalidCount);
            }
            if (maxScore != hits.getMaxScore()) {
                SearchUtils.replaceMaxScore(hits, maxScore);
            }
        }
        catch (Exception nsfe) {
            throw new RuntimeException(nsfe);
        }
    }

    private boolean hasFuzzinessQuery(String[] matchQueries) {
        boolean retVal = false;
        for (String str : matchQueries) {
            if (Arrays.binarySearch(this.targetMatchName, str.toLowerCase()) < 0) continue;
            return true;
        }
        return retVal;
    }

    private Set<Integer> tryFilterByMinimuIndexField(Set<Integer> sourceIndexList) {
        HashSet<Integer> matchedIndexSet = new HashSet<Integer>();
        SearchHits hits = this.context.getResponse().getHits();
        SearchHit[] hitDocs = hits.getHits();
        String compareQ = StringUtils.delPunct(this.context.getQ()).replaceAll("-", "").replaceAll(" ", "").toLowerCase();
        String compareNorm = "";
        boolean matched = false;
        for (Integer index : sourceIndexList) {
            HighlightField matchFields = (HighlightField)hitDocs[index].getHighlightFields().get(this.context.getAttribure("fuzzy_full_text_field"));
            matched = false;
            if (matchFields != null && matchFields.fragments() != null && matchFields.fragments().length > 0) {
                for (Text t : matchFields.fragments()) {
                    Set<String> matchedStrList = SearchUtils.findMatchStr(t.string(), this.context.getHighlightPreTag(), this.context.getHighlightPostTag());
                    for (String s : matchedStrList) {
                        compareNorm = StringUtils.delPunct(s).replaceAll("-", "").replaceAll(" ", "").toLowerCase();
                        if (!((float)compareNorm.length() * 1.0f / ((float)compareQ.length() * 1.0f) > 0.66f)) continue;
                        matched = true;
                        break;
                    }
                    if (matched) break;
                }
            }
            if (!matched) continue;
            matchedIndexSet.add(index);
        }
        return matchedIndexSet;
    }
}

