/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.hunspell;

import com.valor.common.search.engine.util.StringUtils;
import dumonts.hunspell.Hunspell;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineHunspell {
    Logger logger = LoggerFactory.getLogger((String)"HunspellSearcher");
    private static Hunspell enHunSpell = Hunspell.forDictionaryInResources("en_GB", "dicts/");
    private static Hunspell esHunSpell = Hunspell.forDictionaryInResources("es_AR", "dicts/");
    private static Hunspell ptHunSpell = Hunspell.forDictionaryInResources("pt_BR", "dicts/");

    @PostConstruct
    public void init() {
    }

    public List<List<String>> suggestByForceSplit(String word) {
        ArrayList<List<String>> finalTargetWordsList = new ArrayList<List<String>>();
        if (StringUtils.isEmpty(word) || word.split("([\\s\\p{Zs}])+").length != 1 || word.length() < 6) {
            return new ArrayList<List<String>>();
        }
        int wordMinLen = 2;
        for (int index = 0; index < word.length() - wordMinLen; ++index) {
            ArrayList<String> targetWords = new ArrayList<String>();
            targetWords.add(word.substring(0, index + wordMinLen));
            targetWords.add(word.substring(index + wordMinLen));
            boolean b0 = this.check((String)targetWords.get(0));
            boolean b1 = this.check((String)targetWords.get(1));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("check result: " + (String)targetWords.get(0) + ":" + b0 + " " + (String)targetWords.get(1) + ":" + b1);
            }
            if (b1 && b0) {
                finalTargetWordsList.add(targetWords);
                continue;
            }
            if (b0 && ((String)targetWords.get(0)).length() > 2) {
                finalTargetWordsList.add(targetWords);
                continue;
            }
            if (!b1 || ((String)targetWords.get(1)).length() <= 2) continue;
            finalTargetWordsList.add(targetWords);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Spilt composite word:" + Arrays.toString(finalTargetWordsList.toArray()));
        }
        return finalTargetWordsList;
    }

    public boolean check(String word) {
        boolean b1 = enHunSpell.spell(word);
        boolean b2 = esHunSpell.spell(word);
        boolean b3 = ptHunSpell.spell(word);
        int count = 0;
        if (b1) {
            ++count;
        }
        if (b2) {
            ++count;
        }
        if (b3) {
            ++count;
        }
        return count > 0;
    }
}

