/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.matcher;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.matcher.AbstractMatcher;
import com.valor.common.search.engine.matcher.Matcher;
import com.valor.common.search.engine.util.SearchUtils;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class GeneralTermMatcher
extends AbstractMatcher {
    public static final String DEFAULT_MATCH_NAME = "GeneralTermMatcher";

    public GeneralTermMatcher(RequestContext context, String matchFieldName, String word) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.matchFieldName = matchFieldName;
        this.q = SearchUtils.rebuildQ(word);
        this.context = context;
        this.matchFieldName = context.getAttribure("fuzzy_full_text_field");
        this.init();
    }

    private void init() {
        this.context.saveMatcheNameandMatcheFieldNamePair(this.matchName, this.matchFieldName);
    }

    @Override
    public Matcher.MATCHER_TYPE getMatcherType() {
        return Matcher.MATCHER_TYPE.GENERAL_TERM;
    }

    @Override
    public Matcher assembly() {
        return this;
    }

    @Override
    public QueryBuilder buildBase() {
        return QueryBuilders.matchQuery((String)this.matchFieldName, (Object)this.q);
    }
}

