/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.matcher;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.facade.config.MatcherConfig;
import com.valor.common.search.engine.facade.config.MatcherParams;
import com.valor.common.search.engine.matcher.AbstractFuzzyMatcher;
import com.valor.common.search.engine.matcher.CompareableTerm;
import com.valor.common.search.engine.matcher.Matcher;
import com.valor.common.search.engine.matcher.Term;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.SearchUtils;
import com.valor.common.search.engine.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MininumStrMatcher
extends AbstractFuzzyMatcher {
    public static final String PREFIX_LENGTH_RATE = "mininumstrmatcher_prefix_length_rate";
    public static final String SUF_LENGTH_RATE = "mininumstrmatcher_suf_length_rate";
    public static final String MININUM_STR_LENGTH_RATE = "mininumstrmatcher_mininum_str_rate";
    public static final String PREFIX_LENGTH = "mininumstrmatcher_prefix_length";
    public static final String SUF_LENGTH = "mininumstrmatcher_suf_length";
    public static final String MININUM_STR_LENGTH = "mininumstrmatcher_total_str_length";
    public static final String DEFAULT_MATCH_NAME = "MininumStrMatcher";
    public static final float DEFAULT_BOOST = 0.8f;
    public static final int MINIMUQ_MAX_LEN = 9;
    public static final int DEFAULT_PREFIX_LENGTH = 2;
    public static final int DEFAULT_SUF_LENGTH = 2;
    public static final int DEFAULT_MININUM_STR_MAX_LENGTH = 10;
    public static final float DEFAULT_PREFIX_LENGTH_RATE = 0.5f;
    public static final float DEFAULT_MININUM_STR_LENGTH_RATE = 0.6666667f;
    Logger logger = LoggerFactory.getLogger(MininumStrMatcher.class);
    private Set<String> queryUsedFieldNameSet = new HashSet<String>();
    private Set<Term> mainTermList = new HashSet<Term>();
    private Set<Term> yearTermList = new HashSet<Term>();
    private int prefixLength = 2;
    private int sufLength = 2;
    private float prefixRate;
    private float mininumStrLengthRate;
    private AtomicInteger matchsentenceCount = new AtomicInteger(0);

    public MininumStrMatcher() {
        this.matchName = DEFAULT_MATCH_NAME;
        this.boost = 0.8f;
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_TWO_CHARS, "clean_no_char_2_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_ONE_CHARS, "cutsomeword");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_THREE_CHARS, "clean_no_char_3_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_FOUR_CHARS, "clean_no_char_4_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_FIVE_CHARS, "clean_no_char_5_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_SIX_CHARS, "clean_no_char_6_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_SEVEN_CHARS, "clean_no_char_7_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_EIGHT_CHARS, "clean_no_char_8_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_MORE_CHARS, "clean_no_char_9_10_ngram");
    }

    public MininumStrMatcher(RequestContext context) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.boost = 0.8f;
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_TWO_CHARS, "clean_no_char_2_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_ONE_CHARS, "cutsomeword");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_THREE_CHARS, "clean_no_char_3_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_FOUR_CHARS, "clean_no_char_4_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_FIVE_CHARS, "clean_no_char_5_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_SIX_CHARS, "clean_no_char_6_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_SEVEN_CHARS, "clean_no_char_7_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_EIGHT_CHARS, "clean_no_char_8_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_MORE_CHARS, "clean_no_char_9_10_ngram");
        this.q = context.getQ().trim();
        this.context = context;
        this.matchFieldName = context.getAttribure("mininum_full_text_field");
        this.init();
    }

    public MininumStrMatcher(RequestContext context, String matchName, String matchFieldName) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.boost = 0.8f;
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_TWO_CHARS, "clean_no_char_2_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_ONE_CHARS, "cutsomeword");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_THREE_CHARS, "clean_no_char_3_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_FOUR_CHARS, "clean_no_char_4_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_FIVE_CHARS, "clean_no_char_5_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_SIX_CHARS, "clean_no_char_6_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_SEVEN_CHARS, "clean_no_char_7_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_EIGHT_CHARS, "clean_no_char_8_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_MORE_CHARS, "clean_no_char_9_10_ngram");
        this.q = context.getQ().trim();
        this.context = context;
        this.matchFieldName = matchFieldName;
        this.matchName = matchName;
        this.init();
    }

    public MininumStrMatcher(String analyzerName, RequestContext context) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.boost = 0.8f;
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_TWO_CHARS, "clean_no_char_2_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_ONE_CHARS, "cutsomeword");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_THREE_CHARS, "clean_no_char_3_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_FOUR_CHARS, "clean_no_char_4_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_FIVE_CHARS, "clean_no_char_5_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_SIX_CHARS, "clean_no_char_6_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_SEVEN_CHARS, "clean_no_char_7_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_EIGHT_CHARS, "clean_no_char_8_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_MORE_CHARS, "clean_no_char_9_10_ngram");
        this.q = context.getQ().trim();
        this.analyzerName = analyzerName;
        this.matchFieldName = context.getAttribure("mininum_full_text_field");
        this.context = context;
        this.init();
    }

    public MininumStrMatcher(String analyzerName, String matchFieldName, RequestContext context) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.boost = 0.8f;
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_TWO_CHARS, "clean_no_char_2_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_ONE_CHARS, "cutsomeword");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_THREE_CHARS, "clean_no_char_3_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_FOUR_CHARS, "clean_no_char_4_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_FIVE_CHARS, "clean_no_char_5_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_SIX_CHARS, "clean_no_char_6_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_SEVEN_CHARS, "clean_no_char_7_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_EIGHT_CHARS, "clean_no_char_8_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_MORE_CHARS, "clean_no_char_9_10_ngram");
        this.q = context.getQ().trim();
        this.analyzerName = analyzerName;
        this.matchFieldName = matchFieldName;
        this.context = context;
        this.init();
    }

    private static String getPrefix(String item, int wantedOength) {
        if (item.length() <= wantedOength) {
            return item;
        }
        return item.substring(0, wantedOength);
    }

    private static String getSuffix(String item, int wantedLength) {
        if (item.length() <= wantedLength) {
            return item;
        }
        return item.substring(item.length() - wantedLength, item.length());
    }

    private static String getPrefix(String item, float rate) {
        int wantedCharsLen = Math.round((float)item.length() * rate);
        return item.substring(0, wantedCharsLen);
    }

    private void init() {
        Number curPrefixLength = this.context.getNumAttr(PREFIX_LENGTH);
        Number curSufLength = this.context.getNumAttr(SUF_LENGTH);
        Number curPrefixLengthRate = this.context.getNumAttr(PREFIX_LENGTH_RATE);
        Number curMininumStrLengthRate = this.context.getNumAttr(MININUM_STR_LENGTH_RATE);
        if (curMininumStrLengthRate == null || curMininumStrLengthRate.floatValue() <= 0.0f) {
            this.mininumStrLengthRate = 0.6666667f;
        }
        if (curPrefixLengthRate == null || curPrefixLengthRate.floatValue() <= 0.0f) {
            this.prefixRate = 0.5f;
        }
        if (curPrefixLength == null || curPrefixLength.floatValue() <= 0.0f) {
            this.prefixLength = 2;
        }
        if (curSufLength == null || curSufLength.floatValue() <= 2.0f) {
            this.sufLength = 2;
        }
        this.context.saveMatcheNameandMatcheFieldNamePair(this.matchName, this.matchFieldName);
        this.inited = true;
    }

    public void setMatchFieldName(String matchFieldName) {
        if (this.inited) {
            return;
        }
        this.matchFieldName = matchFieldName;
    }

    void setAnalyzerName(String analyzerName) {
        if (this.inited) {
            return;
        }
        this.analyzerName = analyzerName;
    }

    @Override
    public Matcher.MATCHER_TYPE getMatcherType() {
        return Matcher.MATCHER_TYPE.MININUM_STR;
    }

    @Override
    public MininumStrMatcher assembly() {
        this.mainTermList.clear();
        this.q = StringUtils.delPunctWithNoSpace(this.context.getQ().replace("-", " ")).trim();
        int queryTermType = this.queryTermType().ordinal();
        switch (queryTermType) {
            case 1: {
                this.assembly4CaseOneWord();
                break;
            }
            case 2: {
                this.assembly4CaseTwoWord();
                break;
            }
            case 4: {
                this.assembly4CaseThreeWord();
                break;
            }
            default: {
                this.assembly4CaseMoreWord();
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public QueryBuilder buildBase() {
        if (CollectionUtils.isEmpty(this.mainTermList)) {
            return null;
        }
        this.matchsentenceCount = new AtomicInteger(0);
        ArrayList<MatchQueryBuilder> queryList = new ArrayList<MatchQueryBuilder>();
        ArrayList<MatchQueryBuilder> queryList4Years = new ArrayList<MatchQueryBuilder>();
        ArrayList<TermQueryBuilder> yearFilterQueryBuilderList = new ArrayList<TermQueryBuilder>();
        HashSet<String> yearSet = new HashSet<String>();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        String sentenceQueryName = "";
        for (Term term : this.mainTermList) {
            if (!SearchUtils.isLatin(term.getTermStr())) {
                return null;
            }
            sentenceQueryName = this.getSentenceQueryName();
            MatchQueryBuilder matchQueryBuilder = (MatchQueryBuilder)QueryBuilders.matchQuery((String)term.getMatchedFieldName(), (Object)SearchUtils.takeStrByPrefixLimit(term.getTermStr(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT)).operator(term.getOperator()).queryName(sentenceQueryName);
            this.queryUsedFieldNameSet.add(term.getMatchedFieldName());
            this.saveSentenceMatchFieldName(sentenceQueryName, term.getMatchedFieldName());
            if (term.getOperator() != null) {
                matchQueryBuilder.operator(term.getOperator());
                if (term.getOperator().ordinal() != Operator.AND.ordinal() && !StringUtils.isEmpty(term.getAnalyzer())) {
                    matchQueryBuilder.analyzer(term.getAnalyzer());
                }
            }
            queryList.add(matchQueryBuilder);
        }
        for (MatchQueryBuilder matchQueryBuilder : queryList) {
            boolQueryBuilder.should((QueryBuilder)matchQueryBuilder);
        }
        if (this.matcherConfig.getYearFlag().booleanValue()) {
            HashSet<String> querySentenceMatchedFieldNameSet = new HashSet<String>();
            for (Term term : this.yearTermList) {
                MatchQueryBuilder query = (MatchQueryBuilder)((MatchQueryBuilder)QueryBuilders.matchQuery((String)term.getMatchedFieldName(), (Object)SearchUtils.takeStrByPrefixLimit(term.getTermStr(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT)).queryName(sentenceQueryName)).boost(term.getBoost());
                this.queryUsedFieldNameSet.add(term.getMatchedFieldName());
                querySentenceMatchedFieldNameSet.add(term.getMatchedFieldName());
                if (!StringUtils.isEmpty(term.getAnalyzer())) {
                    query.analyzer(term.getAnalyzer());
                }
                if (term.getOperator() != null) {
                    query.operator(term.getOperator());
                }
                yearSet.addAll(term.getYearList());
                queryList4Years.add(query);
            }
            for (String string : yearSet) {
                yearFilterQueryBuilderList.add(QueryBuilders.termQuery((String)this.matcherConfig.getYearFieldName(), (String)string));
            }
            if (queryList4Years.size() > 0) {
                BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery();
                for (MatchQueryBuilder query : queryList4Years) {
                    boolQueryBuilder2.should((QueryBuilder)query);
                }
                boolQueryBuilder2.minimumShouldMatch(1);
                Object var9_20 = null;
                if (yearFilterQueryBuilderList.size() > 0) {
                    void var9_23;
                    if (yearFilterQueryBuilderList.size() == 1) {
                        QueryBuilder queryBuilder = (QueryBuilder)yearFilterQueryBuilderList.get(0);
                    } else {
                        BoolQueryBuilder filtersQueryBuilder = QueryBuilders.boolQuery();
                        for (QueryBuilder queryBuilder : yearFilterQueryBuilderList) {
                            filtersQueryBuilder.should(queryBuilder);
                        }
                        filtersQueryBuilder.minimumShouldMatch(1);
                        BoolQueryBuilder boolQueryBuilder3 = filtersQueryBuilder;
                    }
                    boolQueryBuilder2.filter((QueryBuilder)var9_23);
                }
                sentenceQueryName = this.getSentenceQueryName();
                boolQueryBuilder2.queryName(sentenceQueryName);
                this.saveSentenceMatchFieldName(sentenceQueryName, new ArrayList<String>(querySentenceMatchedFieldNameSet));
                boolQueryBuilder.should((QueryBuilder)boolQueryBuilder2);
            }
        }
        boolQueryBuilder.minimumShouldMatch(1);
        this.saveQuerySentenceMatchedFieldNameMapToContext();
        this.context.putQueryMatcherMatchedFieldNameMap(this.matchName, CollectionUtils.arrayToList(this.queryUsedFieldNameSet.toArray()));
        return boolQueryBuilder.boost(this.boost);
    }

    private List<Term> assemblyForOneWordImpl(String qStr) {
        String q = SearchUtils.takeStrByPrefixLimit(StringUtils.delPunct(qStr.toLowerCase().trim()), this.MATCHER_FUZZY_TERM_LETTER_LIMIT);
        ArrayList<Term> workTermList = new ArrayList<Term>();
        int charMinLenth = Math.round(0.75f * (float)q.length());
        if (q.length() >= 8) {
            charMinLenth = Math.round(0.66f * (float)q.length());
        }
        Term term = new Term(q);
        term.setOperator(Operator.OR);
        workTermList.add(term);
        if (this.globalBoost == 1.0f) {
            this.globalBoost = 0.8f;
        }
        String innerMatchFiedName = "";
        innerMatchFiedName = StringUtils.isEmpty(this.matchFieldName) ? this.context.getAttribure("mininum_full_text_field") : this.matchFieldName;
        term.setMatchedFieldName(innerMatchFiedName);
        if (StringUtils.isEmpty(this.analyzerName)) {
            term.setAnalyzer(this.getMinimalAnalyzerName(charMinLenth));
        } else {
            term.setAnalyzer(this.analyzerName);
        }
        return workTermList;
    }

    private List<Term> assemblyForTwoWordImpl(String workQ) {
        String q = workQ.toLowerCase();
        q = q.replaceAll("-", " ").trim();
        String[] newQs = q.split("([\\s\\p{Zs}])+");
        newQs[0] = SearchUtils.takeStrByPrefixLimit(StringUtils.delPunct(newQs[0]), this.MATCHER_FUZZY_TERM_LETTER_LIMIT);
        newQs[1] = SearchUtils.takeStrByPrefixLimit(StringUtils.delPunct(newQs[1]), this.MATCHER_FUZZY_TERM_LETTER_LIMIT);
        ArrayList<Term> workTermList = new ArrayList<Term>();
        List<Term> workTermList4ParseMain = this.parseMainStrForTwoWords(newQs);
        for (Term term : workTermList4ParseMain) {
            term.setOperator(Operator.AND);
        }
        workTermList.addAll(workTermList4ParseMain);
        List<Term> workTermList4ParseLeader = this.parseLeaderTailerStr4TwoWord(newQs);
        for (Term term : workTermList4ParseLeader) {
            term.setOperator(Operator.AND);
        }
        workTermList.addAll(workTermList4ParseLeader);
        return workTermList;
    }

    private Term makeTerm(String str, float boost) {
        CompareableTerm term = new CompareableTerm(str);
        if (StringUtils.isEmpty(this.matchFieldName)) {
            term.setMatchedFieldName(this.context.getAttribure("mininum_full_text_field"));
        } else {
            term.setMatchedFieldName(this.matchFieldName);
        }
        if (StringUtils.isEmpty(this.analyzerName)) {
            int len = str.trim().length();
            int analyzerLen = 4;
            if (len >= 6) {
                analyzerLen = len - 2;
            } else if (len >= 4) {
                analyzerLen = len;
            }
            term.setAnalyzer(this.getMinimalAnalyzerName(analyzerLen));
        } else {
            term.setAnalyzer(this.analyzerName);
        }
        term.setBoost(boost);
        return term;
    }

    private List<Term> parseLeaderTailerStr4TwoWord(String[] newQs) {
        ArrayList<Term> workTermList = new ArrayList<Term>();
        String minimalQ = "";
        String tempQ = newQs[0] + newQs[1];
        if (newQs[0].length() >= 7 || newQs[1].length() >= 7) {
            if (newQs[0].length() >= newQs[1].length()) {
                minimalQ = newQs[0] + newQs[1].substring(0, Math.min(2, newQs[1].length()));
                workTermList.add(this.makeTerm(minimalQ, 1.0f));
                minimalQ = newQs[0] + newQs[1].substring(0, 1);
                workTermList.add(this.makeTerm(minimalQ, 1.0f));
                minimalQ = newQs[1].substring(newQs[1].length() - Math.min(2, newQs[1].length())) + newQs[0];
                workTermList.add(this.makeTerm(minimalQ, 0.5f));
                minimalQ = newQs[1].substring(newQs[1].length() - 1) + newQs[0];
                workTermList.add(this.makeTerm(minimalQ, 0.5f));
                if ((double)((float)(newQs[0].length() - newQs[1].length()) * 1.0f / (float)newQs[1].length()) < 0.45) {
                    minimalQ = newQs[1] + newQs[0].substring(0, Math.round((float)newQs[0].length() * 0.5f));
                    workTermList.add(this.makeTerm(minimalQ, 1.0f));
                    minimalQ = newQs[0].substring(newQs[0].length() - Math.round((float)newQs[0].length() * 0.45f)) + newQs[1];
                    workTermList.add(this.makeTerm(minimalQ, 0.5f));
                }
            } else if (newQs[1].length() > newQs[0].length()) {
                minimalQ = newQs[0].substring(newQs[0].length() - Math.min(2, newQs[0].length())) + newQs[1];
                workTermList.add(this.makeTerm(minimalQ, 1.0f));
                minimalQ = newQs[0].substring(newQs[0].length() - 1) + newQs[1];
                workTermList.add(this.makeTerm(minimalQ, 1.0f));
                minimalQ = newQs[1] + newQs[0].substring(0, 1);
                workTermList.add(this.makeTerm(minimalQ, 0.5f));
                minimalQ = newQs[1] + newQs[0].substring(0, Math.min(2, newQs[0].length()));
                workTermList.add(this.makeTerm(minimalQ, 0.5f));
                if ((double)((float)(newQs[1].length() - newQs[0].length()) * 1.0f / (float)newQs[0].length()) < 0.45) {
                    minimalQ = newQs[1].substring(newQs[1].length() - Math.round((float)newQs[1].length() * 0.5f)) + newQs[0];
                    workTermList.add(this.makeTerm(minimalQ, 0.5f));
                    minimalQ = newQs[0] + newQs[1].substring(0, Math.round((float)newQs[1].length() * 0.45f));
                    workTermList.add(this.makeTerm(minimalQ, 0.5f));
                }
            }
            return workTermList;
        }
        if (tempQ.length() >= 10) {
            if (newQs[0].length() >= newQs[1].length()) {
                minimalQ = newQs[0] + newQs[1].substring(0, 2);
                workTermList.add(this.makeTerm(minimalQ, 1.0f));
                minimalQ = newQs[1].substring(newQs[1].length() - 2) + newQs[0];
                workTermList.add(this.makeTerm(minimalQ, 0.5f));
                if ((double)((float)(newQs[0].length() - newQs[1].length()) * 1.0f / (float)newQs[1].length()) < 0.33) {
                    minimalQ = newQs[1] + newQs[0].substring(0, 2);
                    workTermList.add(this.makeTerm(minimalQ, 0.5f));
                    minimalQ = newQs[0].substring(newQs[0].length() - 2) + newQs[1];
                    workTermList.add(this.makeTerm(minimalQ, 0.5f));
                } else if ((double)((float)(newQs[0].length() - newQs[1].length()) * 1.0f / (float)newQs[1].length()) <= 0.5) {
                    minimalQ = newQs[1] + newQs[0].substring(0, 3);
                    workTermList.add(this.makeTerm(minimalQ, 0.5f));
                    minimalQ = newQs[0].substring(newQs[0].length() - 3) + newQs[1];
                    workTermList.add(this.makeTerm(minimalQ, 0.5f));
                }
            } else if (newQs[1].length() > newQs[0].length()) {
                minimalQ = newQs[0].substring(newQs[0].length() - 2) + newQs[1];
                workTermList.add(this.makeTerm(minimalQ, 1.0f));
                minimalQ = newQs[1] + newQs[0].substring(0, 2);
                workTermList.add(this.makeTerm(minimalQ, 0.8f));
                if ((double)((float)(newQs[1].length() - newQs[0].length()) * 1.0f / (float)newQs[0].length()) < 0.33) {
                    minimalQ = newQs[1].substring(newQs[1].length() - 2) + newQs[0];
                    workTermList.add(this.makeTerm(minimalQ, 0.8f));
                    minimalQ = newQs[0] + newQs[1].substring(0, 2);
                    workTermList.add(this.makeTerm(minimalQ, 0.8f));
                } else if ((double)((float)(newQs[1].length() - newQs[0].length()) * 1.0f / (float)newQs[0].length()) <= 0.5) {
                    minimalQ = newQs[1].substring(newQs[1].length() - 3) + newQs[0];
                    workTermList.add(this.makeTerm(minimalQ, 0.8f));
                    minimalQ = newQs[0] + newQs[1].substring(0, 3);
                    workTermList.add(this.makeTerm(minimalQ, 0.8f));
                }
            }
        } else if (tempQ.length() < 10 && tempQ.length() > 7) {
            if (newQs[0].length() >= newQs[1].length()) {
                minimalQ = newQs[0] + newQs[1].substring(0, 1);
                workTermList.add(this.makeTerm(minimalQ, 1.0f));
                minimalQ = newQs[1].substring(newQs[1].length() - 1) + newQs[0];
                workTermList.add(this.makeTerm(minimalQ, 0.8f));
                if ((double)((float)(newQs[0].length() - newQs[1].length()) * 1.0f / (float)newQs[1].length()) < 0.33) {
                    minimalQ = newQs[1] + newQs[0].substring(0, 2);
                    workTermList.add(this.makeTerm(minimalQ, 0.5f));
                    minimalQ = newQs[0].substring(newQs[0].length() - 2) + newQs[1];
                    workTermList.add(this.makeTerm(minimalQ, 0.5f));
                }
            } else if (newQs[1].length() > newQs[0].length()) {
                minimalQ = newQs[0].substring(newQs[0].length() - 1) + newQs[1];
                workTermList.add(this.makeTerm(minimalQ, 0.8f));
                minimalQ = newQs[1] + newQs[0].substring(0, 2);
                workTermList.add(this.makeTerm(minimalQ, 1.0f));
                if ((double)((float)(newQs[1].length() - newQs[0].length()) * 1.0f / (float)newQs[0].length()) < 0.33) {
                    minimalQ = newQs[1].substring(newQs[1].length() - 2) + newQs[0];
                    workTermList.add(this.makeTerm(minimalQ, 0.8f));
                    minimalQ = newQs[0] + newQs[1].substring(0, 2);
                    workTermList.add(this.makeTerm(minimalQ, 0.8f));
                }
            }
        } else if (newQs[0].length() >= newQs[1].length()) {
            minimalQ = newQs[0] + newQs[1].substring(0, Math.min(newQs[1].length(), 2));
            workTermList.add(this.makeTerm(minimalQ, 1.0f));
            minimalQ = newQs[1].substring(newQs[1].length() - Math.min(newQs[1].length(), 2)) + newQs[0];
            workTermList.add(this.makeTerm(minimalQ, 0.8f));
            if ((double)((float)(newQs[0].length() - newQs[1].length()) * 1.0f / (float)newQs[1].length()) <= 0.5) {
                minimalQ = newQs[1] + newQs[0].substring(0, Math.min(newQs[0].length(), 2));
                workTermList.add(this.makeTerm(minimalQ, 0.2f));
                minimalQ = newQs[0].substring(newQs[0].length() - Math.min(newQs[0].length(), 2)) + newQs[1];
                workTermList.add(this.makeTerm(minimalQ, 0.2f));
            }
        } else if (newQs[1].length() > newQs[0].length()) {
            minimalQ = newQs[0].substring(newQs[0].length() - Math.min(newQs[0].length(), 2)) + newQs[1];
            workTermList.add(this.makeTerm(minimalQ, 0.8f));
            minimalQ = newQs[1] + newQs[0].substring(0, Math.min(newQs[0].length(), 2));
            workTermList.add(this.makeTerm(minimalQ, 1.0f));
            if ((double)((float)(newQs[1].length() - newQs[0].length()) * 1.0f / (float)newQs[0].length()) <= 0.5) {
                minimalQ = newQs[1].substring(newQs[1].length() - Math.min(newQs[1].length(), 2)) + newQs[0];
                workTermList.add(this.makeTerm(minimalQ, 0.2f));
                minimalQ = newQs[0] + newQs[1].substring(0, Math.min(newQs[1].length(), 2));
                workTermList.add(this.makeTerm(minimalQ, 0.2f));
            }
        }
        return workTermList;
    }

    private String getSuffix(String item, float rate) {
        int wantedCharsLen = Math.round((float)item.length() * rate);
        return item.substring(item.length() - wantedCharsLen);
    }

    @Override
    public Matcher.QUERY_TERM_TYPE queryTermType() {
        String q = this.getQ();
        if (q.isEmpty()) {
            return Matcher.QUERY_TERM_TYPE.NONE;
        }
        String[] newQs = (q = q.replace("-", " ").trim()).split("([\\s\\p{Zs}])+");
        if (newQs.length == 1) {
            return Matcher.QUERY_TERM_TYPE.ONE_WORD;
        }
        if (newQs.length == 2) {
            return Matcher.QUERY_TERM_TYPE.TWO_WORD;
        }
        if (newQs.length == 3) {
            return Matcher.QUERY_TERM_TYPE.EXTRA_THREE_WORD;
        }
        if (newQs.length > 3) {
            return Matcher.QUERY_TERM_TYPE.MORE_WORD;
        }
        return Matcher.QUERY_TERM_TYPE.NONE;
    }

    private List<Term> assemblyForThreeWordImpl(String qStr) {
        ArrayList<Term> workTermList = new ArrayList<Term>();
        String q = qStr.toLowerCase();
        q = q.replace("-", " ").trim();
        String[] newQs = q.split("([\\s\\p{Zs}])+");
        for (int i = 0; i < newQs.length; ++i) {
            newQs[i] = SearchUtils.takeStrByPrefixLimit(StringUtils.delPunct(newQs[i]), this.MATCHER_FUZZY_TERM_LETTER_LIMIT);
        }
        int charsCount = 0;
        for (String str : newQs) {
            charsCount += str.length();
        }
        StringBuilder sBuilder = new StringBuilder();
        for (int i = 1; i < newQs.length - 1; ++i) {
            sBuilder.append(newQs[i]);
        }
        int midCharsCount = sBuilder.length();
        float wantedCharsCount = Math.round((float)charsCount * 0.65f);
        int firstCharsLen = Math.round((wantedCharsCount - (float)midCharsCount) * (float)newQs[0].length() / (float)(charsCount - midCharsCount) * 1.0f);
        int tailCharsLen = (int)wantedCharsCount - midCharsCount - firstCharsLen;
        String firstChars = MininumStrMatcher.getSuffix(StringUtils.delPunct(newQs[0]), Math.max(2, firstCharsLen));
        String tailChars = MininumStrMatcher.getPrefix(StringUtils.delPunct(newQs[newQs.length - 1]), Math.max(2, tailCharsLen));
        String midChars = sBuilder.toString();
        String minimalQ = firstChars + midChars + tailChars;
        Term workTerm = this.createWorkTerm(minimalQ);
        workTermList.add(workTerm);
        String newNorms = SearchUtils.tryToMissWordByLooseRule(q).trim();
        boolean hasInvalidWord = false;
        String[] newNormList = null;
        if (!StringUtils.isEmpty(newNorms) && newNorms.length() != q.length()) {
            newNormList = newNorms.split("([\\s\\p{Zs}])+");
            hasInvalidWord = true;
        }
        if (hasInvalidWord) {
            minimalQ = this.finalMinimalQStr((String)newNormList[0], Math.round((float)charsCount * 0.7f), newNormList, 1, true);
            if (minimalQ.length() == newNormList[0].length()) {
                minimalQ = minimalQ + newNormList[1].substring(0, 1);
            }
            workTerm = this.createWorkTerm(minimalQ);
            workTerm.setOperator(Operator.AND);
            workTermList.add(workTerm);
        }
        if ((minimalQ = this.finalMinimalQStr(newQs[0] + newQs[1], Math.round(wantedCharsCount), newQs, 2, true)).length() <= newQs[0].length() + newQs[1].length()) {
            minimalQ = newQs[0] + newQs[1] + newQs[2].substring(0, 1);
        }
        workTerm = this.createWorkTerm(minimalQ);
        workTermList.add(workTerm);
        if (hasInvalidWord) {
            minimalQ = this.finalMinimalQStr(newNormList[1], Math.round((float)charsCount * 0.7f), newNormList, 0, false);
            if (minimalQ.length() == newNormList[1].length()) {
                minimalQ = newNormList[0].substring(newNormList[0].length() - 1) + minimalQ;
            }
            workTerm = this.createWorkTerm(minimalQ);
            workTermList.add(workTerm);
        }
        if ((minimalQ = this.finalMinimalQStr(newQs[1] + newQs[2], Math.round(wantedCharsCount), newQs, 0, false)).length() <= newQs[1].length() + newQs[2].length()) {
            minimalQ = newQs[0].substring(newQs[0].length() - 1) + newQs[1] + newQs[2];
        }
        workTerm = this.createWorkTerm(minimalQ);
        workTermList.add(workTerm);
        if (this.globalBoost == 1.0f) {
            this.globalBoost = 1.5f;
        }
        return workTermList;
    }

    private String finalMinimalQStr(String mainStr, int wantedCharsCount, String[] newQs, int appendWordIndex, Boolean appendTotail) {
        int appendCharsLen = wantedCharsCount - mainStr.length();
        if (appendCharsLen < 0) {
            mainStr = mainStr.substring(0, mainStr.length() + appendCharsLen);
        } else if (appendCharsLen > 0) {
            mainStr = appendTotail != false ? mainStr + newQs[appendWordIndex].substring(0, Math.min(appendCharsLen, newQs[appendWordIndex].length())) : newQs[appendWordIndex].substring(Math.max(0, newQs[appendWordIndex].length() - appendCharsLen)) + mainStr;
        }
        return mainStr;
    }

    private Term createWorkTerm(String minimalQ) {
        CompareableTerm workTerm = new CompareableTerm(minimalQ);
        if (StringUtils.isEmpty(this.matchFieldName)) {
            workTerm.setMatchedFieldName(this.context.getAttribure("mininum_full_text_field"));
        } else {
            workTerm.setMatchedFieldName(this.matchFieldName);
        }
        if (!StringUtils.isEmpty(this.analyzerName)) {
            workTerm.setAnalyzer(this.analyzerName);
        } else {
            workTerm.setAnalyzer(this.context.getAttribure("word_analyzer_name"));
        }
        return workTerm;
    }

    private List<Term> parseMainStrForTwoWords(String[] newQs) {
        ArrayList<Term> workTermList = new ArrayList<Term>();
        String minimalQ = "";
        String firstItem = "";
        String secondItem = "";
        if (newQs[0].length() <= 2 || newQs[1].length() <= 2) {
            if (newQs[0].length() <= 2) {
                if (newQs[1].length() <= 5 && newQs[1].length() > 2) {
                    try {
                        minimalQ = newQs[0].substring(Math.min(1, newQs[0].length() - 1)) + newQs[1];
                    }
                    catch (Exception e) {
                        this.logger.error("error :newQs[0]: {} q: {}", (Object)newQs[0], (Object)this.q);
                        throw e;
                    }
                } else {
                    minimalQ = newQs[1].length() > 5 ? newQs[1] : newQs[0] + newQs[1];
                }
            } else {
                minimalQ = newQs[0].length() > 2 && newQs[0].length() <= 6 ? newQs[0] + newQs[1].substring(0, 1) : newQs[0];
            }
        } else {
            if (newQs[1].length() >= 9) {
                if (newQs[0].length() <= 6 && newQs[0].length() > 4) {
                    firstItem = newQs[0].substring(newQs[0].length() - Math.min(2, newQs[0].length()));
                    secondItem = MininumStrMatcher.getPrefix(newQs[1], 0.65f);
                } else if (newQs[0].length() > 6 && newQs[0].length() < 9) {
                    firstItem = this.getSuffix(newQs[0], 0.5f);
                    secondItem = MininumStrMatcher.getPrefix(newQs[1], 0.9f);
                } else if (newQs[0].length() >= 9) {
                    firstItem = this.getSuffix(newQs[0], 0.65f);
                    secondItem = MininumStrMatcher.getPrefix(newQs[1], 0.65f);
                } else {
                    firstItem = this.getSuffix(newQs[0], 0.33f);
                    secondItem = newQs[1];
                }
            } else if (newQs[1].length() > 6 && newQs[1].length() < 9) {
                if (newQs[0].length() <= 6 && newQs[0].length() > 4) {
                    firstItem = this.getSuffix(newQs[0], 0.45f);
                    secondItem = MininumStrMatcher.getPrefix(newQs[1], 0.7f);
                } else if (newQs[0].length() > 6 && newQs[0].length() < 9) {
                    firstItem = this.getSuffix(newQs[0], 0.65f);
                    secondItem = MininumStrMatcher.getPrefix(newQs[1], 0.65f);
                } else if (newQs[0].length() >= 9) {
                    firstItem = this.getSuffix(newQs[0], 0.9f);
                    secondItem = MininumStrMatcher.getPrefix(newQs[1], 0.55f);
                } else if (newQs[0].length() == 4) {
                    firstItem = this.getSuffix(newQs[0], 0.5f);
                    secondItem = MininumStrMatcher.getPrefix(newQs[1], 0.6f);
                } else {
                    firstItem = newQs[0];
                    secondItem = MininumStrMatcher.getPrefix(newQs[1], 0.6f);
                }
            } else if (newQs[1].length() > 4 && newQs[1].length() <= 6) {
                if (newQs[0].length() <= 6 && newQs[0].length() > 4) {
                    firstItem = this.getSuffix(newQs[0], 0.65f);
                    secondItem = MininumStrMatcher.getPrefix(newQs[1], 0.65f);
                } else if (newQs[0].length() > 6 && newQs[0].length() < 9) {
                    firstItem = this.getSuffix(newQs[0], 0.7f);
                    secondItem = MininumStrMatcher.getPrefix(newQs[1], 0.45f);
                } else if (newQs[0].length() >= 9) {
                    firstItem = this.getSuffix(newQs[0], 0.65f);
                    secondItem = newQs[1].substring(0, Math.min(2, newQs[1].length()));
                } else {
                    firstItem = this.getSuffix(newQs[0], 0.75f);
                    secondItem = MininumStrMatcher.getPrefix(newQs[1], 0.65f);
                }
            } else if (newQs[1].length() <= 4) {
                if (newQs[0].length() <= 6 && newQs[0].length() > 4) {
                    firstItem = this.getSuffix(newQs[0], 0.65f);
                    secondItem = MininumStrMatcher.getPrefix(newQs[1], 0.65f);
                } else if (newQs[0].length() > 6 && newQs[0].length() < 9) {
                    firstItem = this.getSuffix(newQs[0], 0.6f);
                    secondItem = MininumStrMatcher.getPrefix(newQs[1], 0.5f);
                } else if (newQs[0].length() >= 9) {
                    firstItem = newQs[0];
                    secondItem = MininumStrMatcher.getPrefix(newQs[1], 0.33f);
                } else if (newQs[0].length() < newQs[1].length()) {
                    firstItem = newQs[0].substring(Math.round((float)newQs[0].length() / 2.0f));
                    secondItem = newQs[1];
                } else {
                    firstItem = newQs[0];
                    secondItem = newQs[1].substring(0, Math.round((float)newQs[0].length() / 2.0f));
                }
                if (StringUtils.isEmpty(secondItem)) {
                    secondItem = newQs[1];
                }
            }
            minimalQ = firstItem + secondItem;
        }
        if (!StringUtils.isEmpty(minimalQ)) {
            workTermList.add(this.makeTerm(minimalQ, 1.0f));
        }
        return workTermList;
    }

    private String getMinimalAnalyzerName(int minCharLen) {
        String innerAnalyzerName;
        switch (minCharLen) {
            case 1: {
                innerAnalyzerName = (String)this.analyzerNameMap.get((Object)AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_ONE_CHARS);
                break;
            }
            case 2: {
                innerAnalyzerName = (String)this.analyzerNameMap.get((Object)AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_TWO_CHARS);
                break;
            }
            case 3: {
                innerAnalyzerName = (String)this.analyzerNameMap.get((Object)AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_THREE_CHARS);
                break;
            }
            case 4: {
                innerAnalyzerName = (String)this.analyzerNameMap.get((Object)AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_FOUR_CHARS);
                break;
            }
            case 5: {
                innerAnalyzerName = (String)this.analyzerNameMap.get((Object)AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_FIVE_CHARS);
                break;
            }
            case 6: {
                innerAnalyzerName = (String)this.analyzerNameMap.get((Object)AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_SIX_CHARS);
                break;
            }
            case 7: {
                innerAnalyzerName = (String)this.analyzerNameMap.get((Object)AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_SEVEN_CHARS);
                break;
            }
            case 8: {
                innerAnalyzerName = (String)this.analyzerNameMap.get((Object)AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_EIGHT_CHARS);
                break;
            }
            case 9: {
                innerAnalyzerName = (String)this.analyzerNameMap.get((Object)AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_MORE_CHARS);
                break;
            }
            default: {
                innerAnalyzerName = (String)this.analyzerNameMap.get((Object)AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_MORE_CHARS);
            }
        }
        return innerAnalyzerName;
    }

    @Override
    public void prepareByConfig(MatcherConfig config) {
        this.matcherConfig = config;
        MatcherParams matcherParams = this.matcherConfig.getMatcherParams();
        if (!StringUtils.isEmpty(matcherParams.getMatchFieldName())) {
            this.setMatchFieldName(matcherParams.getMatchFieldName());
        } else {
            this.setMatchFieldName(this.context.getAttribure("mininum_full_text_field"));
        }
        if (!StringUtils.isEmpty(matcherParams.getAnalyzerName())) {
            this.setAnalyzerName(matcherParams.getAnalyzerName());
        }
        if (!StringUtils.isEmpty(this.matcherConfig.getIdName())) {
            this.matchName = this.matcherConfig.getIdName();
        }
        this.boost = this.matcherConfig.getMatcherParams().getBoost();
        this.globalBoost = this.matcherConfig.getMatcherParams().getGlobalBoost();
        super.prepareByConfig(this.matcherConfig);
        this.init();
    }

    private List<Term> assembly4Year(String strQ) {
        ArrayList<Term> workTermList = new ArrayList<Term>();
        Map<String, List<String>> yearSplitMap = SearchUtils.splitByYear(strQ);
        if (!(CollectionUtils.isEmpty(yearSplitMap) || CollectionUtils.isEmpty((Collection)yearSplitMap.get("keywords")) || CollectionUtils.isEmpty((Collection)yearSplitMap.get("years")))) {
            String keywords = yearSplitMap.get("keywords").get(0);
            String[] splitKeywords = keywords.split("([\\s\\p{Zs}])+");
            List<Term> workTermList4Year = null;
            if (splitKeywords.length == 2) {
                workTermList4Year = this.assemblyForTwoWordImpl4Year(keywords, yearSplitMap.get("years"));
            } else if (splitKeywords.length == 1) {
                workTermList4Year = this.assemblyForOneWordImpl4Year(keywords, yearSplitMap.get("years"));
            }
            if (!CollectionUtils.isEmpty(workTermList4Year)) {
                workTermList.addAll(workTermList4Year);
            }
        }
        return workTermList;
    }

    private void assembly4CaseOneWord() {
        List<Term> workTermList;
        List<Term> workTermList4Year;
        Boolean isOk = false;
        if (this.matcherConfig.getYearFlag().booleanValue() && !CollectionUtils.isEmpty(workTermList4Year = this.assembly4Year(this.q))) {
            this.yearTermList.addAll(workTermList4Year);
            isOk = true;
        }
        if (!isOk.booleanValue() && !CollectionUtils.isEmpty(workTermList = this.assemblyForOneWordImpl(this.q.trim()))) {
            this.mainTermList.addAll(workTermList);
        }
    }

    private void assembly4CaseThreeWord() {
        String aliasQ;
        List<Term> workTermList;
        List<Term> workTermList4Year;
        boolean isOk = false;
        if (this.matcherConfig.getYearFlag().booleanValue() && !CollectionUtils.isEmpty(workTermList4Year = this.assembly4Year(this.q))) {
            this.yearTermList.addAll(workTermList4Year);
            isOk = true;
        }
        if (!isOk && !CollectionUtils.isEmpty(workTermList = this.assemblyForThreeWordImpl(this.q))) {
            this.mainTermList.addAll(workTermList);
        }
        if (!StringUtils.isEmpty(aliasQ = SearchUtils.takeAliasStr(this.q, 3).trim()) && aliasQ.split("([\\s\\p{Zs}])+").length < this.q.split("([\\s\\p{Zs}])+").length) {
            this.context.putAttribute("execute_partiword_alis_query", aliasQ);
            int nLen = aliasQ.split("([\\s\\p{Zs}])+").length;
            if (nLen == 1) {
                List<Term> workTermList2;
                List<Term> workTermList4Year2;
                isOk = false;
                if (this.matcherConfig.getYearFlag().booleanValue() && !CollectionUtils.isEmpty(workTermList4Year2 = this.assembly4Year(aliasQ))) {
                    this.yearTermList.addAll(workTermList4Year2);
                    isOk = true;
                }
                if (!isOk && !CollectionUtils.isEmpty(workTermList2 = this.assemblyForOneWordImpl(aliasQ))) {
                    this.mainTermList.addAll(workTermList2);
                }
            } else if (nLen == 2) {
                List<Term> workTermList3;
                List<Term> workTermList4Year3;
                isOk = false;
                if (this.matcherConfig.getYearFlag().booleanValue() && !CollectionUtils.isEmpty(workTermList4Year3 = this.assembly4Year(aliasQ))) {
                    this.yearTermList.addAll(workTermList4Year3);
                    isOk = true;
                }
                if (!isOk && !CollectionUtils.isEmpty(workTermList3 = this.assemblyForTwoWordImpl(aliasQ))) {
                    this.mainTermList.addAll(workTermList3);
                }
            } else {
                List<Term> workTermList4;
                List<Term> workTermList4Year4;
                isOk = false;
                if (this.matcherConfig.getYearFlag().booleanValue() && !CollectionUtils.isEmpty(workTermList4Year4 = this.assembly4Year(this.q))) {
                    this.yearTermList.addAll(workTermList4Year4);
                    isOk = true;
                }
                if (!isOk && !CollectionUtils.isEmpty(workTermList4 = this.assemblyForThreeWordImpl(this.q))) {
                    this.mainTermList.addAll(workTermList4);
                }
            }
        }
        if (this.globalBoost == 1.0f) {
            this.globalBoost = 1.8f;
        }
    }

    private void assembly4CaseTwoWord() {
        String aliasQ = SearchUtils.takeAliasStr(this.q, 3).trim();
        if (!StringUtils.isEmpty(aliasQ) && aliasQ.split("([\\s\\p{Zs}])+").length < this.q.split("([\\s\\p{Zs}])+").length) {
            List<Term> workTermList;
            List<Term> workTermList4Year;
            boolean isOk = false;
            if (this.matcherConfig.getYearFlag().booleanValue() && !CollectionUtils.isEmpty(workTermList4Year = this.assembly4Year(aliasQ))) {
                this.yearTermList.addAll(workTermList4Year);
                isOk = true;
            }
            if (!isOk && !CollectionUtils.isEmpty(workTermList = this.assemblyForOneWordImpl(aliasQ))) {
                this.mainTermList.addAll(workTermList);
            }
        } else {
            List<Term> workTermList;
            List<Term> workTermList4Year;
            boolean isOk = false;
            if (this.matcherConfig.getYearFlag().booleanValue() && !CollectionUtils.isEmpty(workTermList4Year = this.assembly4Year(this.q))) {
                this.yearTermList.addAll(workTermList4Year);
                isOk = true;
            }
            if (!isOk && !CollectionUtils.isEmpty(workTermList = this.assemblyForTwoWordImpl(this.q))) {
                this.mainTermList.addAll(workTermList);
            }
        }
    }

    private void assembly4CaseMoreWord() {
        String q = this.q.toLowerCase();
        q = q.replaceAll("-", " ").trim();
        String[] newQs = q.split("([\\s\\p{Zs}])+");
        int charsCount = 0;
        for (String str : newQs) {
            charsCount += str.length();
        }
        StringBuilder sBuilder = new StringBuilder();
        for (int i = 1; i < newQs.length - 1; ++i) {
            sBuilder.append(StringUtils.delPunct(newQs[i]).trim());
        }
        int midCharsCount = sBuilder.length();
        float wantedCharsCount = Math.round((float)charsCount * 0.65f);
        int firstCharsLen = Math.round((wantedCharsCount - (float)midCharsCount) * (float)newQs[0].length() / (float)(charsCount - midCharsCount) * 1.0f);
        int tailCharsLen = (int)wantedCharsCount - midCharsCount - firstCharsLen;
        String firstChars = MininumStrMatcher.getSuffix(StringUtils.delPunct(newQs[0]), Math.max(2, firstCharsLen));
        String tailChars = MininumStrMatcher.getPrefix(StringUtils.delPunct(newQs[newQs.length - 1]), Math.max(2, tailCharsLen));
        String midChars = sBuilder.toString();
        String minimalQ = firstChars + midChars + tailChars;
        if (minimalQ.length() > this.MATCHER_FUZZY_TERM_LETTER_LIMIT) {
            return;
        }
        Term firstTerm = new Term(minimalQ);
        if (StringUtils.isEmpty(this.matchFieldName)) {
            firstTerm.setMatchedFieldName(this.context.getAttribure("mininum_full_text_field"));
        } else {
            firstTerm.setMatchedFieldName(this.matchFieldName);
        }
        if (StringUtils.isEmpty(this.analyzerName)) {
            firstTerm.setAnalyzer(this.context.getAttribure("word_analyzer_name"));
        } else {
            firstTerm.setAnalyzer(this.analyzerName);
        }
        this.mainTermList.add(firstTerm);
        if (this.globalBoost == 1.0f) {
            this.globalBoost = 1.5f;
        }
    }

    private List<Term> assemblyForOneWordImpl4Year(String keyword, List<String> years) {
        ArrayList<Term> workTermList = new ArrayList<Term>();
        keyword = SearchUtils.takeStrByPrefixLimit(keyword, this.MATCHER_FUZZY_TERM_LETTER_LIMIT);
        int charMinLenth = Math.round(0.75f * (float)keyword.length());
        if (keyword.length() >= 8) {
            charMinLenth = Math.round(0.66f * (float)keyword.length());
        }
        Term term = new Term(keyword);
        term.setYearList(years);
        term.setOperator(Operator.OR);
        workTermList.add(term);
        if (this.globalBoost == 1.0f) {
            this.globalBoost = 0.8f;
        }
        String innerMatchfieldName = "";
        innerMatchfieldName = StringUtils.isEmpty(this.matchFieldName) ? this.context.getAttribure("mininum_full_text_field") : this.matchFieldName;
        term.setMatchedFieldName(innerMatchfieldName);
        if (StringUtils.isEmpty(this.analyzerName)) {
            term.setAnalyzer(this.getMinimalAnalyzerName(charMinLenth));
        } else {
            term.setAnalyzer(this.analyzerName);
        }
        return workTermList;
    }

    private List<Term> assemblyForTwoWordImpl4Year(String keywords, List<String> yearsList) {
        ArrayList<Term> workTermList = new ArrayList<Term>();
        String[] newQs = keywords.split("([\\s\\p{Zs}])+");
        newQs[0] = SearchUtils.takeStrByPrefixLimit(StringUtils.delPunct(newQs[0]), this.MATCHER_FUZZY_TERM_LETTER_LIMIT);
        newQs[1] = SearchUtils.takeStrByPrefixLimit(StringUtils.delPunct(newQs[1]), this.MATCHER_FUZZY_TERM_LETTER_LIMIT);
        List<Term> workTermList4ParseMain = this.parseMainStrForTwoWords(newQs);
        for (Term term : workTermList4ParseMain) {
            term.setOperator(Operator.AND);
        }
        workTermList.addAll(workTermList4ParseMain);
        List<Term> workTermList4ParseLeader = this.parseLeaderTailerStr4TwoWord(newQs);
        for (Term term : workTermList4ParseLeader) {
            term.setOperator(Operator.AND);
        }
        workTermList.addAll(workTermList4ParseLeader);
        for (Term term : workTermList) {
            term.setYearList(yearsList);
        }
        return workTermList;
    }

    private String getSentenceQueryName() {
        return "check_minimumStr_" + this.matchsentenceCount.getAndIncrement();
    }
}

