/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.matcher;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.matcher.AbstractFuzzyMatcher;
import com.valor.common.search.engine.matcher.Matcher;
import com.valor.common.search.engine.matcher.Term;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class MultiFieldPhraseMatcher
extends AbstractFuzzyMatcher {
    public static final String DEFAULT_MATCH_NAME = "MultiFieldPhraseMatcher";
    private List<Term> termList = new ArrayList<Term>();
    private DISTANCE_TYPE distanceType = DISTANCE_TYPE.BY_WORD;
    private int distance = 1;
    private Set<String> queryUsedFieldNameSet = new HashSet<String>();
    private final List<ImmutablePair<String, Float>> multiMatchFieldNames = new ArrayList<ImmutablePair<String, Float>>();

    public MultiFieldPhraseMatcher(RequestContext context, List<ImmutablePair<String, Float>> multiMatchFieldNames) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.q = context.getQ().trim();
        this.context = context;
        this.multiMatchFieldNames.addAll(multiMatchFieldNames);
        this.matchFieldName = context.getAttribure("fuzzy_full_text_field");
        this.init();
    }

    public MultiFieldPhraseMatcher(RequestContext context, int distance, DISTANCE_TYPE distanceType, List<ImmutablePair<String, Float>> multiMatchFieldNames) {
        this.matchName = DEFAULT_MATCH_NAME;
        if (distance < 0 || distance > 2) {
            throw new RuntimeException("Distance mut be 0,1,2");
        }
        this.q = context.getQ().trim();
        this.context = context;
        this.matchFieldName = context.getAttribure("fuzzy_full_text_field");
        this.distance = distance;
        this.distanceType = distanceType;
        this.init();
    }

    private void init() {
        ArrayList<String> multiFieldNamesList = new ArrayList<String>();
        for (ImmutablePair<String, Float> p : this.multiMatchFieldNames) {
            multiFieldNamesList.add((String)p.getLeft());
        }
        this.context.saveMultiMatcheNameandMatcheFieldNamePair(this.matchName, multiFieldNamesList);
    }

    @Override
    public Matcher.MATCHER_TYPE getMatcherType() {
        return Matcher.MATCHER_TYPE.GENERAL_FUZZY;
    }

    @Override
    public MultiFieldPhraseMatcher assembly() {
        this.termList.clear();
        this.q = this.context.getQ().trim().toLowerCase();
        if (this.distanceType.equals((Object)DISTANCE_TYPE.BY_WORD)) {
            String[] newQs;
            for (String str : newQs = this.q.split("([\\s\\p{Zs}])+")) {
                this.assemblyInternal(str);
            }
        } else {
            this.assemblyInternal(this.q);
        }
        return this;
    }

    private void assemblyInternal(String str) {
        Term term = new Term(str);
        term.setFuzzyDistance(this.distance);
        term.setMatchedFieldName(this.matchFieldName);
        if (!StringUtils.isEmpty(this.analyzerName)) {
            term.setAnalyzer(this.analyzerName);
        }
        this.termList.add(term);
    }

    @Override
    public QueryBuilder buildBase() {
        BoolQueryBuilder boolQueryBuilder;
        BoolQueryBuilder retVal = null;
        HashMap<String, Float> fieldBoostMap = new HashMap<String, Float>();
        HashMap<String, Object> allLetterSubIndexFieldBoostMap = new HashMap<String, Object>();
        HashMap<String, Object> wordSubIndexFieldBoostMap = new HashMap<String, Object>();
        int nSlop = 20;
        for (ImmutablePair<String, Float> immutablePair : this.multiMatchFieldNames) {
            fieldBoostMap.put((String)immutablePair.getLeft(), (Float)immutablePair.getRight());
            allLetterSubIndexFieldBoostMap.put((String)immutablePair.getLeft() + "." + "all_letters", immutablePair.getRight());
            wordSubIndexFieldBoostMap.put((String)immutablePair.getLeft() + "." + "word_letters", immutablePair.getRight());
        }
        if (this.distanceType == DISTANCE_TYPE.BY_WORD) {
            MatchPhraseQueryBuilder queryItem;
            boolQueryBuilder = QueryBuilders.boolQuery();
            for (Map.Entry entry : fieldBoostMap.entrySet()) {
                BoolQueryBuilder prefixQueryBuilderByFields = QueryBuilders.boolQuery();
                for (Term term : this.termList) {
                    queryItem = (MatchPhraseQueryBuilder)QueryBuilders.matchPhraseQuery((String)((String)entry.getKey()), (Object)term.getTermStr()).boost(((Float)fieldBoostMap.get(entry.getKey())).floatValue() * 5.0f * this.boost);
                    if (!StringUtils.isEmpty(term.getAnalyzer())) {
                        queryItem.analyzer(term.getAnalyzer());
                    }
                    prefixQueryBuilderByFields.must((QueryBuilder)queryItem);
                }
                boolQueryBuilder.should((QueryBuilder)prefixQueryBuilderByFields);
            }
            for (String string : allLetterSubIndexFieldBoostMap.keySet()) {
                BoolQueryBuilder allLetterQueryBuilderByFields = QueryBuilders.boolQuery();
                for (Term term : this.termList) {
                    queryItem = (MatchPhraseQueryBuilder)QueryBuilders.matchPhraseQuery((String)string, (Object)term.getTermStr()).boost(((Float)allLetterSubIndexFieldBoostMap.get(string)).floatValue() * 5.0f * this.boost);
                    if (!StringUtils.isEmpty(term.getAnalyzer())) {
                        queryItem.analyzer(term.getAnalyzer());
                    }
                    allLetterQueryBuilderByFields.must((QueryBuilder)queryItem);
                }
                boolQueryBuilder.should((QueryBuilder)allLetterQueryBuilderByFields);
            }
            for (String string : wordSubIndexFieldBoostMap.keySet()) {
                BoolQueryBuilder wordQueryBuilderByFields = QueryBuilders.boolQuery();
                for (Term term : this.termList) {
                    queryItem = ((MatchQueryBuilder)QueryBuilders.matchQuery((String)string, (Object)term.getTermStr()).boost(((Float)wordSubIndexFieldBoostMap.get(string)).floatValue() * 5.0f * this.boost)).operator(Operator.AND);
                    if (!StringUtils.isEmpty(term.getAnalyzer())) {
                        queryItem.analyzer(term.getAnalyzer());
                    }
                    wordQueryBuilderByFields.must((QueryBuilder)queryItem);
                }
                boolQueryBuilder.should((QueryBuilder)wordQueryBuilderByFields);
            }
            boolQueryBuilder.minimumShouldMatch(1);
            BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery();
            for (Term term : this.termList) {
                boolQueryBuilder2.must(this.buildPrefixQuery(fieldBoostMap, term.getTermStr()).boost(this.boost * 5.0f));
            }
            boolQueryBuilder.should((QueryBuilder)boolQueryBuilder2);
            retVal = boolQueryBuilder;
        } else {
            MatchPhraseQueryBuilder queryItem;
            boolQueryBuilder = QueryBuilders.boolQuery();
            for (String string : fieldBoostMap.keySet()) {
                queryItem = (MatchPhraseQueryBuilder)QueryBuilders.matchPhraseQuery((String)string, (Object)this.termList.get(0).getTermStr()).boost(((Float)fieldBoostMap.get(string)).floatValue() * 5.0f * this.boost);
                if (!StringUtils.isEmpty(this.termList.get(0).getAnalyzer())) {
                    queryItem.analyzer(this.termList.get(0).getAnalyzer());
                }
                boolQueryBuilder.should((QueryBuilder)queryItem);
            }
            for (String string : allLetterSubIndexFieldBoostMap.keySet()) {
                queryItem = (MatchPhraseQueryBuilder)QueryBuilders.matchPhraseQuery((String)string, (Object)this.termList.get(0).getTermStr()).boost(((Float)allLetterSubIndexFieldBoostMap.get(string)).floatValue() * 5.0f * this.boost);
                if (!StringUtils.isEmpty(this.termList.get(0).getAnalyzer())) {
                    queryItem.analyzer(this.termList.get(0).getAnalyzer());
                }
                boolQueryBuilder.should((QueryBuilder)queryItem);
            }
            for (String string : wordSubIndexFieldBoostMap.keySet()) {
                queryItem = ((MatchQueryBuilder)QueryBuilders.matchQuery((String)string, (Object)this.termList.get(0).getTermStr()).boost(((Float)wordSubIndexFieldBoostMap.get(string)).floatValue() * 5.0f * this.boost)).operator(Operator.AND);
                if (!StringUtils.isEmpty(this.termList.get(0).getAnalyzer())) {
                    queryItem.analyzer(this.termList.get(0).getAnalyzer());
                }
                boolQueryBuilder.should((QueryBuilder)queryItem);
            }
            boolQueryBuilder.minimumShouldMatch(1);
            boolQueryBuilder.should(this.buildPrefixQuery(fieldBoostMap, this.termList.get(0).getTermStr()).boost(this.boost * 5.0f));
            retVal = boolQueryBuilder;
        }
        this.context.putQueryMatcherMatchedFieldNameMap(this.matchName, CollectionUtils.arrayToList(this.queryUsedFieldNameSet.toArray()));
        return retVal.boost(this.boost);
    }

    private QueryBuilder buildPrefixQuery(Map<String, Float> mainFieldBoostMap, String qStr) {
        BoolQueryBuilder regexpQueryBuilder = QueryBuilders.boolQuery();
        for (Map.Entry<String, Float> entry : mainFieldBoostMap.entrySet()) {
            regexpQueryBuilder.should((QueryBuilder)QueryBuilders.regexpQuery((String)(entry.getKey() + "." + "cut_word"), (String)(qStr.trim() + ".*")).boost(mainFieldBoostMap.get(entry.getKey()).floatValue()));
        }
        regexpQueryBuilder.minimumShouldMatch(1);
        return regexpQueryBuilder;
    }

    @Override
    public MultiFieldPhraseMatcher boost(float boost) {
        this.boost = boost;
        return this;
    }

    public MultiFieldPhraseMatcher analyzer(String analyzerName) {
        this.analyzerName = analyzerName;
        return this;
    }

    public static enum DISTANCE_TYPE {
        BY_WORD(1),
        BY_SENTENCE(2);

        private int type;

        private DISTANCE_TYPE(int type) {
            this.type = type;
        }
    }
}

