/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.matcher;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.facade.config.MatcherConfig;
import com.valor.common.search.engine.facade.config.MatcherParams;
import com.valor.common.search.engine.matcher.AbstractFuzzyMatcher;
import com.valor.common.search.engine.matcher.Matcher;
import com.valor.common.search.engine.matcher.Term;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.SearchUtils;
import com.valor.common.search.engine.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.keyvalue.DefaultKeyValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class PartialWordMatcher
extends AbstractFuzzyMatcher {
    public static final String DEFAULT_MATCH_NAME = "PartialWordMatcher";
    private final OneWordAnalyzer oneWordAnalyzer = new OneWordAnalyzer();
    private final TwoWordAnalyzer twoWordAnalyzer = new TwoWordAnalyzer();
    private final MoreWordAnalyzer moreWordAnalyzer = new MoreWordAnalyzer();
    Logger logger = LoggerFactory.getLogger(PartialWordMatcher.class);
    private float rate = -1.0f;
    private List<Term> mainTermList = new ArrayList<Term>();
    private List<Term> leaderTermList = new ArrayList<Term>();
    private List<Term> tailerTermList = new ArrayList<Term>();
    private List<Term> aliasTermList = new ArrayList<Term>();
    private int queryTermWorkType = 0;
    private int aliasQueryTermType = 0;
    private Set<String> queryUsedFieldNameSet = new HashSet<String>();
    private String normalFullTextFieldName;

    public PartialWordMatcher() {
        this.matchName = DEFAULT_MATCH_NAME;
    }

    public PartialWordMatcher(RequestContext context) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.q = context.getQ().trim();
        this.context = context;
        this.matchFieldName = context.getAttribure("fuzzy_full_text_field");
        this.normalFullTextFieldName = context.getAttribure("normal_full_text_field");
        this.init();
    }

    public PartialWordMatcher(RequestContext context, String matcherName) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.q = context.getQ().trim();
        this.matchName = matcherName;
        this.context = context;
        this.matchFieldName = context.getAttribure("fuzzy_full_text_field");
        this.normalFullTextFieldName = context.getAttribure("normal_full_text_field");
        this.init();
    }

    public PartialWordMatcher(RequestContext context, float rate) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.q = context.getQ().trim();
        this.rate = rate;
        this.context = context;
        this.matchFieldName = context.getAttribure("fuzzy_full_text_field");
        this.normalFullTextFieldName = context.getAttribure("normal_full_text_field");
        this.init();
    }

    public PartialWordMatcher(RequestContext context, float rate, Map<AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE, String> analyzerNameMap) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.q = context.getQ().trim();
        this.rate = rate;
        this.analyzerNameMap = new HashMap<AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE, String>(analyzerNameMap);
        this.context = context;
        this.matchFieldName = context.getAttribure("fuzzy_full_text_field");
        this.normalFullTextFieldName = context.getAttribure("normal_full_text_field");
        this.init();
    }

    public PartialWordMatcher(RequestContext context, float rate, Map<AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE, String> analyzerNameMap, String matchFieldName) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.q = context.getQ().trim();
        this.rate = rate;
        this.analyzerNameMap = new HashMap<AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE, String>(analyzerNameMap);
        this.context = context;
        this.matchFieldName = matchFieldName;
        this.normalFullTextFieldName = context.getAttribure("normal_full_text_field");
        this.init();
    }

    public void setMatchFieldName(String matchFieldName) {
        if (this.inited) {
            return;
        }
        this.matchFieldName = matchFieldName;
    }

    public void setNormalFullTextFieldName(String fieldName) {
        this.normalFullTextFieldName = fieldName;
    }

    private void init() {
        this.context.saveMatcheNameandMatcheFieldNamePair(this.matchName, this.matchFieldName);
        this.inited = true;
    }

    @Override
    public Matcher.MATCHER_TYPE getMatcherType() {
        return Matcher.MATCHER_TYPE.PARTIAL_WORD;
    }

    public void putAnalyzerName(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE nameType, String analyzerName) {
        this.analyzerNameMap.put(nameType, analyzerName);
    }

    @Override
    public PartialWordMatcher assembly() {
        String qStr;
        int queryTermType;
        this.mainTermList.clear();
        this.leaderTermList.clear();
        this.tailerTermList.clear();
        this.aliasTermList.clear();
        this.q = this.context.getQ().trim();
        this.queryTermWorkType = queryTermType = this.queryTermType(this.q).ordinal();
        if (queryTermType >= 3 && (qStr = SearchUtils.tryToMissWordByLooseRule(this.q)).trim().length() != this.q.trim().length()) {
            this.boost = 0.65f;
            this.queryTermWorkType = queryTermType = this.queryTermType(qStr).ordinal();
            this.q = qStr;
            this.context.putAttribute("execute_partiword_query", qStr);
        }
        this.q = this.q.replace("-", " ").trim();
        this.queryTermWorkType = queryTermType = this.queryTermType(this.q).ordinal();
        switch (this.queryTermWorkType) {
            case 1: {
                this.assemblyForOneWord();
                break;
            }
            case 2: {
                this.assemblyForTwoWord();
                String aliasQ = SearchUtils.takeAliasStr(this.q, 3).trim();
                if (StringUtils.isEmpty(aliasQ) || aliasQ.split("([\\s\\p{Zs}])+").length >= this.q.split("([\\s\\p{Zs}])+").length) break;
                this.assemblyForOneWord(aliasQ, this.aliasTermList);
                this.aliasQueryTermType = Matcher.QUERY_TERM_TYPE.ONE_WORD.ordinal();
                this.context.putAttribute("execute_partiword_alis_query", aliasQ);
                break;
            }
            case 3: {
                this.assemblyForMoreWord();
                String aliasQ = SearchUtils.takeAliasStr(this.q, 3).trim();
                if (StringUtils.isEmpty(aliasQ) || aliasQ.split("([\\s\\p{Zs}])+").length >= this.q.split("([\\s\\p{Zs}])+").length) break;
                this.context.putAttribute("execute_partiword_alis_query", aliasQ);
                int nLen = aliasQ.split("([\\s\\p{Zs}])+").length;
                if (nLen == 1) {
                    this.assemblyForOneWord(aliasQ, this.aliasTermList);
                    this.aliasQueryTermType = Matcher.QUERY_TERM_TYPE.ONE_WORD.ordinal();
                    break;
                }
                if (nLen != 2) break;
                this.assemblyForTwoWord(aliasQ, this.aliasTermList);
                this.aliasQueryTermType = Matcher.QUERY_TERM_TYPE.TWO_WORD.ordinal();
                break;
            }
            default: {
                this.logger.warn("unsupport match model ,query term is: " + this.q + " context.q:" + this.context.getQ());
                throw new RuntimeException("unsupport match model");
            }
        }
        return this;
    }

    @Override
    public QueryBuilder buildBase() {
        if (SearchUtils.keywordsTermCount(this.context.getQ()) >= 4) {
            return null;
        }
        int queryTermType = this.queryTermWorkType;
        BoolQueryBuilder queryBuilder = null;
        switch (queryTermType) {
            case 1: {
                break;
            }
            case 2: {
                queryBuilder = (BoolQueryBuilder)this.buildForTwoWord().boost(this.globalBoost);
                break;
            }
            case 3: {
                queryBuilder = (BoolQueryBuilder)this.buildForMoreWord().boost(this.globalBoost);
                break;
            }
            default: {
                return null;
            }
        }
        this.context.putQueryMatcherMatchedFieldNameMap(this.matchName, CollectionUtils.arrayToList(this.queryUsedFieldNameSet.toArray()));
        return queryBuilder;
    }

    private void prepareAnalyzerName(Term term) {
        int fuzzinessCharLength = Math.round((float)term.getTermStr().length() * term.getMatchRate());
        String analyzerName = this.getFuzzyAnalyzerName(fuzzinessCharLength);
        term.setAnalyzer(analyzerName);
    }

    private BoolQueryBuilder buildForOneWord() {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        QueryBuilder queryBuilder = this.buildForOneWordInternal(this.mainTermList);
        boolQueryBuilder.must(queryBuilder);
        return boolQueryBuilder;
    }

    private QueryBuilder buildForOneWordInternal(List<Term> terms) {
        Term term = terms.get(0);
        MatchQueryBuilder queryBuilder = QueryBuilders.matchQuery((String)term.getMatchedFieldName(), (Object)SearchUtils.takeStrByPrefixLimit(term.getTermStr(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT)).analyzer(term.getAnalyzer()).fuzziness((Object)term.getFuzzyDistance()).fuzzyTranspositions(false);
        this.queryUsedFieldNameSet.add(term.getMatchedFieldName());
        return queryBuilder;
    }

    private BoolQueryBuilder buildForTwoWord() {
        BoolQueryBuilder boolQueryBuilder = this.buildForTwoWordInternal(this.mainTermList);
        return boolQueryBuilder;
    }

    private BoolQueryBuilder buildForTwoWordInternal(List<Term> workTermsList) {
        MatchQueryBuilder leaderMatcherFirstQuery = QueryBuilders.matchQuery((String)this.normalFullTextFieldName, (Object)SearchUtils.takeStrByPrefixLimit(this.leaderTermList.get(0).getTermStr(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT)).analyzer(this.leaderTermList.get(0).getAnalyzer());
        MatchQueryBuilder leaderMatcherSubStrQuery = QueryBuilders.matchQuery((String)this.normalFullTextFieldName, (Object)SearchUtils.takeStrByPrefixLimit(this.leaderTermList.get(1).getTermStr(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT)).analyzer(this.leaderTermList.get(1).getAnalyzer());
        MatchQueryBuilder tailerMatcherFirstQuery = QueryBuilders.matchQuery((String)this.normalFullTextFieldName, (Object)SearchUtils.takeStrByPrefixLimit(this.tailerTermList.get(0).getTermStr(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT)).analyzer(this.tailerTermList.get(0).getAnalyzer());
        MatchQueryBuilder tailerMatcherSubStrQuery = QueryBuilders.matchQuery((String)this.normalFullTextFieldName, (Object)SearchUtils.takeStrByPrefixLimit(this.tailerTermList.get(1).getTermStr(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT)).analyzer(this.tailerTermList.get(1).getAnalyzer());
        this.queryUsedFieldNameSet.add(this.normalFullTextFieldName);
        ArrayList<MatchQueryBuilder> queryList = new ArrayList<MatchQueryBuilder>();
        for (Term term : workTermsList) {
            MatchQueryBuilder query = QueryBuilders.matchQuery((String)term.getMatchedFieldName(), (Object)SearchUtils.takeStrByPrefixLimit(term.getTermStr(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT)).analyzer(term.getAnalyzer());
            queryList.add(query);
            this.queryUsedFieldNameSet.add(term.getMatchedFieldName());
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)leaderMatcherFirstQuery).must((QueryBuilder)leaderMatcherSubStrQuery)).should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)tailerMatcherFirstQuery).must((QueryBuilder)tailerMatcherSubStrQuery)).should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)queryList.get(0)).must((QueryBuilder)queryList.get(1))).minimumShouldMatch(1);
        DefaultKeyValue querySentenceAndMatchFieldNamePair = new DefaultKeyValue((Object)"check_partial_2_word", this.queryUsedFieldNameSet);
        this.querySentenceMatchedFieldNamePairsList.add(querySentenceAndMatchFieldNamePair);
        return boolQueryBuilder;
    }

    private BoolQueryBuilder buildForMoreWord() {
        BoolQueryBuilder mainQueryBuilder = QueryBuilders.boolQuery();
        for (Term term : this.mainTermList) {
            MatchQueryBuilder query = QueryBuilders.matchQuery((String)term.getMatchedFieldName(), (Object)SearchUtils.takeStrByPrefixLimit(term.getTermStr(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT)).analyzer(term.getAnalyzer()).fuzziness((Object)term.getFuzzyDistance()).fuzzyTranspositions(false);
            mainQueryBuilder.must((QueryBuilder)query);
            this.queryUsedFieldNameSet.add(term.getMatchedFieldName());
        }
        if (this.aliasQueryTermType == Matcher.QUERY_TERM_TYPE.TWO_WORD.ordinal()) {
            BoolQueryBuilder wrapQueryBuilder = QueryBuilders.boolQuery();
            wrapQueryBuilder.should((QueryBuilder)this.buildForTwoWordInternal(this.aliasTermList)).should((QueryBuilder)mainQueryBuilder).minimumShouldMatch(1);
            mainQueryBuilder = wrapQueryBuilder;
        }
        DefaultKeyValue querySentenceAndMatchFieldNamePair = new DefaultKeyValue((Object)"check_partial_more_word", this.queryUsedFieldNameSet);
        this.querySentenceMatchedFieldNamePairsList.add(querySentenceAndMatchFieldNamePair);
        return mainQueryBuilder;
    }

    private void assemblyForTwoWord() {
        this.assemblyForTwoWord(this.q, this.mainTermList);
    }

    private void assemblyForTwoWord(String strQ, List<Term> parsedTermList) {
        String[] newQs;
        String q = strQ.replaceAll("-", " ").trim();
        for (String s : newQs = q.split("([\\s\\p{Zs}])+")) {
            Term term = new Term(s);
            if (this.rate != -1.0f) {
                term.setMatchRate(this.rate);
            }
            if (!StringUtils.isEmpty(this.matchFieldName)) {
                term.setMatchedFieldName(this.matchFieldName);
            }
            parsedTermList.add(term);
        }
        Term[] terms = new Term[2];
        parsedTermList.toArray(terms);
        this.twoWordAnalyzer.analyze(terms, this.context);
    }

    private void assemblyForMoreWord() {
        String[] newQs;
        String q = this.q.replaceAll("-", " ").trim();
        for (String s : newQs = q.split("([\\s\\p{Zs}])+")) {
            Term term = new Term(s);
            if (this.rate == -1.0f) {
                term.setMatchRate(0.7f);
            } else {
                term.setMatchRate(this.rate);
            }
            if (!StringUtils.isEmpty(this.matchFieldName)) {
                term.setMatchedFieldName(this.matchFieldName);
            }
            this.mainTermList.add(term);
        }
        this.moreWordAnalyzer.analyze(this.mainTermList, this.context);
    }

    private void assemblyForOneWord() {
        this.assemblyForOneWord(this.q.trim(), this.mainTermList);
    }

    private void assemblyForOneWord(String aliasQ, List<Term> parsedTermsList) {
        Term term = new Term(aliasQ);
        if (this.rate == -1.0f) {
            term.setMatchRate(0.75f);
        } else {
            term.setMatchRate(this.rate);
        }
        this.oneWordAnalyzer.analyze(term, this.context);
        parsedTermsList.add(term);
    }

    public Matcher.QUERY_TERM_TYPE queryTermType(String q) {
        if (q.isEmpty()) {
            return Matcher.QUERY_TERM_TYPE.NONE;
        }
        String[] newQs = (q = q.replaceAll("-", " ").trim()).split("([\\s\\p{Zs}])+");
        if (newQs.length == 1) {
            return Matcher.QUERY_TERM_TYPE.ONE_WORD;
        }
        if (newQs.length == 2) {
            return Matcher.QUERY_TERM_TYPE.TWO_WORD;
        }
        if (newQs.length >= 3) {
            return Matcher.QUERY_TERM_TYPE.MORE_WORD;
        }
        return Matcher.QUERY_TERM_TYPE.NONE;
    }

    @Override
    public void prepareByConfig(MatcherConfig config) {
        this.matcherConfig = config;
        MatcherParams matcherParams = this.matcherConfig.getMatcherParams();
        if (!StringUtils.isEmpty(matcherParams.getMatchFieldName())) {
            this.setMatchFieldName(matcherParams.getMatchFieldName());
        } else {
            this.setMatchFieldName(this.context.getAttribure("fuzzy_full_text_field"));
        }
        if (!StringUtils.isEmpty(matcherParams.getNormalFullTextFieldName())) {
            this.setNormalFullTextFieldName(matcherParams.getNormalFullTextFieldName());
        } else {
            this.setNormalFullTextFieldName(this.context.getAttribure("normal_full_text_field"));
        }
        if (!StringUtils.isEmpty(this.matcherConfig.getIdName())) {
            this.matchName = this.matcherConfig.getIdName();
        }
        if (matcherParams.getGlobalBoost() > 0.0f) {
            this.globalBoost = matcherParams.getGlobalBoost();
        }
        if (matcherParams.getBoost() > 0.0f) {
            this.boost = matcherParams.getBoost();
        }
        super.prepareByConfig(this.matcherConfig);
        this.init();
    }

    class MoreWordAnalyzer {
        public void analyze(List<Term> terms, RequestContext context) {
            for (Term term : terms) {
                term.setBoost(PartialWordMatcher.this.boost);
                if (term.getTermStr().length() <= 3) {
                    term.setAnalyzer(PartialWordMatcher.this.getFuzzyAnalyzerName(term.getTermStr().length()));
                    if (!StringUtils.isEmpty(term.getMatchedFieldName())) continue;
                    term.setMatchedFieldName(context.getAttribure("normal_full_text_field"));
                    continue;
                }
                if (StringUtils.isEmpty(term.getMatchedFieldName())) {
                    term.setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                }
                if (term.getMatchRate() == -1.0f) {
                    term.setMatchRate(0.75f);
                }
                if (!StringUtils.isEmpty(term.getAnalyzer())) continue;
                PartialWordMatcher.this.prepareAnalyzerName(term);
            }
        }
    }

    class TwoWordAnalyzer {
        public void analyze(Term[] terms, RequestContext context) {
            this.mainTerm(terms, context);
            this.leaderTailTerm(terms, context);
        }

        private void leaderTailTerm(Term[] terms, RequestContext context) {
            String mainWord = "";
            String subStr = "";
            Term term = new Term(terms[0].getTermStr());
            term.setAnalyzer(context.getAttribure("word_analyzer_name"));
            term.setBoost(PartialWordMatcher.this.boost);
            PartialWordMatcher.this.leaderTermList.add(term);
            term = new Term(terms[1].getTermStr());
            term.setAnalyzer(this.getAnalyzerName4LeaderTail(terms[1].getTermStr()));
            term.setBoost(PartialWordMatcher.this.boost);
            PartialWordMatcher.this.leaderTermList.add(term);
            term = new Term(terms[1].getTermStr());
            term.setAnalyzer(context.getAttribure("word_analyzer_name"));
            term.setBoost(PartialWordMatcher.this.boost);
            PartialWordMatcher.this.tailerTermList.add(term);
            term = new Term(terms[0].getTermStr());
            term.setAnalyzer(this.getAnalyzerName4LeaderTail(terms[0].getTermStr()));
            term.setBoost(PartialWordMatcher.this.boost);
            PartialWordMatcher.this.tailerTermList.add(term);
        }

        private String getAnalyzerName4LeaderTail(String termStr) {
            int len = termStr.trim().length();
            int analyzeNameLen = 0;
            analyzeNameLen = len >= 12 ? (int)Math.round((double)len * 0.7) : (len >= 9 && len < 12 ? (int)Math.round((double)len * 0.65) : (len >= 6 && len < 9 ? (int)Math.round((double)len * 0.6) : (int)Math.round((double)len * 0.55)));
            return PartialWordMatcher.this.getFuzzyAnalyzerName(analyzeNameLen);
        }

        private void mainTerm(Term[] terms, RequestContext context) {
            terms[0].setBoost(PartialWordMatcher.this.boost);
            terms[1].setBoost(PartialWordMatcher.this.boost);
            if (terms[1].getTermStr().length() >= 9) {
                if (terms[0].getTermStr().length() <= 6 && terms[0].getTermStr().length() > 4) {
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        terms[0].setAnalyzer((String)PartialWordMatcher.this.analyzerNameMap.get((Object)AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_THREE_CHARS));
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.9f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("normal_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("normal_full_text_field"));
                    }
                } else if (terms[0].getTermStr().length() > 6 && terms[0].getTermStr().length() < 9) {
                    if (terms[0].getMatchRate() == -1.0f) {
                        terms[0].setMatchRate(0.5f);
                    }
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[0]);
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.9f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("normal_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("normal_full_text_field"));
                    }
                } else if (terms[0].getTermStr().length() >= 9) {
                    if (terms[0].getMatchRate() == -1.0f) {
                        terms[0].setMatchRate(0.65f);
                    }
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[0]);
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.65f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("normal_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("normal_full_text_field"));
                    }
                } else {
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        terms[0].setAnalyzer(context.getAttribure("word_analyzer_name"));
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.9f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("normal_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    terms[0].setFuzzyDistance(1);
                }
            } else if (terms[1].getTermStr().length() > 6 && terms[1].getTermStr().length() < 9) {
                if (terms[0].getTermStr().length() <= 6 && terms[0].getTermStr().length() > 4) {
                    if (terms[0].getMatchRate() == -1.0f) {
                        terms[0].setMatchRate(0.69f);
                    }
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[0]);
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.75f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                } else if (terms[0].getTermStr().length() > 6 && terms[0].getTermStr().length() < 9) {
                    if (terms[0].getMatchRate() == -1.0f) {
                        terms[0].setMatchRate(0.65f);
                    }
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[0]);
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.65f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                } else if (terms[0].getTermStr().length() >= 9) {
                    if (terms[0].getMatchRate() == -1.0f) {
                        terms[0].setMatchRate(0.9f);
                    }
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[0]);
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.55f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                } else if (terms[0].getTermStr().length() == 4) {
                    if (terms[0].getMatchRate() == -1.0f) {
                        terms[0].setMatchRate(0.7f);
                    }
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[0]);
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.75f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                } else {
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        terms[0].setAnalyzer(context.getAttribure("word_analyzer_name"));
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.9f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("normal_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    terms[0].setFuzzyDistance(1);
                }
            } else if (terms[1].getTermStr().length() > 4 && terms[1].getTermStr().length() <= 6) {
                if (terms[0].getTermStr().length() <= 6 && terms[0].getTermStr().length() > 4) {
                    if (terms[0].getMatchRate() == -1.0f) {
                        terms[0].setMatchRate(0.75f);
                    }
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[0]);
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.75f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                } else if (terms[0].getTermStr().length() > 6 && terms[0].getTermStr().length() < 9) {
                    if (terms[0].getMatchRate() == -1.0f) {
                        terms[0].setMatchRate(0.75f);
                    }
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[0]);
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.69f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                } else if (terms[0].getTermStr().length() >= 9) {
                    if (terms[0].getMatchRate() == -1.0f) {
                        terms[0].setMatchRate(0.9f);
                    }
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[0]);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        terms[1].setAnalyzer((String)PartialWordMatcher.this.analyzerNameMap.get((Object)AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_THREE_CHARS));
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                } else {
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        terms[0].setAnalyzer(context.getAttribure("word_analyzer_name"));
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.9f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                }
            } else if (terms[1].getTermStr().length() <= 4) {
                if (terms[0].getTermStr().length() <= 6 && terms[0].getTermStr().length() > 4) {
                    if (terms[0].getMatchRate() == -1.0f) {
                        terms[0].setMatchRate(0.9f);
                    }
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[0]);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                        terms[1].setAnalyzer(context.getAttribure("word_analyzer_name"));
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                } else if (terms[0].getTermStr().length() > 6 && terms[0].getTermStr().length() < 9) {
                    if (terms[0].getMatchRate() == -1.0f) {
                        terms[0].setMatchRate(0.75f);
                    }
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[0]);
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.7f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                } else if (terms[0].getTermStr().length() >= 9) {
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        terms[0].setAnalyzer(context.getAttribure("word_analyzer_name"));
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.69f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        PartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("normal_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    terms[0].setFuzzyDistance(1);
                } else {
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        terms[0].setAnalyzer(context.getAttribure("word_analyzer_name"));
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        terms[1].setAnalyzer(context.getAttribure("word_analyzer_name"));
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                }
            }
        }
    }

    class OneWordAnalyzer {
        public void analyze(Term term, RequestContext context) {
            PartialWordMatcher.this.prepareAnalyzerName(term);
            term.setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
            term.setBoost(PartialWordMatcher.this.boost);
        }
    }
}

