/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.ranker.comparator;

import com.valor.common.search.engine.facade.config.ComputeExpressConfig;
import com.valor.common.search.engine.ranker.comparator.AbstractRankerComparator;
import com.valor.common.search.engine.util.CollectionUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.SearchHit;

public class CelebsHotWeightComparator
extends AbstractRankerComparator {
    private Map<String, Number> bizParams = new HashMap<String, Number>();
    private ComputeExpressConfig computeExpressConfig;

    public CelebsHotWeightComparator() {
        this.bizParams.put("modelHotWeight.01.hotRate".replaceFirst("modelHotWeight.01.", ""), Float.valueOf(0.7f));
        this.bizParams.put("modelHotWeight.01.weightRate".replaceFirst("modelHotWeight.01.", ""), Float.valueOf(0.3f));
        this.bizParams.put("modelHotWeight.01.hotScale".replaceFirst("modelHotWeight.01.", ""), Float.valueOf(1000.0f));
        this.bizParams.put("modelHotWeight.01.weightScale".replaceFirst("modelHotWeight.01.", ""), Float.valueOf(3.0f));
    }

    public Map<String, Number> getBizParams() {
        return this.bizParams;
    }

    public void appendBizParams(Map<String, Number> bizParams) {
        this.bizParams.putAll(bizParams);
    }

    @Override
    public void appendSysParams(Map<String, Object> sysParams) {
        if (CollectionUtils.isEmpty(sysParams)) {
            return;
        }
        this.bizParams.put("modelHotWeight.01.hotRate".replaceFirst("modelHotWeight.01.", ""), Float.valueOf(Float.parseFloat(sysParams.getOrDefault("modelHotWeight.01.hotRate", Float.valueOf(0.7f)).toString())));
        this.bizParams.put("modelHotWeight.01.hotScale".replaceFirst("modelHotWeight.01.", ""), Float.valueOf(Float.parseFloat(sysParams.getOrDefault("modelHotWeight.01.hotScale", Float.valueOf(1000.0f)).toString())));
        this.bizParams.put("modelHotWeight.01.weightScale".replaceFirst("modelHotWeight.01.", ""), Float.valueOf(Float.parseFloat(sysParams.getOrDefault("modelHotWeight.01.weightScale", Float.valueOf(3.0f)).toString())));
        this.bizParams.put("modelHotWeight.01.weightRate".replaceFirst("modelHotWeight.01.", ""), Float.valueOf(Float.parseFloat(sysParams.getOrDefault("modelHotWeight.01.weightRate", Float.valueOf(0.3f)).toString())));
    }

    @Override
    public int compare(SearchHit o1, SearchHit o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        if (o1 == o2) {
            return 0;
        }
        if (o1.getSourceAsMap().get("hot") == null && o2.getSourceAsMap().get("hot") == null) {
            return 0;
        }
        if (o1.getSourceAsMap().get("hot") == null) {
            return -1;
        }
        if (o2.getSourceAsMap().get("hot") == null) {
            return 1;
        }
        Float o1Score = Float.valueOf(Float.parseFloat(o1.getSourceAsMap().get("newScore").toString()));
        Float o2Score = Float.valueOf(Float.parseFloat(o2.getSourceAsMap().get("newScore").toString()));
        o1.getSourceAsMap().put("sortBy", "celebsHotWeight");
        o2.getSourceAsMap().put("sortBy", "celebsHotWeight");
        o1Score = Float.valueOf(o1Score.isNaN() ? 0.0f : o1Score.floatValue());
        o2Score = Float.valueOf(o2Score.isNaN() ? 0.0f : o2Score.floatValue());
        if (o1Score.floatValue() == o2Score.floatValue()) {
            return 0;
        }
        if (o1Score.floatValue() > o2Score.floatValue()) {
            return -1;
        }
        return 1;
    }

    @Override
    public void prepareByConfig(List<ComputeExpressConfig> computeExpressMapList) {
        if (!CollectionUtils.isEmpty(computeExpressMapList)) {
            this.computeExpressConfig = computeExpressMapList.get(0);
        }
    }

    @Override
    public float computeScore(SearchHit hit) {
        HashMap<String, Number> jepParams = new HashMap<String, Number>();
        for (String name : this.computeExpressConfig.getParamsName()) {
            String objValue = hit.getSourceAsMap().getOrDefault(name, "0");
            double val = objValue == null ? 0.0 : (double)((float)Math.ceil(Double.parseDouble(objValue.toString()) * 100.0) / 100.0f);
            val = val < 0.0 ? 0.0 : val;
            jepParams.put(name, val);
        }
        jepParams.put("score", Double.valueOf(hit.getScore()));
        jepParams.putAll(this.bizParams);
        float newScore = this.getNewScore(jepParams, this.computeExpressConfig.getScoreExpress());
        hit.getSourceAsMap().put("newScore", Float.valueOf(newScore));
        hit.getSourceAsMap().put("computeScoreBy", "celebsHotWeight");
        return newScore;
    }
}

