/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine;

import com.valor.common.search.engine.SearchEngineConfig;
import com.valor.common.search.engine.facade.config.HighlightConfig;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.SearchUtils;
import com.valor.common.search.engine.zsymspell.SymSpell;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;

public class RequestContext
implements Serializable,
Cloneable {
    public static final String FUZZY_SUBINDEX_FIELD_SHORT_NAME = "word_letters";
    public static final String MININUM_SUBINDEX_FIELD_SHORT_NAME = "all_letters";
    public static final String WORD_SUBINDEX_FIELD_SHORT_NAME = "cut_word";
    public String wordAnalyzerName;
    public String KEY_MAIN_INDEX_FIELD = "title";
    public String fuzzySubIndexFieldName = "title.word_letters";
    public String minimumSubIndexFieldName = "title.all_letters";
    public String wordSubIndexFieldName = "title.cut_word";
    public int invalidDocCount = 0;
    public String queryExecutePartialWord = "";
    public String queryExecutePartialWordAlias = "";
    public String queryExecuteExtraWordAlias = "";
    private boolean fuzziness = false;
    private final String q;
    private String originalQ;
    private SearchResponse response;
    private final String indexName;
    private final RestHighLevelClient restHighLevelClient;
    private int fromIndex = 0;
    private int size = 200;
    private List<String> marks = new ArrayList<String>();
    private String highlightPostTag = "</em>";
    private String highlightPreTag = "<em>";
    private String mainIndexFieldName = "title";
    private final Map<String, String> attributeMap = new ConcurrentHashMap<String, String>();
    private final Map<String, Number> numberAttributeMap = new ConcurrentHashMap<String, Number>();
    private final Map<String, String> machterMatcheFieldNameMap = new HashMap<String, String>();
    private final Map<String, List<String>> machterMultiMatcheFieldNameMap = new HashMap<String, List<String>>();
    private final Map<String, List<String>> queryMatcherMatchedFieldNameMap = new HashMap<String, List<String>>();
    private final Map<String, Set<String>> querySentenceMatchedFieldNamesMap = new HashMap<String, Set<String>>();
    private List<HighlightConfig.HighlightItemConfig> highlightItemConfigList;
    private String defaultHighlightType = "unified";
    private String highlightExtFieldNameSuffix;
    private SearchEngineConfig bizSysConfig;
    private List<SymSpell.SuggestItem> predictions;
    private long predictTookMillis;

    public RequestContext(String q, String indexName, String mainIndexFieldName, RestHighLevelClient client, int fromIndex, int size) {
        if (fromIndex + size > 10000) {
            throw new RuntimeException("ResultSet are too large  ");
        }
        this.originalQ = q;
        this.q = SearchUtils.rebuildQ(q);
        this.indexName = indexName;
        this.restHighLevelClient = client;
        this.mainIndexFieldName = mainIndexFieldName;
        this.fromIndex = fromIndex;
        this.size = size;
        this.postConstruct();
    }

    private void postConstruct() {
        this.KEY_MAIN_INDEX_FIELD = this.mainIndexFieldName;
        this.fuzzySubIndexFieldName = this.mainIndexFieldName + "." + FUZZY_SUBINDEX_FIELD_SHORT_NAME;
        this.minimumSubIndexFieldName = this.mainIndexFieldName + "." + MININUM_SUBINDEX_FIELD_SHORT_NAME;
        this.wordSubIndexFieldName = this.mainIndexFieldName + "." + WORD_SUBINDEX_FIELD_SHORT_NAME;
        this.wordAnalyzerName = "cutsomeword";
    }

    public Map<String, Set<String>> getQuerySentenceMatchedFieldNamesMap() {
        return this.querySentenceMatchedFieldNamesMap;
    }

    public void putQuerySentenceMatchedFieldNamesMap(String querySentenceName, Set<String> matchedFieldNames) {
        this.querySentenceMatchedFieldNamesMap.put(querySentenceName, matchedFieldNames);
    }

    public String getDefaultHighlightType() {
        return this.defaultHighlightType;
    }

    public void setDefaultHighlightType(String defaultHighlightType) {
        this.defaultHighlightType = defaultHighlightType;
    }

    public String getHighlightPostTag() {
        return this.highlightPostTag;
    }

    public void setHighlightPostTag(String highlightPostTag) {
        this.highlightPostTag = highlightPostTag;
    }

    public String getHighlightPreTag() {
        return this.highlightPreTag;
    }

    public void setHighlightPreTag(String highlightPreTag) {
        this.highlightPreTag = highlightPreTag;
    }

    public void putAttribute(String key, String value) {
        this.attributeMap.put(key, value);
    }

    public void putNumAttr(String key, Number num) {
        this.numberAttributeMap.put(key, num);
    }

    public Number getNumAttr(String key) {
        return this.numberAttributeMap.get(key);
    }

    public String getAttribute(String key) {
        return this.attributeMap.get(key);
    }

    public Map<String, List<String>> getQueryMatcherMatchedFieldNameMap() {
        return this.queryMatcherMatchedFieldNameMap;
    }

    public void putQueryMatcherMatchedFieldNameMap(String matcherName, List<String> matchedFieldNameList) {
        this.queryMatcherMatchedFieldNameMap.put(matcherName, matchedFieldNameList);
    }

    public String indexName() {
        return this.indexName;
    }

    public RestHighLevelClient getRestHighLevelClient() {
        return this.restHighLevelClient;
    }

    public String getQ() {
        return this.q;
    }

    public int fromIndex() {
        return this.fromIndex;
    }

    public int size() {
        return this.size;
    }

    public void saveResponse(SearchResponse response) {
        this.response = response;
    }

    public SearchResponse getResponse() {
        return this.response;
    }

    public void saveMatcheNameandMatcheFieldNamePair(String matcheName, String matcheFieldName) {
        this.machterMatcheFieldNameMap.put(matcheName, matcheFieldName);
    }

    public void saveMultiMatcheNameandMatcheFieldNamePair(String matcheName, List<String> matcheFieldName) {
        if (!CollectionUtils.isEmpty((Collection)this.machterMultiMatcheFieldNameMap.get(matcheName))) {
            List<String> list = this.machterMultiMatcheFieldNameMap.get(matcheName);
            list.addAll(matcheFieldName);
            this.machterMultiMatcheFieldNameMap.put(matcheName, list);
        } else {
            this.machterMultiMatcheFieldNameMap.put(matcheName, matcheFieldName);
        }
    }

    public List<String> getMarks() {
        return this.marks;
    }

    public void putMarks(List<String> marks) {
        this.marks.addAll(marks);
    }

    public SearchEngineConfig getBizSysConfig() {
        return this.bizSysConfig;
    }

    public void setBizSysConfig(SearchEngineConfig bizSysConfig) {
        this.bizSysConfig = bizSysConfig;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public List<HighlightConfig.HighlightItemConfig> getHighlightItemConfigList() {
        return this.highlightItemConfigList;
    }

    public void setHighLightItemConfigList(List<HighlightConfig.HighlightItemConfig> highLightItemConfigList) {
        this.highlightItemConfigList = highLightItemConfigList;
    }

    public String getHighlightExtFieldNameSuffix() {
        return this.highlightExtFieldNameSuffix;
    }

    public void setHighlightExtFieldNameSuffix(String highlightExtFieldNameSuffix) {
        this.highlightExtFieldNameSuffix = highlightExtFieldNameSuffix;
    }

    public boolean isEnableFuzziness() {
        return this.fuzziness;
    }

    public void enableFuzziness() {
        this.fuzziness = true;
    }

    public void disableFuzziness() {
        this.fuzziness = false;
    }

    public List<SymSpell.SuggestItem> getPredictions() {
        return this.predictions;
    }

    public void setPredictions(List<SymSpell.SuggestItem> predictions) {
        this.predictions = predictions;
    }

    public long getPredictTookMillis() {
        return this.predictTookMillis;
    }

    public void setPredictTookMillis(long predictTookMillis) {
        this.predictTookMillis = predictTookMillis;
    }
}

