/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.filter;

import com.valor.common.search.engine.filter.InlineFilterBase;
import com.valor.common.search.engine.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;

public class CompositeFilterBase
implements InlineFilterBase {
    protected InlineFilterBase mainFilter;
    protected List<InlineFilterBase> subFilterList = new ArrayList<InlineFilterBase>();
    protected Func func = Func.OR;

    public CompositeFilterBase(InlineFilterBase mainFilter) {
        if (mainFilter == null) {
            throw new RuntimeException("main filter must not null");
        }
        this.mainFilter = mainFilter;
    }

    public CompositeFilterBase(InlineFilterBase mainFilter, Func func) {
        if (mainFilter == null) {
            throw new RuntimeException("main filter must not null");
        }
        this.mainFilter = mainFilter;
        this.func = func;
    }

    public CompositeFilterBase(Func func, List<InlineFilterBase> filterList) {
        if (CollectionUtils.isEmpty(filterList)) {
            throw new RuntimeException("main filter must not null");
        }
        this.func = func;
        this.mainFilter = filterList.get(0);
        for (int index = 1; index < filterList.size(); ++index) {
            this.subFilterList.add(filterList.get(index));
        }
    }

    public CompositeFilterBase append(InlineFilterBase subFilter) {
        if (subFilter != null) {
            this.subFilterList.add(subFilter);
        }
        return this;
    }

    @Override
    public String getInlineFilterClassName() {
        return "com.valor.common.search.engine.filter.CompositeFilter";
    }

    @Override
    public String getFilterName() {
        return null;
    }

    public static enum Func {
        OR(1, "\u6216"),
        AND(2, "\u5e76\u4e14");

        private int value;
        private String desc;

        private Func(int index, String desc) {
            this.value = index;
            this.desc = desc;
        }
    }
}

