/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.matcher;

import com.valor.common.search.engine.matcher.AbstractMatcher;
import com.valor.common.search.engine.matcher.Term;
import com.valor.common.search.engine.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractFuzzyMatcher
extends AbstractMatcher {
    protected Map<CHARS_ANALYZER_TYPE, String> analyzerNameMap = new HashMap<CHARS_ANALYZER_TYPE, String>();

    public AbstractFuzzyMatcher() {
        this.analyzerNameMap.put(CHARS_ANALYZER_TYPE.LIMIT_TWO_CHARS, "word_char_2_10_ngram");
        this.analyzerNameMap.put(CHARS_ANALYZER_TYPE.LIMIT_ONE_CHARS, "cutsomeword");
        this.analyzerNameMap.put(CHARS_ANALYZER_TYPE.LIMIT_THREE_CHARS, "word_char_3_10_ngram");
        this.analyzerNameMap.put(CHARS_ANALYZER_TYPE.LIMIT_FOUR_CHARS, "word_char_4_10_ngram");
        this.analyzerNameMap.put(CHARS_ANALYZER_TYPE.LIMIT_FIVE_CHARS, "word_char_5_10_ngram");
        this.analyzerNameMap.put(CHARS_ANALYZER_TYPE.LIMIT_SIX_CHARS, "word_char_6_10_ngram");
        this.analyzerNameMap.put(CHARS_ANALYZER_TYPE.LIMIT_SEVEN_CHARS, "word_char_7_10_ngram");
        this.analyzerNameMap.put(CHARS_ANALYZER_TYPE.LIMIT_EIGHT_CHARS, "word_char_8_10_ngram");
        this.analyzerNameMap.put(CHARS_ANALYZER_TYPE.LIMIT_MORE_CHARS, "word_char_9_10_ngram");
    }

    protected String getFuzzyAnalyzerName(int minCharLen) {
        String innerAnalyzerName;
        switch (minCharLen) {
            case 1: {
                innerAnalyzerName = this.analyzerNameMap.get((Object)CHARS_ANALYZER_TYPE.LIMIT_ONE_CHARS);
                break;
            }
            case 2: {
                innerAnalyzerName = this.analyzerNameMap.get((Object)CHARS_ANALYZER_TYPE.LIMIT_TWO_CHARS);
                break;
            }
            case 3: {
                innerAnalyzerName = this.analyzerNameMap.get((Object)CHARS_ANALYZER_TYPE.LIMIT_THREE_CHARS);
                break;
            }
            case 4: {
                innerAnalyzerName = this.analyzerNameMap.get((Object)CHARS_ANALYZER_TYPE.LIMIT_FOUR_CHARS);
                break;
            }
            case 5: {
                innerAnalyzerName = this.analyzerNameMap.get((Object)CHARS_ANALYZER_TYPE.LIMIT_FIVE_CHARS);
                break;
            }
            case 6: {
                innerAnalyzerName = this.analyzerNameMap.get((Object)CHARS_ANALYZER_TYPE.LIMIT_SIX_CHARS);
                break;
            }
            case 7: {
                innerAnalyzerName = this.analyzerNameMap.get((Object)CHARS_ANALYZER_TYPE.LIMIT_SEVEN_CHARS);
                break;
            }
            case 8: {
                innerAnalyzerName = this.analyzerNameMap.get((Object)CHARS_ANALYZER_TYPE.LIMIT_EIGHT_CHARS);
                break;
            }
            case 9: {
                innerAnalyzerName = this.analyzerNameMap.get((Object)CHARS_ANALYZER_TYPE.LIMIT_MORE_CHARS);
                break;
            }
            default: {
                innerAnalyzerName = this.analyzerNameMap.get((Object)CHARS_ANALYZER_TYPE.LIMIT_MORE_CHARS);
            }
        }
        return innerAnalyzerName;
    }

    protected final Map<String, List<Term>> splitTermIntoGroupByFieldName(List<Term> termList) {
        HashMap<String, List<Term>> termSplitByFieldNameMap = new HashMap<String, List<Term>>();
        for (Term term : termList) {
            ArrayList<Term> termGroupList;
            String fieldName = term.getMatchedFieldName();
            if (StringUtils.isEmpty(fieldName)) {
                fieldName = "NONE";
            }
            if ((termGroupList = (ArrayList<Term>)termSplitByFieldNameMap.get(fieldName)) == null) {
                termGroupList = new ArrayList<Term>();
                termSplitByFieldNameMap.put(fieldName, termGroupList);
            }
            termGroupList.add(term);
        }
        return termSplitByFieldNameMap;
    }

    protected static enum CHARS_ANALYZER_TYPE {
        LIMIT_THREE_CHARS(1, "\u6700\u5c11\u4e09\u4e2a\u5b57\u7b26"),
        LIMIT_FOUR_CHARS(2, "\u6700\u5c114\u4e2a\u5b57\u7b26"),
        LIMIT_FIVE_CHARS(3, "\u6700\u5c115\u4e2a\u5b57\u7b26"),
        LIMIT_SIX_CHARS(4, "\u6700\u5c116\u4e2a\u5b57\u7b26"),
        LIMIT_SEVEN_CHARS(5, "\u6700\u5c117\u4e2a\u5b57\u7b26"),
        LIMIT_EIGHT_CHARS(6, "\u6700\u5c118\u4e2a\u5b57\u7b26"),
        LIMIT_MORE_CHARS(7, "\u4e0d\u5c11\u4e8e9\u4e2a\u5b57\u7b26"),
        LIMIT_TWO_CHARS(8, "\u6700\u5c11\u4e8c\u4e2a\u5b57\u7b26"),
        LIMIT_ONE_CHARS(9, "\u6700\u5c111\u4e2a\u5b57\u7b26"),
        LIMIT_ALL_LETTER_THREE_CHARS(21, "\u6700\u5c11\u4e09\u4e2a\u5b57\u7b26"),
        LIMIT_ALL_LETTER_FOUR_CHARS(22, "\u6700\u5c114\u4e2a\u5b57\u7b26"),
        LIMIT_ALL_LETTER_FIVE_CHARS(23, "\u6700\u5c115\u4e2a\u5b57\u7b26"),
        LIMIT_ALL_LETTER_SIX_CHARS(24, "\u6700\u5c116\u4e2a\u5b57\u7b26"),
        LIMIT_ALL_LETTER_SEVEN_CHARS(25, "\u6700\u5c117\u4e2a\u5b57\u7b26"),
        LIMIT_ALL_LETTER_EIGHT_CHARS(26, "\u6700\u5c118\u4e2a\u5b57\u7b26"),
        LIMIT_ALL_LETTER_MORE_CHARS(27, "\u4e0d\u5c11\u4e8e9\u4e2a\u5b57\u7b26"),
        LIMIT_ALL_LETTER_TWO_CHARS(28, "\u6700\u5c11\u4e8c\u4e2a\u5b57\u7b26"),
        LIMIT_ALL_LETTER_ONE_CHARS(29, "\u6700\u5c111\u4e2a\u5b57\u7b26");

        private int index;
        private String desc;

        private CHARS_ANALYZER_TYPE(int index, String desc) {
            this.index = index;
            this.desc = desc;
        }
    }
}

