/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.matcher;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.facade.config.MatcherConfig;
import com.valor.common.search.engine.facade.config.MatcherParams;
import com.valor.common.search.engine.matcher.AbstractMatcher;
import com.valor.common.search.engine.matcher.Matcher;
import com.valor.common.search.engine.matcher.Term;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.SearchUtils;
import com.valor.common.search.engine.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchPhrasePrefixQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;

public class EntiretyMatcher
extends AbstractMatcher {
    public static final String DEFAULT_MATCH_NAME = "EntiretyMatcher";
    public static final float DEFAULT_BOOST = 5.0f;
    private final Set<String> queryUsedFieldNameSet = new HashSet<String>();
    private final List<Map<String, Object>> enhanceFieldNames = new ArrayList<Map<String, Object>>();
    private MatchType matchType;
    private Term term;
    private Term termForYear;
    private final List<Term> aliasTermList = new ArrayList<Term>();
    private final List<Term> aliasForYearTermList = new ArrayList<Term>();
    private AtomicInteger matchsentenceCount = new AtomicInteger(0);

    public EntiretyMatcher() {
        this.matchName = DEFAULT_MATCH_NAME;
        this.globalBoost = 5.0f;
    }

    public EntiretyMatcher(RequestContext context, MatchType matchType) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.globalBoost = 5.0f;
        this.q = context.getQ();
        this.context = context;
        this.matchType = matchType;
        this.matchFieldName = context.KEY_MAIN_INDEX_FIELD;
        this.init();
    }

    public EntiretyMatcher(RequestContext context, MatchType matchType, String matchName) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.globalBoost = 5.0f;
        this.q = context.getQ();
        this.context = context;
        this.matchType = matchType;
        this.matchName = matchName;
        this.matchFieldName = context.KEY_MAIN_INDEX_FIELD;
        this.init();
    }

    public EntiretyMatcher(RequestContext context, String matchFieldName, String analyzerName, MatchType matchType) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.globalBoost = 5.0f;
        this.q = context.getQ().trim();
        this.context = context;
        this.matchType = matchType;
        this.matchFieldName = matchFieldName;
        this.analyzerName = analyzerName;
        this.init();
    }

    public EntiretyMatcher(String analyzerName, RequestContext context, MatchType matchType) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.globalBoost = 5.0f;
        this.q = context.getQ().trim();
        this.context = context;
        this.matchType = matchType;
        this.analyzerName = analyzerName;
        this.matchFieldName = context.KEY_MAIN_INDEX_FIELD;
        this.init();
    }

    public EntiretyMatcher(String analyzerName, String matchFieldName, RequestContext context, MatchType matchType) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.globalBoost = 5.0f;
        this.q = context.getQ().trim();
        this.context = context;
        this.matchType = matchType;
        this.analyzerName = analyzerName;
        this.matchFieldName = matchFieldName;
        this.init();
    }

    public void setMatchFieldName(String matchFieldName) {
        if (this.inited) {
            return;
        }
        this.matchFieldName = matchFieldName;
    }

    void setAnalyzerName(String analyzerName) {
        if (this.inited) {
            return;
        }
        this.analyzerName = analyzerName;
    }

    private void init() {
        this.context.saveMatcheNameandMatcheFieldNamePair(this.matchName, this.matchFieldName);
        this.inited = true;
    }

    @Override
    public Matcher.MATCHER_TYPE getMatcherType() {
        return Matcher.MATCHER_TYPE.ENTIRETY;
    }

    @Override
    public EntiretyMatcher assembly() {
        Term mainTermAliasByYear;
        String aliasQ;
        this.q = this.context.getQ();
        this.term = new Term(this.q);
        if (!StringUtils.isEmpty(this.analyzerName)) {
            this.term.setAnalyzer(this.analyzerName);
        }
        this.term.setMatchedFieldName(this.matchFieldName, this.context.KEY_MAIN_INDEX_FIELD);
        String missAliasQ = SearchUtils.tryToMissWordByLooseRule(this.q).trim();
        if (!StringUtils.isEmpty(missAliasQ) && missAliasQ.split("([\\s\\p{Zs}])+").length < this.q.split("([\\s\\p{Zs}])+").length) {
            Term aliasTerm = new Term(missAliasQ);
            if (!StringUtils.isEmpty(this.analyzerName)) {
                aliasTerm.setAnalyzer(this.analyzerName);
            }
            aliasTerm.setMatchedFieldName(this.matchFieldName, this.context.KEY_MAIN_INDEX_FIELD);
            this.aliasTermList.add(aliasTerm);
        }
        if (!StringUtils.isEmpty(aliasQ = SearchUtils.takeAliasStr(this.q, 3).trim())) {
            this.context.queryExecuteExtraWordAlias = aliasQ;
        }
        if (aliasQ.length() != missAliasQ.length() && !StringUtils.isEmpty(aliasQ) && aliasQ.split("([\\s\\p{Zs}])+").length < this.q.split("([\\s\\p{Zs}])+").length) {
            Term aliasTerm = new Term(aliasQ);
            if (!StringUtils.isEmpty(this.analyzerName)) {
                aliasTerm.setAnalyzer(this.analyzerName);
            }
            aliasTerm.setMatchedFieldName(this.matchFieldName, this.context.KEY_MAIN_INDEX_FIELD);
            this.aliasTermList.add(aliasTerm);
        }
        String aliasQDelPunct = StringUtils.delPunctWithNoSpace(this.q).trim();
        if (aliasQ.length() != aliasQDelPunct.length() && aliasQDelPunct.length() != missAliasQ.length() && this.q.length() != aliasQDelPunct.length()) {
            Term aliasTerm = new Term(aliasQDelPunct);
            if (!StringUtils.isEmpty(this.analyzerName)) {
                aliasTerm.setAnalyzer(this.analyzerName);
            }
            aliasTerm.setMatchedFieldName(this.matchFieldName, this.context.KEY_MAIN_INDEX_FIELD);
            this.aliasTermList.add(aliasTerm);
        }
        if ((mainTermAliasByYear = this.assemblyForYears(this.term)) != null) {
            this.termForYear = mainTermAliasByYear;
        }
        for (Term workTerm : this.aliasTermList) {
            Term subTermAliasByYear = this.assemblyForYears(workTerm);
            if (subTermAliasByYear == null) continue;
            this.aliasForYearTermList.add(subTermAliasByYear);
        }
        return this;
    }

    private Term assemblyForYears(Term workItem) {
        Map<String, List<String>> splitQ;
        if (this.matcherConfig.getYearFlag().booleanValue() && !CollectionUtils.isEmpty(splitQ = SearchUtils.splitByYear(workItem.getTermStr()))) {
            List<String> newQWords = splitQ.get("keywords");
            List<String> yearList = splitQ.get("years");
            Term newTerm = new Term(newQWords.get(0));
            if (!StringUtils.isEmpty(this.analyzerName)) {
                newTerm.setAnalyzer(this.analyzerName);
            }
            newTerm.setMatchedFieldName(this.matchFieldName, this.context.KEY_MAIN_INDEX_FIELD);
            newTerm.setYearList(yearList);
            return newTerm;
        }
        return null;
    }

    @Override
    public QueryBuilder buildBase() {
        this.matchsentenceCount = new AtomicInteger(0);
        QueryBuilder query = null;
        if (this.matchType.equals((Object)MatchType.NORMAL_MATCH) || this.matchType.equals((Object)MatchType.NORMAL_MATCH_WITH_TERM)) {
            query = this.buildBaseForNormalMatch();
        } else if (this.matchType.equals((Object)MatchType.STRICT_MATCH_WITH_TERM)) {
            query = this.buildBaseForStrictMatchWithTerm();
        } else if (this.matchType.equals((Object)MatchType.STRICT_MATCH)) {
            query = this.buildBaseForStrictMatch();
        }
        this.saveQuerySentenceMatchedFieldNameMapToContext();
        return query;
    }

    private QueryBuilder buildBaseForStrictMatch() {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        String sentenceQueryName = this.nextSentenceQueryName();
        MatchPhraseQueryBuilder mainQuery = (MatchPhraseQueryBuilder)QueryBuilders.matchPhraseQuery((String)this.term.getMatchedFieldName(), (Object)SearchUtils.takeStrByPrefixLimit(this.term.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT)).queryName(sentenceQueryName);
        this.queryUsedFieldNameSet.add(this.term.getMatchedFieldName());
        this.saveSentenceMatchFieldName(sentenceQueryName, this.term.getMatchedFieldName());
        boolQueryBuilder.should((QueryBuilder)mainQuery);
        if (!StringUtils.isEmpty(this.term.getAnalyzer())) {
            mainQuery.analyzer(this.term.getAnalyzer());
        }
        if (this.termForYear != null) {
            boolQueryBuilder.should(this.buildAliasTermQuery(this.termForYear));
        }
        this.context.getQueryMatcherMatchedFieldNameMap().put(this.matchName, new ArrayList<String>(this.queryUsedFieldNameSet));
        return boolQueryBuilder;
    }

    private QueryBuilder buildBaseForStrictMatchWithTerm() {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        String sentenceQueryName = this.nextSentenceQueryName();
        MatchPhraseQueryBuilder query = (MatchPhraseQueryBuilder)QueryBuilders.matchPhraseQuery((String)this.term.getMatchedFieldName(), (Object)SearchUtils.takeStrByPrefixLimit(this.term.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT)).queryName(sentenceQueryName);
        this.queryUsedFieldNameSet.add(this.term.getMatchedFieldName());
        this.saveSentenceMatchFieldName(sentenceQueryName, this.term.getMatchedFieldName());
        boolQueryBuilder.should((QueryBuilder)query);
        sentenceQueryName = this.nextSentenceQueryName();
        AbstractQueryBuilder cutSomeWordQueryBuilder = ((MatchPhraseQueryBuilder)QueryBuilders.matchPhraseQuery((String)this.context.wordSubIndexFieldName, (Object)SearchUtils.takeStrByPrefixLimit(this.term.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT)).slop(0).boost(this.boost * 3.0f)).queryName(sentenceQueryName);
        this.queryUsedFieldNameSet.add(this.context.wordSubIndexFieldName);
        this.saveSentenceMatchFieldName(sentenceQueryName, this.context.wordSubIndexFieldName);
        boolQueryBuilder.should((QueryBuilder)cutSomeWordQueryBuilder);
        ArrayList<Term> aliasForYearTermWorkList = new ArrayList<Term>(this.aliasForYearTermList);
        aliasForYearTermWorkList.add(this.termForYear);
        for (Term term : aliasForYearTermWorkList) {
            if (term == null) continue;
            boolQueryBuilder.should(this.buildAliasTermQuery(term));
        }
        if (this.matchType.equals((Object)MatchType.STRICT_MATCH_WITH_TERM)) {
            sentenceQueryName = this.nextSentenceQueryName();
            TermQueryBuilder termQueryBuilder = (TermQueryBuilder)((TermQueryBuilder)new TermQueryBuilder(this.matchFieldName + ".raw", SearchUtils.takeStrByPrefixLimit(this.context.getQ(), this.MATCHER_SENTENCE_LETTER_LIMIT)).boost(this.boost * 3.0f)).queryName(sentenceQueryName);
            this.queryUsedFieldNameSet.add(this.matchFieldName + ".raw");
            this.saveSentenceMatchFieldName(sentenceQueryName, this.matchFieldName + ".raw");
            boolQueryBuilder.should((QueryBuilder)termQueryBuilder);
        }
        for (Map map : this.enhanceFieldNames) {
            sentenceQueryName = this.nextSentenceQueryName();
            AbstractQueryBuilder enhanceQuery = ((MatchPhraseQueryBuilder)QueryBuilders.matchPhraseQuery((String)map.get("name").toString(), (Object)SearchUtils.takeStrByPrefixLimit(this.term.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT)).boost(this.boost * Float.parseFloat(map.get("rate").toString()))).queryName(sentenceQueryName);
            this.queryUsedFieldNameSet.add(map.get("name").toString());
            this.saveSentenceMatchFieldName(sentenceQueryName, map.get("name").toString());
            boolQueryBuilder.should((QueryBuilder)enhanceQuery);
        }
        boolQueryBuilder.minimumShouldMatch(1).boost(this.boost);
        this.context.getQueryMatcherMatchedFieldNameMap().put(this.matchName, new ArrayList<String>(this.queryUsedFieldNameSet));
        return boolQueryBuilder;
    }

    private QueryBuilder buildSentencePrefixMatch(String matchField, String wordLettersFieldName, String allLettersFieldName, String queryWord) {
        String[] newQs = this.q.trim().split("([\\s\\p{Zs}])+");
        BoolQueryBuilder sentencePrefixQuery = null;
        if (newQs.length > 1) {
            StringBuilder buffer = new StringBuilder();
            StringBuilder prefixBuffer = new StringBuilder();
            for (int index = 0; index < newQs.length - 1; ++index) {
                buffer.append(newQs[index]).append(" ");
            }
            for (String str : newQs) {
                prefixBuffer.append(str);
            }
            MatchQueryBuilder prefixWordQuery = QueryBuilders.matchQuery((String)allLettersFieldName, (Object)prefixBuffer.toString().toLowerCase()).operator(Operator.AND);
            AbstractQueryBuilder matchQuery = QueryBuilders.matchPhraseQuery((String)matchField, (Object)buffer.toString()).boost(10.0f);
            sentencePrefixQuery = (BoolQueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)prefixWordQuery).must((QueryBuilder)matchQuery).queryName("check_entiretyMatch_prefix_sentence");
        } else if (newQs.length == 1) {
            sentencePrefixQuery = (BoolQueryBuilder)((BoolQueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.matchQuery((String)matchField, (Object)queryWord)).must((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.wildcardQuery((String)matchField, (String)(queryWord + "*"))).must((QueryBuilder)QueryBuilders.matchQuery((String)wordLettersFieldName, (Object)queryWord).boost(2.5f))).boost(1.0f)).queryName("check_entiretyMatch_prefix_sentence");
        }
        return sentencePrefixQuery;
    }

    private QueryBuilder buildBaseForNormalMatch() {
        if (!this.matchType.equals((Object)MatchType.NORMAL_MATCH) && !this.matchType.equals((Object)MatchType.NORMAL_MATCH_WITH_TERM)) {
            return null;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        String sentenceQueryName = this.nextSentenceQueryName();
        MatchPhraseQueryBuilder query = (MatchPhraseQueryBuilder)((MatchPhraseQueryBuilder)QueryBuilders.matchPhraseQuery((String)this.term.getMatchedFieldName(), (Object)SearchUtils.takeStrByPrefixLimit(this.term.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT)).slop(20).boost(this.boost * 5.0f)).queryName(sentenceQueryName);
        this.queryUsedFieldNameSet.add(this.term.getMatchedFieldName());
        this.saveSentenceMatchFieldName(sentenceQueryName, this.term.getMatchedFieldName());
        boolQueryBuilder.should((QueryBuilder)query);
        if (!StringUtils.isEmpty(this.term.getAnalyzer())) {
            query.analyzer(this.term.getAnalyzer());
        }
        AbstractQueryBuilder preFixeQuery = ((MatchPhrasePrefixQueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)this.term.getMatchedFieldName(), (Object)SearchUtils.takeStrByPrefixLimit(this.term.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT)).boost(this.boost * 5.0f)).queryName("check_entiretyMatch_prefix_sentence_w");
        this.queryUsedFieldNameSet.add(this.term.getMatchedFieldName());
        this.saveSentenceMatchFieldName("check_entiretyMatch_prefix_sentence_w", this.term.getMatchedFieldName());
        boolQueryBuilder.should((QueryBuilder)preFixeQuery);
        AbstractQueryBuilder cutSomeWordQueryBuilder = ((MatchPhraseQueryBuilder)QueryBuilders.matchPhraseQuery((String)this.context.wordSubIndexFieldName, (Object)SearchUtils.takeStrByPrefixLimit(this.term.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT)).slop(0).boost(this.boost * 3.0f)).queryName(sentenceQueryName);
        this.queryUsedFieldNameSet.add(this.context.wordSubIndexFieldName);
        this.saveSentenceMatchFieldName(sentenceQueryName, this.context.wordSubIndexFieldName);
        boolQueryBuilder.should((QueryBuilder)cutSomeWordQueryBuilder);
        for (Term term : this.aliasTermList) {
            if (!StringUtils.isEmpty(term.getAnalyzer())) {
                query.analyzer(term.getAnalyzer());
            }
            sentenceQueryName = this.nextAliasSentenceQueryName();
            MatchPhraseQueryBuilder aliasQuery = (MatchPhraseQueryBuilder)QueryBuilders.matchPhraseQuery((String)term.getMatchedFieldName(), (Object)SearchUtils.takeStrByPrefixLimit(term.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT)).slop(20).queryName(sentenceQueryName);
            this.queryUsedFieldNameSet.add(term.getMatchedFieldName());
            this.saveSentenceMatchFieldName(sentenceQueryName, term.getMatchedFieldName());
            boolQueryBuilder.should((QueryBuilder)aliasQuery);
            for (Map<String, Object> enhanceField : this.enhanceFieldNames) {
                sentenceQueryName = this.nextAliasSentenceQueryName();
                MatchPhraseQueryBuilder enhanceQuery = (MatchPhraseQueryBuilder)((MatchPhraseQueryBuilder)QueryBuilders.matchPhraseQuery((String)enhanceField.get("name").toString(), (Object)SearchUtils.takeStrByPrefixLimit(term.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT)).boost(this.boost * Float.parseFloat(enhanceField.get("rate").toString()))).queryName(sentenceQueryName);
                this.queryUsedFieldNameSet.add(enhanceField.get("name").toString());
                this.saveSentenceMatchFieldName(sentenceQueryName, enhanceField.get("name").toString());
                boolQueryBuilder.should((QueryBuilder)enhanceQuery);
            }
        }
        ArrayList<Term> aliasForYearTermWorkList = new ArrayList<Term>(this.aliasForYearTermList);
        aliasForYearTermWorkList.add(this.termForYear);
        for (Term aliseTerm : aliasForYearTermWorkList) {
            if (aliseTerm == null) continue;
            boolQueryBuilder.should(this.buildAliasTermQuery(aliseTerm));
        }
        if (this.matchType.equals((Object)MatchType.NORMAL_MATCH_WITH_TERM)) {
            sentenceQueryName = this.nextSentenceQueryName();
            TermQueryBuilder termQueryBuilder = (TermQueryBuilder)((TermQueryBuilder)new TermQueryBuilder(this.matchFieldName + ".raw", SearchUtils.takeStrByPrefixLimit(this.context.getQ(), this.MATCHER_SENTENCE_LETTER_LIMIT)).boost(this.boost * 3.0f)).queryName(sentenceQueryName);
            this.queryUsedFieldNameSet.add(this.matchFieldName + ".raw");
            this.saveSentenceMatchFieldName(sentenceQueryName, this.matchFieldName + ".raw");
            boolQueryBuilder.should((QueryBuilder)termQueryBuilder);
        }
        for (Map<String, Object> enhanceField : this.enhanceFieldNames) {
            sentenceQueryName = this.nextSentenceQueryName();
            MatchPhraseQueryBuilder enhanceQuery = (MatchPhraseQueryBuilder)((MatchPhraseQueryBuilder)QueryBuilders.matchPhraseQuery((String)enhanceField.get("name").toString(), (Object)SearchUtils.takeStrByPrefixLimit(this.term.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT)).boost(this.boost * Float.parseFloat(enhanceField.get("rate").toString()))).queryName(sentenceQueryName);
            this.queryUsedFieldNameSet.add(enhanceField.get("name").toString());
            this.saveSentenceMatchFieldName(sentenceQueryName, enhanceField.get("name").toString());
            boolQueryBuilder.should((QueryBuilder)enhanceQuery);
        }
        boolQueryBuilder.minimumShouldMatch(1).boost(this.boost);
        this.context.getQueryMatcherMatchedFieldNameMap().put(this.matchName, new ArrayList<String>(this.queryUsedFieldNameSet));
        return boolQueryBuilder;
    }

    private String nextSentenceQueryName() {
        return "check_entiretyMatch_" + this.matchsentenceCount.getAndIncrement();
    }

    private String nextAliasSentenceQueryName() {
        return "check_entiretyMatch_alias_" + this.matchsentenceCount.getAndIncrement();
    }

    private QueryBuilder buildAliasTermQuery(Term workTerm) {
        ArrayList<MatchPhraseQueryBuilder> mainQueryBuilderList = new ArrayList<MatchPhraseQueryBuilder>();
        String sentenceQuertName = this.nextAliasSentenceQueryName();
        MatchPhraseQueryBuilder aliasQuery = (MatchPhraseQueryBuilder)QueryBuilders.matchPhraseQuery((String)workTerm.getMatchedFieldName(), (Object)SearchUtils.takeStrByPrefixLimit(workTerm.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT)).slop(20).queryName(sentenceQuertName);
        this.queryUsedFieldNameSet.add(workTerm.getMatchedFieldName());
        this.saveSentenceMatchFieldName(sentenceQuertName, workTerm.getMatchedFieldName());
        mainQueryBuilderList.add(aliasQuery);
        if (!StringUtils.isEmpty(workTerm.getAnalyzer())) {
            aliasQuery.analyzer(workTerm.getAnalyzer());
        }
        for (Map<String, Object> map : this.enhanceFieldNames) {
            sentenceQuertName = this.nextAliasSentenceQueryName();
            MatchPhraseQueryBuilder matchPhraseQueryBuilder = (MatchPhraseQueryBuilder)((MatchPhraseQueryBuilder)QueryBuilders.matchPhraseQuery((String)map.get("name").toString(), (Object)SearchUtils.takeStrByPrefixLimit(workTerm.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT)).boost(this.boost * Float.parseFloat(map.get("rate").toString()))).queryName(sentenceQuertName);
            this.queryUsedFieldNameSet.add(map.get("name").toString());
            this.saveSentenceMatchFieldName(sentenceQuertName, map.get("name").toString());
            mainQueryBuilderList.add(matchPhraseQueryBuilder);
        }
        ArrayList<TermQueryBuilder> filterLQueryBuilderList = new ArrayList<TermQueryBuilder>();
        if (!CollectionUtils.isEmpty(workTerm.getYearList())) {
            for (String string : workTerm.getYearList()) {
                if (StringUtils.isEmpty(string)) continue;
                filterLQueryBuilderList.add(QueryBuilders.termQuery((String)this.matcherConfig.getYearFieldName(), (String)string));
            }
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        ((BoolQueryBuilder)boolQueryBuilder.queryName("YearAlias_query")).minimumShouldMatch(1);
        for (QueryBuilder queryBuilder : mainQueryBuilderList) {
            boolQueryBuilder.should(queryBuilder);
        }
        if (filterLQueryBuilderList.size() == 1) {
            boolQueryBuilder.filter((QueryBuilder)filterLQueryBuilderList.get(0)).minimumShouldMatch(1);
        } else if (filterLQueryBuilderList.size() > 1) {
            BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery();
            for (QueryBuilder queryBuilder : filterLQueryBuilderList) {
                boolQueryBuilder2.should(queryBuilder);
            }
            boolQueryBuilder.filter((QueryBuilder)boolQueryBuilder2).minimumShouldMatch(1);
        }
        return boolQueryBuilder;
    }

    @Override
    public void prepareByConfig(MatcherConfig config) {
        this.matcherConfig = config;
        MatcherParams matcherParams = this.matcherConfig.getMatcherParams();
        this.matchType = MatchType.valueOf(matcherParams.getMatchType());
        if (!StringUtils.isEmpty(matcherParams.getMatchFieldName())) {
            this.setMatchFieldName(matcherParams.getMatchFieldName());
        } else {
            this.setMatchFieldName(this.context.KEY_MAIN_INDEX_FIELD);
        }
        if (!StringUtils.isEmpty(matcherParams.getAnalyzerName())) {
            this.setAnalyzerName(matcherParams.getAnalyzerName());
        }
        try {
            if (!CollectionUtils.isEmpty(matcherParams.getEnhanceField())) {
                for (Map<String, Object> item : matcherParams.getEnhanceField()) {
                    if (CollectionUtils.isEmpty(item)) continue;
                    this.enhanceFieldNames.add(item);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("enhanceFieldName in  config error " + e);
        }
        super.prepareByConfig(this.matcherConfig);
        this.init();
    }

    public static enum MatchType {
        STRICT_MATCH(1, "strict", "\u4e25\u683c\u5b8c\u5168\u5339\u914d"),
        NORMAL_MATCH(2, "non-strict", "\u975e\u4e25\u683c\u5b8c\u5168\u5339\u914d"),
        NORMAL_MATCH_WITH_TERM(3, "non-strict-with-term", "\u975e\u4e25\u683c\u5b8c\u5168\u5339\u914d,\u540c\u65f6\u9700\u8981term\u53ec\u56deQ\u5b8c\u5168\u5339\u914d\u7684\u6587\u672c"),
        STRICT_MATCH_WITH_TERM(4, "strict-with-term", "\u4e25\u683c\u5b8c\u5168\u5339\u914d,\u540c\u65f6\u9700\u8981term\u53ec\u56deQ\u5b8c\u5168\u5339\u914d\u7684\u6587\u672c");

        private final String type;
        private final String desc;
        private int index;

        private MatchType(int index, String strict, String desc) {
            this.type = strict;
            this.index = index;
            this.desc = desc;
        }

        private String getType() {
            return this.type;
        }
    }
}

