/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.matcher;

import com.valor.common.search.engine.filter.InlineFilter;
import com.valor.common.search.engine.ranker.AbstractInlineScoreRanker;
import org.elasticsearch.index.query.QueryBuilder;

public interface Matcher {
    default public QUERY_TERM_TYPE queryTermType() {
        String q = this.getQ().trim();
        if (q.isEmpty()) {
            return QUERY_TERM_TYPE.NONE;
        }
        String[] newQs = q.split("([\\s\\p{Zs}])+");
        if (newQs.length == 1) {
            return QUERY_TERM_TYPE.ONE_WORD;
        }
        if (newQs.length == 2) {
            return QUERY_TERM_TYPE.TWO_WORD;
        }
        if (newQs.length >= 3) {
            return QUERY_TERM_TYPE.MORE_WORD;
        }
        return QUERY_TERM_TYPE.NONE;
    }

    public MATCHER_TYPE getMatcherType();

    public String getQ();

    public String getMatchFieldName();

    public String getMatchName();

    public Matcher assembly();

    public QueryBuilder buildAll();

    public QueryBuilder buildBase();

    public QueryBuilder buildBaseWidthFilter();

    public QueryBuilder buildWith(BUILD_MODE[] var1);

    public Matcher name(String var1);

    public Matcher exclude(Matcher var1);

    public Matcher filter(InlineFilter var1);

    public Matcher scoreRanker(AbstractInlineScoreRanker var1);

    public Matcher boost(float var1);

    public Matcher globalBoost(float var1);

    public static enum QUERY_TERM_TYPE {
        NONE(0),
        ONE_WORD(1),
        TWO_WORD(2),
        MORE_WORD(3),
        EXTRA_THREE_WORD(4);

        private int index;

        private QUERY_TERM_TYPE(int i) {
            this.index = i;
        }
    }

    public static enum MATCHER_TYPE {
        ENTIRETY(1),
        MISSING_WORD(2),
        PARTIAL_WORD(3),
        MININUM_STR(4),
        GENERAL_FUZZY(5),
        GENERAL_TERM(6),
        NEST_QUERY(7);

        private int index = 0;

        private MATCHER_TYPE(int i) {
            this.index = i;
        }
    }

    public static enum BUILD_MODE {
        BASE(1),
        ALL(2),
        WITH_EXCLUDE(3),
        WITH_FILTER(4),
        WITH_RANKER(5);

        private int index = 0;

        private BUILD_MODE(int index) {
            this.index = index;
        }
    }
}

