/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.matcher;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.matcher.AbstractFuzzyMatcher;
import com.valor.common.search.engine.matcher.Matcher;
import com.valor.common.search.engine.matcher.Term;
import com.valor.common.search.engine.matcher.WordToken;
import com.valor.common.search.engine.matcher.WordTokenIndexComparator;
import com.valor.common.search.engine.matcher.WordTokenLengthComparator;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class MultiFieldMissingWordMatcher
extends AbstractFuzzyMatcher {
    public static final float DEFAULT_LOST_WORD_LIMIT_RATE = 0.35f;
    public static final float DEFAULT_LOST_CHAR_LIMIT_RATE = 0.4f;
    public static final String DEFAULT_MATCH_NAME = "MissingWordMatcher";
    private float lostCharLimitRate;
    private float lostWordLimitRate;
    private List<List<Term>> termList = new ArrayList<List<Term>>();
    private String[] notSearchNormWord = new String[]{"on", "the", "a", "an", "in"};
    private Set<String> queryUsedFieldNameSet = new HashSet<String>();
    private final List<ImmutablePair<String, Float>> multiMatchFieldNames = new ArrayList<ImmutablePair<String, Float>>();

    public MultiFieldMissingWordMatcher(RequestContext context, List<ImmutablePair<String, Float>> matchFieldNameList) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.q = context.getQ().trim();
        this.context = context;
        this.multiMatchFieldNames.addAll(matchFieldNameList);
        this.init();
    }

    public MultiFieldMissingWordMatcher(RequestContext context, String matchName, List<ImmutablePair<String, Float>> matchFieldNameList) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.q = context.getQ().trim();
        this.context = context;
        this.matchName = matchName;
        this.multiMatchFieldNames.addAll(matchFieldNameList);
        this.init();
    }

    private void init() {
        ArrayList<String> multiFieldNamesList = new ArrayList<String>();
        for (ImmutablePair<String, Float> p : this.multiMatchFieldNames) {
            multiFieldNamesList.add((String)p.getLeft());
        }
        this.context.saveMultiMatcheNameandMatcheFieldNamePair(this.matchName, multiFieldNamesList);
        this.globalBoost = 0.8f;
    }

    @Override
    public Matcher.MATCHER_TYPE getMatcherType() {
        return Matcher.MATCHER_TYPE.MISSING_WORD;
    }

    @Override
    public MultiFieldMissingWordMatcher assembly() {
        this.termList.clear();
        this.q = this.context.getQ();
        if (this.lostWordLimitRate == 0.0f) {
            this.lostWordLimitRate = 0.35f;
        }
        if (this.lostCharLimitRate == 0.0f) {
            this.lostCharLimitRate = 0.4f;
        }
        List<List<WordToken>> lists = this.cutSomeWords(this.q);
        StringBuilder sbuilder = new StringBuilder();
        int maxCharsLenTermIndex = 0;
        int maxCharsLen = 0;
        int index = 0;
        for (List<WordToken> list : lists) {
            ArrayList<Term> terms = new ArrayList<Term>();
            index = 0;
            maxCharsLen = 0;
            maxCharsLenTermIndex = 0;
            for (WordToken t : list) {
                Term term = new Term(t.getToken().trim());
                if (StringUtils.isEmpty(this.matchFieldName)) {
                    term.setMatchedFieldName(this.context.wordSubIndexFieldName);
                } else {
                    term.setMatchedFieldName(this.matchFieldName);
                }
                if (!StringUtils.isEmpty(this.analyzerName)) {
                    term.setAnalyzer(this.analyzerName);
                } else {
                    term.setAnalyzer(this.context.wordAnalyzerName);
                }
                if (maxCharsLen < term.getTermStr().length()) {
                    maxCharsLen = term.getTermStr().length();
                    maxCharsLenTermIndex = index;
                }
                ++index;
                terms.add(term);
            }
            this.termList.add(terms);
            ((Term)terms.get(maxCharsLenTermIndex)).setAnalyzer(this.getFuzzyAnalyzerName(maxCharsLen));
        }
        return this;
    }

    @Override
    public QueryBuilder buildBase() {
        BoolQueryBuilder mainQuery = null;
        if (this.termList.size() > 0) {
            mainQuery = QueryBuilders.boolQuery();
        }
        for (List<Term> terms : this.termList) {
            BoolQueryBuilder subBoolQuery = QueryBuilders.boolQuery();
            Map<String, List<Term>> termSplitByFieldNameMap = this.splitTermIntoGroupByFieldName(terms);
            for (Map.Entry<String, List<Term>> entry : termSplitByFieldNameMap.entrySet()) {
                HashMap<String, Object> workTermFieldBoostMap = new HashMap<String, Object>();
                for (ImmutablePair<String, Float> p : this.multiMatchFieldNames) {
                    String newFieldName = entry.getKey().replaceAll("NONE", (String)p.getLeft());
                    workTermFieldBoostMap.put(newFieldName, p.getRight());
                }
                this.queryUsedFieldNameSet.addAll(workTermFieldBoostMap.keySet());
                for (Term term : entry.getValue()) {
                    MultiMatchQueryBuilder queryBuilder = QueryBuilders.multiMatchQuery((Object)term.getTermStr(), (String[])((String[])workTermFieldBoostMap.keySet().stream().toArray(String[]::new))).tieBreaker(1.0f).fields(workTermFieldBoostMap);
                    if (!StringUtils.isEmpty(term.getAnalyzer())) {
                        queryBuilder.analyzer(term.getAnalyzer());
                    }
                    subBoolQuery.must((QueryBuilder)queryBuilder.operator(Operator.AND));
                }
            }
            mainQuery.should((QueryBuilder)subBoolQuery);
        }
        if (mainQuery != null) {
            mainQuery.minimumShouldMatch(1).boost(this.globalBoost);
        }
        this.context.putQueryMatcherMatchedFieldNameMap(this.matchName, CollectionUtils.arrayToList(this.queryUsedFieldNameSet.toArray()));
        return mainQuery;
    }

    private List<List<WordToken>> cutSomeWords(String q) {
        String[] qs = q.replaceAll("-", " ").trim().split("([\\s\\p{Zs}])+");
        int totalCharLength = 0;
        ArrayList<WordToken> list = new ArrayList<WordToken>();
        int index = 0;
        boolean searchNorm = false;
        for (String s : qs) {
            totalCharLength += s.length();
            searchNorm = StringUtils.delPunct(s).length() > 1 && this.isValidSearchNorm(s);
            list.add(new WordToken(s, ++index, searchNorm));
        }
        list.sort(new WordTokenLengthComparator());
        int maxCutCharsCount = (int)Math.ceil((float)totalCharLength * 0.35f);
        maxCutCharsCount = totalCharLength == 5 || totalCharLength == 10 ? (int)((float)totalCharLength * this.lostCharLimitRate * 10.0f) / 10 : (int)Math.floor((float)totalCharLength * this.lostCharLimitRate);
        return this.tryCutWordToken(list, maxCutCharsCount, totalCharLength, qs.length);
    }

    private List<List<WordToken>> tryCutWordToken(List<WordToken> list, int maxCutCharsCount, int totalLength, int totalWord) {
        ArrayList<List<WordToken>> tokenList = new ArrayList<List<WordToken>>();
        int currentWordLength = 0;
        for (WordToken t : list) {
            currentWordLength += t.getToken().length();
        }
        int cutWordMax = Math.min(5, Math.round((float)totalWord * this.lostWordLimitRate));
        int cuttedWordCount = 0;
        int cuttedCharsCount = 0;
        WordTokenIndexComparator comparator = new WordTokenIndexComparator();
        for (int index = 0; index < list.size() - cutWordMax + 1; ++index) {
            boolean isOk = true;
            ArrayList<WordToken> candidateToken = new ArrayList<WordToken>();
            cuttedCharsCount = 0;
            for (int i = 0; i < list.size(); ++i) {
                if ((i < index || i >= index + cutWordMax) && list.get(i).isSearchNorm()) {
                    candidateToken.add(list.get(i));
                    continue;
                }
                ++cuttedWordCount;
                if ((cuttedCharsCount += list.get(i).getToken().length()) <= maxCutCharsCount) continue;
                isOk = false;
                break;
            }
            if (!isOk || cuttedWordCount > cutWordMax) continue;
            candidateToken.sort(comparator);
            tokenList.add(candidateToken);
        }
        return tokenList;
    }

    private boolean isValidSearchNorm(String t) {
        boolean retVal = CollectionUtils.arrayToList(this.notSearchNormWord).contains(t.trim().toLowerCase());
        return !retVal;
    }
}

