/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.ranker;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.facade.config.PostRankerConfig;
import com.valor.common.search.engine.facade.config.RankerComparatorConfig;
import com.valor.common.search.engine.ranker.AbstractPostScoreRanker;
import com.valor.common.search.engine.ranker.comparator.AbstractRankerComparator;
import com.valor.common.search.engine.ranker.comparator.CelebsHotWeightComparator;
import com.valor.common.search.engine.ranker.comparator.MovieSeriesYearPopularityWeightComparator;
import com.valor.common.search.engine.ranker.comparator.ScoreDescComparator;
import com.valor.common.search.engine.ranker.comparator.ScoreWeightDescComparator;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.SearchUtils;
import com.valor.common.search.engine.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.search.SearchHit;
import org.nfunk.jep.JEP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeliplatTurningAllMatchRanker
extends AbstractPostScoreRanker {
    private static final Logger logger = LoggerFactory.getLogger(PeliplatTurningAllMatchRanker.class);
    public static final String DEFAULT_THRESHOLD_TYPE_NAME = "default";
    private String searchName;
    private final List<String> sortFieldNames = new ArrayList<String>();
    private String thresholdFieldName = "weight";
    private final Map<String, Float> thresholdTypeValueMap = new HashMap<String, Float>();
    private String thresholdTypeFieldName = "mark";
    private final Map<String, Comparator> comparatorMap = new HashMap<String, Comparator>();
    private boolean enableTurningRankerNewSort = true;

    public PeliplatTurningAllMatchRanker() {
    }

    public PeliplatTurningAllMatchRanker(RequestContext context, String searchName, String sortFieldNames) {
        this.context = context;
        this.searchName = searchName;
        this.sortFieldNames.add(sortFieldNames);
        this.initComparator();
    }

    public PeliplatTurningAllMatchRanker(RequestContext context) {
        this.context = context;
        this.searchName = "EntiretyMatcher";
        this.sortFieldNames.add(context.KEY_MAIN_INDEX_FIELD);
        this.enableTurningRankerNewSort = context.getBizSysConfig().isEnableTurningRankerNewSort();
        this.initComparator();
    }

    public PeliplatTurningAllMatchRanker(RequestContext context, String ... sortFieldNames) {
        this.context = context;
        this.searchName = "EntiretyMatcher";
        this.sortFieldNames.addAll(Arrays.asList(sortFieldNames));
        this.enableTurningRankerNewSort = context.getBizSysConfig().isEnableTurningRankerNewSort();
        this.initComparator();
    }

    private void initComparator() {
        this.comparatorMap.put("CelebsComparator", new CelebsHotWeightComparator());
        this.comparatorMap.put("MovieSeriesComparator", new MovieSeriesYearPopularityWeightComparator());
        this.comparatorMap.put("NormalComparator", new ScoreWeightDescComparator());
        this.comparatorMap.put("ScoreDescComparator", new ScoreDescComparator());
    }

    @Override
    public void execute() throws RuntimeException {
        String q = this.context.getQ().toLowerCase();
        q = org.apache.commons.lang3.StringUtils.stripAccents((String)q);
        SearchHit topHit = null;
        ArrayList<SearchHit> willSortingDataList = new ArrayList<SearchHit>();
        ArrayList<SearchHit> otherMatchHitList = new ArrayList<SearchHit>();
        for (SearchHit hit2 : this.context.getResponse().getHits().getHits()) {
            if (this.hasAllMatchQuery(hit2.getMatchedQueries())) {
                willSortingDataList.add(hit2);
                continue;
            }
            otherMatchHitList.add(hit2);
        }
        ArrayList<SearchHit> extraAllMatchHitList = new ArrayList<SearchHit>();
        ArrayList<SearchHit> hasSameWordAndPosList = new ArrayList<SearchHit>();
        ArrayList<SearchHit> hasSameWordList = new ArrayList<SearchHit>();
        ArrayList<SearchHit> notSortDataList = new ArrayList<SearchHit>();
        ArrayList<SearchHit> sameWordSortedList = new ArrayList<SearchHit>();
        for (String sortingFieldName : this.sortFieldNames) {
            for (SearchHit searchHit : willSortingDataList) {
                ArrayList<String> titleList;
                Object obj = searchHit.getSourceAsMap().get(sortingFieldName);
                if (obj == null) continue;
                if (obj instanceof String) {
                    titleList = new ArrayList<String>();
                    titleList.add(obj.toString());
                } else {
                    titleList = (ArrayList<String>)obj;
                }
                String extraAliasQ = this.context.queryExecuteExtraWordAlias;
                if (!StringUtils.isEmpty(extraAliasQ)) {
                    extraAliasQ = org.apache.commons.lang3.StringUtils.stripAccents((String)extraAliasQ.toLowerCase(Locale.ROOT).trim());
                }
                boolean isExtraAllMatch = false;
                boolean isHasSameWordandPos = false;
                for (String s : titleList) {
                    if ((s = org.apache.commons.lang3.StringUtils.stripAccents((String)s.toLowerCase().trim())).equals(q)) {
                        isExtraAllMatch = true;
                        continue;
                    }
                    if (isExtraAllMatch || !s.contains(q) && (StringUtils.isEmpty(extraAliasQ) || !s.contains(extraAliasQ))) continue;
                    isHasSameWordandPos = true;
                }
                if (isExtraAllMatch) {
                    if (this.canApplyThreshold(searchHit)) {
                        if (extraAllMatchHitList.contains(searchHit)) continue;
                        extraAllMatchHitList.add(searchHit);
                        continue;
                    }
                    if (notSortDataList.contains(searchHit)) continue;
                    notSortDataList.add(searchHit);
                    continue;
                }
                if (isHasSameWordandPos) {
                    if (this.canApplyThreshold(searchHit)) {
                        if (hasSameWordAndPosList.contains(searchHit)) continue;
                        hasSameWordAndPosList.add(searchHit);
                        continue;
                    }
                    if (notSortDataList.contains(searchHit)) continue;
                    notSortDataList.add(searchHit);
                    continue;
                }
                if (this.canApplyThreshold(searchHit)) {
                    if (hasSameWordList.contains(searchHit)) continue;
                    hasSameWordList.add(searchHit);
                    continue;
                }
                if (notSortDataList.contains(searchHit)) continue;
                notSortDataList.add(searchHit);
            }
            extraAllMatchHitList.removeAll(sameWordSortedList);
            hasSameWordAndPosList.removeAll(sameWordSortedList);
            extraAllMatchHitList.forEach(m -> m.getSourceAsMap().put("matchType", "extractSameWord"));
            hasSameWordAndPosList.forEach(m -> m.getSourceAsMap().put("matchType", "sameWord"));
            sameWordSortedList.addAll(extraAllMatchHitList);
            sameWordSortedList.addAll(hasSameWordAndPosList);
            ArrayList<SearchHit> cutoffList = new ArrayList<SearchHit>();
            this.filterHitsforSortByWeight(sameWordSortedList, cutoffList);
            for (SearchHit hit4 : cutoffList) {
                hit4.getSourceAsMap().put("weight", Float.valueOf(Float.parseFloat(hit4.getSourceAsMap().get("weight").toString()) * 2.0f));
            }
            cutoffList.removeAll(notSortDataList);
            notSortDataList.addAll(cutoffList);
            if (topHit == null) {
                topHit = !CollectionUtils.isEmpty(extraAllMatchHitList) && !((SearchHit)extraAllMatchHitList.get(0)).equals(sameWordSortedList.get(0)) ? (SearchHit)extraAllMatchHitList.get(0) : this.getTopHitDoc(willSortingDataList, q, sortingFieldName);
            }
            willSortingDataList.clear();
            willSortingDataList.addAll(notSortDataList);
            notSortDataList.clear();
        }
        AbstractRankerComparator comparator = this.enableTurningRankerNewSort ? (this.context.getMarks().size() == 1 && ("movies".equalsIgnoreCase(this.context.getMarks().get(0)) || "series".equalsIgnoreCase(this.context.getMarks().get(0))) ? (AbstractRankerComparator)this.comparatorMap.get("MovieSeriesComparator") : (this.context.getMarks().size() == 1 && "celebs".equalsIgnoreCase(this.context.getMarks().get(0)) ? (AbstractRankerComparator)this.comparatorMap.get("CelebsComparator") : (this.context.getMarks().size() == 1 && ("article".equalsIgnoreCase(this.context.getMarks().get(0)) || "user".equalsIgnoreCase(this.context.getMarks().get(0)) || "video".equalsIgnoreCase(this.context.getMarks().get(0))) ? (AbstractRankerComparator)this.comparatorMap.get("ScoreDescComparator") : (this.context.getMarks().size() > 0 && this.context.getMarks().contains("meta") ? (AbstractRankerComparator)this.comparatorMap.get("NormalComparator") : (AbstractRankerComparator)this.comparatorMap.get("NormalComparator"))))) : (AbstractRankerComparator)this.comparatorMap.get("NormalComparator");
        sameWordSortedList.parallelStream().forEach(m -> {
            comparator.computeScore((SearchHit)m);
            Float newScore = Float.valueOf(Float.parseFloat(m.getSourceAsMap().get("newScore").toString()));
            if (newScore.isNaN()) {
                newScore = Float.valueOf(0.0f);
            }
            m.getSourceAsMap().put("newScore", newScore);
            m.getSourceAsMap().put("rankerType", "sameWord");
        });
        sameWordSortedList.sort(comparator);
        hasSameWordList.parallelStream().forEach(m -> {
            comparator.computeScore((SearchHit)m);
            Float newScore = Float.valueOf(Float.parseFloat(m.getSourceAsMap().get("newScore").toString()));
            if (newScore.isNaN()) {
                newScore = Float.valueOf(0.0f);
            }
            m.getSourceAsMap().put("newScore", newScore);
            m.getSourceAsMap().put("rankerType", "lowCreditSameWord");
            m.getSourceAsMap().put("matchType", "includeSameWord");
        });
        hasSameWordList.sort(comparator);
        otherMatchHitList.addAll(willSortingDataList);
        AbstractRankerComparator otherComparator = (AbstractRankerComparator)this.comparatorMap.get("ScoreDescComparator");
        otherMatchHitList.parallelStream().forEach(m -> {
            otherComparator.computeScore((SearchHit)m);
            this.raiseScoreByPopularityAndHot((SearchHit)m);
            m.getSourceAsMap().put("rankerType", "other");
            m.getSourceAsMap().put("matchType", "other");
        });
        otherMatchHitList.sort(otherComparator);
        if (logger.isDebugEnabled()) {
            ArrayList<SearchHit> debugHits = new ArrayList<SearchHit>();
            debugHits.addAll(sameWordSortedList);
            debugHits.addAll(hasSameWordList);
            debugHits.forEach(hit -> System.out.println("publicationYear=" + hit.getSourceAsMap().get("publicationYear") + ", weight=" + hit.getSourceAsMap().get("weight") + ", popularity=" + hit.getSourceAsMap().get("popularity") + ", newScore=" + hit.getSourceAsMap().get("newScore") + ", hot=" + hit.getSourceAsMap().get("hot")));
        }
        ArrayList<SearchHit> finalHits = new ArrayList<SearchHit>();
        finalHits.addAll(sameWordSortedList);
        finalHits.addAll(hasSameWordList);
        finalHits.addAll(otherMatchHitList);
        if (!this.enableTurningRankerNewSort && topHit != null) {
            finalHits.remove(topHit);
            finalHits.add(0, topHit);
        }
        try {
            SearchUtils.replaceHits(this.context.getResponse().getHits(), finalHits.toArray());
        }
        catch (Exception exception) {
            logger.error("Error while replace hits into response. Exception:", (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    private void raiseScoreByPopularityAndHot(SearchHit hit) {
        for (String matchedQuerie : hit.getMatchedQueries()) {
            if (StringUtils.isEmpty(matchedQuerie) || matchedQuerie.toLowerCase().indexOf("prefix") == -1 && matchedQuerie.toLowerCase().indexOf("check_defaultCompensator".toLowerCase()) == -1) continue;
            float newScore = Float.parseFloat(hit.getSourceAsMap().get("newScore").toString());
            try {
                float popularity = Float.parseFloat(hit.getSourceAsMap().get("popularity").toString());
                if (popularity > 9980000.0f) {
                    hit.getSourceAsMap().put("newScore", Float.valueOf(newScore *= 1.0f + (popularity - 9980000.0f) / 7000.0f));
                    hit.getSourceAsMap().put("reComputeScoreBy", "other");
                }
            }
            catch (Exception popularity) {
                // empty catch block
            }
            try {
                float hot = Float.parseFloat(hit.getSourceAsMap().get("hot").toString());
                if (!(hot > 98000.0f)) continue;
                hit.getSourceAsMap().put("newScore", Float.valueOf(newScore *= 1.0f + (hot - 98000.0f) / 700.0f));
                hit.getSourceAsMap().put("reComputeScoreBy", "other");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private List<SearchHit> filterHitsforSortByWeight(List<SearchHit> sourceList, List<SearchHit> cutoffList) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return sourceList;
        }
        SearchHit topScoreHit = sourceList.get(0);
        ArrayList<SearchHit> weightSortList = new ArrayList<SearchHit>();
        for (SearchHit hit : sourceList) {
            if ((double)hit.getScore() > (double)topScoreHit.getScore() * 0.1) {
                weightSortList.add(hit);
                continue;
            }
            cutoffList.add(hit);
        }
        sourceList.clear();
        sourceList.addAll(weightSortList);
        return sourceList;
    }

    private boolean canApplyThreshold(SearchHit hit) {
        String thresholdType = hit.getSourceAsMap().get(this.thresholdTypeFieldName).toString();
        if (StringUtils.isEmpty(thresholdType) || this.thresholdTypeValueMap.get(thresholdType) == null && this.thresholdTypeValueMap.get(DEFAULT_THRESHOLD_TYPE_NAME) == null || StringUtils.isEmpty(this.thresholdFieldName)) {
            return true;
        }
        float f = Float.parseFloat(hit.getSourceAsMap().get(this.thresholdFieldName).toString());
        return !(this.thresholdTypeValueMap.get(thresholdType) != null && f < this.thresholdTypeValueMap.get(thresholdType).floatValue()) && (this.thresholdTypeValueMap.get(DEFAULT_THRESHOLD_TYPE_NAME) == null || !(f < this.thresholdTypeValueMap.get(DEFAULT_THRESHOLD_TYPE_NAME).floatValue()));
    }

    private SearchHit getTopHitDoc(List<SearchHit> soureHitsList, String qStr, String sourceFieldName) {
        boolean isExtraAllMatch = false;
        float maxScore = -10.0f;
        SearchHit topHit = null;
        block0: for (SearchHit hit : soureHitsList) {
            Object obj = hit.getSourceAsMap().get(sourceFieldName);
            if (obj == null) continue;
            ArrayList<String> titleList = null;
            if (obj instanceof String) {
                titleList = new ArrayList<String>();
                titleList.add(obj.toString());
            } else {
                titleList = (ArrayList<String>)obj;
            }
            for (String s : titleList) {
                if (!(s = s.toLowerCase()).trim().equals(qStr)) continue;
                if (maxScore < hit.getScore()) {
                    topHit = hit;
                    maxScore = hit.getScore();
                }
                if (this.canApplyThreshold(hit)) continue block0;
                topHit = null;
            }
        }
        return topHit;
    }

    @Override
    public List<String> sortFieldNames() {
        return this.sortFieldNames;
    }

    private boolean hasAllMatchQuery(String[] matchQueries) {
        boolean retVal = false;
        for (String str : matchQueries) {
            if (str.indexOf(this.searchName) == -1) continue;
            return true;
        }
        return retVal;
    }

    @Override
    public void prepareByConfig(PostRankerConfig config) {
        this.postRankerConfig = config;
        Map<String, Object> params = config.getParams();
        this.searchName = params.getOrDefault("SearchName", "EntiretyMatcher").toString();
        this.thresholdTypeFieldName = params.getOrDefault("thresholdTypeFieldName", "mark").toString();
        this.thresholdFieldName = params.getOrDefault("thresholdFieldName", "weight").toString();
        this.enableTurningRankerNewSort = Boolean.valueOf(params.getOrDefault("enableTunningRankerNewSort", "true").toString());
        List sortedFieldNameList = (List)params.get("sortFieldNames");
        this.sortFieldNames.clear();
        this.sortFieldNames.addAll(sortedFieldNameList);
        Object objItem = params.get("thresholdTypeValue");
        if (objItem instanceof List) {
            List thresholdTypeValueMapList = (List)objItem;
            this.thresholdTypeValueMap.clear();
            for (Map thresholdTypeValueMap : thresholdTypeValueMapList) {
                String name = thresholdTypeValueMap.get("name").toString();
                float value = Float.parseFloat(thresholdTypeValueMap.get("value").toString());
                this.thresholdTypeValueMap.put(name, Float.valueOf(value));
            }
        }
        for (RankerComparatorConfig rankerComparatorConfig : config.getComparators()) {
            if (StringUtils.isEmpty(rankerComparatorConfig.getFullClassName())) {
                throw new RuntimeException("PostRanker class name must not empty!");
            }
            try {
                Class<?> clz = Class.forName(rankerComparatorConfig.getFullClassName());
                AbstractRankerComparator abstractRankerComparator = (AbstractRankerComparator)clz.newInstance();
                abstractRankerComparator.prepareByConfig(rankerComparatorConfig.getComputeExpress());
                abstractRankerComparator.appendSysParams(Collections.EMPTY_MAP);
                this.comparatorMap.put(rankerComparatorConfig.getIdName(), abstractRankerComparator);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        this.inited = true;
    }

    public static void main(String[] args) {
        JEP jep = new JEP();
        jep.addStandardFunctions();
        jep.addVariable("popularity", 99000.0);
        jep.addVariable("hot", 99990.0);
        jep.parseExpression("if(popularity>9900000,log(popularity)/log(1.5),if(hot>99000,log(hot)/log(1.5),0))");
        System.out.println(jep.getErrorInfo());
        System.out.println(jep.getValue());
    }
}

