/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.ranker.comparator;

import com.valor.common.search.engine.facade.config.ComputeExpressConfig;
import com.valor.common.search.engine.ranker.comparator.AbstractRankerComparator;
import com.valor.common.search.engine.ranker.comparator.BizModelParams;
import com.valor.common.search.engine.util.CollectionUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.SearchHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllInOneComparator
extends AbstractRankerComparator {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private ComputeExpressConfig moviesScoreExpressConfig;
    private ComputeExpressConfig celebsScoreExpressConfig;
    private ComputeExpressConfig otherScoreExpressConfig;
    private Map<String, Number> hotWeightModelBizParams = new HashMap<String, Number>();
    private Map<String, Number> movieSeriesModelBizParams = new HashMap<String, Number>();
    private Map<String, Number> scoreWeightModelBizParams = new HashMap<String, Number>();

    public AllInOneComparator() {
        this.hotWeightModelBizParams.put("modelHotWeight.01.hotRate".replaceFirst("modelHotWeight.01.", ""), Float.valueOf(0.7f));
        this.hotWeightModelBizParams.put("modelHotWeight.01.weightRate".replaceFirst("modelHotWeight.01.", ""), Float.valueOf(0.3f));
        this.hotWeightModelBizParams.put("modelHotWeight.01.hotScale".replaceFirst("modelHotWeight.01.", ""), Float.valueOf(1000.0f));
        this.hotWeightModelBizParams.put("modelHotWeight.01.weightScale".replaceFirst("modelHotWeight.01.", ""), Float.valueOf(3.0f));
        this.movieSeriesModelBizParams.put("movieSeriesModel.01.popularityRate".replaceFirst("movieSeriesModel.01.", ""), Float.valueOf(0.3f));
        this.movieSeriesModelBizParams.put("movieSeriesModel.01.popularityScale".replaceFirst("movieSeriesModel.01.", ""), Float.valueOf(100000.0f));
        this.movieSeriesModelBizParams.put("movieSeriesModel.01.publicationYearRate".replaceFirst("movieSeriesModel.01.", ""), Float.valueOf(0.4f));
        this.movieSeriesModelBizParams.put("movieSeriesModel.01.publicationYearScale".replaceFirst("movieSeriesModel.01", ""), Float.valueOf(10.0f));
        this.movieSeriesModelBizParams.put("movieSeriesModel.01.weightRate".replaceFirst("movieSeriesModel.01.", ""), Float.valueOf(0.3f));
        this.movieSeriesModelBizParams.put("movieSeriesModel.01.weightScale".replaceFirst("movieSeriesModel.01.", ""), Float.valueOf(12.0f));
        this.scoreWeightModelBizParams.put("scoreWeightModel.01.scoreScale".replaceFirst("scoreWeightModel.01.", ""), Float.valueOf(75.0f));
        this.scoreWeightModelBizParams.put("scoreWeightModel.01.weightRate".replaceFirst("scoreWeightModel.01.", ""), Float.valueOf(1.5f));
    }

    @Override
    public void appendSysParams(Map<String, Object> sysParams) {
        if (CollectionUtils.isEmpty(sysParams)) {
            return;
        }
        this.hotWeightModelBizParams.put(BizModelParams.MODEL_HOT_WEIGHT_01.getRealName("modelHotWeight.01.hotRate"), Float.valueOf(Float.parseFloat(sysParams.getOrDefault("modelHotWeight.01.hotRate", Float.valueOf(0.7f)).toString())));
        this.hotWeightModelBizParams.put(BizModelParams.MODEL_HOT_WEIGHT_01.getRealName("modelHotWeight.01.hotScale"), Float.valueOf(Float.parseFloat(sysParams.getOrDefault("modelHotWeight.01.hotScale", Float.valueOf(1000.0f)).toString())));
        this.hotWeightModelBizParams.put(BizModelParams.MODEL_HOT_WEIGHT_01.getRealName("modelHotWeight.01.weightScale"), Float.valueOf(Float.parseFloat(sysParams.getOrDefault("modelHotWeight.01.weightScale", Float.valueOf(3.0f)).toString())));
        this.hotWeightModelBizParams.put(BizModelParams.MODEL_HOT_WEIGHT_01.getRealName("modelHotWeight.01.weightRate"), Float.valueOf(Float.parseFloat(sysParams.getOrDefault("modelHotWeight.01.weightRate", Float.valueOf(0.3f)).toString())));
        this.movieSeriesModelBizParams.put(BizModelParams.MODEL_MOVIE_SERIES_01.getRealName("movieSeriesModel.01.popularityRate"), Float.valueOf(Float.parseFloat(sysParams.getOrDefault("movieSeriesModel.01.popularityRate", Float.valueOf(0.3f)).toString())));
        this.movieSeriesModelBizParams.put(BizModelParams.MODEL_MOVIE_SERIES_01.getRealName("movieSeriesModel.01.popularityScale"), Float.valueOf(Float.parseFloat(sysParams.getOrDefault("movieSeriesModel.01.popularityScale", Float.valueOf(100000.0f)).toString())));
        this.movieSeriesModelBizParams.put(BizModelParams.MODEL_MOVIE_SERIES_01.getRealName("movieSeriesModel.01.weightScale"), Float.valueOf(Float.parseFloat(sysParams.getOrDefault("movieSeriesModel.01.weightScale", Float.valueOf(12.0f)).toString())));
        this.movieSeriesModelBizParams.put(BizModelParams.MODEL_MOVIE_SERIES_01.getRealName("movieSeriesModel.01.weightRate"), Float.valueOf(Float.parseFloat(sysParams.getOrDefault("movieSeriesModel.01.weightRate", Float.valueOf(0.3f)).toString())));
        this.movieSeriesModelBizParams.put(BizModelParams.MODEL_MOVIE_SERIES_01.getRealName("movieSeriesModel.01.publicationYearScale"), Float.valueOf(Float.parseFloat(sysParams.getOrDefault("movieSeriesModel.01.publicationYearScale", Float.valueOf(10.0f)).toString())));
        this.movieSeriesModelBizParams.put(BizModelParams.MODEL_MOVIE_SERIES_01.getRealName("movieSeriesModel.01.publicationYearRate"), Float.valueOf(Float.parseFloat(sysParams.getOrDefault("movieSeriesModel.01.publicationYearRate", Float.valueOf(0.4f)).toString())));
        this.scoreWeightModelBizParams.put(BizModelParams.MODEL_SCORE_WEIGHT_01.getRealName("scoreWeightModel.01.weightRate"), Float.valueOf(Float.parseFloat(sysParams.getOrDefault("scoreWeightModel.01.weightRate", Float.valueOf(1.5f)).toString())));
        this.scoreWeightModelBizParams.put(BizModelParams.MODEL_SCORE_WEIGHT_01.getRealName("scoreWeightModel.01.scoreScale"), Float.valueOf(Float.parseFloat(sysParams.getOrDefault("scoreWeightModel.01.scoreScale", Float.valueOf(75.0f)).toString())));
    }

    @Override
    public void prepareByConfig(List<ComputeExpressConfig> computeExpressMapList) {
        if (!CollectionUtils.isEmpty(computeExpressMapList)) {
            for (ComputeExpressConfig expressConfig : computeExpressMapList) {
                if ("movieSeries".equalsIgnoreCase(expressConfig.getType())) {
                    this.moviesScoreExpressConfig = expressConfig;
                    continue;
                }
                if ("celebs".equalsIgnoreCase(expressConfig.getType())) {
                    this.celebsScoreExpressConfig = expressConfig;
                    continue;
                }
                if (!"others".equalsIgnoreCase(expressConfig.getType())) continue;
                this.otherScoreExpressConfig = expressConfig;
            }
        }
    }

    @Override
    public int compare(SearchHit o1, SearchHit o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        Float o1Score = Float.valueOf(Float.parseFloat(o1.getSourceAsMap().get("newScore").toString()));
        Float o2Score = Float.valueOf(Float.parseFloat(o2.getSourceAsMap().get("newScore").toString()));
        o1Score = Float.valueOf(o1Score.isNaN() ? 0.0f : o1Score.floatValue());
        o2Score = Float.valueOf(o2Score.isNaN() ? 0.0f : o2Score.floatValue());
        o1.getSourceAsMap().put("sortBy", "allInOne");
        o2.getSourceAsMap().put("sortBy", "allInOne");
        if (o1Score.floatValue() == o2Score.floatValue()) {
            return 0;
        }
        if (o1Score.floatValue() > o2Score.floatValue()) {
            return -1;
        }
        return 1;
    }

    @Override
    public float computeScore(SearchHit item) {
        try {
            double score = item.getScore();
            String mark = item.getSourceAsMap().getOrDefault("mark", "").toString();
            if ("movies".equalsIgnoreCase(mark) || "series".equalsIgnoreCase(mark)) {
                HashMap<String, Number> jepParams = new HashMap<String, Number>();
                for (String name : this.moviesScoreExpressConfig.getParamsName()) {
                    String objValue = item.getSourceAsMap().getOrDefault(name, "0");
                    double val = objValue == null ? 0.0 : (double)((float)Math.ceil(Double.parseDouble(objValue.toString()) * 100.0) / 100.0f);
                    val = val < 0.0 ? 0.0 : val;
                    jepParams.put(name, val);
                }
                jepParams.putAll(this.movieSeriesModelBizParams);
                jepParams.put("score", score);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(item.getId()).append(",");
                item.getSourceAsMap().put("computeScoreBy", "allInOne.moviesSeries");
                float newScore = this.getNewScore(jepParams, this.moviesScoreExpressConfig.getScoreExpress());
                item.getSourceAsMap().put("newScore", Float.valueOf(newScore));
                return newScore;
            }
            if ("celebs".equalsIgnoreCase(mark)) {
                HashMap<String, Number> jepParams = new HashMap<String, Number>();
                for (String name : this.celebsScoreExpressConfig.getParamsName()) {
                    String objValue = item.getSourceAsMap().getOrDefault(name, "0");
                    float val = objValue == null ? 0.0f : (float)Math.ceil(Double.parseDouble(objValue.toString()) * 100.0) / 100.0f;
                    val = val < 0.0f ? 0.0f : val;
                    jepParams.put(name, Float.valueOf(val));
                }
                jepParams.putAll(this.hotWeightModelBizParams);
                jepParams.put("score", score);
                item.getSourceAsMap().put("computeScoreBy", "allInOne.celebs");
                float newScore = this.getNewScore(jepParams, this.celebsScoreExpressConfig.getScoreExpress());
                item.getSourceAsMap().put("newScore", Float.valueOf(newScore));
                return newScore;
            }
            HashMap<String, Number> jepParams = new HashMap<String, Number>();
            for (String name : this.otherScoreExpressConfig.getParamsName()) {
                String objValue = item.getSourceAsMap().getOrDefault(name, "0");
                double val = objValue == null ? 0.0 : (double)((float)Math.ceil(Double.parseDouble(objValue.toString()) * 100.0) / 100.0f);
                val = val < 0.0 ? 0.0 : val;
                jepParams.put(name, val);
            }
            jepParams.putAll(this.scoreWeightModelBizParams);
            jepParams.put("score", score);
            item.getSourceAsMap().put("computeScoreBy", "allInOne.others");
            float newScore = this.getNewScore(jepParams, this.otherScoreExpressConfig.getScoreExpress());
            item.getSourceAsMap().put("newScore", Float.valueOf(newScore));
            return newScore;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

