/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.zpredict;

import com.valor.common.search.engine.matcher.Term;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.zpredict.PredictParams;
import com.valor.common.search.engine.zpredict.TermAnalyzerUtil;
import com.valor.common.search.engine.zsymspell.SymSpell;
import java.util.ArrayList;
import java.util.List;

public class PredictionBuilder {
    private static final String PATH = "peliplat_all_terms.csv";
    private static final int MAX_EDIT_DISTANCE_LOOKUP = 2;
    private static final int TOP_K = 5;
    private static final SymSpell.Verbosity VERBOSITY = SymSpell.Verbosity.All;
    private static final TermAnalyzerUtil analyzerUtil = new TermAnalyzerUtil();
    private static volatile SymSpell symSpell = new SymSpell(-1, -1, -1, -1, 18);

    public static void initSymSpell(int prefixLength, int maxDictionaryEditDistance, int initialCapacity) {
        symSpell = new SymSpell(initialCapacity, maxDictionaryEditDistance, prefixLength, -1, 18);
    }

    public static void loadWords(String filepath, int termIndex, int countIndex, String separatorChars) {
        if (symSpell == null) {
            throw new RuntimeException("SymSpell not init yet");
        }
        if (filepath == null || filepath.isEmpty()) {
            filepath = PATH;
        }
        if (!symSpell.loadDictionary(filepath, termIndex, countIndex, separatorChars)) {
            throw new RuntimeException("Read file ERROR: " + filepath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean batchAddSentence(List<String> sentenceList) {
        if (symSpell == null) {
            return false;
        }
        Class<PredictionBuilder> clazz = PredictionBuilder.class;
        synchronized (PredictionBuilder.class) {
            for (String s : sentenceList) {
                if (TermAnalyzerUtil.isContentId(s.trim().toLowerCase())) continue;
                analyzerUtil.getTerms(s).forEach(word -> symSpell.addWord((String)word));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean batchAddWords(List<WordInfo> wordInfoList) {
        if (symSpell == null) {
            return false;
        }
        Class<PredictionBuilder> clazz = PredictionBuilder.class;
        synchronized (PredictionBuilder.class) {
            wordInfoList.forEach(wordInfo -> symSpell.addWord(((WordInfo)wordInfo).word, ((WordInfo)wordInfo).count));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }

    public static List<SymSpell.SuggestItem> getPredictions(List<Term> termList, int termNr, int minWordLength) {
        return PredictionBuilder.getPredictions(termList, termNr, minWordLength, VERBOSITY, 2, 5);
    }

    public static List<SymSpell.SuggestItem> getPredictions(List<Term> termList, PredictParams predictParams) {
        return PredictionBuilder.getPredictions(termList, predictParams.getTermNr(), predictParams.getMinWordLength(), predictParams.getVerbosity(), predictParams.getMaxEditDistance(), predictParams.getTopK());
    }

    public static List<SymSpell.SuggestItem> getPredictions(List<Term> termList, int termNr, int minWordLength, SymSpell.Verbosity verbosity, int maxEditDistance, int topK) {
        if (CollectionUtils.isEmpty(termList) || symSpell == null || symSpell.getWordCount() == 0) {
            return null;
        }
        ArrayList<SymSpell.SuggestItem> predictions = new ArrayList<SymSpell.SuggestItem>();
        for (int i = 0; i < Math.min(termNr, termList.size()); ++i) {
            List<SymSpell.SuggestItem> suggestions;
            String term = termList.get(i).getTermStr().toLowerCase();
            if (term.length() < minWordLength || TermAnalyzerUtil.isContentId(term) || (suggestions = symSpell.lookup(term = analyzerUtil.getTerm(term), verbosity, maxEditDistance, true)) == null || suggestions.isEmpty()) continue;
            predictions.addAll(suggestions.subList(0, Math.min(topK, suggestions.size())));
        }
        return predictions;
    }

    public static String getStatus() {
        if (symSpell == null) {
            return "Not init yet";
        }
        return "wordCount: " + symSpell.getWordCount() + ", entryCount: " + symSpell.getEntryCount() + ", countThreshold: " + symSpell.getCountThreshold() + ", maxWordLength: " + symSpell.getMaxWordLength() + ", maxDictionaryEditDistance: " + symSpell.getMaxDictionaryEditDistance() + ", prefixLength: " + symSpell.getPrefixLength();
    }

    public static class WordInfo {
        private String word;
        private long count;

        public String getWord() {
            return this.word;
        }

        public long getCount() {
            return this.count;
        }

        public void setWord(String word) {
            this.word = word;
        }

        public void setCount(long count) {
            this.count = count;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WordInfo)) {
                return false;
            }
            WordInfo other = (WordInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCount() != other.getCount()) {
                return false;
            }
            String this$word = this.getWord();
            String other$word = other.getWord();
            return !(this$word == null ? other$word != null : !this$word.equals(other$word));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WordInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $count = this.getCount();
            result = result * 59 + (int)($count >>> 32 ^ $count);
            String $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : $word.hashCode());
            return result;
        }

        public String toString() {
            return "PredictionBuilder.WordInfo(word=" + this.getWord() + ", count=" + this.getCount() + ")";
        }

        public WordInfo() {
        }

        public WordInfo(String word, long count) {
            this.word = word;
            this.count = count;
        }
    }
}

