/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.zsymspell.SoftWx.Match;

import com.valor.common.search.engine.zsymspell.SoftWx.Match.Helpers;
import com.valor.common.search.engine.zsymspell.SoftWx.Match.IDistance;

public class DamerauOSA
implements IDistance {
    private int[] baseChar1Costs;
    private int[] basePrevChar1Costs;

    public DamerauOSA() {
        this.baseChar1Costs = new int[0];
        this.basePrevChar1Costs = new int[0];
    }

    public DamerauOSA(int expectedMaxStringLength) {
        this.baseChar1Costs = new int[expectedMaxStringLength];
        this.basePrevChar1Costs = new int[expectedMaxStringLength];
    }

    @Override
    public double distance(String string1, String string2) {
        if (string1 == null) {
            return string2 == null ? 0.0 : (double)string2.length();
        }
        if (string2 == null) {
            return string1.length();
        }
        if (string1.length() > string2.length()) {
            String t = string1;
            string1 = string2;
            string2 = t;
        }
        Helpers.PrepInfo prepInfo = Helpers.prefixSuffixPrep(string1, string2);
        int len1 = prepInfo.len1;
        int len2 = prepInfo.len2;
        int start = prepInfo.start;
        if (len1 == 0) {
            return len2;
        }
        if (len2 > this.baseChar1Costs.length) {
            this.baseChar1Costs = new int[len2];
            this.basePrevChar1Costs = new int[len2];
        }
        return DamerauOSA._distance(string1, string2, len1, len2, start, this.baseChar1Costs, this.basePrevChar1Costs);
    }

    @Override
    public double distance(String string1, String string2, double maxDistance) {
        int iMaxDistance;
        if (string1 == null || string2 == null) {
            return Helpers.NullDistanceResults(string1, string2, maxDistance);
        }
        if (maxDistance <= 0.0) {
            return string1.equals(string2) ? 0.0 : -1.0;
        }
        int n = iMaxDistance = (maxDistance = Math.ceil(maxDistance)) <= 2.147483647E9 ? (int)maxDistance : Integer.MAX_VALUE;
        if (string1.length() > string2.length()) {
            String t = string1;
            string1 = string2;
            string2 = t;
        }
        if (string2.length() - string1.length() > iMaxDistance) {
            return -1.0;
        }
        Helpers.PrepInfo prepInfo = Helpers.prefixSuffixPrep(string1, string2);
        int len1 = prepInfo.len1;
        int len2 = prepInfo.len2;
        int start = prepInfo.start;
        if (len1 == 0) {
            return len2 <= iMaxDistance ? (double)len2 : -1.0;
        }
        if (len2 > this.baseChar1Costs.length) {
            this.baseChar1Costs = new int[len2];
            this.basePrevChar1Costs = new int[len2];
        }
        if (iMaxDistance < len2) {
            return DamerauOSA._distance(string1, string2, len1, len2, start, iMaxDistance, this.baseChar1Costs, this.basePrevChar1Costs);
        }
        return DamerauOSA._distance(string1, string2, len1, len2, start, this.baseChar1Costs, this.basePrevChar1Costs);
    }

    public double similarity(String string1, String string2) {
        if (string1 == null) {
            return string2 == null ? 1.0 : 0.0;
        }
        if (string2 == null) {
            return 0.0;
        }
        if (string1.length() > string2.length()) {
            String t = string1;
            string1 = string2;
            string2 = t;
        }
        Helpers.PrepInfo prepInfo = Helpers.prefixSuffixPrep(string1, string2);
        int len1 = prepInfo.len1;
        int len2 = prepInfo.len2;
        int start = prepInfo.start;
        if (len1 == 0) {
            return 1.0;
        }
        if (len2 > this.baseChar1Costs.length) {
            this.baseChar1Costs = new int[len2];
            this.basePrevChar1Costs = new int[len2];
        }
        int d = DamerauOSA._distance(string1, string2, len1, len2, start, this.baseChar1Costs, this.basePrevChar1Costs);
        return Helpers.toSimilarity(d, string2.length());
    }

    public double similarity(String string1, String string2, double minSimilarity) {
        if (minSimilarity < 0.0 || minSimilarity > 1.0) {
            throw new IllegalArgumentException("minSimilarity must be in range 0 to 1.0");
        }
        if (string1 == null || string2 == null) {
            return Helpers.NullSimilarityResults(string1, string2, minSimilarity);
        }
        if (string1.length() > string2.length()) {
            String t = string1;
            string1 = string2;
            string2 = t;
        }
        int iMaxDistance = Helpers.toDistance(minSimilarity, string2.length());
        if (string2.length() - string1.length() > iMaxDistance) {
            return -1.0;
        }
        if (iMaxDistance <= 0) {
            return string1.equals(string2) ? 1.0 : -1.0;
        }
        Helpers.PrepInfo prepInfo = Helpers.prefixSuffixPrep(string1, string2);
        int len1 = prepInfo.len1;
        int len2 = prepInfo.len2;
        int start = prepInfo.start;
        if (len1 == 0) {
            return 1.0;
        }
        if (len2 > this.baseChar1Costs.length) {
            this.baseChar1Costs = new int[len2];
            this.basePrevChar1Costs = new int[len2];
        }
        if (iMaxDistance < len2) {
            int d = DamerauOSA._distance(string1, string2, len1, len2, start, iMaxDistance, this.baseChar1Costs, this.basePrevChar1Costs);
            return Helpers.toSimilarity(d, string2.length());
        }
        int d = DamerauOSA._distance(string1, string2, len1, len2, start, this.baseChar1Costs, this.basePrevChar1Costs);
        return Helpers.toSimilarity(d, string2.length());
    }

    private static int _distance(String string1, String string2, int len1, int len2, int start, int[] char1Costs, int[] prevChar1Costs) {
        int j = 0;
        while (j < len2) {
            char1Costs[j++] = j;
        }
        int char1 = 32;
        int currentCost = 0;
        for (int i = 0; i < len1; ++i) {
            int aboveCharCost;
            int prevChar1 = char1;
            char1 = string1.charAt(start + i);
            int char2 = 32;
            int leftCharCost = aboveCharCost = i;
            int nextTransCost = 0;
            for (j = 0; j < len2; ++j) {
                int thisTransCost = nextTransCost;
                nextTransCost = prevChar1Costs[j];
                prevChar1Costs[j] = currentCost = leftCharCost;
                leftCharCost = char1Costs[j];
                int prevChar2 = char2;
                char2 = string2.charAt(start + j);
                if (char1 != char2) {
                    if (aboveCharCost < currentCost) {
                        currentCost = aboveCharCost;
                    }
                    if (leftCharCost < currentCost) {
                        currentCost = leftCharCost;
                    }
                    if (i != 0 && j != 0 && char1 == prevChar2 && prevChar1 == char2 && thisTransCost + 1 < ++currentCost) {
                        currentCost = thisTransCost + 1;
                    }
                }
                char1Costs[j] = aboveCharCost = currentCost;
            }
        }
        return currentCost;
    }

    private static int _distance(String string1, String string2, int len1, int len2, int start, int maxDistance, int[] char1Costs, int[] prevChar1Costs) {
        assert (len2 < maxDistance);
        assert (len2 - len1 > maxDistance);
        int j = 0;
        while (j < maxDistance) {
            char1Costs[j++] = j;
        }
        while (j < len2) {
            char1Costs[j++] = maxDistance + 1;
        }
        int lenDiff = len2 - len1;
        int jStartOffset = maxDistance - lenDiff;
        int jStart = 0;
        int jEnd = maxDistance;
        int char1 = 32;
        int currentCost = 0;
        for (int i = 0; i < len1; ++i) {
            int aboveCharCost;
            int prevChar1 = char1;
            char1 = string1.charAt(start + i);
            int char2 = 32;
            int leftCharCost = aboveCharCost = i;
            int nextTransCost = 0;
            jEnd += jEnd < len2 ? 1 : 0;
            for (j = jStart += i > jStartOffset ? 1 : 0; j < jEnd; ++j) {
                int thisTransCost = nextTransCost;
                nextTransCost = prevChar1Costs[j];
                prevChar1Costs[j] = currentCost = leftCharCost;
                leftCharCost = char1Costs[j];
                int prevChar2 = char2;
                char2 = string2.charAt(start + j);
                if (char1 != char2) {
                    if (aboveCharCost < currentCost) {
                        currentCost = aboveCharCost;
                    }
                    if (leftCharCost < currentCost) {
                        currentCost = leftCharCost;
                    }
                    if (i != 0 && j != 0 && char1 == prevChar2 && prevChar1 == char2 && thisTransCost + 1 < ++currentCost) {
                        currentCost = thisTransCost + 1;
                    }
                }
                char1Costs[j] = aboveCharCost = currentCost;
            }
            if (char1Costs[i + lenDiff] <= maxDistance) continue;
            return -1;
        }
        return currentCost <= maxDistance ? currentCost : -1;
    }
}

