/*
 * Decompiled with CFR 0.152.
 */
package dumonts.hunspell;

import com.sun.jna.Memory;
import com.sun.jna.ptr.PointerByReference;
import dumonts.hunspell.bindings.HunspellLibrary;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class Hunspell
implements Closeable {
    private final PointerByReference handle;
    private final String encoding;
    private final Charset charset;

    public Hunspell(Path dictionary, Path affix) {
        this.handle = HunspellLibrary.Hunspell_create(affix.toString(), dictionary.toString());
        if (this.handle == null) {
            throw new RuntimeException("Unable to create Hunspell instance");
        }
        this.encoding = HunspellLibrary.Hunspell_get_dic_encoding(this.handle).getString(0L);
        this.charset = Charset.forName(this.encoding);
    }

    public static Hunspell forDictionaryInResources(String language, String resourcePath) {
        try {
            ClassLoader loader = Hunspell.class.getClassLoader();
            InputStream dictionaryStream = loader.getResourceAsStream(resourcePath + language + ".dic");
            InputStream affixStream = loader.getResourceAsStream(resourcePath + language + ".aff");
            if (dictionaryStream == null || affixStream == null) {
                throw new RuntimeException("Could not find dictionary for language \"" + language + "\" in classpath");
            }
            Path dictionary = Files.createTempFile(language, ".dic", new FileAttribute[0]);
            Path affix = Files.createTempFile(language, ".aff", new FileAttribute[0]);
            Files.copy(dictionaryStream, dictionary, StandardCopyOption.REPLACE_EXISTING);
            Files.copy(affixStream, affix, StandardCopyOption.REPLACE_EXISTING);
            return new Hunspell(dictionary, affix);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create temporary dictionaries for language \"" + language + "\"", e);
        }
    }

    public static Hunspell forDictionaryInResources(String language) {
        return Hunspell.forDictionaryInResources(language, "");
    }

    public boolean spell(String word) {
        if (this.handle == null) {
            throw new RuntimeException("Attempt to use hunspell instance after closing");
        }
        byte[] bytes = word.getBytes(this.charset);
        try (Memory m = new Memory(bytes.length + 1);){
            m.write(0L, bytes, 0, bytes.length);
            m.setByte(bytes.length, (byte)0);
            int result = HunspellLibrary.Hunspell_spell(this.handle, m);
            boolean bl = result != 0;
            return bl;
        }
    }

    public void add(String word) {
        if (this.handle == null) {
            throw new RuntimeException("Attempt to use hunspell instance after closing");
        }
        byte[] bytes = word.getBytes(this.charset);
        try (Memory m = new Memory(bytes.length + 1);){
            m.write(0L, bytes, 0, bytes.length);
            m.setByte(bytes.length, (byte)0);
            HunspellLibrary.Hunspell_add(this.handle, m);
        }
    }

    public String[] suggest(String word) {
        String[] result;
        PointerByReference ptr = new PointerByReference();
        byte[] bytes = word.getBytes(this.charset);
        try (Memory m = new Memory(bytes.length + 1);){
            m.write(0L, bytes, 0, bytes.length);
            m.setByte(bytes.length, (byte)0);
            int suggestionCount = HunspellLibrary.Hunspell_suggest(this.handle, ptr, m);
            if (suggestionCount > 0) {
                result = ptr.getValue().getStringArray(0L, suggestionCount, this.encoding);
                HunspellLibrary.Hunspell_free_list(this.handle, ptr, suggestionCount);
            } else {
                result = new String[]{};
            }
        }
        return result;
    }

    @Override
    public void close() {
        if (this.handle != null) {
            HunspellLibrary.Hunspell_destroy(this.handle);
        }
    }
}

