/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.aggs.Aggregation;
import com.valor.common.search.engine.compensator.AbstractCompensator;
import com.valor.common.search.engine.filter.Filter;
import com.valor.common.search.engine.filter.InlineFilter;
import com.valor.common.search.engine.filter.PostFilter;
import com.valor.common.search.engine.handler.GeneralHandler;
import com.valor.common.search.engine.matcher.Matcher;
import com.valor.common.search.engine.ranker.AbstractInlineScoreRanker;
import com.valor.common.search.engine.ranker.AbstractPostScoreRanker;
import com.valor.common.search.engine.ranker.ScoreRanker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchResponse;

public abstract class AbstractSearcher {
    protected List<Matcher> matcherList = new ArrayList<Matcher>();
    protected List<AbstractCompensator> compensatorList = new ArrayList<AbstractCompensator>();
    protected List<InlineFilter> inLineFilterList = new ArrayList<InlineFilter>();
    protected List<AbstractInlineScoreRanker> inLineRankList = new ArrayList<AbstractInlineScoreRanker>();
    protected List<PostFilter> postFilterList = new ArrayList<PostFilter>();
    protected List<AbstractPostScoreRanker> postRankerList = new ArrayList<AbstractPostScoreRanker>();
    protected List<String> includeSourceFieldList = new ArrayList<String>();
    protected List<String> excludeSourceFieldList = new ArrayList<String>();
    protected boolean autoScanSourceField = false;

    public AbstractSearcher matcher(Matcher matcher) {
        this.matcherList.add(matcher);
        return this;
    }

    public AbstractSearcher compensator(AbstractCompensator compensator) {
        this.compensatorList.add(compensator);
        return this;
    }

    public AbstractSearcher filter(Filter filter) {
        if (filter instanceof InlineFilter) {
            this.inLineFilterList.add((InlineFilter)filter);
        } else if (filter instanceof PostFilter) {
            this.postFilterList.add((PostFilter)filter);
        }
        return this;
    }

    public AbstractSearcher ranker(ScoreRanker ranker) {
        if (ranker instanceof AbstractInlineScoreRanker) {
            this.inLineRankList.add((AbstractInlineScoreRanker)ranker);
        } else if (ranker instanceof AbstractPostScoreRanker) {
            this.postRankerList.add((AbstractPostScoreRanker)ranker);
        }
        return this;
    }

    public void cleanPostRanker() {
        this.postRankerList = new ArrayList<AbstractPostScoreRanker>();
    }

    public AbstractSearcher includeSourceField(String ... sourceFieldName) {
        this.includeSourceFieldList.addAll(Arrays.asList(sourceFieldName));
        return this;
    }

    public AbstractSearcher autoScanSourceFieldName(boolean auto) {
        this.autoScanSourceField = auto;
        return this;
    }

    public AbstractSearcher excludeSourceField(String ... sourceFieldName) {
        this.excludeSourceFieldList.addAll(Arrays.asList(sourceFieldName));
        return this;
    }

    public abstract void enableHighlight();

    public abstract void disableHighlight();

    protected void scanMustIncludeSourceFieldName() {
        if (this.autoScanSourceField) {
            for (PostFilter postFilter : this.postFilterList) {
                this.includeSourceFieldList.add(postFilter.getFilterFieldName());
            }
            for (AbstractPostScoreRanker ranker : this.postRankerList) {
                this.includeSourceFieldList.addAll(ranker.sortFieldNames());
            }
        }
    }

    protected abstract RequestContext prepareRequestContext(String var1, String var2, int var3, int var4);

    protected abstract void assembly();

    protected abstract void build();

    protected abstract void addHandler(GeneralHandler var1);

    protected abstract void doExecuteQuery() throws IOException;

    protected abstract void doPostProcess();

    protected abstract SearchResponse takeResult();

    public SearchResponse execute() throws IOException {
        this.assembly();
        this.build();
        this.scanMustIncludeSourceFieldName();
        this.doExecuteQuery();
        this.doPostProcess();
        return this.takeResult();
    }

    protected abstract Map<String, Number> doAggregation(Aggregation var1);

    public Map<String, Number> executeAggs(Aggregation aggs) throws Exception {
        return this.doAggregation(aggs);
    }

    public Map<String, Long> executeCountAggs(Aggregation aggs) throws Exception {
        Map<String, Number> countMap = this.doAggregation(aggs);
        HashMap<String, Long> rMap = new HashMap<String, Long>();
        for (Map.Entry<String, Number> enrty : countMap.entrySet()) {
            rMap.put(enrty.getKey(), enrty.getValue().longValue());
        }
        return rMap;
    }
}

