/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine;

import com.valor.common.search.engine.AbstractSearcher;
import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.aggs.Aggregation;
import com.valor.common.search.engine.compensator.AbstractCompensator;
import com.valor.common.search.engine.facade.config.HighlightConfig;
import com.valor.common.search.engine.filter.Filter;
import com.valor.common.search.engine.filter.InlineFilter;
import com.valor.common.search.engine.filter.PostFilter;
import com.valor.common.search.engine.handler.GeneralHandler;
import com.valor.common.search.engine.handler.TakeResultHandler;
import com.valor.common.search.engine.matcher.Matcher;
import com.valor.common.search.engine.ranker.AbstractInlineScoreRanker;
import com.valor.common.search.engine.ranker.AbstractPostScoreRanker;
import com.valor.common.search.engine.ranker.ScoreRanker;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.SearchUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSearcher
extends AbstractSearcher {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    Logger searcherLogger = LoggerFactory.getLogger((String)"Searcher");
    private final RestHighLevelClient restHighLevelClient;
    private final String indexName;
    private float tryToPageSizeScaleRate = 1.0f;
    private QueryBuilder allInlineQuery = null;
    private GeneralHandler takeResultHandler;
    private SearchResponse result = null;
    private RequestContext context;
    private boolean openHighlight = false;
    private List<RequestContext> subContextList = new ArrayList<RequestContext>();
    private long startQueryTime;
    private long endQueryTime;

    public long getStartQueryTime() {
        return this.startQueryTime;
    }

    public long getEndQueryTime() {
        return this.endQueryTime;
    }

    public DefaultSearcher(RestHighLevelClient restHighLevelClient, String indexName) {
        this.restHighLevelClient = restHighLevelClient;
        this.indexName = indexName;
    }

    @Override
    public RequestContext prepareRequestContext(String q, String mainIndexFieldName, int from, int size) {
        this.context = new RequestContext(q, this.indexName, mainIndexFieldName, this.restHighLevelClient, from, size);
        return this.context;
    }

    @Override
    public void enableHighlight() {
        this.openHighlight = true;
    }

    @Override
    public void disableHighlight() {
        this.openHighlight = false;
    }

    public RequestContext getRequestContext() {
        return this.context;
    }

    @Override
    public void addHandler(GeneralHandler handler) {
        if (handler instanceof TakeResultHandler) {
            this.takeResultHandler = handler;
        }
    }

    @Override
    protected void assembly() {
        for (Matcher matcher : this.matcherList) {
            try {
                matcher.assembly();
            }
            catch (Exception e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("assembly matcher error: ", (Throwable)e);
                }
                throw e;
            }
        }
    }

    @Override
    protected void build() {
        BoolQueryBuilder matcherQuery = QueryBuilders.boolQuery();
        BoolQueryBuilder mainQuery = null;
        QueryBuilder tempQuery = null;
        for (Object matcher : this.matcherList) {
            tempQuery = matcher.buildAll();
            if (tempQuery == null) continue;
            matcherQuery.should(tempQuery);
            mainQuery = matcherQuery;
        }
        if (!CollectionUtils.isEmpty(this.inLineFilterList)) {
            BoolQueryBuilder filterQuery = QueryBuilders.boolQuery();
            for (InlineFilter filter : this.inLineFilterList) {
                QueryBuilder query = filter.build();
                if (query == null) continue;
                filterQuery = filterQuery.filter(query);
            }
            if (filterQuery.filter().size() > 0) {
                mainQuery = filterQuery.must((QueryBuilder)matcherQuery).minimumShouldMatch(0);
            }
        }
        if (!CollectionUtils.isEmpty(this.inLineRankList)) {
            for (AbstractInlineScoreRanker ranker : this.inLineRankList) {
                if (mainQuery == null) continue;
                mainQuery = ranker.build((QueryBuilder)mainQuery);
            }
        }
        this.allInlineQuery = mainQuery;
    }

    @Override
    protected void doExecuteQuery() throws IOException {
        SearchRequest request = new SearchRequest(new String[]{this.indexName});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query(this.allInlineQuery).size((int)((float)this.context.size() * this.tryToPageSizeScaleRate)).from(this.context.fromIndex());
        if (this.openHighlight) {
            HighlightBuilder allHighLightBuilder = new HighlightBuilder();
            ArrayList<String> fieldList = new ArrayList<String>();
            List<HighlightConfig.HighlightItemConfig> highLightItemConfigList = this.getRequestContext().getHighlightItemConfigList();
            for (HighlightConfig.HighlightItemConfig highLightItemConfig : highLightItemConfigList) {
                if (fieldList.contains(highLightItemConfig.getField())) continue;
                fieldList.add(highLightItemConfig.getField());
                this.buildHighLightField(allHighLightBuilder, highLightItemConfig, true);
            }
            ArrayList<String> fieldsFromQuery = new ArrayList<String>();
            fieldsFromQuery.add(this.getRequestContext().KEY_MAIN_INDEX_FIELD);
            fieldsFromQuery.add(this.getRequestContext().KEY_MAIN_INDEX_FIELD + ".raw");
            fieldsFromQuery.add(this.getRequestContext().fuzzySubIndexFieldName);
            fieldsFromQuery.add(this.getRequestContext().minimumSubIndexFieldName);
            fieldsFromQuery.add(this.getRequestContext().wordSubIndexFieldName);
            for (String fieldName : fieldsFromQuery) {
                if (fieldList.contains(fieldName)) continue;
                fieldList.add(fieldName);
                this.buildHighLightField(allHighLightBuilder, new HighlightConfig.HighlightItemConfig(fieldName, this.context.getDefaultHighlightType()), true);
            }
            sourceBuilder.highlighter(allHighLightBuilder).collapse();
        }
        String[] includeFieldName = new String[this.includeSourceFieldList.size()];
        sourceBuilder.fetchSource(this.toStringArray(this.includeSourceFieldList), this.toStringArray(this.excludeSourceFieldList));
        if (this.searcherLogger.isDebugEnabled()) {
            this.searcherLogger.debug(sourceBuilder.toString());
        }
        request.source(sourceBuilder);
        try {
            this.startQueryTime = System.currentTimeMillis();
            this.result = SearchUtils.search(this.restHighLevelClient, request);
            this.endQueryTime = System.currentTimeMillis();
            if (this.endQueryTime - this.startQueryTime >= 200L && this.logger.isDebugEnabled()) {
                this.logger.debug("spend time is {}  query {}", (Object)(this.endQueryTime - this.startQueryTime), (Object)sourceBuilder.toString());
            }
            this.context.saveResponse(this.result);
            for (RequestContext subContext : this.subContextList) {
                subContext.saveResponse(this.result);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void buildHighLightField(HighlightBuilder allHighLightBuilder, HighlightConfig.HighlightItemConfig highLightItemConfig, boolean requireFieldMatch) {
        allHighLightBuilder.field((HighlightBuilder.Field)((HighlightBuilder.Field)((HighlightBuilder.Field)((HighlightBuilder.Field)((HighlightBuilder.Field)new HighlightBuilder.Field(highLightItemConfig.getField().trim()).postTags(new String[]{this.context.getHighlightPostTag()})).preTags(new String[]{this.context.getHighlightPreTag()})).order(HighlightBuilder.Order.SCORE)).highlighterType(highLightItemConfig.getType().trim().toLowerCase())).requireFieldMatch(Boolean.valueOf(requireFieldMatch)));
    }

    @Override
    protected void doPostProcess() {
        for (Filter filter : this.postFilterList) {
            if (filter.getFilterType() != 2 || !(filter instanceof PostFilter)) continue;
            ((PostFilter)filter).doFilter();
        }
        for (ScoreRanker ranker : this.postRankerList) {
            if (ranker.getType() != ScoreRanker.RANKER_TYPE.POST_SCORERANKER.ordinal() || !(ranker instanceof AbstractPostScoreRanker)) continue;
            ((AbstractPostScoreRanker)ranker).execute();
        }
        if (!CollectionUtils.isEmpty(this.compensatorList)) {
            AbstractCompensator compensater = (AbstractCompensator)this.compensatorList.get(0);
            for (InlineFilter filter : this.inLineFilterList) {
                compensater.filter(filter);
            }
            for (AbstractInlineScoreRanker ranker : this.inLineRankList) {
                compensater.ranker(ranker);
            }
            for (AbstractPostScoreRanker abstractPostScoreRanker : this.postRankerList) {
                compensater.ranker(abstractPostScoreRanker);
            }
            compensater.execute();
        }
    }

    @Override
    protected SearchResponse takeResult() {
        if (this.takeResultHandler != null) {
            this.takeResultHandler.doExcute(this.context);
        }
        this.result = this.context.getResponse();
        return this.result;
    }

    @Override
    protected Map<String, Number> doAggregation(Aggregation aggs) {
        if (aggs == null) {
            throw new RuntimeException("Aggregation must not null");
        }
        this.assembly();
        this.build();
        this.scanMustIncludeSourceFieldName();
        if (this.allInlineQuery == null) {
            throw new RuntimeException("Must call  method 'execute()' first.");
        }
        SearchRequest request = new SearchRequest(new String[]{this.indexName});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query(this.allInlineQuery).size(0).aggregation(aggs.build());
        request.source(sourceBuilder);
        if (this.searcherLogger.isDebugEnabled()) {
            this.searcherLogger.debug(sourceBuilder.toString());
        }
        try {
            SearchResponse response = this.restHighLevelClient.search(request, new Header[0]);
            HashMap<String, Number> result = new HashMap<String, Number>();
            ParsedStringTerms aggResult = (ParsedStringTerms)response.getAggregations().getAsMap().get(aggs.getAggName());
            for (Terms.Bucket bucket : aggResult.getBuckets()) {
                result.put(bucket.getKeyAsString(), bucket.getDocCount());
            }
            if (this.searcherLogger.isDebugEnabled()) {
                this.searcherLogger.debug("matchCount speed time:{}", (Object)response.getTook().getMillis());
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String[] toStringArray(List<String> m) {
        String[] newArrays = new String[m.size()];
        for (int index = 0; index < newArrays.length; ++index) {
            newArrays[index] = m.get(index);
        }
        return newArrays;
    }
}

