/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine;

import com.valor.common.search.engine.MatchingTitle;
import com.valor.common.search.engine.facade.FuzzinessQueryMode;
import com.valor.common.search.engine.zpredict.PredictParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchEngineConfig {
    public static final String DEFAULT_INDEX_NAME = "search_engine_index";
    private String indexName = "search_engine_index";
    private String matchMainIndexFieldName = "mainTitle";
    private String instantMainIndexFieldName;
    private String documentIdentifyFieldName;
    private String weightFieldName = "weight";
    private String classifyFieldName = "mark";
    private String scoreExpress = "_score*doc['weight'].value";
    private String timeFilterFieldName;
    private float weightThreshold = 4.0f;
    private float celebsWeightThreshold = 8.0f;
    private float videoWeightThreshold = 18.0f;
    private boolean enableTimeFilter = false;
    private boolean enableTurningRankerNewSort = true;
    private boolean openHighlight = true;
    private List<String> highlightFieldsName = new ArrayList<String>();
    private String highlightPreTag = "<em>";
    private String highlightPostTag = "</em>";
    private Map<String, Number> bizParams;
    private boolean openHiddenContent = true;
    private int matcherFuzzyTermLetterLimit = 20;
    private int matcherSentenceLetterLimit = 512;
    private int fixPageSize = 100;
    private FuzzinessQueryMode fuzzinessQueryMode = FuzzinessQueryMode.YES;
    private PredictParams predictParams = new PredictParams();
    private MatchingTitle.Verbosity matchingTitleVerbosity = MatchingTitle.Verbosity.Top;
    private List<String> matchingTitleExpectExts;
    private Map<String, Object> bizSysConfig = new HashMap<String, Object>();

    public SearchEngineConfig() {
    }

    public SearchEngineConfig(SearchEngineConfig defaultConfig) {
        this.indexName = defaultConfig.indexName;
        this.matchMainIndexFieldName = defaultConfig.matchMainIndexFieldName;
        this.instantMainIndexFieldName = defaultConfig.instantMainIndexFieldName;
        this.documentIdentifyFieldName = defaultConfig.documentIdentifyFieldName;
        this.weightFieldName = defaultConfig.weightFieldName;
        this.classifyFieldName = defaultConfig.classifyFieldName;
        this.scoreExpress = defaultConfig.scoreExpress;
        this.timeFilterFieldName = defaultConfig.timeFilterFieldName;
        this.weightThreshold = defaultConfig.weightThreshold;
        this.celebsWeightThreshold = defaultConfig.celebsWeightThreshold;
        this.videoWeightThreshold = defaultConfig.videoWeightThreshold;
        this.enableTimeFilter = defaultConfig.enableTimeFilter;
        this.enableTurningRankerNewSort = defaultConfig.enableTurningRankerNewSort;
        this.openHighlight = defaultConfig.openHighlight;
        this.highlightPreTag = defaultConfig.highlightPreTag;
        this.highlightPostTag = defaultConfig.highlightPostTag;
        this.openHiddenContent = defaultConfig.openHiddenContent;
        this.matcherFuzzyTermLetterLimit = defaultConfig.matcherFuzzyTermLetterLimit;
        this.matcherSentenceLetterLimit = defaultConfig.matcherSentenceLetterLimit;
        this.fixPageSize = defaultConfig.fixPageSize;
        this.fuzzinessQueryMode = defaultConfig.fuzzinessQueryMode;
        this.matchingTitleVerbosity = defaultConfig.matchingTitleVerbosity;
        this.predictParams = defaultConfig.predictParams;
        this.highlightFieldsName = defaultConfig.getHighlightFieldsName() == null ? new ArrayList<String>() : new ArrayList<String>(defaultConfig.getHighlightFieldsName());
        this.bizParams = defaultConfig.getBizParams() == null ? new HashMap<String, Number>() : new HashMap<String, Number>(defaultConfig.getBizParams());
        this.bizSysConfig = new HashMap<String, Object>();
        this.matchingTitleExpectExts = new ArrayList<String>();
    }

    public void setOpenHiddenContent(boolean openHiddenContent) {
        this.openHiddenContent = openHiddenContent;
        this.bizSysConfig.put("openHiddenContent", openHiddenContent);
    }

    public Object getOrDefault(String key, Object defVal) {
        return this.bizSysConfig.getOrDefault(key, defVal);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getMatchMainIndexFieldName() {
        return this.matchMainIndexFieldName;
    }

    public String getInstantMainIndexFieldName() {
        return this.instantMainIndexFieldName;
    }

    public String getDocumentIdentifyFieldName() {
        return this.documentIdentifyFieldName;
    }

    public String getWeightFieldName() {
        return this.weightFieldName;
    }

    public String getClassifyFieldName() {
        return this.classifyFieldName;
    }

    public String getScoreExpress() {
        return this.scoreExpress;
    }

    public String getTimeFilterFieldName() {
        return this.timeFilterFieldName;
    }

    public float getWeightThreshold() {
        return this.weightThreshold;
    }

    public float getCelebsWeightThreshold() {
        return this.celebsWeightThreshold;
    }

    public float getVideoWeightThreshold() {
        return this.videoWeightThreshold;
    }

    public boolean isEnableTimeFilter() {
        return this.enableTimeFilter;
    }

    public boolean isEnableTurningRankerNewSort() {
        return this.enableTurningRankerNewSort;
    }

    public boolean isOpenHighlight() {
        return this.openHighlight;
    }

    public List<String> getHighlightFieldsName() {
        return this.highlightFieldsName;
    }

    public String getHighlightPreTag() {
        return this.highlightPreTag;
    }

    public String getHighlightPostTag() {
        return this.highlightPostTag;
    }

    public Map<String, Number> getBizParams() {
        return this.bizParams;
    }

    public boolean isOpenHiddenContent() {
        return this.openHiddenContent;
    }

    public int getMatcherFuzzyTermLetterLimit() {
        return this.matcherFuzzyTermLetterLimit;
    }

    public int getMatcherSentenceLetterLimit() {
        return this.matcherSentenceLetterLimit;
    }

    public int getFixPageSize() {
        return this.fixPageSize;
    }

    public FuzzinessQueryMode getFuzzinessQueryMode() {
        return this.fuzzinessQueryMode;
    }

    public PredictParams getPredictParams() {
        return this.predictParams;
    }

    public MatchingTitle.Verbosity getMatchingTitleVerbosity() {
        return this.matchingTitleVerbosity;
    }

    public List<String> getMatchingTitleExpectExts() {
        return this.matchingTitleExpectExts;
    }

    public Map<String, Object> getBizSysConfig() {
        return this.bizSysConfig;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setMatchMainIndexFieldName(String matchMainIndexFieldName) {
        this.matchMainIndexFieldName = matchMainIndexFieldName;
    }

    public void setInstantMainIndexFieldName(String instantMainIndexFieldName) {
        this.instantMainIndexFieldName = instantMainIndexFieldName;
    }

    public void setDocumentIdentifyFieldName(String documentIdentifyFieldName) {
        this.documentIdentifyFieldName = documentIdentifyFieldName;
    }

    public void setWeightFieldName(String weightFieldName) {
        this.weightFieldName = weightFieldName;
    }

    public void setClassifyFieldName(String classifyFieldName) {
        this.classifyFieldName = classifyFieldName;
    }

    public void setScoreExpress(String scoreExpress) {
        this.scoreExpress = scoreExpress;
    }

    public void setTimeFilterFieldName(String timeFilterFieldName) {
        this.timeFilterFieldName = timeFilterFieldName;
    }

    public void setWeightThreshold(float weightThreshold) {
        this.weightThreshold = weightThreshold;
    }

    public void setCelebsWeightThreshold(float celebsWeightThreshold) {
        this.celebsWeightThreshold = celebsWeightThreshold;
    }

    public void setVideoWeightThreshold(float videoWeightThreshold) {
        this.videoWeightThreshold = videoWeightThreshold;
    }

    public void setEnableTimeFilter(boolean enableTimeFilter) {
        this.enableTimeFilter = enableTimeFilter;
    }

    public void setEnableTurningRankerNewSort(boolean enableTurningRankerNewSort) {
        this.enableTurningRankerNewSort = enableTurningRankerNewSort;
    }

    public void setOpenHighlight(boolean openHighlight) {
        this.openHighlight = openHighlight;
    }

    public void setHighlightFieldsName(List<String> highlightFieldsName) {
        this.highlightFieldsName = highlightFieldsName;
    }

    public void setHighlightPreTag(String highlightPreTag) {
        this.highlightPreTag = highlightPreTag;
    }

    public void setHighlightPostTag(String highlightPostTag) {
        this.highlightPostTag = highlightPostTag;
    }

    public void setBizParams(Map<String, Number> bizParams) {
        this.bizParams = bizParams;
    }

    public void setMatcherFuzzyTermLetterLimit(int matcherFuzzyTermLetterLimit) {
        this.matcherFuzzyTermLetterLimit = matcherFuzzyTermLetterLimit;
    }

    public void setMatcherSentenceLetterLimit(int matcherSentenceLetterLimit) {
        this.matcherSentenceLetterLimit = matcherSentenceLetterLimit;
    }

    public void setFixPageSize(int fixPageSize) {
        this.fixPageSize = fixPageSize;
    }

    public void setFuzzinessQueryMode(FuzzinessQueryMode fuzzinessQueryMode) {
        this.fuzzinessQueryMode = fuzzinessQueryMode;
    }

    public void setPredictParams(PredictParams predictParams) {
        this.predictParams = predictParams;
    }

    public void setMatchingTitleVerbosity(MatchingTitle.Verbosity matchingTitleVerbosity) {
        this.matchingTitleVerbosity = matchingTitleVerbosity;
    }

    public void setMatchingTitleExpectExts(List<String> matchingTitleExpectExts) {
        this.matchingTitleExpectExts = matchingTitleExpectExts;
    }

    public void setBizSysConfig(Map<String, Object> bizSysConfig) {
        this.bizSysConfig = bizSysConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchEngineConfig)) {
            return false;
        }
        SearchEngineConfig other = (SearchEngineConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getWeightThreshold(), other.getWeightThreshold()) != 0) {
            return false;
        }
        if (Float.compare(this.getCelebsWeightThreshold(), other.getCelebsWeightThreshold()) != 0) {
            return false;
        }
        if (Float.compare(this.getVideoWeightThreshold(), other.getVideoWeightThreshold()) != 0) {
            return false;
        }
        if (this.isEnableTimeFilter() != other.isEnableTimeFilter()) {
            return false;
        }
        if (this.isEnableTurningRankerNewSort() != other.isEnableTurningRankerNewSort()) {
            return false;
        }
        if (this.isOpenHighlight() != other.isOpenHighlight()) {
            return false;
        }
        if (this.isOpenHiddenContent() != other.isOpenHiddenContent()) {
            return false;
        }
        if (this.getMatcherFuzzyTermLetterLimit() != other.getMatcherFuzzyTermLetterLimit()) {
            return false;
        }
        if (this.getMatcherSentenceLetterLimit() != other.getMatcherSentenceLetterLimit()) {
            return false;
        }
        if (this.getFixPageSize() != other.getFixPageSize()) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
            return false;
        }
        String this$matchMainIndexFieldName = this.getMatchMainIndexFieldName();
        String other$matchMainIndexFieldName = other.getMatchMainIndexFieldName();
        if (this$matchMainIndexFieldName == null ? other$matchMainIndexFieldName != null : !this$matchMainIndexFieldName.equals(other$matchMainIndexFieldName)) {
            return false;
        }
        String this$instantMainIndexFieldName = this.getInstantMainIndexFieldName();
        String other$instantMainIndexFieldName = other.getInstantMainIndexFieldName();
        if (this$instantMainIndexFieldName == null ? other$instantMainIndexFieldName != null : !this$instantMainIndexFieldName.equals(other$instantMainIndexFieldName)) {
            return false;
        }
        String this$documentIdentifyFieldName = this.getDocumentIdentifyFieldName();
        String other$documentIdentifyFieldName = other.getDocumentIdentifyFieldName();
        if (this$documentIdentifyFieldName == null ? other$documentIdentifyFieldName != null : !this$documentIdentifyFieldName.equals(other$documentIdentifyFieldName)) {
            return false;
        }
        String this$weightFieldName = this.getWeightFieldName();
        String other$weightFieldName = other.getWeightFieldName();
        if (this$weightFieldName == null ? other$weightFieldName != null : !this$weightFieldName.equals(other$weightFieldName)) {
            return false;
        }
        String this$classifyFieldName = this.getClassifyFieldName();
        String other$classifyFieldName = other.getClassifyFieldName();
        if (this$classifyFieldName == null ? other$classifyFieldName != null : !this$classifyFieldName.equals(other$classifyFieldName)) {
            return false;
        }
        String this$scoreExpress = this.getScoreExpress();
        String other$scoreExpress = other.getScoreExpress();
        if (this$scoreExpress == null ? other$scoreExpress != null : !this$scoreExpress.equals(other$scoreExpress)) {
            return false;
        }
        String this$timeFilterFieldName = this.getTimeFilterFieldName();
        String other$timeFilterFieldName = other.getTimeFilterFieldName();
        if (this$timeFilterFieldName == null ? other$timeFilterFieldName != null : !this$timeFilterFieldName.equals(other$timeFilterFieldName)) {
            return false;
        }
        List<String> this$highlightFieldsName = this.getHighlightFieldsName();
        List<String> other$highlightFieldsName = other.getHighlightFieldsName();
        if (this$highlightFieldsName == null ? other$highlightFieldsName != null : !((Object)this$highlightFieldsName).equals(other$highlightFieldsName)) {
            return false;
        }
        String this$highlightPreTag = this.getHighlightPreTag();
        String other$highlightPreTag = other.getHighlightPreTag();
        if (this$highlightPreTag == null ? other$highlightPreTag != null : !this$highlightPreTag.equals(other$highlightPreTag)) {
            return false;
        }
        String this$highlightPostTag = this.getHighlightPostTag();
        String other$highlightPostTag = other.getHighlightPostTag();
        if (this$highlightPostTag == null ? other$highlightPostTag != null : !this$highlightPostTag.equals(other$highlightPostTag)) {
            return false;
        }
        Map<String, Number> this$bizParams = this.getBizParams();
        Map<String, Number> other$bizParams = other.getBizParams();
        if (this$bizParams == null ? other$bizParams != null : !((Object)this$bizParams).equals(other$bizParams)) {
            return false;
        }
        FuzzinessQueryMode this$fuzzinessQueryMode = this.getFuzzinessQueryMode();
        FuzzinessQueryMode other$fuzzinessQueryMode = other.getFuzzinessQueryMode();
        if (this$fuzzinessQueryMode == null ? other$fuzzinessQueryMode != null : !((Object)((Object)this$fuzzinessQueryMode)).equals((Object)other$fuzzinessQueryMode)) {
            return false;
        }
        PredictParams this$predictParams = this.getPredictParams();
        PredictParams other$predictParams = other.getPredictParams();
        if (this$predictParams == null ? other$predictParams != null : !((Object)this$predictParams).equals(other$predictParams)) {
            return false;
        }
        MatchingTitle.Verbosity this$matchingTitleVerbosity = this.getMatchingTitleVerbosity();
        MatchingTitle.Verbosity other$matchingTitleVerbosity = other.getMatchingTitleVerbosity();
        if (this$matchingTitleVerbosity == null ? other$matchingTitleVerbosity != null : !((Object)((Object)this$matchingTitleVerbosity)).equals((Object)other$matchingTitleVerbosity)) {
            return false;
        }
        List<String> this$matchingTitleExpectExts = this.getMatchingTitleExpectExts();
        List<String> other$matchingTitleExpectExts = other.getMatchingTitleExpectExts();
        if (this$matchingTitleExpectExts == null ? other$matchingTitleExpectExts != null : !((Object)this$matchingTitleExpectExts).equals(other$matchingTitleExpectExts)) {
            return false;
        }
        Map<String, Object> this$bizSysConfig = this.getBizSysConfig();
        Map<String, Object> other$bizSysConfig = other.getBizSysConfig();
        return !(this$bizSysConfig == null ? other$bizSysConfig != null : !((Object)this$bizSysConfig).equals(other$bizSysConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchEngineConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getWeightThreshold());
        result = result * 59 + Float.floatToIntBits(this.getCelebsWeightThreshold());
        result = result * 59 + Float.floatToIntBits(this.getVideoWeightThreshold());
        result = result * 59 + (this.isEnableTimeFilter() ? 79 : 97);
        result = result * 59 + (this.isEnableTurningRankerNewSort() ? 79 : 97);
        result = result * 59 + (this.isOpenHighlight() ? 79 : 97);
        result = result * 59 + (this.isOpenHiddenContent() ? 79 : 97);
        result = result * 59 + this.getMatcherFuzzyTermLetterLimit();
        result = result * 59 + this.getMatcherSentenceLetterLimit();
        result = result * 59 + this.getFixPageSize();
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        String $matchMainIndexFieldName = this.getMatchMainIndexFieldName();
        result = result * 59 + ($matchMainIndexFieldName == null ? 43 : $matchMainIndexFieldName.hashCode());
        String $instantMainIndexFieldName = this.getInstantMainIndexFieldName();
        result = result * 59 + ($instantMainIndexFieldName == null ? 43 : $instantMainIndexFieldName.hashCode());
        String $documentIdentifyFieldName = this.getDocumentIdentifyFieldName();
        result = result * 59 + ($documentIdentifyFieldName == null ? 43 : $documentIdentifyFieldName.hashCode());
        String $weightFieldName = this.getWeightFieldName();
        result = result * 59 + ($weightFieldName == null ? 43 : $weightFieldName.hashCode());
        String $classifyFieldName = this.getClassifyFieldName();
        result = result * 59 + ($classifyFieldName == null ? 43 : $classifyFieldName.hashCode());
        String $scoreExpress = this.getScoreExpress();
        result = result * 59 + ($scoreExpress == null ? 43 : $scoreExpress.hashCode());
        String $timeFilterFieldName = this.getTimeFilterFieldName();
        result = result * 59 + ($timeFilterFieldName == null ? 43 : $timeFilterFieldName.hashCode());
        List<String> $highlightFieldsName = this.getHighlightFieldsName();
        result = result * 59 + ($highlightFieldsName == null ? 43 : ((Object)$highlightFieldsName).hashCode());
        String $highlightPreTag = this.getHighlightPreTag();
        result = result * 59 + ($highlightPreTag == null ? 43 : $highlightPreTag.hashCode());
        String $highlightPostTag = this.getHighlightPostTag();
        result = result * 59 + ($highlightPostTag == null ? 43 : $highlightPostTag.hashCode());
        Map<String, Number> $bizParams = this.getBizParams();
        result = result * 59 + ($bizParams == null ? 43 : ((Object)$bizParams).hashCode());
        FuzzinessQueryMode $fuzzinessQueryMode = this.getFuzzinessQueryMode();
        result = result * 59 + ($fuzzinessQueryMode == null ? 43 : ((Object)((Object)$fuzzinessQueryMode)).hashCode());
        PredictParams $predictParams = this.getPredictParams();
        result = result * 59 + ($predictParams == null ? 43 : ((Object)$predictParams).hashCode());
        MatchingTitle.Verbosity $matchingTitleVerbosity = this.getMatchingTitleVerbosity();
        result = result * 59 + ($matchingTitleVerbosity == null ? 43 : ((Object)((Object)$matchingTitleVerbosity)).hashCode());
        List<String> $matchingTitleExpectExts = this.getMatchingTitleExpectExts();
        result = result * 59 + ($matchingTitleExpectExts == null ? 43 : ((Object)$matchingTitleExpectExts).hashCode());
        Map<String, Object> $bizSysConfig = this.getBizSysConfig();
        result = result * 59 + ($bizSysConfig == null ? 43 : ((Object)$bizSysConfig).hashCode());
        return result;
    }

    public String toString() {
        return "SearchEngineConfig(indexName=" + this.getIndexName() + ", matchMainIndexFieldName=" + this.getMatchMainIndexFieldName() + ", instantMainIndexFieldName=" + this.getInstantMainIndexFieldName() + ", documentIdentifyFieldName=" + this.getDocumentIdentifyFieldName() + ", weightFieldName=" + this.getWeightFieldName() + ", classifyFieldName=" + this.getClassifyFieldName() + ", scoreExpress=" + this.getScoreExpress() + ", timeFilterFieldName=" + this.getTimeFilterFieldName() + ", weightThreshold=" + this.getWeightThreshold() + ", celebsWeightThreshold=" + this.getCelebsWeightThreshold() + ", videoWeightThreshold=" + this.getVideoWeightThreshold() + ", enableTimeFilter=" + this.isEnableTimeFilter() + ", enableTurningRankerNewSort=" + this.isEnableTurningRankerNewSort() + ", openHighlight=" + this.isOpenHighlight() + ", highlightFieldsName=" + this.getHighlightFieldsName() + ", highlightPreTag=" + this.getHighlightPreTag() + ", highlightPostTag=" + this.getHighlightPostTag() + ", bizParams=" + this.getBizParams() + ", openHiddenContent=" + this.isOpenHiddenContent() + ", matcherFuzzyTermLetterLimit=" + this.getMatcherFuzzyTermLetterLimit() + ", matcherSentenceLetterLimit=" + this.getMatcherSentenceLetterLimit() + ", fixPageSize=" + this.getFixPageSize() + ", fuzzinessQueryMode=" + (Object)((Object)this.getFuzzinessQueryMode()) + ", predictParams=" + this.getPredictParams() + ", matchingTitleVerbosity=" + (Object)((Object)this.getMatchingTitleVerbosity()) + ", matchingTitleExpectExts=" + this.getMatchingTitleExpectExts() + ", bizSysConfig=" + this.getBizSysConfig() + ")";
    }
}

