/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.compensator;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.compensator.AbstractCompensator;
import com.valor.common.search.engine.compensator.Compensator;
import com.valor.common.search.engine.facade.config.CompensatorConfig;
import com.valor.common.search.engine.filter.Filter;
import com.valor.common.search.engine.filter.InlineFilter;
import com.valor.common.search.engine.filter.PostFilter;
import com.valor.common.search.engine.ranker.AbstractInlineScoreRanker;
import com.valor.common.search.engine.ranker.AbstractPostScoreRanker;
import com.valor.common.search.engine.ranker.ScoreRanker;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.SearchUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCompensator
extends AbstractCompensator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String DEFAULT_COMPENSATE_NAME = "DefaultCompensator";
    Random r = new Random(System.nanoTime());
    private RestHighLevelClient restHighLevelClient;
    private CompensateParameter compensateParameter = new CompensateParameter();
    private List<InlineFilter> inlineFilterList = new ArrayList<InlineFilter>();
    private List<AbstractInlineScoreRanker> inLineRankerList = new ArrayList<AbstractInlineScoreRanker>();
    private float mainWordBoost = 5.0f;
    private float compensateWordBoost = 0.5f;
    private AtomicInteger matchsentenceCount = new AtomicInteger(0);

    public DefaultCompensator() {
        this.compensateName = DEFAULT_COMPENSATE_NAME;
    }

    public DefaultCompensator(RequestContext context) {
        this.compensateName = DEFAULT_COMPENSATE_NAME;
        this.context = context;
        this.q = context.getQ();
        this.matchFieldName = context.KEY_MAIN_INDEX_FIELD;
        this.compensateParameter = new CompensateParameter();
        this.init();
    }

    public DefaultCompensator(RequestContext context, String matchFieldName) {
        this.compensateName = DEFAULT_COMPENSATE_NAME;
        this.context = context;
        this.q = context.getQ();
        this.matchFieldName = matchFieldName;
        this.compensateParameter = new CompensateParameter();
        this.init();
    }

    public DefaultCompensator(RequestContext context, String matchFieldName, CompensateParameter compensateParameter) {
        this.compensateName = DEFAULT_COMPENSATE_NAME;
        this.context = context;
        this.q = context.getQ();
        this.matchFieldName = matchFieldName;
        this.compensateParameter = compensateParameter;
        this.init();
    }

    @Override
    public Compensator filter(InlineFilter filter) {
        this.inlineFilterList.add(filter);
        return this;
    }

    private void init() {
        this.context.saveMatcheNameandMatcheFieldNamePair(this.compensateName, this.matchFieldName);
        this.restHighLevelClient = this.context.getRestHighLevelClient();
        this.inited = true;
    }

    @Override
    public void execute() throws RuntimeException {
        SearchResponse response = this.context.getResponse();
        String indexName = this.context.indexName();
        String[] newQs = this.getValidWordNrom(this.q);
        if (response.getHits().getHits().length > 0 && response.getHits().getHits().length > this.compensateParameter.triggeCompensateHitDocLimit) {
            return;
        }
        if (this.context.fromIndex() > 0) {
            return;
        }
        QueryBuilder queryBuilder = this.buildInternal(this.q);
        SearchRequest request = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        int prepareSize = 200;
        sourceBuilder.query(queryBuilder.queryName(this.compensateName).boost(this.compensateWordBoost)).size(prepareSize).from(0).highlighter(new HighlightBuilder().field((HighlightBuilder.Field)((HighlightBuilder.Field)((HighlightBuilder.Field)((HighlightBuilder.Field)new HighlightBuilder.Field(this.matchFieldName).postTags(new String[]{this.context.getHighlightPostTag()})).preTags(new String[]{this.context.getHighlightPreTag()})).boundaryScannerType(HighlightBuilder.BoundaryScannerType.SENTENCE)).requireFieldMatch(Boolean.valueOf(false))));
        request.source(sourceBuilder);
        SearchResponse esResponse = null;
        try {
            esResponse = SearchUtils.search(this.restHighLevelClient, request);
        }
        catch (Exception e) {
            System.out.println("Exception :" + e.getMessage() + " q=" + this.q);
            return;
        }
        this.context.saveResponse(esResponse);
        for (Filter filter : this.postFilterList) {
            if (filter.getFilterType() != 2 || !(filter instanceof PostFilter)) continue;
            ((PostFilter)filter).doFilter();
        }
        for (ScoreRanker ranker : this.postRankerList) {
            if (ranker.getType() != ScoreRanker.RANKER_TYPE.POST_SCORERANKER.ordinal() || !(ranker instanceof AbstractPostScoreRanker)) continue;
            ((AbstractPostScoreRanker)ranker).execute();
        }
    }

    private QueryBuilder buildInternal(String q) {
        BoolQueryBuilder mainAllWordQuery;
        BoolQueryBuilder mainQuery = null;
        mainQuery = mainAllWordQuery = (BoolQueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)this.matchFieldName, (Object)q).fuzziness((Object)"auto").fuzzyTranspositions(true)).boost(this.mainWordBoost);
        if (!CollectionUtils.isEmpty(this.inlineFilterList)) {
            BoolQueryBuilder filterQuery = QueryBuilders.boolQuery();
            for (InlineFilter filter : this.inlineFilterList) {
                QueryBuilder query = filter.build();
                if (query == null) continue;
                filterQuery.filter(query);
            }
            if (filterQuery.filter().size() > 0) {
                mainQuery = filterQuery.must((QueryBuilder)mainAllWordQuery);
            }
        }
        if (!CollectionUtils.isEmpty(this.inLineRankerList)) {
            for (AbstractInlineScoreRanker ranker : this.inLineRankerList) {
                mainQuery = ranker.build((QueryBuilder)mainQuery);
            }
        }
        String querySentenceName = this.getSentenceQueryName();
        this.saveSentenceMatchFieldName(querySentenceName, this.matchFieldName);
        this.saveQuerySentenceMatchedFieldNameMapToContext();
        mainQuery.queryName(querySentenceName);
        return QueryBuilders.boolQuery().should((QueryBuilder)mainQuery);
    }

    private String[] getValidWordNrom(String q) {
        String[] newQs = q.replaceAll("\\.", " ").trim().split("([\\s\\p{Zs}])+");
        boolean count = false;
        ArrayList<String> list = new ArrayList<String>();
        for (String st : newQs) {
            if (st.length() <= 1) continue;
            list.add(st);
        }
        newQs = new String[list.size()];
        for (int index = 0; index < list.size(); ++index) {
            newQs[index] = (String)list.get(index);
        }
        return newQs;
    }

    @Override
    public void prepareByConfig(CompensatorConfig config) {
        this.compensaterConfig = config;
        this.matchFieldName = config.getMatcherParams().getMatchFieldName();
        Object obj = config.getMatcherParams().getExtParams().get("triggeCompensateHitDocLimit");
        if (obj != null) {
            try {
                this.compensateParameter.triggeCompensateHitDocLimit = Integer.parseInt(obj.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.init();
    }

    private String getSentenceQueryName() {
        return "check_defaultCompensator_" + this.matchsentenceCount.getAndIncrement();
    }

    public static class CompensateParameter {
        private int triggeCompensateHitDocLimit = 15;
        private int mininumTotalWordCharLimit = 11;
        private float mainWordRateLimimt = 0.68f;
        private float compensateHitScale = 1.8f;
        private int takeCompensateHitDocLimit = 20;

        public int getTakeCompensateHitDocLimit() {
            return this.takeCompensateHitDocLimit;
        }

        public CompensateParameter setTakeCompensateHitDocLimit(int takeCompensateHitDocLimit) {
            this.takeCompensateHitDocLimit = takeCompensateHitDocLimit;
            return this;
        }

        public int getTriggeCompensateHitDocLimit() {
            return this.triggeCompensateHitDocLimit;
        }

        public CompensateParameter setTriggeCompensateHitDocLimit(int triggeCompensateHitDocLimit) {
            this.triggeCompensateHitDocLimit = triggeCompensateHitDocLimit;
            return this;
        }

        public int getMininumTotalWordCharLimit() {
            return this.mininumTotalWordCharLimit;
        }

        public CompensateParameter setMininumTotalWordCharLimit(int mininumTotalWordCharLimit) {
            this.mininumTotalWordCharLimit = mininumTotalWordCharLimit;
            return this;
        }

        public float getMainWordRateLimimt() {
            return this.mainWordRateLimimt;
        }

        public CompensateParameter setMainWordRateLimimt(float mainWordRateLimimt) {
            this.mainWordRateLimimt = mainWordRateLimimt;
            return this;
        }

        public float getCompensateHitScale() {
            return this.compensateHitScale;
        }

        public CompensateParameter setCompensateHitScale(float compensateHitScale) {
            this.compensateHitScale = compensateHitScale;
            return this;
        }
    }
}

