/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.filter;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.filter.AbstractSimilarityFilter;
import com.valor.common.search.engine.util.SearchUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;

public class MissingMatchFilter
extends AbstractSimilarityFilter {
    private String[] targetMatchName;
    private int maxMatched = 10;

    public MissingMatchFilter(RequestContext context) {
        this.context = context;
        this.targetMatchName = new String[]{"MissingWordMatcher".toLowerCase()};
        this.matchFieldName = context.KEY_MAIN_INDEX_FIELD;
    }

    public MissingMatchFilter(RequestContext context, String matchFieldName) {
        this.context = context;
        this.targetMatchName = new String[]{"MissingWordMatcher".toLowerCase()};
        this.matchFieldName = matchFieldName;
    }

    public MissingMatchFilter(RequestContext context, String ... targetMatchName) {
        this.context = context;
        for (int index = 0; index < targetMatchName.length; ++index) {
            this.targetMatchName[index] = targetMatchName[index].toLowerCase();
        }
        this.matchFieldName = context.KEY_MAIN_INDEX_FIELD;
    }

    public MissingMatchFilter(RequestContext context, String matchFieldName, String ... targetMatchName) {
        this.context = context;
        this.matchFieldName = matchFieldName;
        for (int index = 0; index < targetMatchName.length; ++index) {
            this.targetMatchName[index] = targetMatchName[index].toLowerCase();
        }
    }

    @Override
    public void doFilter() throws RuntimeException {
        SearchHits hits = this.context.getResponse().getHits();
        SearchHit[] hitDocs = hits.getHits();
        String q = this.context.getQ().trim();
        int qWordCount = q.split("([\\s\\p{Zs}])+").length;
        int abandonedCount = 0;
        HashSet<Integer> validHitDocIndex = new HashSet<Integer>();
        int matchCount = 0;
        block2: for (int index = 0; index < hitDocs.length; ++index) {
            if (!this.isMissingMatchOnly(hitDocs[index].getMatchedQueries())) {
                validHitDocIndex.add(index);
                continue;
            }
            if (matchCount >= this.maxMatched) continue;
            ArrayList titleList = (ArrayList)hitDocs[index].getSourceAsMap().get(this.matchFieldName);
            for (String title : titleList) {
                if (matchCount >= this.maxMatched) continue block2;
                if (title.trim().split("([\\s\\p{Zs}])+").length >= qWordCount) {
                    validHitDocIndex.add(index);
                    ++matchCount;
                    continue block2;
                }
                if ((float)title.length() * 1.0f / ((float)q.length() * 1.0f) > 0.75f) {
                    validHitDocIndex.add(index);
                    ++matchCount;
                    continue block2;
                }
                ++abandonedCount;
            }
        }
        SearchHit[] targetHitArray = new SearchHit[validHitDocIndex.size()];
        int cIndex = 0;
        float maxScore = 0.0f;
        for (int i = 0; i < hitDocs.length; ++i) {
            if (!validHitDocIndex.contains(i)) continue;
            maxScore = maxScore > hitDocs[i].getScore() ? maxScore : hitDocs[i].getScore();
            targetHitArray[cIndex] = hitDocs[i];
            ++cIndex;
        }
        try {
            SearchUtils.replaceHits(hits, targetHitArray);
            SearchUtils.replaceTotalHitsSize(hits, targetHitArray.length);
            if (maxScore != hits.getMaxScore()) {
                SearchUtils.replaceMaxScore(hits, maxScore);
            }
        }
        catch (Exception nsfe) {
            throw new RuntimeException(nsfe);
        }
        if (matchCount < this.maxMatched) {
            this.increaseInvalidDocCountBy(abandonedCount);
        }
    }

    @Override
    public String getFilterFieldName() {
        return this.matchFieldName;
    }

    private boolean isMissingMatchOnly(String[] matchQueries) {
        boolean retVal = false;
        for (String str : matchQueries) {
            if (Arrays.binarySearch(this.targetMatchName, str.toLowerCase()) < 0) continue;
            return true;
        }
        return retVal;
    }

    private Set<String> tryMatchedWord(Text[] matchTextList, String[] newQs) {
        HashSet<String> matchedWord = new HashSet<String>();
        for (Text t : matchTextList) {
            Set<String> matchedWordSet = SearchUtils.findMatchStr(t.toString(), this.context.getHighlightPreTag(), this.context.getHighlightPostTag());
            matchedWord.addAll(matchedWordSet);
        }
        return matchedWord;
    }
}

