/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.filter;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.facade.config.InlineFilterConfig;
import com.valor.common.search.engine.filter.DateTimeFormat;
import com.valor.common.search.engine.filter.FilterFuncEnum;
import com.valor.common.search.engine.filter.InlineFilter;
import com.valor.common.search.engine.util.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;

public class TimeFilter
implements InlineFilter {
    private RequestContext context;
    private String filterValue;
    private String filterFieldName;
    private FilterFuncEnum filterType = null;
    private DateTimeFormat filterValueFormat = DateTimeFormat.YEAR;
    private static Pattern yearPattern = Pattern.compile("[0-9]{4}");

    public TimeFilter(RequestContext context, String filterFieldName) {
        this.context = context;
        this.filterFieldName = filterFieldName;
    }

    public TimeFilter(String filterFieldName) {
        this.filterFieldName = filterFieldName;
    }

    @Override
    public String getFilterName() {
        return null;
    }

    @Override
    public QueryBuilder build(QueryBuilder targetQuery) {
        if (this.filterType == null) {
            return targetQuery;
        }
        QueryBuilder filter = this.build();
        if (filter != null) {
            return QueryBuilders.boolQuery().must(targetQuery).filter(filter);
        }
        return targetQuery;
    }

    @Override
    public QueryBuilder build() {
        RangeQueryBuilder filter = null;
        if (this.filterType == FilterFuncEnum.EQUAL) {
            filter = QueryBuilders.rangeQuery((String)this.filterFieldName).from((Object)this.filterValue, true).to((Object)this.filterValue, true).format(this.filterValueFormat.value);
        } else if (this.filterType == FilterFuncEnum.LT) {
            filter = QueryBuilders.rangeQuery((String)this.filterFieldName).lt((Object)this.filterValue).format(this.filterValueFormat.value);
        } else if (this.filterType == FilterFuncEnum.GT) {
            filter = QueryBuilders.rangeQuery((String)this.filterFieldName).gt((Object)this.filterValue).format(this.filterValueFormat.value);
        } else if (this.filterType == FilterFuncEnum.GTE) {
            filter = QueryBuilders.rangeQuery((String)this.filterFieldName).gte((Object)this.filterValue).format(this.filterValueFormat.value);
        } else if (this.filterType == FilterFuncEnum.LTE) {
            filter = QueryBuilders.rangeQuery((String)this.filterFieldName).lte((Object)this.filterValue).format(this.filterValueFormat.value);
        } else if (this.filterType == FilterFuncEnum.NOTEQUAL) {
            filter = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)this.filterFieldName, (String)this.filterValue));
        }
        return filter;
    }

    @Override
    public void prepareByConfig(InlineFilterConfig config) {
    }

    public void params(FilterFuncEnum filterType) {
        if (this.context == null) {
            throw new RuntimeException("Search engine context must not null.");
        }
        String timeStr = this.parseYear(this.context.getQ());
        if (StringUtils.isEmpty(timeStr)) {
            return;
        }
        this.params(timeStr, filterType, DateTimeFormat.YEAR);
    }

    public void params(RequestContext context, FilterFuncEnum filterType) {
        if (context == null) {
            throw new RuntimeException("Search engine context must not null.");
        }
        String timeStr = this.parseYear(context.getQ());
        if (StringUtils.isEmpty(timeStr)) {
            return;
        }
        this.params(timeStr, filterType, DateTimeFormat.YEAR);
    }

    public void params(String timeStr, FilterFuncEnum filterType) {
        this.params(timeStr, filterType, DateTimeFormat.YEAR);
    }

    public void params(String timeStr, FilterFuncEnum filterType, DateTimeFormat dateTimeFormat) {
        this.filterValue = timeStr;
        this.filterType = filterType;
        this.filterValueFormat = dateTimeFormat;
    }

    private String parseYear(String q) {
        Matcher m = yearPattern.matcher(q);
        if (m.matches()) {
            this.filterValue = m.group(1);
            return this.filterValue;
        }
        return null;
    }
}

