/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.handler;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.WrappedHighlightField;
import com.valor.common.search.engine.WrappedSearchResponse;
import com.valor.common.search.engine.handler.GeneralHandler;
import com.valor.common.search.engine.util.SearchUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TakeResultHandler
implements GeneralHandler {
    private static Logger logger = LoggerFactory.getLogger(TakeResultHandler.class);
    private int wantedSize = 200;

    public void setWantedSize(int size) {
        this.wantedSize = size;
    }

    @Override
    public void doExcute(RequestContext context) {
        if (this.wantedSize < context.getResponse().getHits().getHits().length) {
            SearchHit[] newHits = new SearchHit[this.wantedSize];
            for (int index = 0; index < this.wantedSize; ++index) {
                newHits[index] = context.getResponse().getHits().getHits()[index];
            }
            try {
                SearchUtils.replaceHits(context.getResponse().getHits(), newHits);
            }
            catch (Exception e) {
                logger.error("Error while repalce hits into response. Exception:", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        HighlightField highlightField = null;
        for (SearchHit hit : context.getResponse().getHits().getHits()) {
            Map highlightFieldMap = hit.getHighlightFields();
            for (Map.Entry entry : highlightFieldMap.entrySet()) {
                String key = (String)entry.getKey();
                highlightField = (HighlightField)highlightFieldMap.get(key);
                WrappedHighlightField wrappedHighlightField = WrappedHighlightField.wrap(highlightField, context);
                highlightFieldMap.put(key, wrappedHighlightField);
            }
        }
        try {
            WrappedSearchResponse resp = WrappedSearchResponse.wrap(context.getResponse());
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            map.putAll(context.getQueryMatcherMatchedFieldNameMap());
            resp.setMatchedQueryHightFieldNameMap(map);
            resp.setAbandonedHitsCount(context.invalidDocCount);
            resp.rebuildLastIndex(context);
            context.saveResponse(resp);
        }
        catch (Exception e) {
            logger.error("Error while wrap reponse,Exception:", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

