/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.matcher;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.facade.FuzzinessQueryMode;
import com.valor.common.search.engine.facade.config.MatcherConfig;
import com.valor.common.search.engine.facade.config.MatcherParams;
import com.valor.common.search.engine.hunspell.EngineHunspell;
import com.valor.common.search.engine.matcher.AbstractFuzzyMatcher;
import com.valor.common.search.engine.matcher.Matcher;
import com.valor.common.search.engine.matcher.Term;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.SearchUtils;
import com.valor.common.search.engine.util.StringUtils;
import com.valor.common.search.engine.zpredict.PredictParams;
import com.valor.common.search.engine.zpredict.PredictionBuilder;
import com.valor.common.search.engine.zsymspell.SymSpell;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.keyvalue.DefaultKeyValue;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.DisMaxQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RegexpQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;

public class GeneralFuzzyMatcher
extends AbstractFuzzyMatcher {
    public static final String DEFAULT_MATCH_NAME = "GeneralFuzzyMatcher";
    private static final int fuzzyWordMinLength = 3;
    private static final int compositeWordMinLength = 6;
    private static final int prefixWordMinLength = 3;
    private static final int SUGGEST_WORD_TERM_LIMIT = 5;
    Set<String> queryUsedFieldNameSet = new LinkedHashSet<String>();
    private final List<Term> termList = new ArrayList<Term>();
    private final List<Term> yearTermList = new ArrayList<Term>();
    private final List<Term> aliasTermList = new ArrayList<Term>();
    private DISTANCE_TYPE distanceType = DISTANCE_TYPE.BY_WORD;
    private int distance = 1;
    private String wildCardMatchFieldName = "";
    private final List<String> fuzzyMatchFieldNames = new ArrayList<String>();
    private String wordLettersMatchFieldName = "";
    private String allLettersMatchFieldName = "";
    private final List<String> prefixMatchFieldName = new ArrayList<String>();
    private String fuzzyAnalyzer;
    private AtomicInteger matchsentenceCount = new AtomicInteger(0);
    private EngineHunspell engineHunspell;

    public GeneralFuzzyMatcher() {
        this.matchName = DEFAULT_MATCH_NAME;
    }

    public GeneralFuzzyMatcher(RequestContext context) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.q = context.getQ().trim();
        this.context = context;
        this.matchFieldName = context.fuzzySubIndexFieldName;
        this.init();
    }

    public GeneralFuzzyMatcher(RequestContext context, String matchFieldName) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.q = context.getQ().trim();
        this.context = context;
        this.matchFieldName = matchFieldName;
        this.init();
    }

    public GeneralFuzzyMatcher(RequestContext context, int distance, DISTANCE_TYPE distanceType) {
        this.matchName = DEFAULT_MATCH_NAME;
        if (distance < 0 || distance > 2) {
            throw new RuntimeException("Distance mut be 0,1,2");
        }
        this.q = context.getQ().trim();
        this.context = context;
        this.matchFieldName = context.fuzzySubIndexFieldName;
        this.distance = distance;
        this.distanceType = distanceType;
        this.init();
    }

    public GeneralFuzzyMatcher(RequestContext context, int distance, DISTANCE_TYPE distanceType, String matchFieldName) {
        this.matchName = DEFAULT_MATCH_NAME;
        if (distance < 0 || distance > 2) {
            throw new RuntimeException("Distance mut be 0,1,2");
        }
        this.q = context.getQ().trim();
        this.context = context;
        this.matchFieldName = matchFieldName;
        this.distance = distance;
        this.distanceType = distanceType;
        this.init();
    }

    public GeneralFuzzyMatcher(RequestContext context, int distance, DISTANCE_TYPE distanceType, String matchFieldName, String analyerName) {
        this.matchName = DEFAULT_MATCH_NAME;
        if (distance < 0 || distance > 2) {
            throw new RuntimeException("Distance mut be 0,1,2");
        }
        this.q = context.getQ().trim();
        this.context = context;
        this.matchFieldName = matchFieldName;
        this.distance = distance;
        this.distanceType = distanceType;
        this.analyzerName = analyerName;
        this.init();
    }

    private void init() {
        this.context.saveMatcheNameandMatcheFieldNamePair(this.matchName, this.matchFieldName);
        this.engineHunspell = new EngineHunspell();
        this.engineHunspell.init();
    }

    @Override
    public Matcher.MATCHER_TYPE getMatcherType() {
        return Matcher.MATCHER_TYPE.GENERAL_FUZZY;
    }

    @Override
    public GeneralFuzzyMatcher assembly() {
        this.termList.clear();
        this.q = this.context.getQ().trim().replaceAll("-", " ");
        if (this.distanceType.equals((Object)DISTANCE_TYPE.BY_WORD)) {
            String strQ;
            String aliasQ;
            Map<String, List<String>> yearTermMap;
            String[] newQs;
            for (String str : newQs = this.q.trim().split("([\\s\\p{Zs}])+")) {
                this.assemblyInternal(str);
            }
            if (this.matcherConfig.getYearFlag().booleanValue() && !CollectionUtils.isEmpty(yearTermMap = SearchUtils.splitByYear(this.q.trim()))) {
                String[] newQs4Year;
                List<String> keywords = yearTermMap.get("keywords");
                List<String> yearList = yearTermMap.get("years");
                String queryWordForYear = keywords.get(0);
                for (String str : newQs4Year = queryWordForYear.trim().split("([\\s\\p{Zs}])+")) {
                    Term yearTerm = this.assemblyInternalForYear(str);
                    yearTerm.setYearList(yearList);
                    this.yearTermList.add(yearTerm);
                }
            }
            if (this.yearTermList.isEmpty() && newQs.length > 3 && !StringUtils.isEmpty(aliasQ = SearchUtils.takeAliasStr(strQ = SearchUtils.tryToMissWordByLooseRule(this.q), 3))) {
                String[] aliasQSplit = aliasQ.split("([\\s\\p{Zs}])+");
                if (!StringUtils.isEmpty(aliasQ) && aliasQSplit.length < this.q.split("([\\s\\p{Zs}])+").length) {
                    this.context.queryExecutePartialWordAlias = aliasQ;
                    for (String str : aliasQSplit) {
                        Term term = new Term(SearchUtils.takeStrByPrefixLimit(str, this.MATCHER_WORD_TERM_LETTER_LIMIT));
                        term.setFuzzyDistance(this.distance);
                        term.setMatchedFieldName(this.matchFieldName);
                        if (!StringUtils.isEmpty(this.analyzerName)) {
                            term.setAnalyzer(this.analyzerName);
                        }
                        this.aliasTermList.add(term);
                    }
                }
            }
        } else {
            this.assemblyInternal(this.q);
        }
        return this;
    }

    private Term assemblyInternalForYear(String str) {
        Term term = new Term(SearchUtils.takeStrByPrefixLimit(str, this.MATCHER_WORD_TERM_LETTER_LIMIT));
        term.setFuzzyDistance(this.distance);
        term.setMatchedFieldName(this.matchFieldName);
        if (!StringUtils.isEmpty(this.analyzerName)) {
            term.setAnalyzer(this.analyzerName);
        }
        return term;
    }

    private void assemblyInternal(String str) {
        Term term = new Term(SearchUtils.takeStrByPrefixLimit(str, this.MATCHER_WORD_TERM_LETTER_LIMIT));
        term.setFuzzyDistance(this.distance);
        term.setMatchedFieldName(this.matchFieldName);
        if (!StringUtils.isEmpty(this.analyzerName)) {
            term.setAnalyzer(this.analyzerName);
        }
        this.termList.add(term);
    }

    private void assemblyInternalBySentence(String str) {
        Term term = new Term(SearchUtils.takeStrByPrefixLimit(str, this.MATCHER_SENTENCE_LETTER_LIMIT));
        term.setFuzzyDistance(this.distance);
        term.setMatchedFieldName(this.matchFieldName);
        if (!StringUtils.isEmpty(this.analyzerName)) {
            term.setAnalyzer(this.analyzerName);
        }
        this.termList.add(term);
    }

    @Override
    public QueryBuilder buildBase() {
        this.matchsentenceCount = new AtomicInteger(0);
        String[] qs = this.q.replaceAll("-", " ").trim().split("([\\s\\p{Zs}])+");
        if (qs.length >= 6) {
            return null;
        }
        Object retVal = null;
        if (this.termList.size() > 3 && this.aliasTermList.size() > 3) {
            return null;
        }
        if (!SearchUtils.isLatin(this.q)) {
            return QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)this.matchFieldName, (Object)this.q).operator(Operator.OR).queryName("check_other_not_latin"));
        }
        if (this.distanceType == DISTANCE_TYPE.BY_WORD) {
            String[] newQs;
            ArrayList<Term> workTermList = new ArrayList<Term>(this.termList);
            this.sortTermListByKeywordLength(workTermList);
            this.sortTermListByKeywordLength(this.yearTermList);
            this.sortTermListByKeywordLength(this.aliasTermList);
            Object sentencePrefixQuery = null;
            BoolQueryBuilder fuzzyQueryBuilder = this.buildFuzzyQuery(workTermList, 3, this.fuzzyMatchFieldNames, this.matchFieldName, null);
            BoolQueryBuilder allLetterBuilder = this.buildCompositeKeywordFuzzyQuery(workTermList, 3, this.wordLettersMatchFieldName, this.matchFieldName);
            BoolQueryBuilder prefixQueryBuilder = this.buildPrefixFuzzyQuery(workTermList, 3, this.prefixMatchFieldName, this.matchFieldName);
            BoolQueryBuilder compositeTermToWordBuilder = this.buildCompositeToWordFuzzyQuery(workTermList, this.wordLettersMatchFieldName, this.matchFieldName);
            BoolQueryBuilder termInOtherWordBuilder = this.buildTermInOtherWordFuzzyQuery(workTermList, 4, this.wordLettersMatchFieldName, this.matchFieldName);
            BoolQueryBuilder fuzzyQueryBuilderForYear = this.buildFuzzyQuery(this.yearTermList, 3, this.fuzzyMatchFieldNames, this.matchFieldName, null);
            BoolQueryBuilder allLetterBuilderForYear = this.buildCompositeKeywordFuzzyQuery(this.yearTermList, 3, this.wordLettersMatchFieldName, this.matchFieldName);
            BoolQueryBuilder prefixQueryBuilderForYear = this.buildPrefixFuzzyQuery(this.yearTermList, 3, this.prefixMatchFieldName, this.matchFieldName);
            BoolQueryBuilder compositeTermToWordBuilderForYear = this.buildCompositeToWordFuzzyQuery(this.yearTermList, this.wordLettersMatchFieldName, this.matchFieldName);
            BoolQueryBuilder termInOtherWordBuilderForYear = this.buildTermInOtherWordFuzzyQuery(this.yearTermList, 4, this.wordLettersMatchFieldName, this.matchFieldName);
            BoolQueryBuilder fuzzyQueryBuilder4Alias = this.buildFuzzyQuery(this.aliasTermList, 3, this.fuzzyMatchFieldNames, this.matchFieldName, null);
            BoolQueryBuilder compositeTermToWordBuilder4Alias = this.buildCompositeToWordFuzzyQuery(this.aliasTermList, this.wordLettersMatchFieldName, this.matchFieldName);
            BoolQueryBuilder missWordFuzzyQueryBuilder = null;
            BoolQueryBuilder missWordFuzzyQueryBuilderForYear = null;
            if (SearchUtils.isLatin(this.q) && (newQs = SearchUtils.tryToMissWord(this.q).trim().split("([\\s\\p{Zs}])+")).length < workTermList.size()) {
                ArrayList<Term> missWordTermList = new ArrayList<Term>();
                for (String qStr : newQs) {
                    missWordTermList.add(new Term(qStr));
                }
                this.sortTermListByKeywordLength(missWordTermList);
                missWordFuzzyQueryBuilder = this.buildFuzzyQuery(missWordTermList, 3, this.fuzzyMatchFieldNames, this.matchFieldName, null);
                missWordFuzzyQueryBuilderForYear = this.buildFuzzyQuery(this.yearTermList, 3, this.fuzzyMatchFieldNames, this.matchFieldName, null);
            }
            BoolQueryBuilder queryWordCompositeQuery = this.buildQueryWordIsComposite(workTermList, this.fuzzyMatchFieldNames, this.matchFieldName, this.wordLettersMatchFieldName);
            BoolQueryBuilder queryWordCompositeQueryForYear = this.buildQueryWordIsComposite(this.yearTermList, this.fuzzyMatchFieldNames, this.matchFieldName, this.wordLettersMatchFieldName);
            HashSet<String> uniqueYearSet = new HashSet<String>();
            for (Term term : this.yearTermList) {
                uniqueYearSet.addAll(term.getYearList());
            }
            if (!uniqueYearSet.isEmpty()) {
                if (fuzzyQueryBuilderForYear != null) {
                    fuzzyQueryBuilderForYear = this.appendFilter2QueryBuilder(fuzzyQueryBuilderForYear, uniqueYearSet);
                }
                if (allLetterBuilderForYear != null) {
                    allLetterBuilderForYear = this.appendFilter2QueryBuilder(allLetterBuilderForYear, uniqueYearSet);
                }
                if (prefixQueryBuilderForYear != null) {
                    prefixQueryBuilderForYear = this.appendFilter2QueryBuilder(prefixQueryBuilderForYear, uniqueYearSet);
                }
                if (compositeTermToWordBuilderForYear != null) {
                    compositeTermToWordBuilderForYear = this.appendFilter2QueryBuilder(compositeTermToWordBuilderForYear, uniqueYearSet);
                }
                if (termInOtherWordBuilderForYear != null) {
                    termInOtherWordBuilderForYear = this.appendFilter2QueryBuilder(termInOtherWordBuilderForYear, uniqueYearSet);
                }
                if (missWordFuzzyQueryBuilderForYear != null) {
                    missWordFuzzyQueryBuilderForYear = this.appendFilter2QueryBuilder(missWordFuzzyQueryBuilderForYear, uniqueYearSet);
                }
                if (queryWordCompositeQueryForYear != null) {
                    queryWordCompositeQueryForYear = this.appendFilter2QueryBuilder(queryWordCompositeQueryForYear, uniqueYearSet);
                }
            }
            BoolQueryBuilder finalQuery = QueryBuilders.boolQuery();
            BoolQueryBuilder finalQuery4Year = QueryBuilders.boolQuery();
            if (null != sentencePrefixQuery) {
                finalQuery.should((QueryBuilder)sentencePrefixQuery.boost(this.boost));
            }
            if (compositeTermToWordBuilder4Alias != null) {
                finalQuery.should((QueryBuilder)compositeTermToWordBuilder4Alias.boost(this.boost * 2.0f));
            }
            if (fuzzyQueryBuilder4Alias != null) {
                finalQuery.should((QueryBuilder)fuzzyQueryBuilder4Alias.boost(this.boost * 2.0f));
            }
            if (queryWordCompositeQuery != null) {
                finalQuery.should((QueryBuilder)queryWordCompositeQuery.boost(this.boost * 2.0f));
            }
            if (queryWordCompositeQueryForYear != null) {
                finalQuery.should((QueryBuilder)queryWordCompositeQueryForYear.boost(this.boost * 2.0f));
            }
            if (termInOtherWordBuilder != null) {
                termInOtherWordBuilder.boost(this.boost * 2.0f);
                finalQuery.should((QueryBuilder)termInOtherWordBuilder);
            }
            if (termInOtherWordBuilderForYear != null) {
                termInOtherWordBuilderForYear.boost(this.boost * 2.0f);
                finalQuery4Year.should((QueryBuilder)termInOtherWordBuilderForYear);
            }
            if (compositeTermToWordBuilder != null) {
                compositeTermToWordBuilder.boost(this.boost * 3.0f);
                finalQuery.should((QueryBuilder)compositeTermToWordBuilder);
            }
            if (compositeTermToWordBuilderForYear != null) {
                compositeTermToWordBuilderForYear.boost(this.boost * 3.0f);
                finalQuery4Year.should((QueryBuilder)compositeTermToWordBuilderForYear);
            }
            if (fuzzyQueryBuilder != null) {
                fuzzyQueryBuilder.boost(this.boost * 2.0f);
                finalQuery.should((QueryBuilder)fuzzyQueryBuilder);
            }
            if (fuzzyQueryBuilderForYear != null) {
                fuzzyQueryBuilderForYear.boost(this.boost * 2.0f);
                finalQuery4Year.should((QueryBuilder)fuzzyQueryBuilderForYear);
            }
            if (missWordFuzzyQueryBuilder != null) {
                missWordFuzzyQueryBuilder.boost(this.boost * 2.0f);
                finalQuery.should((QueryBuilder)missWordFuzzyQueryBuilder);
            }
            if (missWordFuzzyQueryBuilderForYear != null) {
                missWordFuzzyQueryBuilderForYear.boost(this.boost * 2.0f);
                finalQuery4Year.should((QueryBuilder)termInOtherWordBuilderForYear);
            }
            if (allLetterBuilder != null) {
                allLetterBuilder.boost(this.boost);
                finalQuery.should((QueryBuilder)allLetterBuilder);
            }
            if (allLetterBuilderForYear != null) {
                allLetterBuilderForYear.boost(this.boost);
                finalQuery4Year.should((QueryBuilder)allLetterBuilderForYear);
            }
            if (prefixQueryBuilder != null) {
                prefixQueryBuilder.boost(this.boost * 5.0f);
                finalQuery.should((QueryBuilder)prefixQueryBuilder);
            }
            if (prefixQueryBuilderForYear != null) {
                prefixQueryBuilderForYear.boost(this.boost * 5.0f);
                finalQuery4Year.should((QueryBuilder)prefixQueryBuilderForYear);
            }
            retVal = finalQuery.should().isEmpty() && finalQuery4Year.should().isEmpty() ? QueryBuilders.matchPhraseQuery((String)this.matchFieldName, (Object)SearchUtils.takeStrByPrefixLimit(((Term)workTermList.get(0)).getTermStr(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT)) : (finalQuery.should().isEmpty() ? finalQuery4Year : (finalQuery4Year.should().isEmpty() ? finalQuery : QueryBuilders.boolQuery().should((QueryBuilder)finalQuery).should((QueryBuilder)finalQuery4Year)));
        } else {
            String termStr = SearchUtils.takeStrByPrefixLimit(this.termList.get(0).getTermStr(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT);
            MatchQueryBuilder query = QueryBuilders.matchQuery((String)this.termList.get(0).getMatchedFieldName(), (Object)termStr).fuzziness((Object)Fuzziness.fromEdits((int)this.distance));
            this.queryUsedFieldNameSet.add(this.termList.get(0).getMatchedFieldName());
            if (!StringUtils.isEmpty(this.termList.get(0).getAnalyzer())) {
                query.analyzer(this.termList.get(0).getAnalyzer());
            }
            if (!StringUtils.isEmpty(this.wordLettersMatchFieldName)) {
                MatchQueryBuilder query2 = QueryBuilders.matchQuery((String)this.wordLettersMatchFieldName, (Object)termStr).analyzer(this.getFuzzyAnalyzerName(termStr.length()));
                this.queryUsedFieldNameSet.add(this.wordLettersMatchFieldName);
                retVal = QueryBuilders.boolQuery().should((QueryBuilder)query2).should((QueryBuilder)query).boost(this.boost);
            } else {
                retVal = query;
            }
        }
        this.saveQuerySentenceMatchedFieldNameMapToContext();
        this.context.putQueryMatcherMatchedFieldNameMap(this.matchName, new ArrayList<String>(this.queryUsedFieldNameSet));
        return retVal.boost(this.globalBoost);
    }

    private BoolQueryBuilder appendFilter2QueryBuilder(BoolQueryBuilder queryBuilder, Collection<String> yearList) {
        ArrayList<TermQueryBuilder> filterQueryBuilderList = new ArrayList<TermQueryBuilder>();
        BoolQueryBuilder finalQueryBuilder = null;
        for (String string : yearList) {
            filterQueryBuilderList.add(QueryBuilders.termQuery((String)this.matcherConfig.getYearFieldName(), (String)string));
        }
        if (filterQueryBuilderList.size() > 1) {
            BoolQueryBuilder filterQueryBuilder = QueryBuilders.boolQuery();
            for (QueryBuilder queryBuilder2 : filterQueryBuilderList) {
                filterQueryBuilder.should(queryBuilder2);
            }
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.filter((QueryBuilder)filterQueryBuilder).must((QueryBuilder)queryBuilder.minimumShouldMatch(1));
            finalQueryBuilder = boolQueryBuilder;
        } else {
            BoolQueryBuilder mainQueruBuilder = QueryBuilders.boolQuery();
            mainQueruBuilder.filter((QueryBuilder)filterQueryBuilderList.get(0)).must((QueryBuilder)queryBuilder.minimumShouldMatch(1));
            finalQueryBuilder = mainQueruBuilder;
        }
        return finalQueryBuilder;
    }

    private void sortTermListByKeywordLength(List<Term> workTermList) {
        workTermList.sort((a, b) -> {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            return Integer.compare(b.getTermStr().length(), a.getTermStr().length());
        });
    }

    private BoolQueryBuilder buildQueryWordIsComposite(List<Term> workTermList, List<String> fuzzyMatchFieldNameList, String normalMatchFieldName, String wordLettersMatchFieldName) {
        if (CollectionUtils.isEmpty(workTermList) || !SearchUtils.isLatin(this.q)) {
            return null;
        }
        BoolQueryBuilder oneWordCompositeQuery = null;
        if (workTermList.size() == 1) {
            if (workTermList.get(0).getTermStr().length() < 6) {
                return null;
            }
            List<BoolQueryBuilder> oneWordCompositeQueryList = this.buildForOneWordCompositeImpl(workTermList.get(0).getTermStr(), this.fuzzyMatchFieldNames, this.matchFieldName, this.wordLettersMatchFieldName);
            if (!CollectionUtils.isEmpty(oneWordCompositeQueryList)) {
                oneWordCompositeQuery = QueryBuilders.boolQuery();
                for (BoolQueryBuilder queryBuilder : oneWordCompositeQueryList) {
                    oneWordCompositeQuery.should((QueryBuilder)queryBuilder);
                }
                ((BoolQueryBuilder)oneWordCompositeQuery.boost(this.boost * 5.0f)).queryName("check_QueryWordIsComposite");
                LinkedHashSet<String> querySentenceMatchedFieldNames = new LinkedHashSet<String>(fuzzyMatchFieldNameList);
                querySentenceMatchedFieldNames.add(normalMatchFieldName);
                querySentenceMatchedFieldNames.add(wordLettersMatchFieldName);
                DefaultKeyValue querySentenceAndMatchFieldNamePair = new DefaultKeyValue((Object)"check_QueryWordIsComposite", querySentenceMatchedFieldNames);
                this.querySentenceMatchedFieldNamePairsList.add(querySentenceAndMatchFieldNamePair);
            }
        }
        if (workTermList.size() == 2 || workTermList.size() == 3) {
            int maxLenTermIndex = -1;
            int termLen = 6;
            for (int i = 0; i < workTermList.size(); ++i) {
                if (workTermList.get(i).getTermStr().length() < termLen) continue;
                termLen = workTermList.get(i).getTermStr().length();
                maxLenTermIndex = i;
            }
            ArrayList<String> helpTermStrList = new ArrayList<String>();
            for (int i = 0; i < workTermList.size(); ++i) {
                if (i == maxLenTermIndex || workTermList.get(i).getTermStr().length() <= 2) continue;
                helpTermStrList.add(workTermList.get(i).getTermStr().toLowerCase());
            }
            if (maxLenTermIndex < 0 || !SearchUtils.isLatin(workTermList.get(maxLenTermIndex).getTermStr())) {
                return null;
            }
            List<BoolQueryBuilder> oneWordCompositeQueryList = this.buildForOneWordCompositeImpl(workTermList.get(maxLenTermIndex).getTermStr(), this.fuzzyMatchFieldNames, this.matchFieldName, this.wordLettersMatchFieldName);
            if (!CollectionUtils.isEmpty(oneWordCompositeQueryList)) {
                oneWordCompositeQuery = QueryBuilders.boolQuery();
                for (BoolQueryBuilder queryBuilder : oneWordCompositeQueryList) {
                    oneWordCompositeQuery.should((QueryBuilder)queryBuilder);
                }
                oneWordCompositeQuery.boost(this.boost * 5.0f);
                LinkedHashSet<String> querySentenceMatchedFieldNames = new LinkedHashSet<String>();
                if (!CollectionUtils.isEmpty(helpTermStrList)) {
                    ArrayList<Object> helpTermQueryList = new ArrayList<Object>();
                    for (String helpTermStr : helpTermStrList) {
                        if (helpTermStr.length() < 6) {
                            helpTermQueryList.add(QueryBuilders.matchPhraseQuery((String)this.matchFieldName, (Object)helpTermStr));
                            continue;
                        }
                        helpTermQueryList.add(QueryBuilders.matchQuery((String)this.matchFieldName, (Object)SearchUtils.takeStrByPrefixLimit(helpTermStr, this.MATCHER_FUZZY_TERM_LETTER_LIMIT)).fuzziness((Object)"auto"));
                    }
                    querySentenceMatchedFieldNames.add(this.matchFieldName);
                    if (helpTermQueryList.isEmpty()) {
                        oneWordCompositeQuery = QueryBuilders.boolQuery().must((QueryBuilder)oneWordCompositeQuery);
                    } else {
                        BoolQueryBuilder multiHelpTermQueryList = QueryBuilders.boolQuery();
                        for (QueryBuilder queryBuilder : helpTermQueryList) {
                            multiHelpTermQueryList.should(queryBuilder).minimumShouldMatch(1);
                        }
                        oneWordCompositeQuery = QueryBuilders.boolQuery().must((QueryBuilder)oneWordCompositeQuery).must((QueryBuilder)multiHelpTermQueryList);
                    }
                }
                querySentenceMatchedFieldNames.addAll(fuzzyMatchFieldNameList);
                querySentenceMatchedFieldNames.add(normalMatchFieldName);
                querySentenceMatchedFieldNames.add(wordLettersMatchFieldName);
                oneWordCompositeQuery.queryName("check_QueryWordIsComposite");
                DefaultKeyValue querySentenceAndMatchFieldNamePair = new DefaultKeyValue((Object)"check_QueryWordIsComposite", querySentenceMatchedFieldNames);
                this.querySentenceMatchedFieldNamePairsList.add(querySentenceAndMatchFieldNamePair);
            }
        }
        return oneWordCompositeQuery;
    }

    private List<BoolQueryBuilder> buildForOneWordCompositeImpl(String word, List<String> fuzzyMatchFieldNameList, String normalMatchFieldName, String wordLettersMatchFieldName) {
        if (!SearchUtils.isLatin(word)) {
            return null;
        }
        List<List<String>> suggestWords = this.engineHunspell.suggestByForceSplit(SearchUtils.takeStrByPrefixLimit(word, this.MATCHER_FUZZY_TERM_LETTER_LIMIT));
        if (!CollectionUtils.isEmpty(suggestWords) && suggestWords.size() > 5) {
            suggestWords = suggestWords.subList(0, 5);
        }
        if (CollectionUtils.isEmpty(suggestWords)) {
            return null;
        }
        ArrayList<BoolQueryBuilder> preparedQueryBuilderList = new ArrayList<BoolQueryBuilder>();
        int c = 0;
        for (List<String> splitWords : suggestWords) {
            if (splitWords.isEmpty()) continue;
            BoolQueryBuilder firstWordQuery = this.prepareOneWordQuery(splitWords.get(0), fuzzyMatchFieldNameList, normalMatchFieldName, wordLettersMatchFieldName);
            BoolQueryBuilder secondWordQuery = this.prepareOneWordQuery(splitWords.get(1), fuzzyMatchFieldNameList, normalMatchFieldName, wordLettersMatchFieldName);
            if (firstWordQuery == null || secondWordQuery == null) continue;
            BoolQueryBuilder curWordQueryBuilder = QueryBuilders.boolQuery();
            curWordQueryBuilder.must((QueryBuilder)firstWordQuery).must((QueryBuilder)secondWordQuery).queryName("fh_" + c);
            preparedQueryBuilderList.add(curWordQueryBuilder);
            ++c;
            LinkedHashSet<String> querySentenceMatchedFieldNames = new LinkedHashSet<String>(fuzzyMatchFieldNameList);
            querySentenceMatchedFieldNames.add(normalMatchFieldName);
            querySentenceMatchedFieldNames.add(wordLettersMatchFieldName);
        }
        return preparedQueryBuilderList;
    }

    private BoolQueryBuilder prepareOneWordQuery(String word, List<String> fuzzyMatchFieldNameList, String normalMatchFieldName, String wordLettersMatchFieldName) {
        if (word.length() < 2) {
            return null;
        }
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        this.queryUsedFieldNameSet.add(normalMatchFieldName);
        queryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)normalMatchFieldName, (Object)word));
        queryBuilder.should((QueryBuilder)QueryBuilders.prefixQuery((String)normalMatchFieldName, (String)word));
        this.queryUsedFieldNameSet.add(wordLettersMatchFieldName);
        queryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)wordLettersMatchFieldName, (Object)word).analyzer("whitespace"));
        if (word.length() > 3) {
            for (String fieldName : fuzzyMatchFieldNameList) {
                this.queryUsedFieldNameSet.add(fieldName);
                queryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)fieldName, (Object)word));
            }
        }
        return queryBuilder;
    }

    private BoolQueryBuilder buildPredictQuery(List<Term> termList, List<String> fuzzyMatchFieldNameList) {
        if (CollectionUtils.isEmpty(termList)) {
            return null;
        }
        PredictParams predictParams = this.context.getBizSysConfig().getPredictParams();
        long start = System.currentTimeMillis();
        List<SymSpell.SuggestItem> predictions = PredictionBuilder.getPredictions(termList, predictParams);
        if (predictions == null || predictions.isEmpty()) {
            return null;
        }
        this.context.setPredictTookMillis(System.currentTimeMillis() - start);
        this.context.setPredictions(predictions);
        BoolQueryBuilder termsQuery = QueryBuilders.boolQuery();
        for (String fieldName : fuzzyMatchFieldNameList) {
            for (SymSpell.SuggestItem prediction : predictions) {
                termsQuery.should((QueryBuilder)QueryBuilders.matchQuery((String)fieldName, (Object)prediction.term).boost(this.boost));
            }
            for (int i = predictParams.getTermNr(); i < termList.size(); ++i) {
                termsQuery.should((QueryBuilder)QueryBuilders.matchQuery((String)fieldName, (Object)termList.get(i).getTermStr()).boost(this.boost));
            }
        }
        termsQuery.queryName("check_fuzzy_predict");
        return termsQuery;
    }

    private BoolQueryBuilder buildFuzzyQuery(List<Term> workTermList, int wordLengthLimit, List<String> fuzzyMatchFieldNameList, String normalMatchFieldName, String curAnalyzerName) {
        if (FuzzinessQueryMode.PREDICT == this.context.getBizSysConfig().getFuzzinessQueryMode()) {
            return this.buildPredictQuery(workTermList, fuzzyMatchFieldNameList);
        }
        if (CollectionUtils.isEmpty(workTermList) || !this.context.isEnableFuzziness()) {
            return null;
        }
        if (!SearchUtils.isLatin(this.q)) {
            return QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)this.matchFieldName, (Object)this.q).operator(Operator.OR).queryName("check_other_not_latin"));
        }
        BoolQueryBuilder mainQueryBuilder = null;
        for (int i = 0; i < Math.min(3, workTermList.size()); ++i) {
            Term fuzzyTerm = workTermList.get(i);
            int len = workTermList.get(i).getTermStr().trim().length();
            if (workTermList.size() > 1 && len <= wordLengthLimit || workTermList.size() == 1 && len < 5) continue;
            MatchQueryBuilder queryItem = null;
            ArrayList<MatchQueryBuilder> queryBuilderList = new ArrayList<MatchQueryBuilder>();
            for (String string : fuzzyMatchFieldNameList) {
                String fuzzyTermStr = SearchUtils.takeStrByPrefixLimit(fuzzyTerm.getTermStr(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT);
                queryItem = (MatchQueryBuilder)((MatchQueryBuilder)QueryBuilders.matchQuery((String)string, (Object)fuzzyTermStr).fuzziness((Object)Fuzziness.fromEdits((int)this.distance)).boost(this.boost * 2.0f)).queryName("fuzzy_1");
                queryBuilderList.add(queryItem);
                if (!StringUtils.isEmpty(curAnalyzerName)) {
                    queryItem.analyzer(curAnalyzerName);
                }
                if (fuzzyTerm.getTermStr().length() >= 7) {
                    queryItem = (MatchQueryBuilder)((MatchQueryBuilder)QueryBuilders.matchQuery((String)string, (Object)fuzzyTermStr).fuzziness((Object)Fuzziness.fromEdits((int)(this.distance + 1))).prefixLength(1).boost(this.boost)).queryName("fuzzy_prefix_2");
                    queryBuilderList.add(queryItem);
                    queryItem.analyzer("whitespace");
                    queryItem = (MatchQueryBuilder)((MatchQueryBuilder)QueryBuilders.matchQuery((String)string, (Object)fuzzyTermStr).fuzziness((Object)Fuzziness.fromEdits((int)(this.distance + 1))).boost(this.boost * 0.5f)).queryName("fuzzy_2");
                    queryBuilderList.add(queryItem);
                    if (StringUtils.isEmpty(curAnalyzerName)) continue;
                    queryItem.analyzer(curAnalyzerName);
                    continue;
                }
                queryItem = (MatchQueryBuilder)((MatchQueryBuilder)QueryBuilders.matchQuery((String)string, (Object)fuzzyTermStr).fuzziness((Object)1).prefixLength(1).boost(this.boost * 3.0f)).queryName("fuzzy_prefix_1_");
                queryBuilderList.add(queryItem);
                queryItem.analyzer("whitespace");
            }
            DisMaxQueryBuilder fuzzyQueryMatch = null;
            for (QueryBuilder queryBuilder : queryBuilderList) {
                if (queryBuilder == null) continue;
                if (fuzzyQueryMatch == null) {
                    fuzzyQueryMatch = QueryBuilders.disMaxQuery();
                }
                fuzzyQueryMatch.add(queryBuilder);
            }
            String string = "check_fuzzy_query_" + this.matchsentenceCount.incrementAndGet();
            BoolQueryBuilder subFuzzyQuery = (BoolQueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)fuzzyQueryMatch).queryName(string);
            this.queryUsedFieldNameSet.addAll(fuzzyMatchFieldNameList);
            for (Term term : workTermList) {
                if (term.equals(fuzzyTerm)) continue;
                MatchQueryBuilder normalQueryItem = QueryBuilders.matchQuery((String)normalMatchFieldName, (Object)term.getTermStr());
                this.queryUsedFieldNameSet.add(normalMatchFieldName);
                subFuzzyQuery.must((QueryBuilder)normalQueryItem);
                if (StringUtils.isEmpty(curAnalyzerName)) continue;
                normalQueryItem.analyzer(curAnalyzerName);
            }
            if (mainQueryBuilder == null) {
                mainQueryBuilder = QueryBuilders.boolQuery();
            }
            mainQueryBuilder.should((QueryBuilder)subFuzzyQuery).queryName("fuzzy_query");
            LinkedHashSet<String> querySentenceMatchedFieldNames = new LinkedHashSet<String>(fuzzyMatchFieldNameList);
            querySentenceMatchedFieldNames.add(normalMatchFieldName);
            DefaultKeyValue querySentenceAndMatchFieldNamePair = new DefaultKeyValue((Object)string, querySentenceMatchedFieldNames);
            this.querySentenceMatchedFieldNamePairsList.add(querySentenceAndMatchFieldNamePair);
        }
        return mainQueryBuilder;
    }

    private BoolQueryBuilder buildCompositeKeywordFuzzyQuery(List<Term> workTermList, int wordLengthLimit, String fuzzyMatchFieldName, String normalMatchFieldName) {
        if (CollectionUtils.isEmpty(workTermList)) {
            return null;
        }
        if (!SearchUtils.isLatin(this.q)) {
            return null;
        }
        BoolQueryBuilder mainQueryBuilder = null;
        for (int i = 0; i < Math.min(3, workTermList.size()); ++i) {
            Term fuzzyTerm = workTermList.get(i);
            if (workTermList.get(i).getTermStr().trim().length() < wordLengthLimit) continue;
            if (!SearchUtils.isLatin(fuzzyTerm.getTermStr())) {
                return null;
            }
            BoolQueryBuilder subFuzzyQuery = QueryBuilders.boolQuery();
            MatchQueryBuilder queryItem = QueryBuilders.matchQuery((String)fuzzyMatchFieldName, (Object)SearchUtils.takeStrByPrefixLimit(fuzzyTerm.getTermStr(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT)).operator(Operator.AND);
            this.queryUsedFieldNameSet.add(fuzzyMatchFieldName);
            subFuzzyQuery.must((QueryBuilder)queryItem);
            for (Term term : workTermList) {
                if (term.equals(fuzzyTerm)) continue;
                MatchQueryBuilder normalQueryItem = QueryBuilders.matchQuery((String)normalMatchFieldName, (Object)term.getTermStr()).analyzer("whitespace");
                this.queryUsedFieldNameSet.add(normalMatchFieldName);
                subFuzzyQuery.must((QueryBuilder)normalQueryItem);
            }
            if (mainQueryBuilder == null) {
                mainQueryBuilder = QueryBuilders.boolQuery();
            }
            mainQueryBuilder.should((QueryBuilder)subFuzzyQuery.queryName("check_composite_fuzzy")).queryName("composite_fuzzy");
        }
        LinkedHashSet<String> querySentenceMatchedFieldNames = new LinkedHashSet<String>();
        querySentenceMatchedFieldNames.add(fuzzyMatchFieldName);
        querySentenceMatchedFieldNames.add(normalMatchFieldName);
        DefaultKeyValue querySentenceAndMatchFieldNamePair = new DefaultKeyValue((Object)"check_composite_fuzzy", querySentenceMatchedFieldNames);
        this.querySentenceMatchedFieldNamePairsList.add(querySentenceAndMatchFieldNamePair);
        return mainQueryBuilder;
    }

    private BoolQueryBuilder buildTermInOtherWordFuzzyQuery(List<Term> workTermList, int wordLengthLimit, String fuzzyMatchFieldName, String normalMatchFieldName) {
        if (CollectionUtils.isEmpty(workTermList)) {
            return null;
        }
        if (!SearchUtils.isLatin(this.q)) {
            return null;
        }
        BoolQueryBuilder mainQueryBuilder = null;
        for (int i = 0; i < Math.min(3, workTermList.size()); ++i) {
            Term fuzzyTerm = workTermList.get(i);
            if (workTermList.get(i).getTermStr().trim().length() < wordLengthLimit) continue;
            if (!SearchUtils.isLatin(fuzzyTerm.getTermStr())) {
                return null;
            }
            BoolQueryBuilder subFuzzyQuery = QueryBuilders.boolQuery();
            MatchQueryBuilder queryItem = QueryBuilders.matchQuery((String)fuzzyMatchFieldName, (Object)SearchUtils.takeStrByPrefixLimit(fuzzyTerm.getTermStr(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT)).operator(Operator.AND);
            this.queryUsedFieldNameSet.add(fuzzyMatchFieldName);
            subFuzzyQuery.must((QueryBuilder)queryItem);
            for (Term term : workTermList) {
                if (term.equals(fuzzyTerm)) continue;
                MatchQueryBuilder normalQueryItem = QueryBuilders.matchQuery((String)normalMatchFieldName, (Object)SearchUtils.takeStrByPrefixLimit(term.getTermStr(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT)).analyzer("whitespace");
                this.queryUsedFieldNameSet.add(normalMatchFieldName);
                subFuzzyQuery.must((QueryBuilder)normalQueryItem);
            }
            if (mainQueryBuilder == null) {
                mainQueryBuilder = QueryBuilders.boolQuery();
            }
            mainQueryBuilder.should((QueryBuilder)subFuzzyQuery.queryName("check_TermInOtherWord_fuzzy")).queryName("TermInOtherWord_fuzzy");
        }
        LinkedHashSet<String> querySentenceMatchedFieldNames = new LinkedHashSet<String>();
        querySentenceMatchedFieldNames.add(fuzzyMatchFieldName);
        querySentenceMatchedFieldNames.add(normalMatchFieldName);
        DefaultKeyValue querySentenceAndMatchFieldNamePair = new DefaultKeyValue((Object)"check_TermInOtherWord_fuzzy", querySentenceMatchedFieldNames);
        this.querySentenceMatchedFieldNamePairsList.add(querySentenceAndMatchFieldNamePair);
        return mainQueryBuilder;
    }

    private List<Map<String, List<Term>>> tryMoreCompositedWordTerm(List<Term> workTermList) {
        String word_1;
        String word_0;
        ArrayList<Term> helpTermList = new ArrayList<Term>();
        for (int i = 0; i < Math.min(3, workTermList.size()); ++i) {
            helpTermList.add(workTermList.get(i));
        }
        ArrayList<Map<String, List<Term>>> sortedTermMapList = new ArrayList<Map<String, List<Term>>>();
        if (helpTermList.size() == 3) {
            ArrayList mainTermList;
            HashMap workTermMap;
            ArrayList<Term> fuzzyTermList;
            String word_02 = ((Term)helpTermList.get(0)).getTermStr().toLowerCase();
            String word_12 = ((Term)helpTermList.get(1)).getTermStr().toLowerCase();
            String word_2 = ((Term)helpTermList.get(2)).getTermStr().toLowerCase();
            if (!word_02.contains(word_12) && !word_12.contains(word_02)) {
                fuzzyTermList = new ArrayList<Term>();
                fuzzyTermList.add(new Term(((Term)helpTermList.get(0)).getTermStr()));
                fuzzyTermList.add(new Term(((Term)helpTermList.get(1)).getTermStr()));
                workTermMap = new HashMap();
                workTermMap.put("fuzzyTerm", fuzzyTermList);
                sortedTermMapList.add(workTermMap);
                if (!(word_2.contains(word_02) || word_2.contains(word_12) || word_12.contains(word_2) || word_02.contains(word_2))) {
                    fuzzyTermList.add(new Term(((Term)helpTermList.get(2)).getTermStr()));
                } else {
                    mainTermList = new ArrayList();
                    mainTermList.add(helpTermList.get(2));
                    workTermMap.put("mainTerm", mainTermList);
                }
            }
            if (!word_02.contains(word_2) || !word_2.contains(word_02)) {
                fuzzyTermList = new ArrayList();
                fuzzyTermList.add(new Term(((Term)helpTermList.get(0)).getTermStr()));
                fuzzyTermList.add(new Term(((Term)helpTermList.get(2)).getTermStr()));
                workTermMap = new HashMap();
                workTermMap.put("fuzzyTerm", fuzzyTermList);
                sortedTermMapList.add(workTermMap);
                if (!(word_12.contains(word_02) || word_12.contains(word_2) || word_2.contains(word_12) || word_02.contains(word_12))) {
                    fuzzyTermList.add(new Term(((Term)helpTermList.get(1)).getTermStr()));
                } else {
                    mainTermList = new ArrayList();
                    mainTermList.add(helpTermList.get(1));
                    workTermMap.put("mainTerm", mainTermList);
                }
            }
            if (!word_12.contains(word_2) || !word_2.contains(word_12)) {
                fuzzyTermList = new ArrayList();
                fuzzyTermList.add(new Term(((Term)helpTermList.get(2)).getTermStr()));
                fuzzyTermList.add(new Term(((Term)helpTermList.get(1)).getTermStr()));
                workTermMap = new HashMap();
                workTermMap.put("fuzzyTerm", fuzzyTermList);
                sortedTermMapList.add(workTermMap);
                if (!(word_02.contains(word_12) || word_02.contains(word_2) || word_12.contains(word_02) || word_2.contains(word_02))) {
                    fuzzyTermList.add(new Term(((Term)helpTermList.get(0)).getTermStr()));
                } else {
                    mainTermList = new ArrayList();
                    mainTermList.add(helpTermList.get(0));
                    workTermMap.put("mainTerm", mainTermList);
                }
            }
        } else if (!(helpTermList.size() != 2 || (word_0 = ((Term)helpTermList.get(0)).getTermStr().toLowerCase()).contains(word_1 = ((Term)helpTermList.get(1)).getTermStr().toLowerCase()) && word_1.contains(word_0))) {
            ArrayList<Term> fuzzyTermList = new ArrayList<Term>();
            fuzzyTermList.add(new Term(((Term)helpTermList.get(0)).getTermStr()));
            fuzzyTermList.add(new Term(((Term)helpTermList.get(1)).getTermStr()));
            HashMap<String, ArrayList<Term>> workTermMap = new HashMap<String, ArrayList<Term>>();
            workTermMap.put("fuzzyTerm", fuzzyTermList);
            sortedTermMapList.add(workTermMap);
        }
        return sortedTermMapList;
    }

    private BoolQueryBuilder buildCompositeToWordFuzzyQuery(List<Term> workTermList, String fuzzyMatchFieldName, String normalMatchFieldName) {
        if (CollectionUtils.isEmpty(workTermList)) {
            return null;
        }
        if (!SearchUtils.isLatin(this.q)) {
            return null;
        }
        BoolQueryBuilder mainQueryBuilder = null;
        List<Map<String, List<Term>>> sortedTermList = this.tryMoreCompositedWordTerm(workTermList);
        for (Map<String, List<Term>> termMap : sortedTermList) {
            QueryBuilder finalFuzzyQuery;
            List<Term> mainTermList = termMap.get("mainTerm");
            List<Term> fuzzyTermList = termMap.get("fuzzyTerm");
            MatchQueryBuilder mainQuery = null;
            if (!CollectionUtils.isEmpty(mainTermList)) {
                mainQuery = QueryBuilders.matchQuery((String)normalMatchFieldName, (Object)SearchUtils.takeStrByPrefixLimit(mainTermList.get(0).getTermStr().toLowerCase(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT)).analyzer("whitespace");
            }
            ArrayList<MatchQueryBuilder> fuzzyQueryList = new ArrayList<MatchQueryBuilder>();
            for (Term fuzzyTerm : fuzzyTermList) {
                if (!SearchUtils.isLatin(fuzzyTerm.getTermStr())) {
                    return null;
                }
                MatchQueryBuilder fuzzyQuery = QueryBuilders.matchQuery((String)fuzzyMatchFieldName, (Object)SearchUtils.takeStrByPrefixLimit(fuzzyTerm.getTermStr().toLowerCase(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT)).analyzer("whitespace");
                fuzzyQueryList.add(fuzzyQuery);
            }
            if (fuzzyQueryList.size() > 1) {
                BoolQueryBuilder boolFinalFuzzyQuery = QueryBuilders.boolQuery();
                for (QueryBuilder queryBuilder : fuzzyQueryList) {
                    boolFinalFuzzyQuery.must(queryBuilder);
                }
                finalFuzzyQuery = boolFinalFuzzyQuery;
            } else {
                finalFuzzyQuery = fuzzyQueryList.size() == 1 ? (QueryBuilder)fuzzyQueryList.get(0) : null;
            }
            Object finalQuery = null;
            finalQuery = mainQuery != null ? (finalFuzzyQuery != null ? QueryBuilders.boolQuery().must(finalFuzzyQuery).must((QueryBuilder)mainQuery) : mainQuery) : finalFuzzyQuery;
            if (finalQuery == null) continue;
            if (mainQueryBuilder == null) {
                mainQueryBuilder = (BoolQueryBuilder)QueryBuilders.boolQuery().queryName("CompositeToWordFuzzy");
            }
            mainQueryBuilder.should(finalQuery.queryName("check_CompositeToWordFuzzy"));
        }
        LinkedHashSet<String> querySentenceMatchedFieldNames = new LinkedHashSet<String>();
        querySentenceMatchedFieldNames.add(fuzzyMatchFieldName);
        querySentenceMatchedFieldNames.add(normalMatchFieldName);
        DefaultKeyValue querySentenceAndMatchFieldNamePair = new DefaultKeyValue((Object)"check_CompositeToWordFuzzy", querySentenceMatchedFieldNames);
        this.querySentenceMatchedFieldNamePairsList.add(querySentenceAndMatchFieldNamePair);
        return mainQueryBuilder;
    }

    private BoolQueryBuilder buildPrefixFuzzyQuery(List<Term> workTermList, int wordLengthLimit, List<String> fuzzyMatchFieldName, String normalMatchFieldName) {
        if (CollectionUtils.isEmpty(workTermList)) {
            return null;
        }
        if (!SearchUtils.isLatin(this.q)) {
            return null;
        }
        BoolQueryBuilder mainQueryBuilder = null;
        int doubleWordLengthLimit = 2 * wordLengthLimit;
        BoolQueryBuilder sentencePrefixQuery = null;
        if (workTermList.size() > 1) {
            StringBuilder buffer = new StringBuilder();
            for (int index = 0; index < workTermList.size() - 1; ++index) {
                buffer.append(SearchUtils.takeStrByPrefixLimit(workTermList.get(index).getTermStr(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT)).append(" ");
            }
            StringBuilder prefixStrBuffer = new StringBuilder();
            for (Term term : workTermList) {
                prefixStrBuffer.append(SearchUtils.takeStrByPrefixLimit(term.getTermStr(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT));
            }
            MatchQueryBuilder prefixWordQuery = QueryBuilders.matchQuery((String)this.allLettersMatchFieldName, (Object)prefixStrBuffer.toString().toLowerCase()).analyzer("whitespace").operator(Operator.AND);
            AbstractQueryBuilder matchQuery = QueryBuilders.matchPhraseQuery((String)normalMatchFieldName, (Object)buffer.toString()).boost(2.0f);
            sentencePrefixQuery = (BoolQueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)prefixWordQuery).must((QueryBuilder)matchQuery).queryName("check_prefix_sentence_wc");
            LinkedHashSet<String> querySentenceMatchedFieldNames = new LinkedHashSet<String>();
            querySentenceMatchedFieldNames.add(this.allLettersMatchFieldName);
            querySentenceMatchedFieldNames.add(normalMatchFieldName);
            DefaultKeyValue querySentenceAndMatchFieldNamePair = new DefaultKeyValue((Object)"check_prefix_sentence_wc", querySentenceMatchedFieldNames);
            this.querySentenceMatchedFieldNamePairsList.add(querySentenceAndMatchFieldNamePair);
        }
        for (int i = 0; i < Math.min(3, workTermList.size()); ++i) {
            Term fuzzyTerm = workTermList.get(i);
            if (workTermList.get(i).getTermStr().trim().length() < wordLengthLimit) continue;
            if (!SearchUtils.isLatin(fuzzyTerm.getTermStr())) {
                return null;
            }
            BoolQueryBuilder subFuzzyQuery = QueryBuilders.boolQuery();
            String opTermStr = SearchUtils.delPunctuationChars(fuzzyTerm.getTermStr());
            char[] regExpChars = new char[Math.min(5, opTermStr.length())];
            Arrays.fill(regExpChars, '?');
            StringBuilder stringBuffer = new StringBuilder();
            for (int k = 1; k <= Math.min(5, opTermStr.length()); ++k) {
                stringBuffer.append(new String(Arrays.copyOf(regExpChars, k))).append("|");
            }
            stringBuffer.append("?");
            String regExpPatten = opTermStr + "(" + stringBuffer + ")";
            BoolQueryBuilder queryItem = QueryBuilders.boolQuery();
            for (String fieldName : fuzzyMatchFieldName) {
                RegexpQueryBuilder subQueryItem = QueryBuilders.regexpQuery((String)fieldName, (String)regExpPatten);
                queryItem.should((QueryBuilder)subQueryItem);
            }
            this.queryUsedFieldNameSet.addAll(fuzzyMatchFieldName);
            subFuzzyQuery.must((QueryBuilder)queryItem);
            for (Term term : workTermList) {
                if (term.equals(fuzzyTerm)) continue;
                MatchQueryBuilder normalQueryItem = QueryBuilders.matchQuery((String)normalMatchFieldName, (Object)term.getTermStr()).analyzer("whitespace");
                this.queryUsedFieldNameSet.add(normalMatchFieldName);
                subFuzzyQuery.must((QueryBuilder)normalQueryItem);
            }
            if (mainQueryBuilder == null) {
                mainQueryBuilder = (BoolQueryBuilder)QueryBuilders.boolQuery().queryName("prefixFuzzy_sentence");
            }
            mainQueryBuilder.should((QueryBuilder)subFuzzyQuery.queryName("check_prefixFuzzy_sentence_" + i));
            LinkedHashSet<String> querySentenceMatchedFieldNames = new LinkedHashSet<String>(fuzzyMatchFieldName);
            querySentenceMatchedFieldNames.add(normalMatchFieldName);
            DefaultKeyValue querySentenceAndMatchFieldNamePair = new DefaultKeyValue((Object)"check_prefixFuzzy_sentence", querySentenceMatchedFieldNames);
            this.querySentenceMatchedFieldNamePairsList.add(querySentenceAndMatchFieldNamePair);
        }
        if (mainQueryBuilder != null && sentencePrefixQuery != null) {
            mainQueryBuilder.should(sentencePrefixQuery);
        }
        return mainQueryBuilder;
    }

    @Override
    public GeneralFuzzyMatcher boost(float boost) {
        this.boost = boost;
        return this;
    }

    public GeneralFuzzyMatcher analyzer(String analyzerName) {
        this.analyzerName = analyzerName;
        return this;
    }

    @Override
    public void prepareByConfig(MatcherConfig config) {
        String strPrefixFieldName;
        this.matcherConfig = config;
        MatcherParams matcherParams = this.matcherConfig.getMatcherParams();
        this.matchFieldName = !StringUtils.isEmpty(matcherParams.getMatchFieldName()) ? matcherParams.getMatchFieldName() : this.context.fuzzySubIndexFieldName;
        this.distanceType = DISTANCE_TYPE.valueOf(matcherParams.getExtParams().get("distanceType").toString());
        this.distance = Integer.parseInt(this.matcherConfig.getMatcherParams().getExtParams().get("distance").toString());
        this.boost = this.matcherConfig.getMatcherParams().getBoost();
        this.globalBoost = this.matcherConfig.getMatcherParams().getGlobalBoost();
        this.wordLettersMatchFieldName = this.getExtParamsValue("wordLettersMatchFieldName", this.matchFieldName);
        this.allLettersMatchFieldName = this.getExtParamsValue("allLettersMatchFieldName", this.matchFieldName);
        this.wildCardMatchFieldName = this.getExtParamsValue("wildCardMatchFieldName", this.matchFieldName);
        this.fuzzyAnalyzer = this.getExtParamsValue("fuzzyAnalyzerName", new String[0]);
        String strFuzzyFieldName = this.getExtParamsValue("fuzzyMatchFieldName", new String[0]);
        if (!StringUtils.isEmpty(strFuzzyFieldName)) {
            this.fuzzyMatchFieldNames.addAll(Arrays.asList(strFuzzyFieldName.split(",")));
        }
        if (this.fuzzyMatchFieldNames.isEmpty()) {
            this.fuzzyMatchFieldNames.add(this.matchFieldName);
        }
        if (!StringUtils.isEmpty(strPrefixFieldName = this.getExtParamsValue("prefixMatchFieldName", new String[0]))) {
            this.prefixMatchFieldName.addAll(Arrays.asList(strPrefixFieldName.split(",")));
        }
        if (this.prefixMatchFieldName.isEmpty()) {
            this.prefixMatchFieldName.add(this.matchFieldName);
        }
        if (!StringUtils.isEmpty(this.matcherConfig.getIdName())) {
            this.matchName = this.matcherConfig.getIdName();
        }
        super.prepareByConfig(this.matcherConfig);
        this.init();
    }

    public static enum DISTANCE_TYPE {
        BY_WORD(1),
        BY_SENTENCE(2);

        private int type;

        private DISTANCE_TYPE(int type) {
            this.type = type;
        }
    }
}

