/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.matcher;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.matcher.AbstractFuzzyMatcher;
import com.valor.common.search.engine.matcher.CompareableTerm;
import com.valor.common.search.engine.matcher.Matcher;
import com.valor.common.search.engine.matcher.Term;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.SearchUtils;
import com.valor.common.search.engine.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiFieldMininumStrMatcher
extends AbstractFuzzyMatcher {
    Logger logger = LoggerFactory.getLogger(MultiFieldMininumStrMatcher.class);
    public static final String PREFIX_LENGTH_RATE = "mininumstrmatcher_prefix_length_rate";
    public static final String SUF_LENGTH_RATE = "mininumstrmatcher_suf_length_rate";
    public static final String MININUM_STR_LENGTH_RATE = "mininumstrmatcher_mininum_str_rate";
    public static final String PREFIX_LENGTH = "mininumstrmatcher_prefix_length";
    public static final String SUF_LENGTH = "mininumstrmatcher_suf_length";
    public static final String MININUM_STR_LENGTH = "mininumstrmatcher_total_str_length";
    public static final String DEFAULT_MATCH_NAME = "MininumStrMatcher";
    public static final float DEFAULT_BOOST = 0.8f;
    public static final int MINIMUQ_MAX_LEN = 9;
    public static final int DEFAULT_PREFIX_LENGTH = 2;
    public static final int DEFAULT_SUF_LENGTH = 2;
    public static final int DEFAULT_MININUM_STR_MAX_LENGTH = 10;
    public static final float DEFAULT_PREFIX_LENGTH_RATE = 0.5f;
    public static final float DEFAULT_MININUM_STR_LENGTH_RATE = 0.6666667f;
    private Set<Term> mainTermList = new HashSet<Term>();
    private Set<Term> aliasTermList = new HashSet<Term>();
    private int prefixLength = 2;
    private int sufLength = 2;
    private float prefixRate;
    private float mininumStrLengthRate;
    private int aliasQueryTermType = 0;
    private Set<String> queryUsedFieldNameSet = new HashSet<String>();
    private final List<ImmutablePair<String, Float>> multiMatchFieldNames = new ArrayList<ImmutablePair<String, Float>>();

    public MultiFieldMininumStrMatcher(RequestContext context, List<ImmutablePair<String, Float>> matchFieldNameList) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.boost = 0.8f;
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_TWO_CHARS, "clean_no_char_2_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_ONE_CHARS, "cutsomeword");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_THREE_CHARS, "clean_no_char_3_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_FOUR_CHARS, "clean_no_char_4_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_FIVE_CHARS, "clean_no_char_5_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_SIX_CHARS, "clean_no_char_6_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_SEVEN_CHARS, "clean_no_char_7_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_EIGHT_CHARS, "clean_no_char_8_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_MORE_CHARS, "clean_no_char_9_10_ngram");
        this.q = context.getQ().trim();
        this.context = context;
        this.multiMatchFieldNames.addAll(matchFieldNameList);
        this.initial();
    }

    public MultiFieldMininumStrMatcher(RequestContext context, String matchName, List<ImmutablePair<String, Float>> matchFieldNameList) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.boost = 0.8f;
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_TWO_CHARS, "clean_no_char_2_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_ONE_CHARS, "cutsomeword");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_THREE_CHARS, "clean_no_char_3_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_FOUR_CHARS, "clean_no_char_4_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_FIVE_CHARS, "clean_no_char_5_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_SIX_CHARS, "clean_no_char_6_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_SEVEN_CHARS, "clean_no_char_7_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_EIGHT_CHARS, "clean_no_char_8_10_ngram");
        this.analyzerNameMap.put(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_MORE_CHARS, "clean_no_char_9_10_ngram");
        this.q = context.getQ().trim();
        this.context = context;
        this.matchName = matchName;
        this.multiMatchFieldNames.addAll(matchFieldNameList);
        this.initial();
    }

    private void initial() {
        this.mininumStrLengthRate = 0.6666667f;
        this.prefixRate = 0.5f;
        this.prefixLength = 2;
        this.sufLength = 2;
        ArrayList<String> multiFieldNamesList = new ArrayList<String>();
        for (ImmutablePair<String, Float> p : this.multiMatchFieldNames) {
            multiFieldNamesList.add((String)p.getLeft());
        }
        this.context.saveMultiMatcheNameandMatcheFieldNamePair(this.matchName, multiFieldNamesList);
    }

    @Override
    public Matcher.MATCHER_TYPE getMatcherType() {
        return Matcher.MATCHER_TYPE.MININUM_STR;
    }

    @Override
    public MultiFieldMininumStrMatcher assembly() {
        this.mainTermList.clear();
        this.aliasTermList.clear();
        this.q = StringUtils.delPunctWithNoSpace(this.context.getQ().replaceAll("-", " ")).trim();
        int queryTermType = this.queryTermType().ordinal();
        switch (queryTermType) {
            case 1: {
                this.assemblyForOneWord(this.q.trim());
                break;
            }
            case 2: {
                this.assemblyForTwoWord();
                String aliasQ = SearchUtils.takeAliasStr(this.q, 3).trim();
                if (!StringUtils.isEmpty(aliasQ) && aliasQ.split("([\\s\\p{Zs}])+").length < this.q.split("([\\s\\p{Zs}])+").length) {
                    this.assemblyForOneWord(aliasQ);
                }
                this.boost = 1.0f;
                if (this.globalBoost != 1.0f) break;
                this.globalBoost = 1.8f;
                break;
            }
            case 4: {
                this.assemblyForThreeWord();
                String aliasQ = SearchUtils.takeAliasStr(this.q, 3).trim();
                if (!StringUtils.isEmpty(aliasQ) && aliasQ.split("([\\s\\p{Zs}])+").length < this.q.split("([\\s\\p{Zs}])+").length) {
                    this.context.queryExecutePartialWordAlias = aliasQ;
                    int nLen = aliasQ.split("([\\s\\p{Zs}])+").length;
                    if (nLen == 1) {
                        this.assemblyForOneWord(aliasQ);
                        this.aliasQueryTermType = Matcher.QUERY_TERM_TYPE.ONE_WORD.ordinal();
                    } else if (nLen == 2) {
                        this.assemblyForTwoWord(aliasQ);
                        this.aliasQueryTermType = Matcher.QUERY_TERM_TYPE.TWO_WORD.ordinal();
                    }
                }
                this.boost = 1.0f;
                if (this.globalBoost != 1.0f) break;
                this.globalBoost = 1.8f;
                break;
            }
            default: {
                String q = this.q.toLowerCase();
                q = q.replaceAll("-", " ").trim();
                String[] newQs = q.split("([\\s\\p{Zs}])+");
                int charsCount = 0;
                for (String str : newQs) {
                    charsCount += str.length();
                }
                StringBuilder sBuilder = new StringBuilder();
                for (int i = 1; i < newQs.length - 1; ++i) {
                    sBuilder.append(StringUtils.delPunct(newQs[i]));
                }
                int midCharsCount = sBuilder.length();
                float wantedCharsCount = Math.round((float)charsCount * 0.65f);
                int firstCharsLen = Math.round((wantedCharsCount - (float)midCharsCount) * (float)newQs[0].length() / (float)(charsCount - midCharsCount) * 1.0f);
                int tailCharsLen = (int)wantedCharsCount - midCharsCount - firstCharsLen;
                String firstChars = MultiFieldMininumStrMatcher.getSuffix(StringUtils.delPunct(newQs[0]), Math.max(2, firstCharsLen));
                String tailChars = MultiFieldMininumStrMatcher.getPrefix(StringUtils.delPunct(newQs[newQs.length - 1]), Math.max(2, tailCharsLen));
                String midChars = sBuilder.toString();
                String minimalQ = firstChars + midChars + tailChars;
                Term firstTerm = new Term(minimalQ);
                if (StringUtils.isEmpty(this.matchFieldName)) {
                    firstTerm.setMatchedFieldName(this.context.minimumSubIndexFieldName);
                } else {
                    firstTerm.setMatchedFieldName(this.matchFieldName);
                }
                if (StringUtils.isEmpty(this.analyzerName)) {
                    firstTerm.setAnalyzer(this.context.wordAnalyzerName);
                } else {
                    firstTerm.setAnalyzer(this.analyzerName);
                }
                this.mainTermList.add(firstTerm);
                this.boost = 1.0f;
                if (this.globalBoost != 1.0f) break;
                this.globalBoost = 1.5f;
                break;
            }
        }
        return this;
    }

    @Override
    public QueryBuilder buildBase() {
        ArrayList<MultiMatchQueryBuilder> queryList = new ArrayList<MultiMatchQueryBuilder>();
        Map<String, List<Term>> termSplitByFieldNameMap = this.splitTermIntoGroupByFieldName(this.mainTermList.stream().collect(Collectors.toList()));
        for (Map.Entry<String, List<Term>> entry : termSplitByFieldNameMap.entrySet()) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (ImmutablePair<String, Float> p : this.multiMatchFieldNames) {
                String newFieldName = entry.getKey().replaceAll("NONE", (String)p.getLeft());
                hashMap.put(newFieldName, p.getRight());
            }
            this.queryUsedFieldNameSet.addAll(hashMap.keySet());
            for (Term term : entry.getValue()) {
                MultiMatchQueryBuilder query = ((MultiMatchQueryBuilder)QueryBuilders.multiMatchQuery((Object)term.getTermStr(), (String[])((String[])hashMap.keySet().stream().toArray(String[]::new))).boost(term.getBoost())).fields(hashMap).tieBreaker(1.0f);
                if (!StringUtils.isEmpty(term.getAnalyzer())) {
                    query.analyzer(term.getAnalyzer());
                }
                if (term.getOperator() != null) {
                    query.operator(term.getOperator());
                }
                queryList.add(query);
            }
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        for (QueryBuilder queryBuilder : queryList) {
            boolQueryBuilder.should(queryBuilder);
        }
        boolQueryBuilder.minimumShouldMatch(1);
        this.context.putQueryMatcherMatchedFieldNameMap(this.matchName, CollectionUtils.arrayToList(this.queryUsedFieldNameSet.toArray()));
        return boolQueryBuilder.boost(this.boost);
    }

    private void assemblyForOneWord(String qStr) {
        String q = StringUtils.delPunct(qStr.toLowerCase().trim());
        this.mainTermList.clear();
        this.aliasTermList.clear();
        int charMinLenth = Math.round(0.75f * (float)q.length());
        if (q.length() >= 8) {
            charMinLenth = Math.round(0.66f * (float)q.length());
        }
        Term term = new Term(q);
        this.mainTermList.add(term);
        this.boost = 1.0f;
        if (this.globalBoost == 1.0f) {
            this.globalBoost = 0.8f;
        }
        String _matchFiedName = "";
        _matchFiedName = StringUtils.isEmpty(this.matchFieldName) ? this.context.minimumSubIndexFieldName : this.matchFieldName;
        term.setMatchedFieldName(_matchFiedName);
        if (StringUtils.isEmpty(this.analyzerName)) {
            term.setAnalyzer(this.getMinimalAnalyzerName(charMinLenth));
        } else {
            term.setAnalyzer(this.analyzerName);
        }
    }

    private void assemblyForTwoWord() {
        this.assemblyForTwoWord(this.q);
    }

    private void assemblyForTwoWord(String workQ) {
        String q = workQ.toLowerCase();
        q = q.replaceAll("-", " ").trim();
        String[] newQs = q.split("([\\s\\p{Zs}])+");
        this.assemblyForTwoWord(1.0f, newQs);
    }

    private Term makeTerm(String str, float boost) {
        CompareableTerm term = new CompareableTerm(str);
        if (StringUtils.isEmpty(this.matchFieldName)) {
            term.setMatchedFieldName(this.context.minimumSubIndexFieldName);
        } else {
            term.setMatchedFieldName(this.matchFieldName);
        }
        if (StringUtils.isEmpty(this.analyzerName)) {
            int len = str.trim().length();
            int analyzerLen = 4;
            if (len >= 6) {
                analyzerLen = len - 2;
            }
            term.setAnalyzer(this.getMinimalAnalyzerName(analyzerLen));
            term.setOperator(Operator.AND);
        } else {
            term.setAnalyzer(this.analyzerName);
        }
        term.setBoost(boost);
        return term;
    }

    private void assemblyForTwoWord(float boost, String[] newQs) {
        newQs[0] = StringUtils.delPunct(newQs[0]);
        newQs[1] = StringUtils.delPunct(newQs[1]);
        this.parseMainStrForTwoWords(newQs);
        this.parseLeaderTailerStr4TwoWord(newQs);
    }

    private void parseLeaderTailerStr4TwoWord(String[] newQs) {
        String minimalQ = "";
        String tempQ = newQs[0] + newQs[1];
        if (newQs[0].length() >= 7 || newQs[1].length() >= 7) {
            if (newQs[0].length() >= newQs[1].length()) {
                minimalQ = newQs[0] + newQs[1].substring(0, Math.min(2, newQs[1].length()));
                this.mainTermList.add(this.makeTerm(minimalQ, 1.0f));
                minimalQ = newQs[0] + newQs[1].substring(0, 1);
                this.mainTermList.add(this.makeTerm(minimalQ, 1.0f));
                minimalQ = newQs[1].substring(newQs[1].length() - Math.min(2, newQs[1].length())) + newQs[0];
                this.mainTermList.add(this.makeTerm(minimalQ, 0.5f));
                minimalQ = newQs[1].substring(newQs[1].length() - 1) + newQs[0];
                this.mainTermList.add(this.makeTerm(minimalQ, 0.5f));
                if ((double)((float)(newQs[0].length() - newQs[1].length()) * 1.0f / (float)newQs[1].length()) < 0.45) {
                    minimalQ = newQs[1] + newQs[0].substring(0, Math.round((float)newQs[0].length() * 0.5f));
                    this.mainTermList.add(this.makeTerm(minimalQ, 1.0f));
                    minimalQ = newQs[0].substring(newQs[0].length() - Math.round((float)newQs[0].length() * 0.45f)) + newQs[1];
                    this.mainTermList.add(this.makeTerm(minimalQ, 0.5f));
                }
            } else if (newQs[1].length() > newQs[0].length()) {
                minimalQ = newQs[0].substring(newQs[0].length() - Math.min(2, newQs[0].length())) + newQs[1];
                this.mainTermList.add(this.makeTerm(minimalQ, 1.0f));
                minimalQ = newQs[0].substring(newQs[0].length() - 1) + newQs[1];
                this.mainTermList.add(this.makeTerm(minimalQ, 1.0f));
                minimalQ = newQs[1] + newQs[0].substring(0, 1);
                this.mainTermList.add(this.makeTerm(minimalQ, 0.5f));
                minimalQ = newQs[1] + newQs[0].substring(0, Math.min(2, newQs[0].length()));
                this.mainTermList.add(this.makeTerm(minimalQ, 0.5f));
                if ((double)((float)(newQs[1].length() - newQs[0].length()) * 1.0f / (float)newQs[0].length()) < 0.45) {
                    minimalQ = newQs[1].substring(newQs[1].length() - Math.round((float)newQs[1].length() * 0.5f)) + newQs[0];
                    this.mainTermList.add(this.makeTerm(minimalQ, 0.5f));
                    minimalQ = newQs[0] + newQs[1].substring(0, Math.round((float)newQs[1].length() * 0.45f));
                    this.mainTermList.add(this.makeTerm(minimalQ, 0.5f));
                }
            }
            return;
        }
        if (tempQ.length() >= 10) {
            if (newQs[0].length() >= newQs[1].length()) {
                minimalQ = newQs[0] + newQs[1].substring(0, 2);
                this.mainTermList.add(this.makeTerm(minimalQ, 1.0f));
                minimalQ = newQs[1].substring(newQs[1].length() - 2) + newQs[0];
                this.mainTermList.add(this.makeTerm(minimalQ, 0.5f));
                if ((double)((float)(newQs[0].length() - newQs[1].length()) * 1.0f / (float)newQs[1].length()) < 0.33) {
                    minimalQ = newQs[1] + newQs[0].substring(0, 2);
                    this.mainTermList.add(this.makeTerm(minimalQ, 0.5f));
                    minimalQ = newQs[0].substring(newQs[0].length() - 2) + newQs[1];
                    this.mainTermList.add(this.makeTerm(minimalQ, 0.5f));
                } else if ((double)((float)(newQs[0].length() - newQs[1].length()) * 1.0f / (float)newQs[1].length()) <= 0.5) {
                    minimalQ = newQs[1] + newQs[0].substring(0, 3);
                    this.mainTermList.add(this.makeTerm(minimalQ, 0.5f));
                    minimalQ = newQs[0].substring(newQs[0].length() - 3) + newQs[1];
                    this.mainTermList.add(this.makeTerm(minimalQ, 0.5f));
                }
            } else if (newQs[1].length() > newQs[0].length()) {
                minimalQ = newQs[0].substring(newQs[0].length() - 2) + newQs[1];
                this.mainTermList.add(this.makeTerm(minimalQ, 1.0f));
                minimalQ = newQs[1] + newQs[0].substring(0, 2);
                this.mainTermList.add(this.makeTerm(minimalQ, 0.8f));
                if ((double)((float)(newQs[1].length() - newQs[0].length()) * 1.0f / (float)newQs[0].length()) < 0.33) {
                    minimalQ = newQs[1].substring(newQs[1].length() - 2) + newQs[0];
                    this.mainTermList.add(this.makeTerm(minimalQ, 0.8f));
                    minimalQ = newQs[0] + newQs[1].substring(0, 2);
                    this.mainTermList.add(this.makeTerm(minimalQ, 0.8f));
                } else if ((double)((float)(newQs[1].length() - newQs[0].length()) * 1.0f / (float)newQs[0].length()) <= 0.5) {
                    minimalQ = newQs[1].substring(newQs[1].length() - 3) + newQs[0];
                    this.mainTermList.add(this.makeTerm(minimalQ, 0.8f));
                    minimalQ = newQs[0] + newQs[1].substring(0, 3);
                    this.mainTermList.add(this.makeTerm(minimalQ, 0.8f));
                }
            }
        } else if (tempQ.length() < 10 && tempQ.length() > 7) {
            if (newQs[0].length() >= newQs[1].length()) {
                minimalQ = newQs[0] + newQs[1].substring(0, 1);
                this.mainTermList.add(this.makeTerm(minimalQ, 1.0f));
                minimalQ = newQs[1].substring(newQs[1].length() - 1) + newQs[0];
                this.mainTermList.add(this.makeTerm(minimalQ, 0.8f));
                if ((double)((float)(newQs[0].length() - newQs[1].length()) * 1.0f / (float)newQs[1].length()) < 0.33) {
                    minimalQ = newQs[1] + newQs[0].substring(0, 2);
                    this.mainTermList.add(this.makeTerm(minimalQ, 0.5f));
                    minimalQ = newQs[0].substring(newQs[0].length() - 2) + newQs[1];
                    this.mainTermList.add(this.makeTerm(minimalQ, 0.5f));
                }
            } else if (newQs[1].length() > newQs[0].length()) {
                minimalQ = newQs[0].substring(newQs[0].length() - 1) + newQs[1];
                this.mainTermList.add(this.makeTerm(minimalQ, 0.8f));
                minimalQ = newQs[1] + newQs[0].substring(0, 2);
                this.mainTermList.add(this.makeTerm(minimalQ, 1.0f));
                if ((double)((float)(newQs[1].length() - newQs[0].length()) * 1.0f / (float)newQs[0].length()) < 0.33) {
                    minimalQ = newQs[1].substring(newQs[1].length() - 2) + newQs[0];
                    this.mainTermList.add(this.makeTerm(minimalQ, 0.8f));
                    minimalQ = newQs[0] + newQs[1].substring(0, 2);
                    this.mainTermList.add(this.makeTerm(minimalQ, 0.8f));
                }
            }
        } else if (newQs[0].length() >= newQs[1].length()) {
            minimalQ = newQs[0] + newQs[1].substring(0, Math.min(newQs[1].length(), 2));
            this.mainTermList.add(this.makeTerm(minimalQ, 1.0f));
            minimalQ = newQs[1].substring(newQs[1].length() - Math.min(newQs[1].length(), 2)) + newQs[0];
            this.mainTermList.add(this.makeTerm(minimalQ, 0.8f));
            if ((double)((float)(newQs[0].length() - newQs[1].length()) * 1.0f / (float)newQs[1].length()) <= 0.5) {
                minimalQ = newQs[1] + newQs[0].substring(0, Math.min(newQs[0].length(), 2));
                this.mainTermList.add(this.makeTerm(minimalQ, 0.2f));
                minimalQ = newQs[0].substring(newQs[0].length() - Math.min(newQs[0].length(), 2)) + newQs[1];
                this.mainTermList.add(this.makeTerm(minimalQ, 0.2f));
            }
        } else if (newQs[1].length() > newQs[0].length()) {
            minimalQ = newQs[0].substring(newQs[0].length() - Math.min(newQs[0].length(), 2)) + newQs[1];
            this.mainTermList.add(this.makeTerm(minimalQ, 0.8f));
            minimalQ = newQs[1] + newQs[0].substring(0, Math.min(newQs[0].length(), 2));
            this.mainTermList.add(this.makeTerm(minimalQ, 1.0f));
            if ((double)((float)(newQs[1].length() - newQs[0].length()) * 1.0f / (float)newQs[0].length()) <= 0.5) {
                minimalQ = newQs[1].substring(newQs[1].length() - Math.min(newQs[1].length(), 2)) + newQs[0];
                this.mainTermList.add(this.makeTerm(minimalQ, 0.2f));
                minimalQ = newQs[0] + newQs[1].substring(0, Math.min(newQs[1].length(), 2));
                this.mainTermList.add(this.makeTerm(minimalQ, 0.2f));
            }
        }
    }

    private String normMinialStr(String token, String mainword, String prefixSubf, boolean mainAtLeft, int tokenMaxLength) {
        StringBuilder builder = new StringBuilder().append(token);
        int mainwordRemianChars = mainword.length();
        int prefixSubfRemainChars = prefixSubf.length();
        int mainwordCutChars = 0;
        int prefixSubfCutChars = 0;
        while (builder.length() > tokenMaxLength) {
            if (mainAtLeft) {
                if (prefixSubfRemainChars > 3 && mainwordCutChars > prefixSubfCutChars) {
                    builder.deleteCharAt(builder.length() - 1);
                    ++prefixSubfCutChars;
                    --prefixSubfRemainChars;
                    continue;
                }
                builder.deleteCharAt(0);
                ++mainwordCutChars;
                --mainwordRemianChars;
                continue;
            }
            if (prefixSubfRemainChars > 3 && mainwordCutChars > prefixSubfCutChars) {
                builder.deleteCharAt(0);
                ++prefixSubfCutChars;
                --prefixSubfRemainChars;
                continue;
            }
            builder.deleteCharAt(builder.length() - 1);
            ++mainwordCutChars;
            --mainwordRemianChars;
        }
        return builder.toString();
    }

    private static String getPrefix(String item, int wantedOength) {
        if (item.length() <= wantedOength) {
            return item;
        }
        return item.substring(0, wantedOength);
    }

    private static String getSuffix(String item, int wantedLength) {
        if (item.length() <= wantedLength) {
            return item;
        }
        return item.substring(item.length() - wantedLength, item.length());
    }

    private String getSuffix(String item, float rate) {
        int wantedCharsLen = Math.round((float)item.length() * rate);
        return item.substring(item.length() - wantedCharsLen);
    }

    private static String getPrefix(String item, float rate) {
        int wantedCharsLen = Math.round((float)item.length() * rate);
        return item.substring(0, wantedCharsLen);
    }

    @Override
    public Matcher.QUERY_TERM_TYPE queryTermType() {
        String q = this.getQ();
        if (q.isEmpty()) {
            return Matcher.QUERY_TERM_TYPE.NONE;
        }
        String[] newQs = (q = q.replaceAll("-", " ").trim()).split("([\\s\\p{Zs}])+");
        if (newQs.length == 1) {
            return Matcher.QUERY_TERM_TYPE.ONE_WORD;
        }
        if (newQs.length == 2) {
            return Matcher.QUERY_TERM_TYPE.TWO_WORD;
        }
        if (newQs.length == 3) {
            return Matcher.QUERY_TERM_TYPE.EXTRA_THREE_WORD;
        }
        if (newQs.length > 3) {
            return Matcher.QUERY_TERM_TYPE.MORE_WORD;
        }
        return Matcher.QUERY_TERM_TYPE.NONE;
    }

    private void assemblyForThreeWord() {
        String q = this.q.toLowerCase();
        q = q.replaceAll("-", " ").trim();
        String[] newQs = q.split("([\\s\\p{Zs}])+");
        for (int i = 0; i < newQs.length; ++i) {
            newQs[i] = StringUtils.delPunct(newQs[i]);
        }
        int charsCount = 0;
        for (String str : newQs) {
            charsCount += str.length();
        }
        StringBuilder sBuilder = new StringBuilder();
        for (int i = 1; i < newQs.length - 1; ++i) {
            sBuilder.append(newQs[i]);
        }
        int midCharsCount = sBuilder.length();
        float wantedCharsCount = Math.round((float)charsCount * 0.65f);
        int firstCharsLen = Math.round((wantedCharsCount - (float)midCharsCount) * (float)newQs[0].length() / (float)(charsCount - midCharsCount) * 1.0f);
        int tailCharsLen = (int)wantedCharsCount - midCharsCount - firstCharsLen;
        String firstChars = MultiFieldMininumStrMatcher.getSuffix(StringUtils.delPunct(newQs[0]), Math.max(2, firstCharsLen));
        String tailChars = MultiFieldMininumStrMatcher.getPrefix(StringUtils.delPunct(newQs[newQs.length - 1]), Math.max(2, tailCharsLen));
        String midChars = sBuilder.toString();
        String minimalQ = firstChars + midChars + tailChars;
        Term workTerm = this.createWorkTerm(minimalQ);
        this.mainTermList.add(workTerm);
        String newNorms = SearchUtils.tryToMissWord(q).trim();
        boolean hasInvalidWord = false;
        String[] newNormList = null;
        if (newNorms.length() != q.length()) {
            newNormList = newNorms.split("([\\s\\p{Zs}])+");
            hasInvalidWord = true;
        }
        if (hasInvalidWord) {
            minimalQ = this.finalMinimalQStr(newNormList[0], Math.round((float)charsCount * 0.7f), newNormList, 1, true);
            if (minimalQ.length() == newNormList[0].length()) {
                minimalQ = minimalQ + newNormList[1].substring(0, 1);
            }
            workTerm = this.createWorkTerm(minimalQ);
            this.mainTermList.add(workTerm);
        }
        if ((minimalQ = this.finalMinimalQStr(newQs[0] + newQs[1], Math.round(wantedCharsCount), newQs, 2, true)).length() <= newQs[0].length() + newQs[1].length()) {
            minimalQ = newQs[0] + newQs[1] + newQs[2].substring(0, 1);
        }
        workTerm = this.createWorkTerm(minimalQ);
        this.mainTermList.add(workTerm);
        if (hasInvalidWord) {
            minimalQ = this.finalMinimalQStr(newNormList[1], Math.round((float)charsCount * 0.7f), newNormList, 0, false);
            if (minimalQ.length() == newNormList[1].length()) {
                minimalQ = newNormList[0].substring(newNormList[0].length() - 1) + minimalQ;
            }
            workTerm = this.createWorkTerm(minimalQ);
            this.mainTermList.add(workTerm);
        }
        if ((minimalQ = this.finalMinimalQStr(newQs[1] + newQs[2], Math.round(wantedCharsCount), newQs, 0, false)).length() <= newQs[1].length() + newQs[2].length()) {
            minimalQ = newQs[0].substring(newQs[0].length() - 1) + newQs[1] + newQs[2];
        }
        workTerm = this.createWorkTerm(minimalQ);
        this.mainTermList.add(workTerm);
        this.boost = 1.0f;
        if (this.globalBoost == 1.0f) {
            this.globalBoost = 1.5f;
        }
    }

    private String finalMinimalQStr(String mainStr, int wantedCharsCount, String[] newQs, int appendWordIndex, Boolean appendTotail) {
        int appendCharsLen = wantedCharsCount - mainStr.length();
        if (appendCharsLen < 0) {
            mainStr = mainStr.substring(0, mainStr.length() + appendCharsLen);
        } else if (appendCharsLen > 0) {
            mainStr = appendTotail != false ? mainStr + newQs[appendWordIndex].substring(0, Math.min(appendCharsLen, newQs[appendWordIndex].length())) : newQs[appendWordIndex].substring(Math.max(0, newQs[appendWordIndex].length() - appendCharsLen)) + mainStr;
        }
        return mainStr;
    }

    private Term createWorkTerm(String minimalQ) {
        CompareableTerm workTerm = new CompareableTerm(minimalQ);
        if (StringUtils.isEmpty(this.matchFieldName)) {
            workTerm.setMatchedFieldName(this.context.minimumSubIndexFieldName);
        } else {
            workTerm.setMatchedFieldName(this.matchFieldName);
        }
        if (!StringUtils.isEmpty(this.analyzerName)) {
            workTerm.setAnalyzer(this.analyzerName);
        } else {
            workTerm.setAnalyzer(this.context.wordAnalyzerName);
        }
        return workTerm;
    }

    private void parseMainStrForTwoWords(String[] newQs) {
        String minimalQ = "";
        String firstItem = "";
        String secondItem = "";
        if (newQs[0].length() <= 2 || newQs[1].length() <= 2) {
            if (newQs[0].length() <= 2) {
                if (newQs[1].length() <= 5 && newQs[1].length() > 2) {
                    try {
                        minimalQ = newQs[0].substring(Math.min(1, newQs[0].length() - 1)) + newQs[1];
                    }
                    catch (Exception e) {
                        this.logger.error("error :newQs[0]:" + newQs[0] + "q:" + this.q);
                        throw e;
                    }
                } else {
                    minimalQ = newQs[1].length() > 5 ? newQs[1] : newQs[0] + newQs[1];
                }
            } else {
                minimalQ = newQs[0].length() > 2 && newQs[0].length() <= 5 ? newQs[0] + newQs[1].substring(0, 1) : newQs[0];
            }
        } else {
            if (newQs[1].length() >= 9) {
                if (newQs[0].length() <= 6 && newQs[0].length() > 4) {
                    firstItem = newQs[0].substring(newQs[0].length() - Math.min(2, newQs[0].length()));
                    secondItem = MultiFieldMininumStrMatcher.getPrefix(newQs[1], 0.65f);
                } else if (newQs[0].length() > 6 && newQs[0].length() < 9) {
                    firstItem = this.getSuffix(newQs[0], 0.5f);
                    secondItem = MultiFieldMininumStrMatcher.getPrefix(newQs[1], 0.9f);
                } else if (newQs[0].length() >= 9) {
                    firstItem = this.getSuffix(newQs[0], 0.65f);
                    secondItem = MultiFieldMininumStrMatcher.getPrefix(newQs[1], 0.65f);
                } else {
                    firstItem = this.getSuffix(newQs[0], 0.33f);
                    secondItem = newQs[1];
                }
            } else if (newQs[1].length() > 6 && newQs[1].length() < 9) {
                if (newQs[0].length() <= 6 && newQs[0].length() > 4) {
                    firstItem = this.getSuffix(newQs[0], 0.45f);
                    secondItem = MultiFieldMininumStrMatcher.getPrefix(newQs[1], 0.7f);
                } else if (newQs[0].length() > 6 && newQs[0].length() < 9) {
                    firstItem = this.getSuffix(newQs[0], 0.65f);
                    secondItem = MultiFieldMininumStrMatcher.getPrefix(newQs[1], 0.65f);
                } else if (newQs[0].length() >= 9) {
                    firstItem = this.getSuffix(newQs[0], 0.9f);
                    secondItem = MultiFieldMininumStrMatcher.getPrefix(newQs[1], 0.55f);
                } else if (newQs[0].length() == 4) {
                    firstItem = this.getSuffix(newQs[0], 0.5f);
                    secondItem = MultiFieldMininumStrMatcher.getPrefix(newQs[1], 0.6f);
                } else {
                    firstItem = newQs[0];
                    secondItem = MultiFieldMininumStrMatcher.getPrefix(newQs[1], 0.6f);
                }
            } else if (newQs[1].length() > 4 && newQs[1].length() <= 6) {
                if (newQs[0].length() <= 6 && newQs[0].length() > 4) {
                    firstItem = this.getSuffix(newQs[0], 0.65f);
                    secondItem = MultiFieldMininumStrMatcher.getPrefix(newQs[1], 0.65f);
                } else if (newQs[0].length() > 6 && newQs[0].length() < 9) {
                    firstItem = this.getSuffix(newQs[0], 0.7f);
                    secondItem = MultiFieldMininumStrMatcher.getPrefix(newQs[1], 0.45f);
                } else if (newQs[0].length() >= 9) {
                    firstItem = this.getSuffix(newQs[0], 0.65f);
                    secondItem = newQs[1].substring(0, Math.min(2, newQs[1].length()));
                } else {
                    firstItem = this.getSuffix(newQs[0], 0.75f);
                    secondItem = MultiFieldMininumStrMatcher.getPrefix(newQs[1], 0.65f);
                }
            } else if (newQs[1].length() <= 4) {
                if (newQs[0].length() <= 6 && newQs[0].length() > 4) {
                    firstItem = this.getSuffix(newQs[0], 0.65f);
                    secondItem = MultiFieldMininumStrMatcher.getPrefix(newQs[1], 0.65f);
                } else if (newQs[0].length() > 6 && newQs[0].length() < 9) {
                    firstItem = this.getSuffix(newQs[0], 0.6f);
                    secondItem = MultiFieldMininumStrMatcher.getPrefix(newQs[1], 0.5f);
                } else if (newQs[0].length() >= 9) {
                    firstItem = newQs[0];
                    secondItem = MultiFieldMininumStrMatcher.getPrefix(newQs[1], 0.33f);
                } else if (newQs[0].length() < newQs[1].length()) {
                    firstItem = newQs[0].substring(Math.round((float)newQs[0].length() / 2.0f));
                    secondItem = newQs[1];
                } else {
                    firstItem = newQs[0];
                    secondItem = newQs[1].substring(0, Math.round((float)newQs[0].length() / 2.0f));
                }
            }
            minimalQ = firstItem + secondItem;
        }
        if (!StringUtils.isEmpty(minimalQ)) {
            this.mainTermList.add(this.makeTerm(minimalQ, 1.0f));
        }
    }

    private String getMinimalAnalyzerName(int minCharLen) {
        String _analyzerName;
        switch (minCharLen) {
            case 1: {
                _analyzerName = (String)this.analyzerNameMap.get((Object)AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_ONE_CHARS);
                break;
            }
            case 2: {
                _analyzerName = (String)this.analyzerNameMap.get((Object)AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_TWO_CHARS);
                break;
            }
            case 3: {
                _analyzerName = (String)this.analyzerNameMap.get((Object)AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_THREE_CHARS);
                break;
            }
            case 4: {
                _analyzerName = (String)this.analyzerNameMap.get((Object)AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_FOUR_CHARS);
                break;
            }
            case 5: {
                _analyzerName = (String)this.analyzerNameMap.get((Object)AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_FIVE_CHARS);
                break;
            }
            case 6: {
                _analyzerName = (String)this.analyzerNameMap.get((Object)AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_SIX_CHARS);
                break;
            }
            case 7: {
                _analyzerName = (String)this.analyzerNameMap.get((Object)AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_SEVEN_CHARS);
                break;
            }
            case 8: {
                _analyzerName = (String)this.analyzerNameMap.get((Object)AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_EIGHT_CHARS);
                break;
            }
            case 9: {
                _analyzerName = (String)this.analyzerNameMap.get((Object)AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_MORE_CHARS);
                break;
            }
            default: {
                _analyzerName = (String)this.analyzerNameMap.get((Object)AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_ALL_LETTER_MORE_CHARS);
            }
        }
        return _analyzerName;
    }
}

