/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.util;

import java.util.Arrays;

public class FragmentProximity {
    public static double distance(String s, String t) {
        if (s == null || t == null) {
            return 0.0;
        }
        if (s.equals(t)) {
            return 1.0;
        }
        if (s.length() < 2 || t.length() < 2) {
            return 0.0;
        }
        int n = s.length() - 1;
        int[] sPairs = FragmentProximity.getBigrams(s, n);
        int m = t.length() - 1;
        int[] tPairs = FragmentProximity.getBigrams(t, m);
        Arrays.sort(sPairs);
        Arrays.sort(tPairs);
        int matches = 0;
        int i = 0;
        int j = 0;
        while (i < n && j < m) {
            if (sPairs[i] == tPairs[j]) {
                matches += 2;
                ++i;
                ++j;
                continue;
            }
            if (sPairs[i] < tPairs[j]) {
                ++i;
                continue;
            }
            ++j;
        }
        return (double)matches / (double)(n + m);
    }

    private static int[] getBigrams(String s, int n) {
        int[] sPairs = new int[n];
        for (int i = 0; i <= n; ++i) {
            if (i == 0) {
                sPairs[i] = s.charAt(i) << 16;
                continue;
            }
            if (i == n) {
                int n2 = i - 1;
                sPairs[n2] = sPairs[n2] | s.charAt(i);
                continue;
            }
            int n3 = i - 1;
            int n4 = sPairs[n3] | s.charAt(i);
            sPairs[n3] = n4;
            sPairs[i] = n4 << 16;
        }
        return sPairs;
    }

    public static double jaccardScore(String left, String right) {
        if (left == null || right == null || left.isEmpty() || right.isEmpty()) {
            return 0.0;
        }
        int interCount = 0;
        for (int i = 0; i < left.length(); ++i) {
            char l = left.charAt(i);
            for (int j = 0; j < right.length(); ++j) {
                if (l != right.charAt(j)) continue;
                ++interCount;
            }
        }
        return interCount;
    }
}

