/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.zpredict;

import com.valor.common.search.engine.SearchApiException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.custom.CustomAnalyzer;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;

public class TermAnalyzerUtil {
    private CustomAnalyzer customAnalyzer;

    public TermAnalyzerUtil() {
        this.initAnalyzer();
    }

    private void initAnalyzer() {
        try {
            this.customAnalyzer = CustomAnalyzer.builder().withTokenizer("standard", new String[0]).addTokenFilter("lowercase", new String[0]).addTokenFilter("WordDelimiter", new String[0]).addTokenFilter("Stop", new String[0]).build();
        }
        catch (Exception e) {
            throw new SearchApiException(e);
        }
    }

    public List<String> getTerms(String title) {
        String text = StringUtils.stripAccents((String)title.toLowerCase().trim());
        ArrayList<String> terms = new ArrayList<String>();
        try (TokenStream tokenStream = this.customAnalyzer.tokenStream("field", text);){
            OffsetAttribute offsetAtt = (OffsetAttribute)tokenStream.addAttribute(OffsetAttribute.class);
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                terms.add(offsetAtt.toString());
            }
            tokenStream.end();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return terms;
    }

    public String getTerm(String title) {
        String text;
        String term = text = StringUtils.stripAccents((String)title.toLowerCase().trim());
        try (TokenStream tokenStream = this.customAnalyzer.tokenStream("field", text);){
            OffsetAttribute offsetAtt = (OffsetAttribute)tokenStream.addAttribute(OffsetAttribute.class);
            tokenStream.reset();
            if (tokenStream.incrementToken()) {
                term = offsetAtt.toString();
            }
            tokenStream.end();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return term;
    }

    public static List<String> parseWordsV1(String text) {
        Pattern pattern = Pattern.compile("['\u2019\\p{L}-[_]]+");
        Matcher match = pattern.matcher(text.toLowerCase());
        ArrayList<String> matches = new ArrayList<String>();
        while (match.find()) {
            matches.add(match.group());
        }
        return matches;
    }

    public static List<String> parseWordsV2(String text) {
        Pattern pattern = Pattern.compile("['\u2019\\w-[_]]+");
        Matcher match = pattern.matcher(text.toLowerCase());
        ArrayList<String> matches = new ArrayList<String>();
        while (match.find()) {
            matches.add(match.group());
        }
        return matches;
    }

    public static boolean isContentId(String keyword) {
        Matcher regexMatcher = Pattern.compile("pp[0-9]").matcher(keyword);
        if (regexMatcher.find()) {
            return true;
        }
        regexMatcher = Pattern.compile("pc[0-9]").matcher(keyword);
        if (regexMatcher.find()) {
            return true;
        }
        regexMatcher = Pattern.compile("[0-9]").matcher(keyword);
        return regexMatcher.find();
    }

    public static void main(String[] args) throws IOException {
        TermAnalyzerUtil analyzerUtil = new TermAnalyzerUtil();
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            try {
                while (true) {
                    System.out.println("Enter input:");
                    String inputTerm = br.readLine();
                    List<String> terms = analyzerUtil.getTerms(inputTerm);
                    System.out.println(Arrays.toString(terms.toArray(new String[0])));
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }
}

