/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.zsymspell;

import com.valor.common.search.engine.zsymspell.SoftWx.Match.DamerauOSA;
import com.valor.common.search.engine.zsymspell.SoftWx.Match.IDistance;
import com.valor.common.search.engine.zsymspell.SoftWx.Match.Levenshtein;

public class EditDistance {
    private final DistanceAlgorithm algorithm;
    private final IDistance distanceComparer;

    public EditDistance(DistanceAlgorithm algorithm) {
        this.algorithm = algorithm;
        switch (algorithm) {
            case DamerauOSA: {
                this.distanceComparer = new DamerauOSA();
                break;
            }
            case Levenshtein: {
                this.distanceComparer = new Levenshtein();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown distance algorithm.");
            }
        }
    }

    public int compare(String string1, String string2, int maxDistance) {
        return (int)this.distanceComparer.distance(string1, string2, maxDistance);
    }

    public static enum DistanceAlgorithm {
        Levenshtein,
        DamerauOSA;

    }
}

