/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.matcher;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.matcher.AbstractMatcher;
import com.valor.common.search.engine.matcher.GeneralQueryMatcher;
import com.valor.common.search.engine.matcher.HitScoreMode;
import com.valor.common.search.engine.matcher.Matcher;
import com.valor.common.search.engine.util.CollectionUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class GeneralNestQueryMatcher
extends AbstractMatcher {
    private GeneralQueryMatcher.CMD queryCMD = GeneralQueryMatcher.CMD.MATCH;
    private String pathName;
    private HitScoreMode scoreMode = HitScoreMode.Avg;
    Set<String> queryUsedFieldNameSet = new HashSet<String>();
    public static final String DEFAULT_MATCH_NAME = "GeneralNestQueryMatcher";
    public List<QueryBuilder> queryBuilderList;

    public GeneralNestQueryMatcher(RequestContext context, String pathName) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.queryBuilderList = new ArrayList<QueryBuilder>();
        this.pathName = pathName;
        this.context = context;
        this.init();
    }

    public GeneralNestQueryMatcher(RequestContext context, String pathName, HitScoreMode hitScoreMode) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.queryBuilderList = new ArrayList<QueryBuilder>();
        this.pathName = pathName;
        this.context = context;
        this.scoreMode = hitScoreMode;
        this.init();
    }

    private void init() {
        this.context.saveMatcheNameandMatcheFieldNamePair(this.matchName, this.pathName);
    }

    @Override
    public Matcher.MATCHER_TYPE getMatcherType() {
        return Matcher.MATCHER_TYPE.NEST_QUERY;
    }

    @Override
    public Matcher assembly() {
        return this;
    }

    @Override
    public QueryBuilder buildBase() {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        for (QueryBuilder queryBuilder : this.queryBuilderList) {
            boolQueryBuilder.must(queryBuilder);
        }
        ScoreMode targetScoreMode = ScoreMode.Avg;
        targetScoreMode = this.scoreMode.ordinal() == ScoreMode.Max.ordinal() ? ScoreMode.Max : (this.scoreMode.name().equals(ScoreMode.Min.name()) ? ScoreMode.Min : ScoreMode.None);
        this.context.putQueryMatcherMatchedFieldNameMap(this.matchName, CollectionUtils.arrayToList(this.queryUsedFieldNameSet.toArray()));
        return QueryBuilders.nestedQuery((String)this.pathName, (QueryBuilder)boolQueryBuilder, (ScoreMode)targetScoreMode);
    }

    public GeneralNestQueryMatcher appendQuery(CMD queryCmd, String queryFieldName, String queryValue) {
        MatchQueryBuilder queryBuilder = null;
        switch (queryCmd) {
            case MATCH: {
                queryBuilder = QueryBuilders.matchQuery((String)queryFieldName, (Object)queryValue);
                this.queryUsedFieldNameSet.add(queryFieldName);
                break;
            }
            case PREFIX: {
                queryBuilder = QueryBuilders.prefixQuery((String)queryFieldName, (String)queryValue);
                this.queryUsedFieldNameSet.add(queryFieldName);
                break;
            }
            case TERM: {
                queryBuilder = QueryBuilders.termQuery((String)queryFieldName, (String)queryValue);
                this.queryUsedFieldNameSet.add(queryFieldName);
                break;
            }
        }
        if (queryBuilder != null) {
            this.queryBuilderList.add((QueryBuilder)queryBuilder);
        }
        return this;
    }

    public static enum CMD {
        MATCH(0),
        PREFIX(1),
        TERM(2);

        private int index;

        private CMD(int i) {
            this.index = i;
        }
    }
}

