/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.matcher;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.facade.config.MatcherConfig;
import com.valor.common.search.engine.facade.config.MatcherParams;
import com.valor.common.search.engine.matcher.AbstractFuzzyMatcher;
import com.valor.common.search.engine.matcher.Matcher;
import com.valor.common.search.engine.matcher.Term;
import com.valor.common.search.engine.matcher.WordToken;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.SearchUtils;
import com.valor.common.search.engine.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class MissingWordMatcher
extends AbstractFuzzyMatcher {
    public static final float DEFAULT_LOST_WORD_LIMIT_RATE = 0.35f;
    public static final float DEFAULT_LOST_CHAR_LIMIT_RATE = 0.4f;
    public static final String DEFAULT_MATCH_NAME = "MissingWordMatcher";
    private static final int LONG_TERM_TOKEN_MAX_TERM_LIMIT = 18;
    private static final int LONG_TERM_TOKEN_MAX_WORD_LIMIT = 10;
    private Set<String> queryUsedFieldNameSet = new HashSet<String>();
    private float lostCharLimitRate;
    private float lostWordLimitRate;
    private List<Term> termList = new ArrayList<Term>();
    private LinkedHashMap<String, Integer> cutWordLimitsParamsMap = new LinkedHashMap();
    private String[] notSearchNormWord = new String[]{"on", "the", "a", "an", "in"};
    private AtomicInteger matchsentenceCount;

    public MissingWordMatcher() {
        this.matchName = DEFAULT_MATCH_NAME;
        this.cutWordLimitsParamsMap.put("4", 3);
        this.cutWordLimitsParamsMap.put("5", 3);
        this.cutWordLimitsParamsMap.put("6", 4);
        this.cutWordLimitsParamsMap.put("7", 4);
        this.cutWordLimitsParamsMap.put("8", 5);
        this.matchsentenceCount = new AtomicInteger(0);
    }

    public MissingWordMatcher(RequestContext context) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.cutWordLimitsParamsMap.put("4", 3);
        this.cutWordLimitsParamsMap.put("5", 3);
        this.cutWordLimitsParamsMap.put("6", 4);
        this.cutWordLimitsParamsMap.put("7", 4);
        this.cutWordLimitsParamsMap.put("8", 5);
        this.matchsentenceCount = new AtomicInteger(0);
        this.q = context.getQ().trim();
        this.context = context;
        this.matchFieldName = context.wordSubIndexFieldName;
        this.init();
    }

    public MissingWordMatcher(RequestContext context, String matchFieldName) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.cutWordLimitsParamsMap.put("4", 3);
        this.cutWordLimitsParamsMap.put("5", 3);
        this.cutWordLimitsParamsMap.put("6", 4);
        this.cutWordLimitsParamsMap.put("7", 4);
        this.cutWordLimitsParamsMap.put("8", 5);
        this.matchsentenceCount = new AtomicInteger(0);
        this.q = context.getQ().trim();
        this.context = context;
        this.matchFieldName = matchFieldName;
        this.init();
    }

    public MissingWordMatcher(String analyzerName, RequestContext context) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.cutWordLimitsParamsMap.put("4", 3);
        this.cutWordLimitsParamsMap.put("5", 3);
        this.cutWordLimitsParamsMap.put("6", 4);
        this.cutWordLimitsParamsMap.put("7", 4);
        this.cutWordLimitsParamsMap.put("8", 5);
        this.matchsentenceCount = new AtomicInteger(0);
        this.q = context.getQ().trim();
        this.analyzerName = analyzerName;
        this.context = context;
        this.init();
    }

    public MissingWordMatcher(String analyzerName, RequestContext context, String matchFieldName) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.cutWordLimitsParamsMap.put("4", 3);
        this.cutWordLimitsParamsMap.put("5", 3);
        this.cutWordLimitsParamsMap.put("6", 4);
        this.cutWordLimitsParamsMap.put("7", 4);
        this.cutWordLimitsParamsMap.put("8", 5);
        this.matchsentenceCount = new AtomicInteger(0);
        this.q = context.getQ().trim();
        this.analyzerName = analyzerName;
        this.context = context;
        this.matchFieldName = matchFieldName;
        this.init();
    }

    public MissingWordMatcher(String analyzerName, RequestContext context, float lostCharLimitRate, float lostWordLimitRate) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.cutWordLimitsParamsMap.put("4", 3);
        this.cutWordLimitsParamsMap.put("5", 3);
        this.cutWordLimitsParamsMap.put("6", 4);
        this.cutWordLimitsParamsMap.put("7", 4);
        this.cutWordLimitsParamsMap.put("8", 5);
        this.matchsentenceCount = new AtomicInteger(0);
        this.q = context.getQ().trim();
        this.analyzerName = analyzerName;
        this.context = context;
        this.lostCharLimitRate = lostCharLimitRate;
        this.lostWordLimitRate = lostWordLimitRate;
        this.matchFieldName = context.wordSubIndexFieldName;
        this.init();
    }

    public static List<List<WordToken>> prepareToken(String[] sourceWords, int fromIndex, int wantCutWordCount) {
        ArrayList<List<WordToken>> currentToken = new ArrayList<List<WordToken>>();
        for (int index = fromIndex; index < sourceWords.length - wantCutWordCount + 1; ++index) {
            ArrayList<List<WordToken>> curToken = new ArrayList<List<WordToken>>();
            if (wantCutWordCount > 1) {
                List<List<WordToken>> subList = MissingWordMatcher.prepareToken(sourceWords, index + 1, wantCutWordCount - 1);
                for (List<WordToken> itemList : subList) {
                    itemList.add(0, new WordToken(sourceWords[index], fromIndex, true));
                    currentToken.add(itemList);
                }
                continue;
            }
            for (int i = index; i < sourceWords.length; ++i) {
                ArrayList<WordToken> item = new ArrayList<WordToken>();
                item.add(new WordToken(sourceWords[i], index, true));
                curToken.add(item);
            }
            return curToken;
        }
        return currentToken;
    }

    private void init() {
        this.context.saveMatcheNameandMatcheFieldNamePair(this.matchName, this.matchFieldName);
        this.inited = true;
    }

    public void setMatchFieldName(String matchFieldName) {
        if (this.inited) {
            return;
        }
        this.matchFieldName = matchFieldName;
    }

    void setAnalyzerName(String analyzerName) {
        if (this.inited) {
            return;
        }
        this.analyzerName = analyzerName;
    }

    @Override
    public Matcher.MATCHER_TYPE getMatcherType() {
        return Matcher.MATCHER_TYPE.MISSING_WORD;
    }

    @Override
    public MissingWordMatcher assembly() {
        this.termList.clear();
        this.q = this.context.getQ();
        boolean fromIndex = false;
        List<List<WordToken>> mainWordTokenLists = this.cutSomeWords(this.q);
        ArrayList<WordToken> finnalTokenList = new ArrayList<WordToken>();
        int index = 0;
        for (List<WordToken> item : mainWordTokenLists) {
            StringBuffer buffer = new StringBuffer();
            for (WordToken token : item) {
                buffer.append(token.getToken()).append(" ");
            }
            finnalTokenList.add(new WordToken(buffer.toString(), index, true));
        }
        ArrayList<Term> terms = new ArrayList<Term>();
        for (WordToken t : finnalTokenList) {
            Term term = new Term(SearchUtils.takeStrByPrefixLimit(t.getToken().trim(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT));
            term.setMatchedFieldName(this.context.wordSubIndexFieldName);
            if (!StringUtils.isEmpty(this.analyzerName)) {
                term.setAnalyzer(this.analyzerName);
            }
            terms.add(term);
        }
        this.termList.addAll(terms);
        return this;
    }

    @Override
    public QueryBuilder buildBase() {
        this.matchsentenceCount = new AtomicInteger(0);
        String[] qs = this.q.replaceAll("-", " ").trim().split("([\\s\\p{Zs}])+");
        if (qs.length < 4) {
            return null;
        }
        if (CollectionUtils.isEmpty(this.termList)) {
            return null;
        }
        BoolQueryBuilder mainQuery = QueryBuilders.boolQuery();
        String sentenceQueryName = "";
        for (int index = 0; index < this.termList.size() && index < 18; ++index) {
            Term term = this.termList.get(index);
            HashSet<String> querySentenceFieldNames = new HashSet<String>();
            String[] words = term.getTermStr().split("([\\s\\p{Zs}])+");
            String phraseMatchKeyword = term.getTermStr();
            String fuzzyMatchKeyword = "";
            if (words[words.length - 1].length() >= 4) {
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < words.length - 1; ++i) {
                    buffer.append(words[i]).append(" ");
                }
                phraseMatchKeyword = buffer.toString();
                fuzzyMatchKeyword = words[words.length - 1];
            }
            MatchPhraseQueryBuilder phraseQueryBuilder = QueryBuilders.matchPhraseQuery((String)term.getMatchedFieldName(), (Object)phraseMatchKeyword);
            this.queryUsedFieldNameSet.add(term.getMatchedFieldName());
            querySentenceFieldNames.add(term.getMatchedFieldName());
            if (!StringUtils.isEmpty(term.getAnalyzer())) {
                phraseQueryBuilder.analyzer(term.getAnalyzer());
            }
            phraseQueryBuilder.slop(20);
            MatchPhraseQueryBuilder termBuilder = phraseQueryBuilder;
            if (!StringUtils.isEmpty(fuzzyMatchKeyword)) {
                MatchQueryBuilder fuzzyQuery = QueryBuilders.matchQuery((String)term.getMatchedFieldName(), (Object)fuzzyMatchKeyword.toLowerCase()).fuzziness((Object)"auto").analyzer("whitespace");
                querySentenceFieldNames.add(term.getMatchedFieldName());
                termBuilder = QueryBuilders.boolQuery().must((QueryBuilder)fuzzyQuery).must((QueryBuilder)phraseQueryBuilder);
            }
            sentenceQueryName = this.getSentenceQueryName();
            this.saveSentenceMatchFieldName(sentenceQueryName, term.getMatchedFieldName());
            mainQuery.should(termBuilder.queryName(sentenceQueryName));
        }
        if (mainQuery != null) {
            mainQuery.minimumShouldMatch(1).boost(this.globalBoost);
        }
        this.saveQuerySentenceMatchedFieldNameMapToContext();
        this.context.putQueryMatcherMatchedFieldNameMap(this.matchName, CollectionUtils.arrayToList(this.queryUsedFieldNameSet.toArray()));
        return mainQuery;
    }

    private List<List<WordToken>> cutSomeWords(String q) {
        String[] qs = q.replaceAll("-", " ").trim().split("([\\s\\p{Zs}])+");
        if (qs.length < 4) {
            return new ArrayList<List<WordToken>>();
        }
        Integer cutWordsCount = this.cutWordLimitsParamsMap.get(qs.length + "");
        if (cutWordsCount == null) {
            cutWordsCount = 0;
            for (Integer value : this.cutWordLimitsParamsMap.values()) {
                if (value <= cutWordsCount) continue;
                cutWordsCount = value;
            }
        }
        qs = (String[])Arrays.stream(qs).limit(10L).toArray(String[]::new);
        return MissingWordMatcher.prepareToken(qs, 0, cutWordsCount);
    }

    @Override
    public void prepareByConfig(MatcherConfig config) {
        this.matcherConfig = config;
        this.globalBoost = this.matcherConfig.getMatcherParams().getGlobalBoost();
        this.boost = this.matcherConfig.getMatcherParams().getBoost();
        MatcherParams matcherParams = this.matcherConfig.getMatcherParams();
        if (!StringUtils.isEmpty(matcherParams.getMatchFieldName())) {
            this.setMatchFieldName(matcherParams.getMatchFieldName());
        } else {
            this.setMatchFieldName(this.context.KEY_MAIN_INDEX_FIELD);
        }
        if (!StringUtils.isEmpty(matcherParams.getAnalyzerName())) {
            this.setAnalyzerName(matcherParams.getAnalyzerName());
        }
        if (!StringUtils.isEmpty(this.matcherConfig.getIdName())) {
            this.matchName = this.matcherConfig.getIdName();
        }
        if (!StringUtils.isEmpty(matcherParams.getExtParams())) {
            this.lostWordLimitRate = Float.parseFloat(matcherParams.getExtParams().getOrDefault("lostWordLimitRate", Float.valueOf(0.35f)).toString());
            this.lostCharLimitRate = Float.parseFloat(matcherParams.getExtParams().getOrDefault("lostCharLimitRate", Float.valueOf(0.4f)).toString());
            Object objCutWordLimits = matcherParams.getExtParams().get("cutWordLimits");
            if (objCutWordLimits instanceof Map) {
                Map m = (Map)objCutWordLimits;
                this.cutWordLimitsParamsMap.putAll(m);
            }
        }
        super.prepareByConfig(this.matcherConfig);
        this.init();
    }

    private String getSentenceQueryName() {
        return "check_missingWord_" + this.matchsentenceCount.getAndIncrement();
    }
}

