/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.ranker.comparator;

import com.valor.common.search.engine.facade.config.ComputeExpressConfig;
import com.valor.common.search.engine.ranker.comparator.AbstractRankerComparator;
import com.valor.common.search.engine.util.CollectionUtils;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.SearchHit;

public class MovieSeriesYearPopularityWeightComparator
extends AbstractRankerComparator
implements Comparator<SearchHit> {
    private Map<String, Number> bizParams = new HashMap<String, Number>();
    private ComputeExpressConfig computeExpressConfig;

    public MovieSeriesYearPopularityWeightComparator() {
        this.bizParams.put("movieSeriesModel.01.popularityRate".replaceFirst("movieSeriesModel.01.", ""), Float.valueOf(0.3f));
        this.bizParams.put("movieSeriesModel.01.popularityScale".replaceFirst("movieSeriesModel.01.", ""), Float.valueOf(100000.0f));
        this.bizParams.put("movieSeriesModel.01.publicationYearRate".replaceFirst("movieSeriesModel.01.", ""), Float.valueOf(0.4f));
        this.bizParams.put("movieSeriesModel.01.publicationYearScale".replaceFirst("movieSeriesModel.01.", ""), Float.valueOf(10.0f));
        this.bizParams.put("movieSeriesModel.01.weightRate".replaceFirst("movieSeriesModel.01.", ""), Float.valueOf(0.3f));
        this.bizParams.put("movieSeriesModel.01.weightScale".replaceFirst("movieSeriesModel.01.", ""), Float.valueOf(12.0f));
    }

    @Override
    public int compare(SearchHit o1, SearchHit o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        if (o1 == o2) {
            return 0;
        }
        Float o1Score = Float.valueOf(Float.parseFloat(o1.getSourceAsMap().get("newScore").toString()));
        Float o2Score = Float.valueOf(Float.parseFloat(o2.getSourceAsMap().get("newScore").toString()));
        o1Score = Float.valueOf(o1Score.isNaN() ? 0.0f : o1Score.floatValue());
        o2Score = Float.valueOf(o2Score.isNaN() ? 0.0f : o2Score.floatValue());
        o1.getSourceAsMap().put("sortBy", "movieSeriesYearPopularityWeight");
        o2.getSourceAsMap().put("sortBy", "movieSeriesYearPopularityWeight");
        return Float.compare(o2Score.floatValue(), o1Score.floatValue());
    }

    public ComputeExpressConfig getComputeExpressConfig() {
        return this.computeExpressConfig;
    }

    public Map<String, Number> getBizParams() {
        return this.bizParams;
    }

    @Override
    public void appendSysParams(Map<String, Object> sysParams) {
        if (CollectionUtils.isEmpty(sysParams)) {
            return;
        }
        this.bizParams.put("movieSeriesModel.01.popularityRate".replaceFirst("movieSeriesModel.01.", ""), Float.valueOf(Float.parseFloat(sysParams.getOrDefault("movieSeriesModel.01.popularityRate", Float.valueOf(0.3f)).toString())));
        this.bizParams.put("movieSeriesModel.01.popularityScale".replaceFirst("movieSeriesModel.01.", ""), Float.valueOf(Float.parseFloat(sysParams.getOrDefault("movieSeriesModel.01.popularityScale", Float.valueOf(100000.0f)).toString())));
        this.bizParams.put("movieSeriesModel.01.weightScale".replaceFirst("movieSeriesModel.01.", ""), Float.valueOf(Float.parseFloat(sysParams.getOrDefault("movieSeriesModel.01.weightScale", Float.valueOf(12.0f)).toString())));
        this.bizParams.put("movieSeriesModel.01.weightRate".replaceFirst("movieSeriesModel.01.", ""), Float.valueOf(Float.parseFloat(sysParams.getOrDefault("movieSeriesModel.01.weightRate", Float.valueOf(0.3f)).toString())));
        this.bizParams.put("movieSeriesModel.01.publicationYearScale".replaceFirst("movieSeriesModel.01.", ""), Float.valueOf(Float.parseFloat(sysParams.getOrDefault("movieSeriesModel.01.publicationYearScale", Float.valueOf(10.0f)).toString())));
        this.bizParams.put("movieSeriesModel.01.publicationYearRate".replaceFirst("movieSeriesModel.01.", ""), Float.valueOf(Float.parseFloat(sysParams.getOrDefault("movieSeriesModel.01.publicationYearRate", Float.valueOf(0.4f)).toString())));
    }

    @Override
    public void prepareByConfig(List<ComputeExpressConfig> computeExpressMapList) {
        if (!CollectionUtils.isEmpty(computeExpressMapList)) {
            this.computeExpressConfig = computeExpressMapList.get(0);
        }
    }

    @Override
    public float computeScore(SearchHit hit) {
        HashMap<String, Number> jepParams = new HashMap<String, Number>();
        for (String name : this.computeExpressConfig.getParamsName()) {
            String objValue = hit.getSourceAsMap().getOrDefault(name, "0");
            double val = Math.ceil(Double.parseDouble(objValue.toString()) * 100.0) / 100.0;
            jepParams.put(name, val < 0.0 ? 0.0 : val);
        }
        jepParams.put("score", Double.valueOf(hit.getScore()));
        jepParams.putAll(this.bizParams);
        float newScore = this.getNewScore(jepParams, this.computeExpressConfig.getScoreExpress());
        hit.getSourceAsMap().put("computeScoreBy", "movieSeriesYearPopularityWeight");
        hit.getSourceAsMap().put("newScore", Float.valueOf(newScore));
        HashMap<String, Float> attachmentMap = new HashMap<String, Float>();
        attachmentMap.put("cNewScore", Float.valueOf(newScore));
        hit.getSourceAsMap().put("attachmentMap", attachmentMap);
        return newScore;
    }
}

