/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.ranker.comparator;

import com.valor.common.search.engine.facade.config.ComputeExpressConfig;
import com.valor.common.search.engine.ranker.comparator.AbstractRankerComparator;
import com.valor.common.search.engine.util.CollectionUtils;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.SearchHit;

public class ScoreDescComparator
extends AbstractRankerComparator
implements Comparator<SearchHit> {
    private ComputeExpressConfig computeExpressConfig;

    @Override
    public int compare(SearchHit o1, SearchHit o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        if (o1 == o2) {
            return 0;
        }
        Float o1Score = Float.valueOf(Float.parseFloat(o1.getSourceAsMap().get("newScore").toString()));
        Float o2Score = Float.valueOf(Float.parseFloat(o2.getSourceAsMap().get("newScore").toString()));
        o1Score = Float.valueOf(o1Score.isNaN() ? 0.0f : o1Score.floatValue());
        o2Score = Float.valueOf(o2Score.isNaN() ? 0.0f : o2Score.floatValue());
        o1.getSourceAsMap().put("sortBy", "ScoreDesc");
        o2.getSourceAsMap().put("sortBy", "ScoreDesc");
        if (o1Score.floatValue() == o2Score.floatValue()) {
            float o2Weight;
            Integer objValue = o1.getSourceAsMap().getOrDefault("weight", 0);
            float o1Weight = objValue == null ? 0.0f : Float.parseFloat(((Object)objValue).toString());
            objValue = o2.getSourceAsMap().getOrDefault("weight", 0);
            float f = o2Weight = objValue == null ? 0.0f : Float.parseFloat(((Object)objValue).toString());
            if (o1Weight > o2Weight) {
                return -1;
            }
            if (o1Weight < o2Weight) {
                return 1;
            }
            return 0;
        }
        if (o1Score.floatValue() > o2Score.floatValue()) {
            return -1;
        }
        return 1;
    }

    @Override
    public void appendSysParams(Map<String, Object> sysParams) {
    }

    @Override
    public void prepareByConfig(List<ComputeExpressConfig> computeExpressMapList) {
        if (!CollectionUtils.isEmpty(computeExpressMapList)) {
            this.computeExpressConfig = computeExpressMapList.get(0);
        }
    }

    @Override
    public float computeScore(SearchHit hit) {
        HashMap<String, Number> jepParams = new HashMap<String, Number>();
        jepParams.put("score", Double.valueOf(hit.getScore()));
        float newScore = this.getNewScore(jepParams, this.computeExpressConfig.getScoreExpress());
        hit.getSourceAsMap().put("newScore", Float.valueOf(newScore));
        hit.getSourceAsMap().put("computeScoreBy", "ScoreDesc");
        return newScore;
    }

    public ComputeExpressConfig getComputeExpressConfig() {
        return this.computeExpressConfig;
    }
}

