/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.zsymspell.SoftWx.Match;

public class Helpers {
    public static int NullDistanceResults(String string1, String string2, double maxDistance) {
        if (string1 == null) {
            return string2 == null ? 0 : ((double)string2.length() <= maxDistance ? string2.length() : -1);
        }
        return (double)string1.length() <= maxDistance ? string1.length() : -1;
    }

    public static int NullSimilarityResults(String string1, String string2, double minSimilarity) {
        return string1 == null && string2 == null ? 1 : (0.0 <= minSimilarity ? 0 : -1);
    }

    public static PrepInfo prefixSuffixPrep(String string1, String string2) {
        int start;
        int len2 = string2.length();
        int len1 = string1.length();
        while (len1 != 0 && string1.charAt(len1 - 1) == string2.charAt(len2 - 1)) {
            --len1;
            --len2;
        }
        for (start = 0; start != len1 && string1.charAt(start) == string2.charAt(start); ++start) {
        }
        if (start != 0) {
            len2 -= start;
            len1 -= start;
        }
        return new PrepInfo(len1, len2, start);
    }

    public static double toSimilarity(int distance, int length) {
        return distance < 0 ? -1.0 : 1.0 - (double)distance / (double)length;
    }

    public static int toDistance(double similarity, int length) {
        return (int)((double)length * (1.0 - similarity) + 1.0E-10);
    }

    public static class PrepInfo {
        public int len1;
        public int len2;
        public int start;

        public PrepInfo(int len1, int len2, int start) {
            this.len1 = len1;
            this.len2 = len2;
            this.start = start;
        }
    }
}

