/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.zsymspell.SoftWx.Match;

import com.valor.common.search.engine.zsymspell.SoftWx.Match.Helpers;
import com.valor.common.search.engine.zsymspell.SoftWx.Match.IDistance;
import com.valor.common.search.engine.zsymspell.SoftWx.Match.ISimilarity;

public class Levenshtein
implements IDistance,
ISimilarity {
    private int[] baseChar1Costs;

    public Levenshtein() {
        this.baseChar1Costs = new int[0];
    }

    public Levenshtein(int expectedMaxStringLength) {
        this.baseChar1Costs = new int[expectedMaxStringLength];
    }

    @Override
    public double distance(String string1, String string2) {
        if (string1 == null) {
            return string2 == null ? 0.0 : (double)string2.length();
        }
        if (string2 == null) {
            return string1.length();
        }
        if (string1.length() > string2.length()) {
            String t = string1;
            string1 = string2;
            string2 = t;
        }
        Helpers.PrepInfo prepInfo = Helpers.prefixSuffixPrep(string1, string2);
        int len1 = prepInfo.len1;
        int len2 = prepInfo.len2;
        int start = prepInfo.start;
        if (len1 == 0) {
            return len2;
        }
        this.baseChar1Costs = len2 <= this.baseChar1Costs.length ? this.baseChar1Costs : new int[len2];
        return Levenshtein._distance(string1, string2, len1, len2, start, this.baseChar1Costs);
    }

    @Override
    public double distance(String string1, String string2, double maxDistance) {
        int iMaxDistance;
        if (string1 == null || string2 == null) {
            return Helpers.NullDistanceResults(string1, string2, maxDistance);
        }
        if (maxDistance <= 0.0) {
            return string1.equals(string2) ? 0.0 : -1.0;
        }
        int n = iMaxDistance = (maxDistance = Math.ceil(maxDistance)) <= 2.147483647E9 ? (int)maxDistance : Integer.MAX_VALUE;
        if (string1.length() > string2.length()) {
            String t = string1;
            string1 = string2;
            string2 = t;
        }
        if (string2.length() - string1.length() > iMaxDistance) {
            return -1.0;
        }
        Helpers.PrepInfo prepInfo = Helpers.prefixSuffixPrep(string1, string2);
        int len1 = prepInfo.len1;
        int len2 = prepInfo.len2;
        int start = prepInfo.start;
        if (len1 == 0) {
            return len2 <= iMaxDistance ? (double)len2 : -1.0;
        }
        if (iMaxDistance < len2) {
            this.baseChar1Costs = len2 <= this.baseChar1Costs.length ? this.baseChar1Costs : new int[len2];
            return Levenshtein._distance(string1, string2, len1, len2, start, iMaxDistance, this.baseChar1Costs);
        }
        this.baseChar1Costs = len2 <= this.baseChar1Costs.length ? this.baseChar1Costs : new int[len2];
        return Levenshtein._distance(string1, string2, len1, len2, start, this.baseChar1Costs);
    }

    @Override
    public double similarity(String string1, String string2) {
        if (string1 == null) {
            return string2 == null ? 1.0 : 0.0;
        }
        if (string2 == null) {
            return 0.0;
        }
        if (string1.length() > string2.length()) {
            String t = string1;
            string1 = string2;
            string2 = t;
        }
        Helpers.PrepInfo prepInfo = Helpers.prefixSuffixPrep(string1, string2);
        int len1 = prepInfo.len1;
        int len2 = prepInfo.len2;
        int start = prepInfo.start;
        if (len1 == 0) {
            return 1.0;
        }
        this.baseChar1Costs = len2 <= this.baseChar1Costs.length ? this.baseChar1Costs : new int[len2];
        int d = Levenshtein._distance(string1, string2, len1, len2, start, this.baseChar1Costs);
        return Helpers.toSimilarity(d, string2.length());
    }

    @Override
    public double similarity(String string1, String string2, double minSimilarity) {
        if (minSimilarity < 0.0 || minSimilarity > 1.0) {
            throw new IllegalArgumentException("minSimilarity must be in range 0 to 1.0");
        }
        if (string1 == null || string2 == null) {
            return Helpers.NullSimilarityResults(string1, string2, minSimilarity);
        }
        if (string1.length() > string2.length()) {
            String t = string1;
            string1 = string2;
            string2 = t;
        }
        int iMaxDistance = Helpers.toDistance(minSimilarity, string2.length());
        if (string2.length() - string1.length() > iMaxDistance) {
            return -1.0;
        }
        if (iMaxDistance == 0) {
            return string1.equals(string2) ? 1.0 : -1.0;
        }
        Helpers.PrepInfo prepInfo = Helpers.prefixSuffixPrep(string1, string2);
        int len1 = prepInfo.len1;
        int len2 = prepInfo.len2;
        int start = prepInfo.start;
        if (len1 == 0) {
            return 1.0;
        }
        if (iMaxDistance < len2) {
            this.baseChar1Costs = len2 <= this.baseChar1Costs.length ? this.baseChar1Costs : new int[len2];
            int d = Levenshtein._distance(string1, string2, len1, len2, start, iMaxDistance, this.baseChar1Costs);
            return Helpers.toSimilarity(d, string2.length());
        }
        this.baseChar1Costs = len2 <= this.baseChar1Costs.length ? this.baseChar1Costs : new int[len2];
        int d = Levenshtein._distance(string1, string2, len1, len2, start, this.baseChar1Costs);
        return Helpers.toSimilarity(d, string2.length());
    }

    private static int _distance(String string1, String string2, int len1, int len2, int start, int[] char1Costs) {
        int j = 0;
        while (j < len2) {
            char1Costs[j++] = j;
        }
        int currentCharCost = 0;
        if (start == 0) {
            for (int i = 0; i < len1; ++i) {
                int aboveCharCost;
                int leftCharCost = aboveCharCost = i;
                char char1 = string1.charAt(i);
                for (int j2 = 0; j2 < len2; ++j2) {
                    currentCharCost = leftCharCost;
                    leftCharCost = char1Costs[j2];
                    if (string2.charAt(j2) != char1) {
                        if (aboveCharCost < currentCharCost) {
                            currentCharCost = aboveCharCost;
                        }
                        if (leftCharCost < currentCharCost) {
                            currentCharCost = leftCharCost;
                        }
                    }
                    char1Costs[j2] = aboveCharCost = ++currentCharCost;
                }
            }
        } else {
            for (int i = 0; i < len1; ++i) {
                int aboveCharCost;
                int leftCharCost = aboveCharCost = i;
                char char1 = string1.charAt(start + i);
                for (int j3 = 0; j3 < len2; ++j3) {
                    currentCharCost = leftCharCost;
                    leftCharCost = char1Costs[j3];
                    if (string2.charAt(start + j3) != char1) {
                        if (aboveCharCost < currentCharCost) {
                            currentCharCost = aboveCharCost;
                        }
                        if (leftCharCost < currentCharCost) {
                            currentCharCost = leftCharCost;
                        }
                    }
                    char1Costs[j3] = aboveCharCost = ++currentCharCost;
                }
            }
        }
        return currentCharCost;
    }

    private static int _distance(String string1, String string2, int len1, int len2, int start, int maxDistance, int[] char1Costs) {
        assert (len2 < maxDistance);
        assert (len2 - len1 > maxDistance);
        int j = 0;
        while (j < maxDistance) {
            char1Costs[j++] = j;
        }
        while (j < len2) {
            char1Costs[j++] = maxDistance + 1;
        }
        int lenDiff = len2 - len1;
        int jStartOffset = maxDistance - lenDiff;
        int jStart = 0;
        int jEnd = maxDistance;
        int currentCost = 0;
        if (start == 0) {
            for (int i = 0; i < len1; ++i) {
                int aboveCharCost;
                char char1 = string1.charAt(i);
                int prevChar1Cost = aboveCharCost = i;
                jEnd += jEnd < len2 ? 1 : 0;
                for (j = jStart += i > jStartOffset ? 1 : 0; j < jEnd; ++j) {
                    currentCost = prevChar1Cost;
                    prevChar1Cost = char1Costs[j];
                    if (string2.charAt(j) != char1) {
                        if (aboveCharCost < currentCost) {
                            currentCost = aboveCharCost;
                        }
                        if (prevChar1Cost < currentCost) {
                            currentCost = prevChar1Cost;
                        }
                    }
                    char1Costs[j] = aboveCharCost = ++currentCost;
                }
                if (char1Costs[i + lenDiff] <= maxDistance) continue;
                return -1;
            }
        } else {
            for (int i = 0; i < len1; ++i) {
                int aboveCharCost;
                char char1 = string1.charAt(start + i);
                int prevChar1Cost = aboveCharCost = i;
                jEnd += jEnd < len2 ? 1 : 0;
                for (j = jStart += i > jStartOffset ? 1 : 0; j < jEnd; ++j) {
                    currentCost = prevChar1Cost;
                    prevChar1Cost = char1Costs[j];
                    if (string2.charAt(start + j) != char1) {
                        if (aboveCharCost < currentCost) {
                            currentCost = aboveCharCost;
                        }
                        if (prevChar1Cost < currentCost) {
                            currentCost = prevChar1Cost;
                        }
                    }
                    char1Costs[j] = aboveCharCost = ++currentCost;
                }
                if (char1Costs[i + lenDiff] <= maxDistance) continue;
                return -1;
            }
        }
        return currentCost <= maxDistance ? currentCost : -1;
    }
}

