/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.zsymspell;

import com.valor.common.search.engine.zsymspell.EditDistance;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SymSpell {
    private static final int DEFAULT_MAX_EDIT_DISTANCE = 2;
    private static final int DEFAULT_PREFIX_LENGTH = 7;
    private static final int DEFAULT_COUNT_THRESHOLD = 1;
    private static final int DEFAULT_INITIAL_CAPACITY = 16384;
    private static final int DEFAULT_COMPACT_LEVEL = 5;
    private static final String DEFAULT_SEPARATOR_CHARS = ",";
    private final int initialCapacity;
    private final int maxDictionaryEditDistance;
    private final int prefixLength;
    private final long countThreshold;
    private final int compactMask;
    private final EditDistance.DistanceAlgorithm distanceAlgorithm = EditDistance.DistanceAlgorithm.DamerauOSA;
    private int maxDictionaryWordLength;
    private final ConcurrentHashMap<Integer, String[]> deletes;
    private final ConcurrentHashMap<String, Long> words;
    private ConcurrentHashMap<String, Long> belowThresholdWords = new ConcurrentHashMap();
    public ConcurrentHashMap<String, Long> bigrams = new ConcurrentHashMap();
    public long bigramCountMin = Long.MAX_VALUE;
    public static final long N = 1024908267229L;

    public int getMaxDictionaryEditDistance() {
        return this.maxDictionaryEditDistance;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    public int getMaxWordLength() {
        return this.maxDictionaryWordLength;
    }

    public long getCountThreshold() {
        return this.countThreshold;
    }

    public int getWordCount() {
        return this.words.size();
    }

    public int getEntryCount() {
        return this.deletes.size();
    }

    public SymSpell(int initialCapacity, int maxDictionaryEditDistance, int prefixLength, int countThreshold, byte compactLevel) {
        if (initialCapacity < 0) {
            initialCapacity = 16384;
        }
        if (maxDictionaryEditDistance < 0) {
            maxDictionaryEditDistance = 2;
        }
        if (prefixLength < 1 || prefixLength <= maxDictionaryEditDistance) {
            prefixLength = 7;
        }
        if (countThreshold < 0) {
            countThreshold = 1;
        }
        if (compactLevel > 16) {
            compactLevel = (byte)5;
        }
        this.initialCapacity = initialCapacity;
        this.words = new ConcurrentHashMap(initialCapacity);
        this.deletes = new ConcurrentHashMap(initialCapacity);
        this.maxDictionaryEditDistance = maxDictionaryEditDistance;
        this.prefixLength = prefixLength;
        this.countThreshold = countThreshold;
        if (compactLevel > 16) {
            compactLevel = (byte)16;
        }
        this.compactMask = -1 >> 3 + compactLevel << 2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean createDictionaryEntry(String key, long count, SuggestionStage staging) {
        if (count <= 0L) {
            if (this.countThreshold > 0L) {
                return false;
            }
            count = 0L;
        }
        long countPrevious = -1L;
        Long tmpCountObject = null;
        if (this.countThreshold > 1L && (tmpCountObject = this.belowThresholdWords.get(key)) != null) {
            countPrevious = tmpCountObject;
            long l = count = Long.MAX_VALUE - countPrevious > count ? countPrevious + count : Long.MAX_VALUE;
            if (count < this.countThreshold) {
                this.belowThresholdWords.put(key, count);
                return false;
            }
            this.belowThresholdWords.remove(key);
        } else {
            tmpCountObject = this.words.get(key);
            if (tmpCountObject != null) {
                countPrevious = tmpCountObject;
                count = Long.MAX_VALUE - countPrevious > count ? countPrevious + count : Long.MAX_VALUE;
                this.words.put(key, count);
                return false;
            }
            if (count < this.countThreshold) {
                this.belowThresholdWords.put(key, count);
                return false;
            }
        }
        this.words.put(key, count);
        if (key.length() > this.maxDictionaryWordLength) {
            this.maxDictionaryWordLength = key.length();
        }
        HashSet<String> edits = this.editsPrefix(key);
        if (staging != null) {
            edits.forEach(delete -> staging.add(this.getStringHash((String)delete), key));
            return true;
        }
        edits.forEach(delete -> {
            int deleteHash = this.getStringHash((String)delete);
            String[] suggestions = this.deletes.get(deleteHash);
            if (suggestions != null) {
                String[] newSuggestions = Arrays.copyOf(suggestions, suggestions.length + 1);
                this.deletes.put(deleteHash, newSuggestions);
                suggestions = newSuggestions;
            } else {
                suggestions = new String[1];
                this.deletes.put(deleteHash, suggestions);
            }
            suggestions[suggestions.length - 1] = key;
        });
        return true;
    }

    public void addWord(String word) {
        this.createDictionaryEntry(word, 1L, null);
    }

    public void addWord(String word, long count) {
        this.words.put(word, count);
        if (word.length() > this.maxDictionaryWordLength) {
            this.maxDictionaryWordLength = word.length();
        }
        HashSet<String> edits = this.editsPrefix(word);
        edits.forEach(delete -> {
            int deleteHash = this.getStringHash((String)delete);
            String[] suggestions = this.deletes.get(deleteHash);
            if (suggestions != null) {
                String[] newSuggestions = Arrays.copyOf(suggestions, suggestions.length + 1);
                this.deletes.put(deleteHash, newSuggestions);
                suggestions = newSuggestions;
            } else {
                suggestions = new String[1];
                this.deletes.put(deleteHash, suggestions);
            }
            suggestions[suggestions.length - 1] = word;
        });
    }

    public boolean loadBigramDictionary(String corpus, int termIndex, int countIndex, String separatorChars) {
        File file;
        if (separatorChars == null) {
            separatorChars = DEFAULT_SEPARATOR_CHARS;
        }
        if (!(file = new File(corpus)).exists()) {
            return false;
        }
        try (BufferedReader br = Files.newBufferedReader(Paths.get(corpus, new String[0]), StandardCharsets.UTF_8);){
            String line;
            int linePartsLenth;
            int n = linePartsLenth = separatorChars.equals(DEFAULT_SEPARATOR_CHARS) ? 3 : 2;
            while ((line = br.readLine()) != null) {
                String[] lineParts = line.split(separatorChars);
                if (lineParts.length < linePartsLenth) continue;
                String key = separatorChars.equals(DEFAULT_SEPARATOR_CHARS) ? lineParts[termIndex] + " " + lineParts[termIndex + 1] : lineParts[termIndex];
                long count = Long.parseLong(lineParts[countIndex]);
                this.bigrams.put(key, count);
                if (count >= this.bigramCountMin) continue;
                this.bigramCountMin = count;
            }
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
        return true;
    }

    public boolean loadDictionary(String corpus, int termIndex, int countIndex, String separatorChars) {
        SuggestionStage staging;
        block20: {
            File file;
            if (separatorChars == null) {
                separatorChars = DEFAULT_SEPARATOR_CHARS;
            }
            if (!(file = new File(corpus)).exists()) {
                return false;
            }
            staging = new SuggestionStage(16384);
            try {
                BufferedReader br = Files.newBufferedReader(Paths.get(corpus, new String[0]), StandardCharsets.UTF_8);
                Throwable throwable = null;
                block13: while (true) {
                    try {
                        String line;
                        while ((line = br.readLine()) != null) {
                            String[] lineParts = line.split(separatorChars);
                            if (lineParts.length < 2) continue;
                            String key = lineParts[termIndex];
                            try {
                                long count = Long.parseLong(lineParts[countIndex]);
                                this.createDictionaryEntry(key, count, staging);
                                continue block13;
                            }
                            catch (NumberFormatException ex) {
                                System.out.println(ex.getMessage());
                            }
                        }
                        break block20;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (br != null) {
                        if (throwable != null) {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            br.close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                System.out.println(ex.getMessage());
            }
        }
        this.commitStaged(staging);
        return true;
    }

    public boolean createDictionary(String corpus) {
        File file = new File(corpus);
        if (!file.exists()) {
            return false;
        }
        SuggestionStage staging = new SuggestionStage(16384);
        try (BufferedReader br = Files.newBufferedReader(Paths.get(corpus, new String[0]), StandardCharsets.UTF_8);){
            String line;
            while ((line = br.readLine()) != null) {
                Arrays.stream(this.parseWords(line)).forEach(key -> this.createDictionaryEntry((String)key, 1L, staging));
            }
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
        this.commitStaged(staging);
        return true;
    }

    public void purgeBelowThresholdWords() {
        this.belowThresholdWords = new ConcurrentHashMap();
    }

    private void commitStaged(SuggestionStage staging) {
        staging.commitTo(this.deletes);
    }

    public List<SuggestItem> lookup(String input, Verbosity verbosity) {
        return this.lookup(input, verbosity, this.maxDictionaryEditDistance, false);
    }

    public List<SuggestItem> lookup(String input, Verbosity verbosity, int maxEditDistance) {
        return this.lookup(input, verbosity, maxEditDistance, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public List<SuggestItem> lookup(String input, Verbosity verbosity, int maxEditDistance, boolean includeUnknown) {
        if (maxEditDistance > this.maxDictionaryEditDistance) {
            throw new IllegalArgumentException("Edit distance too big: " + maxEditDistance);
        }
        ArrayList<SuggestItem> suggestions = new ArrayList<SuggestItem>();
        int inputLen = input.length();
        if (inputLen - maxEditDistance > this.maxDictionaryWordLength) {
            if (includeUnknown && suggestions.isEmpty()) {
                suggestions.add(new SuggestItem(input, maxEditDistance + 1, 0L));
            }
            return suggestions;
        }
        long suggestionCount = 0L;
        Long tmpCount = this.words.get(input);
        if (tmpCount != null) {
            suggestionCount = tmpCount;
            suggestions.add(new SuggestItem(input, 0, suggestionCount));
            if (verbosity != Verbosity.All) {
                return suggestions;
            }
        }
        if (maxEditDistance == 0) {
            if (includeUnknown && suggestions.isEmpty()) {
                suggestions.add(new SuggestItem(input, maxEditDistance + 1, 0L));
            }
            return suggestions;
        }
        HashSet<String> hashset1 = new HashSet<String>();
        HashSet<String> hashset2 = new HashSet<String>();
        hashset2.add(input);
        int maxEditDistance2 = maxEditDistance;
        int candidatePointer = 0;
        ArrayList<String> candidates = new ArrayList<String>();
        int inputPrefixLen = inputLen;
        if (inputPrefixLen > this.prefixLength) {
            inputPrefixLen = this.prefixLength;
            candidates.add(input.substring(0, inputPrefixLen));
        } else {
            candidates.add(input);
        }
        EditDistance distanceComparer = new EditDistance(this.distanceAlgorithm);
        while (candidatePointer < candidates.size()) {
            String candidate;
            int candidateLen;
            int lengthDiff;
            if ((lengthDiff = inputPrefixLen - (candidateLen = (candidate = (String)candidates.get(candidatePointer++)).length())) > maxEditDistance2) {
                if (verbosity != Verbosity.All) break;
                continue;
            }
            String[] dictSuggestions = this.deletes.get(this.getStringHash(candidate));
            if (dictSuggestions != null) {
                block5: for (String suggestion : dictSuggestions) {
                    boolean cc;
                    int suggPrefixLen;
                    int suggestionLen;
                    if (suggestion.equals(input) || Math.abs((suggestionLen = suggestion.length()) - inputLen) > maxEditDistance2 || suggestionLen < candidateLen || suggestionLen == candidateLen && !suggestion.equals(candidate) || (suggPrefixLen = Math.min(suggestionLen, this.prefixLength)) > inputPrefixLen && suggPrefixLen - candidateLen > maxEditDistance2) continue;
                    int distance = 0;
                    int min = 0;
                    if (candidateLen == 0) {
                        distance = Math.max(inputLen, suggestionLen);
                        if (distance > maxEditDistance2 || !hashset2.add(suggestion)) {
                            continue;
                        }
                    } else if (suggestionLen == 1) {
                        distance = input.indexOf(suggestion.charAt(0)) < 0 ? inputLen : inputLen - 1;
                        if (distance > maxEditDistance2 || !hashset2.add(suggestion)) {
                            continue;
                        }
                    } else {
                        min = Math.min(inputLen, suggestionLen) - this.prefixLength;
                    }
                    boolean bb = min > 1 && !input.substring(inputLen + 1 - min).equals(suggestion.substring(suggestionLen + 1 - min));
                    boolean bl = cc = min > 0 && input.charAt(inputLen - min) != suggestion.charAt(suggestionLen - min) && (input.charAt(inputLen - min - 1) != suggestion.charAt(suggestionLen - min) || input.charAt(inputLen - min) != suggestion.charAt(suggestionLen - min - 1));
                    if (this.prefixLength - maxEditDistance == candidateLen && bb || cc || verbosity != Verbosity.All && !this.deleteInSuggestionPrefix(candidate, candidateLen, suggestion, suggestionLen) || !hashset2.add(suggestion) || (distance = distanceComparer.compare(input, suggestion, maxEditDistance2)) < 0 || distance > maxEditDistance2) continue;
                    suggestionCount = this.words.get(suggestion);
                    SuggestItem si = new SuggestItem(suggestion, distance, suggestionCount);
                    if (!suggestions.isEmpty()) {
                        switch (verbosity) {
                            case Closest: {
                                if (distance >= maxEditDistance2) break;
                                suggestions.clear();
                                break;
                            }
                            case Top: {
                                if (distance >= maxEditDistance2 && suggestionCount <= ((SuggestItem)suggestions.get((int)0)).count) continue block5;
                                maxEditDistance2 = distance;
                                suggestions.set(0, si);
                                continue block5;
                            }
                        }
                    }
                    if (verbosity != Verbosity.All) {
                        maxEditDistance2 = distance;
                    }
                    suggestions.add(si);
                }
            }
            if (lengthDiff >= maxEditDistance || candidateLen > this.prefixLength || verbosity != Verbosity.All && lengthDiff >= maxEditDistance2) continue;
            for (int i = 0; i < candidateLen; ++i) {
                StringBuilder sb = new StringBuilder(candidate);
                sb.deleteCharAt(i);
                String delete = sb.toString();
                if (!hashset1.add(delete)) continue;
                candidates.add(delete);
            }
        }
        if (suggestions.size() > 1) {
            Collections.sort(suggestions);
        }
        if (includeUnknown && suggestions.isEmpty()) {
            suggestions.add(new SuggestItem(input, maxEditDistance + 1, 0L));
        }
        return suggestions;
    }

    private boolean deleteInSuggestionPrefix(String delete, int deleteLen, String suggestion, int suggestionLen) {
        if (deleteLen == 0) {
            return true;
        }
        if (this.prefixLength < suggestionLen) {
            suggestionLen = this.prefixLength;
        }
        int j = 0;
        for (int i = 0; i < deleteLen; ++i) {
            char delChar = delete.charAt(i);
            while (j < suggestionLen && delChar != suggestion.charAt(j)) {
                ++j;
            }
            if (j != suggestionLen) continue;
            return false;
        }
        return true;
    }

    private String[] parseWords(String text) {
        Pattern pattern = Pattern.compile("['\u2019\\w-[_]]+");
        Matcher match = pattern.matcher(text.toLowerCase());
        ArrayList<String> matches = new ArrayList<String>();
        while (match.find()) {
            matches.add(match.group());
        }
        String[] toreturn = new String[matches.size()];
        matches.toArray(toreturn);
        return toreturn;
    }

    private HashSet<String> edits(String word, int editDistance, HashSet<String> deleteWords) {
        ++editDistance;
        if (word.length() > 1) {
            for (int i = 0; i < word.length(); ++i) {
                StringBuilder sb = new StringBuilder(word);
                sb.deleteCharAt(i);
                String delete = sb.toString();
                if (!deleteWords.add(delete) || editDistance >= this.maxDictionaryEditDistance) continue;
                this.edits(delete, editDistance, deleteWords);
            }
        }
        return deleteWords;
    }

    private HashSet<String> editsPrefix(String key) {
        HashSet<String> hashSet = new HashSet<String>();
        if (key.length() <= this.maxDictionaryEditDistance) {
            hashSet.add("");
        }
        if (key.length() > this.prefixLength) {
            key = key.substring(0, this.prefixLength);
        }
        hashSet.add(key);
        return this.edits(key, 0, hashSet);
    }

    private int getStringHash(String s) {
        int len = s.length();
        int lenMask = len;
        if (lenMask > 3) {
            lenMask = 3;
        }
        long hash = 2166136261L;
        for (int i = 0; i < len; ++i) {
            hash ^= (long)s.charAt(i);
            hash *= 16777619L;
        }
        hash &= (long)this.compactMask;
        return (int)(hash |= (long)lenMask);
    }

    public List<SuggestItem> lookupCompound(String input) {
        return this.lookupCompound(input, this.maxDictionaryEditDistance);
    }

    public List<SuggestItem> lookupCompound(String input, int editDistanceMax) {
        String[] termList1 = this.parseWords(input);
        List<Object> suggestions = new ArrayList();
        ArrayList<Object> suggestionParts = new ArrayList<Object>();
        EditDistance distanceComparer = new EditDistance(this.distanceAlgorithm);
        boolean lastCombi = false;
        for (int i = 0; i < termList1.length; ++i) {
            List<SuggestItem> suggestionsCombi;
            suggestions = this.lookup(termList1[i], Verbosity.Top, editDistanceMax);
            if (i > 0 && !lastCombi && !(suggestionsCombi = this.lookup(termList1[i - 1] + termList1[i], Verbosity.Top, editDistanceMax)).isEmpty()) {
                SuggestItem best1 = (SuggestItem)suggestionParts.get(suggestionParts.size() - 1);
                SuggestItem best2 = new SuggestItem();
                if (!suggestions.isEmpty()) {
                    best2 = (SuggestItem)suggestions.get(0);
                } else {
                    best2.term = termList1[i];
                    best2.distance = editDistanceMax + 1;
                    best2.count = (long)(10.0 / Math.pow(10.0, best2.term.length()));
                }
                int distance1 = best1.distance + best2.distance;
                SuggestItem suggestItem = suggestionsCombi.get(0);
                double aa = (double)best1.count / 1.024908267229E12 * (double)best2.count;
                if (distance1 >= 0 && (suggestItem.distance + 1 < distance1 || suggestItem.distance + 1 == distance1 && (double)suggestItem.count > aa)) {
                    ++suggestItem.distance;
                    suggestionParts.set(suggestionParts.size() - 1, suggestItem);
                    lastCombi = true;
                    continue;
                }
            }
            lastCombi = false;
            if (!(suggestions.isEmpty() || ((SuggestItem)suggestions.get((int)0)).distance != 0 && termList1[i].length() != 1)) {
                suggestionParts.add(suggestions.get(0));
                continue;
            }
            SuggestItem suggestionSplitBest = null;
            if (!suggestions.isEmpty()) {
                suggestionSplitBest = (SuggestItem)suggestions.get(0);
            }
            if (termList1[i].length() > 1) {
                for (int j = 1; j < termList1[i].length(); ++j) {
                    List<SuggestItem> suggestions2;
                    String part1 = termList1[i].substring(0, j);
                    String part2 = termList1[i].substring(j);
                    SuggestItem suggestItem = new SuggestItem();
                    List<SuggestItem> suggestions1 = this.lookup(part1, Verbosity.Top, editDistanceMax);
                    if (suggestions1.isEmpty() || (suggestions2 = this.lookup(part2, Verbosity.Top, editDistanceMax)).isEmpty()) continue;
                    suggestItem.term = suggestions1.get((int)0).term + " " + suggestions2.get((int)0).term;
                    int distance2 = distanceComparer.compare(termList1[i], suggestItem.term, editDistanceMax);
                    if (distance2 < 0) {
                        distance2 = editDistanceMax + 1;
                    }
                    if (suggestionSplitBest != null) {
                        if (distance2 > suggestionSplitBest.distance) continue;
                        if (distance2 < suggestionSplitBest.distance) {
                            suggestionSplitBest = null;
                        }
                    }
                    SuggestItem sugg1 = suggestions1.get(0);
                    SuggestItem sugg2 = suggestions2.get(0);
                    suggestItem.distance = distance2;
                    Long bigramCount = this.bigrams.get(suggestItem.term);
                    if (bigramCount != null) {
                        suggestItem.count = bigramCount;
                        if (!suggestions.isEmpty()) {
                            SuggestItem sugg = (SuggestItem)suggestions.get(0);
                            if ((sugg1.term + sugg2.term).equals(termList1[i])) {
                                suggestItem.count = Math.max(suggestItem.count, sugg.count + 2L);
                            } else if (sugg1.term.equals(sugg.term) || sugg2.term.equals(sugg.term)) {
                                suggestItem.count = Math.max(suggestItem.count, sugg.count + 1L);
                            }
                        } else if ((sugg1.term + sugg2.term).equals(termList1[i])) {
                            suggestItem.count = Math.max(suggestItem.count, Math.max(sugg1.count, sugg2.count) + 2L);
                        }
                    } else {
                        suggestItem.count = Math.min(this.bigramCountMin, (long)((double)sugg1.count / 1.024908267229E12 * (double)sugg2.count));
                    }
                    if (suggestionSplitBest != null && suggestItem.count <= suggestionSplitBest.count) continue;
                    suggestionSplitBest = suggestItem;
                }
                if (suggestionSplitBest != null) {
                    suggestionParts.add(suggestionSplitBest);
                    continue;
                }
                SuggestItem si = new SuggestItem();
                si.term = termList1[i];
                si.count = (long)(10.0 / Math.pow(10.0, si.term.length()));
                si.distance = editDistanceMax + 1;
                suggestionParts.add(si);
                continue;
            }
            SuggestItem si = new SuggestItem();
            si.term = termList1[i];
            si.count = (long)(10.0 / Math.pow(10.0, si.term.length()));
            si.distance = editDistanceMax + 1;
            suggestionParts.add(si);
        }
        SuggestItem suggestion = new SuggestItem();
        double count = 1.024908267229E12;
        StringBuilder s = new StringBuilder();
        for (SuggestItem suggestItem : suggestionParts) {
            s.append(suggestItem.term).append(" ");
            count *= (double)suggestItem.count / 1.024908267229E12;
        }
        suggestion.count = (long)count;
        suggestion.term = s.toString().trim();
        suggestion.distance = distanceComparer.compare(input, suggestion.term, Integer.MAX_VALUE);
        ArrayList<SuggestItem> suggestionsLine = new ArrayList<SuggestItem>();
        suggestionsLine.add(suggestion);
        return suggestionsLine;
    }

    public Composition wordSegmentation(String input) {
        return this.wordSegmentation(input, this.maxDictionaryEditDistance, this.maxDictionaryWordLength);
    }

    public Composition wordSegmentation(String input, int maxEditDistance) {
        return this.wordSegmentation(input, maxEditDistance, this.maxDictionaryWordLength);
    }

    public Composition wordSegmentation(String input, int maxEditDistance, int maxSegmentationWordLength) {
        input = input.replace("-", "");
        int arraySize = Math.min(maxSegmentationWordLength, input.length());
        Composition[] compositions = new Composition[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            compositions[i] = new Composition();
        }
        int circularIndex = -1;
        for (int j = 0; j < input.length(); ++j) {
            int imax = Math.min(input.length() - j, maxSegmentationWordLength);
            for (int i = 1; i <= imax; ++i) {
                String part = input.substring(j, i);
                int separatorLength = 0;
                int topEd = 0;
                double topProbabilityLog = 0.0;
                String topResult = "";
                if (Character.isWhitespace(part.charAt(0))) {
                    part = part.substring(1);
                } else {
                    separatorLength = 1;
                }
                topEd += part.length();
                part = part.replace(" ", "");
                topEd -= part.length();
                List<SuggestItem> results = this.lookup(part.toLowerCase(), Verbosity.Top, maxEditDistance);
                if (!results.isEmpty()) {
                    topResult = results.get((int)0).term;
                    if (!part.isEmpty() && Character.isUpperCase(part.charAt(0))) {
                        char[] a = topResult.toCharArray();
                        a[0] = Character.toUpperCase(topResult.charAt(0));
                        topResult = new String(a);
                    }
                    topEd += results.get((int)0).distance;
                    topProbabilityLog = Math.log10((double)results.get((int)0).count / 1.024908267229E12);
                } else {
                    topResult = part;
                    topEd += part.length();
                    topProbabilityLog = Math.log10(10.0 / (1.024908267229E12 * Math.pow(10.0, part.length())));
                }
                int destIndex = (i + circularIndex) % arraySize;
                if (j == 0) {
                    compositions[destIndex].segmentedString = part;
                    compositions[destIndex].correctedString = topResult;
                    compositions[destIndex].distanceSum = topEd;
                    compositions[destIndex].probabilityLogSum = topProbabilityLog;
                    continue;
                }
                if (i != maxSegmentationWordLength && (compositions[circularIndex].distanceSum + topEd != compositions[destIndex].distanceSum && compositions[circularIndex].distanceSum + separatorLength + topEd != compositions[destIndex].distanceSum || !(compositions[destIndex].probabilityLogSum < compositions[circularIndex].probabilityLogSum + topProbabilityLog)) && compositions[circularIndex].distanceSum + separatorLength + topEd >= compositions[destIndex].distanceSum) continue;
                if (topResult.length() == 1 && this.isPunctuation(topResult.charAt(0)) || topResult.length() == 2 && topResult.startsWith("\u2019")) {
                    compositions[destIndex].segmentedString = compositions[circularIndex].segmentedString + part;
                    compositions[destIndex].correctedString = compositions[circularIndex].correctedString + topResult;
                    compositions[destIndex].distanceSum = compositions[circularIndex].distanceSum + topEd;
                    compositions[destIndex].probabilityLogSum = compositions[circularIndex].probabilityLogSum + topProbabilityLog;
                    continue;
                }
                compositions[destIndex].segmentedString = compositions[circularIndex].segmentedString + " " + part;
                compositions[destIndex].correctedString = compositions[circularIndex].correctedString + " " + topResult;
                compositions[destIndex].distanceSum = compositions[circularIndex].distanceSum + separatorLength + topEd;
                compositions[destIndex].probabilityLogSum = compositions[circularIndex].probabilityLogSum + topProbabilityLog;
            }
            if (++circularIndex != arraySize) continue;
            circularIndex = 0;
        }
        return compositions[circularIndex];
    }

    private boolean isPunctuation(char ch) {
        Matcher matcher = Pattern.compile("[\\\\p{Punct}\\\\p{IsPunctuation}]").matcher(String.valueOf(ch));
        return matcher.find();
    }

    public static class Composition {
        private String segmentedString = "";
        private String correctedString = "";
        private int distanceSum = 0;
        private double probabilityLogSum = 0.0;
    }

    private static class ChunkArray {
        private static final int CHUNK_SIZE = 4096;
        private static final int DIV_SHIFT = 12;
        public SuggestionStage.Node[][] values;
        public int count;

        public ChunkArray(int initialCapacity) {
            int chunks = (initialCapacity + 4096 - 1) / 4096;
            this.values = new SuggestionStage.Node[chunks][];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = new SuggestionStage.Node[4096];
            }
        }

        public int add(SuggestionStage.Node value) {
            if (this.count == this.capacity()) {
                SuggestionStage.Node[][] newValues = (SuggestionStage.Node[][])Arrays.copyOf(this.values, this.values.length + 1);
                newValues[this.values.length] = new SuggestionStage.Node[4096];
                this.values = newValues;
            }
            this.values[this.row((int)this.count)][this.col((int)this.count)] = value;
            ++this.count;
            return this.count - 1;
        }

        public void clear() {
            this.count = 0;
        }

        public SuggestionStage.Node getValues(int index) {
            return this.values[this.row(index)][this.col(index)];
        }

        public void setValues(int index, SuggestionStage.Node value) {
            this.values[this.row((int)index)][this.col((int)index)] = value;
        }

        public void setValues(int index, SuggestionStage.Node value, SuggestionStage.Node[][] list) {
            list[this.row((int)index)][this.col((int)index)] = value;
        }

        private int row(int index) {
            return index >> 12;
        }

        private int col(int index) {
            return index & 0xFFF;
        }

        private int capacity() {
            return this.values.length * 4096;
        }
    }

    public static class SuggestionStage {
        private final ConcurrentHashMap<Integer, Entry> deletes;
        private final ChunkArray nodes;

        public SuggestionStage(int initialCapacity) {
            this.deletes = new ConcurrentHashMap(initialCapacity);
            this.nodes = new ChunkArray(initialCapacity * 2);
        }

        public int deleteCount() {
            return this.deletes.size();
        }

        public int nodeCount() {
            return this.nodes.count;
        }

        public void clear() {
            this.deletes.clear();
            this.nodes.clear();
        }

        private void add(int deleteHash, String suggestion) {
            Entry entry = this.deletes.getOrDefault(deleteHash, new Entry(0, -1));
            int next = entry.first;
            ++entry.count;
            entry.first = this.nodes.count;
            this.deletes.put(deleteHash, entry);
            this.nodes.add(new Node(suggestion, next));
        }

        void commitTo(ConcurrentHashMap<Integer, String[]> permanentDeletes) {
            this.deletes.forEach((key, value) -> {
                int i;
                String[] suggestions = (String[])permanentDeletes.get(key);
                if (suggestions != null) {
                    i = suggestions.length;
                    String[] newSuggestions = Arrays.copyOf(suggestions, i + value.count);
                    permanentDeletes.put((Integer)key, newSuggestions);
                    suggestions = newSuggestions;
                } else {
                    i = 0;
                    suggestions = new String[value.count];
                    permanentDeletes.put((Integer)key, suggestions);
                }
                int next = value.first;
                while (next >= 0) {
                    Node node = this.nodes.getValues(next);
                    suggestions[i] = node.suggestion;
                    next = node.next;
                    ++i;
                }
            });
        }

        private static class Entry {
            public int count;
            public int first;

            Entry(int count, int first) {
                this.count = count;
                this.first = first;
            }
        }

        private static class Node {
            public String suggestion;
            public int next;

            public Node(String suggestion, int next) {
                this.suggestion = suggestion;
                this.next = next;
            }
        }
    }

    public static class SuggestItem
    implements Comparator<SuggestItem>,
    Comparable<SuggestItem> {
        public String term = "";
        public int distance = 0;
        public long count = 0L;
        public double proximity = 0.0;

        public SuggestItem() {
        }

        public SuggestItem(String term, int distance, long count) {
            this.term = term;
            this.distance = distance;
            this.count = count;
        }

        @Override
        public int compare(SuggestItem suggestItem, SuggestItem t1) {
            return suggestItem.compareTo(t1);
        }

        @Override
        public int compareTo(SuggestItem other) {
            if (this.distance == other.distance) {
                return Long.compare(other.count, this.count);
            }
            return Integer.compare(this.distance, other.distance);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof SuggestItem && this.term.equals(((SuggestItem)obj).term);
        }

        public int hashCode() {
            return this.term.hashCode();
        }

        public String toString() {
            return "{" + this.term + ", " + this.distance + ", " + this.count + ", " + this.proximity + "}";
        }
    }

    public static enum Verbosity {
        Top,
        Closest,
        All;

    }
}

