/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.facade;

import com.alibaba.fastjson.JSONArray;
import com.valor.common.search.engine.DefaultSearcher;
import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.SearchApiException;
import com.valor.common.search.engine.SearchEngineConfig;
import com.valor.common.search.engine.compensator.AbstractCompensator;
import com.valor.common.search.engine.facade.config.BizConfig;
import com.valor.common.search.engine.facade.config.CompensatorConfig;
import com.valor.common.search.engine.facade.config.HighlightConfig;
import com.valor.common.search.engine.facade.config.InLineScoreRankerConfig;
import com.valor.common.search.engine.facade.config.InlineFilterConfig;
import com.valor.common.search.engine.facade.config.MatcherConfig;
import com.valor.common.search.engine.facade.config.PostRankerConfig;
import com.valor.common.search.engine.facade.config.TakeResultHandlerConfig;
import com.valor.common.search.engine.filter.GeneralFilter;
import com.valor.common.search.engine.filter.InlineFilter;
import com.valor.common.search.engine.handler.TakeResultHandler;
import com.valor.common.search.engine.matcher.AbstractMatcher;
import com.valor.common.search.engine.matcher.Matcher;
import com.valor.common.search.engine.ranker.AbstractInlineScoreRanker;
import com.valor.common.search.engine.ranker.AbstractPostScoreRanker;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.StringUtils;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.RestHighLevelClient;

public class BizContainerBuilder {
    private RestHighLevelClient elasticSearchClient;
    private SearchEngineConfig bizSysConfig;
    private String bizBuilderConfig = "";
    private final Map<String, BizBuilder> bizBuilderMap = new HashMap<String, BizBuilder>();

    private BizContainerBuilder() {
    }

    public static BizContainerBuilder newInstance(SearchEngineConfig config, RestHighLevelClient esClient) {
        return BizContainerBuilder.newInstance(BizContainerBuilder.readAllLines("/search-engine-app-config.json"), config, esClient);
    }

    public static BizContainerBuilder newInstance(String bizBuilderConfig, SearchEngineConfig bizSysConfig, RestHighLevelClient esClient) {
        BizContainerBuilder instance = new BizContainerBuilder();
        instance.bizSysConfig = bizSysConfig;
        instance.bizBuilderConfig = bizBuilderConfig;
        instance.elasticSearchClient = esClient;
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readAllLines(String resource) {
        try (DataInputStream fin = new DataInputStream(BizContainerBuilder.class.getResourceAsStream(resource));){
            StringBuilder stringBuffer = new StringBuilder();
            String str = fin.readLine();
            while (str != null) {
                stringBuffer.append(str);
                str = fin.readLine();
            }
            String string = stringBuffer.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("read search-engine-app-config information failed!", e);
        }
    }

    public DefaultSearcher build(String bizName, String keywords, int fromIndex, int pageSize) {
        List bizConfigList = JSONArray.parseArray((String)this.bizBuilderConfig, BizConfig.class);
        for (BizConfig bizConfig : bizConfigList) {
            if (!bizConfig.getBizName().equalsIgnoreCase(bizName)) continue;
            BizBuilder bizBuilder = new BizBuilder();
            this.bizBuilderMap.put(bizName, bizBuilder);
            return bizBuilder.build(keywords, fromIndex, pageSize, bizConfig);
        }
        return null;
    }

    private class BizBuilder {
        private BizBuilder() {
        }

        public DefaultSearcher build(String keywords, int fromIndex, int pageSize, BizConfig bizConfig) {
            List<String> includeFields;
            List<String> excludeFields;
            HighlightConfig highlightConfig;
            DefaultSearcher defaultSearcher = new DefaultSearcher(BizContainerBuilder.this.elasticSearchClient, BizContainerBuilder.this.bizSysConfig.getIndexName());
            RequestContext context = defaultSearcher.prepareRequestContext(keywords, BizContainerBuilder.this.bizSysConfig.getMatchMainIndexFieldName(), fromIndex, pageSize);
            context.setBizSysConfig(BizContainerBuilder.this.bizSysConfig);
            int matcherFuzzyTermLetterLimit = BizContainerBuilder.this.bizSysConfig.getMatcherFuzzyTermLetterLimit();
            int matcherWordTermLetterLimit = (int)((float)matcherFuzzyTermLetterLimit * 1.5f);
            int matcherSentenceLetterLimit = BizContainerBuilder.this.bizSysConfig.getMatcherSentenceLetterLimit();
            HashMap hasBuildMatcherMap = new HashMap();
            if (CollectionUtils.isEmpty(bizConfig.getMatchers())) {
                throw new SearchApiException("Matcher is empty in app-config ");
            }
            bizConfig.getMatchers().forEach(matcherConfig -> {
                AbstractMatcher matcher = this.buildMatcher(context, (MatcherConfig)matcherConfig);
                defaultSearcher.matcher(matcher);
                hasBuildMatcherMap.put(matcherConfig.getIdName(), matcher);
            });
            if (!CollectionUtils.isEmpty(hasBuildMatcherMap) && !CollectionUtils.isEmpty(hasBuildMatcherMap.values())) {
                hasBuildMatcherMap.values().forEach(matcher -> {
                    if (!CollectionUtils.isEmpty(matcher.getMatcherConfig().getExclude())) {
                        for (String excludeMatcherName : matcher.getMatcherConfig().getExclude()) {
                            if (hasBuildMatcherMap.get(excludeMatcherName) == null) continue;
                            matcher.exclude((Matcher)hasBuildMatcherMap.get(excludeMatcherName));
                        }
                    }
                });
            }
            if (!CollectionUtils.isEmpty(bizConfig.getPostRankers())) {
                bizConfig.getPostRankers().forEach(postRankerConfig -> {
                    AbstractPostScoreRanker abstractPostScoreRanker = this.buildPostRanker(context, (PostRankerConfig)postRankerConfig);
                    abstractPostScoreRanker.setBizSysConfig(BizContainerBuilder.this.bizSysConfig);
                    defaultSearcher.ranker(abstractPostScoreRanker);
                });
            }
            if (!CollectionUtils.isEmpty(bizConfig.getInLineScoreRankers())) {
                bizConfig.getInLineScoreRankers().forEach(inLineScoreRankerConfig -> defaultSearcher.ranker(this.buildInlineScoreRanker(context, (InLineScoreRankerConfig)inLineScoreRankerConfig)));
            }
            if (!CollectionUtils.isEmpty(bizConfig.getFilters())) {
                bizConfig.getFilters().forEach(inLintFilterConfig -> defaultSearcher.filter(this.buildInlineFilters((InlineFilterConfig)inLintFilterConfig)));
            }
            if (!CollectionUtils.isEmpty(bizConfig.getCompensators())) {
                bizConfig.getCompensators().forEach(compensatorConfig -> defaultSearcher.compensator(this.buildCompensater(context, (CompensatorConfig)compensatorConfig)));
            }
            if (bizConfig.getTakeResultHandler() != null) {
                TakeResultHandler takeResultHandler = this.buildTakeResaultHandler(bizConfig.getTakeResultHandler());
                takeResultHandler.setWantedSize(pageSize);
                defaultSearcher.addHandler(takeResultHandler);
            }
            if ((highlightConfig = bizConfig.getHighlight()) != null) {
                if (BizContainerBuilder.this.bizSysConfig.isOpenHighlight() && highlightConfig.isEnable()) {
                    defaultSearcher.enableHighlight();
                } else {
                    defaultSearcher.disableHighlight();
                }
                context.setHighlightExtFieldNameSuffix(highlightConfig.getExtFieldNameSuffix());
                ArrayList<HighlightConfig.HighlightItemConfig> bizSysHighLightConfig = new ArrayList<HighlightConfig.HighlightItemConfig>();
                for (String fieldName : BizContainerBuilder.this.bizSysConfig.getHighlightFieldsName()) {
                    boolean found = false;
                    for (HighlightConfig.HighlightItemConfig highLightItemConfig : highlightConfig.getHighlightFieldNames()) {
                        if (!highLightItemConfig.getField().equalsIgnoreCase(fieldName)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    bizSysHighLightConfig.add(new HighlightConfig.HighlightItemConfig(fieldName, "unified"));
                }
                bizSysHighLightConfig.addAll(highlightConfig.getHighlightFieldNames());
                context.setHighLightItemConfigList(bizSysHighLightConfig);
                context.setHighlightPreTag(highlightConfig.getPreTag());
                context.setHighlightPostTag(highlightConfig.getPostTag());
                context.setDefaultHighlightType(highlightConfig.getDefaultType());
            }
            if (!CollectionUtils.isEmpty(excludeFields = bizConfig.getSourceField().get("exclude"))) {
                defaultSearcher.excludeSourceField(excludeFields.toArray(new String[0]));
            }
            if (!CollectionUtils.isEmpty(includeFields = bizConfig.getSourceField().get("include"))) {
                defaultSearcher.includeSourceField(includeFields.toArray(new String[0]));
            }
            return defaultSearcher;
        }

        private InlineFilter buildInlineFilters(InlineFilterConfig config) {
            InlineFilter filter = null;
            if (StringUtils.isEmpty(config.getFullClassName())) {
                throw new RuntimeException("InlineFilter class name must not empty!");
            }
            try {
                Class<?> clz = Class.forName(config.getFullClassName());
                filter = (InlineFilter)clz.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            if (filter instanceof GeneralFilter) {
                filter.prepareByConfig(config);
            }
            return filter;
        }

        private AbstractInlineScoreRanker buildInlineScoreRanker(RequestContext context, InLineScoreRankerConfig config) {
            AbstractInlineScoreRanker ranker = null;
            if (StringUtils.isEmpty(config.getFullClassName())) {
                throw new RuntimeException("InLineScoreRanker class name must not empty!");
            }
            try {
                Class<?> clz = Class.forName(config.getFullClassName());
                ranker = (AbstractInlineScoreRanker)clz.newInstance();
                ranker.setContext(context);
                ranker.prepareByConfig(config);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            return ranker;
        }

        private TakeResultHandler buildTakeResaultHandler(TakeResultHandlerConfig config) {
            TakeResultHandler handler = null;
            if (StringUtils.isEmpty(config.getFullClassName())) {
                throw new RuntimeException("TakeResultHandler class name must not empty!");
            }
            try {
                Class<?> clz = Class.forName(config.getFullClassName());
                handler = (TakeResultHandler)clz.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            return handler;
        }

        private AbstractPostScoreRanker buildPostRanker(RequestContext context, PostRankerConfig config) {
            AbstractPostScoreRanker ranker = null;
            if (StringUtils.isEmpty(config.getFullClassName())) {
                throw new RuntimeException("PostRanker class name must not empty!");
            }
            try {
                Class<?> clz = Class.forName(config.getFullClassName());
                ranker = (AbstractPostScoreRanker)clz.newInstance();
                ranker.setContext(context);
                ranker.prepareByConfig(config);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            return ranker;
        }

        private AbstractMatcher buildMatcher(RequestContext context, MatcherConfig config) {
            if (StringUtils.isEmpty(config.getFullClassName())) {
                throw new RuntimeException("matcher class name must not empty!");
            }
            AbstractMatcher matcher = null;
            try {
                Class<?> clz = Class.forName(config.getFullClassName());
                matcher = (AbstractMatcher)clz.newInstance();
                matcher.setContext(context);
                matcher.prepareByConfig(config);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            return matcher;
        }

        private AbstractCompensator buildCompensater(RequestContext context, CompensatorConfig config) {
            if (StringUtils.isEmpty(config.getFullClassName())) {
                throw new RuntimeException("matcher class name must not empty!");
            }
            AbstractCompensator compensater = null;
            try {
                Class<?> clz = Class.forName(config.getFullClassName());
                compensater = (AbstractCompensator)clz.newInstance();
                compensater.setContext(context);
                compensater.prepareByConfig(config);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            return compensater;
        }
    }
}

