/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.facade;

import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.SearchUtils;
import java.util.List;

public class Condition {
    private String fieldName;
    private List<String> values;

    public Condition(String fieldName, List<String> values) {
        this.fieldName = fieldName;
        this.values = values;
    }

    public Condition(String fieldName, String[] values) {
        this.fieldName = fieldName;
        this.values = CollectionUtils.arrayToList(values);
    }

    public Condition(String fieldName, List<String> values, boolean ignoreCase) {
        this.fieldName = fieldName;
        this.values = ignoreCase ? SearchUtils.toLowercase(values) : values;
    }

    public Condition(String fieldName, String[] values, boolean ignoreCase) {
        this.fieldName = fieldName;
        this.values = ignoreCase ? CollectionUtils.arrayToList(SearchUtils.toLowercase(values)) : CollectionUtils.arrayToList(values);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public static Condition createIgnoreCaseCondition(String fieldName, List<String> values) {
        Condition condition = new Condition(fieldName, SearchUtils.toLowercase(values));
        return condition;
    }

    public static Condition createIgnoreCaseCondition(String fieldName, String[] values) {
        Condition condition = new Condition(fieldName, SearchUtils.toLowercase(values));
        return condition;
    }

    public static Condition createNormalCondition(String fieldName, List<String> values) {
        Condition condition = new Condition(fieldName, values);
        return condition;
    }

    public static Condition createNormalCondition(String fieldName, String[] values) {
        Condition condition = new Condition(fieldName, values);
        return condition;
    }
}

