/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.facade;

import com.alibaba.fastjson.JSONObject;
import com.valor.common.search.engine.DefaultSearcher;
import com.valor.common.search.engine.HighlightFieldInfo;
import com.valor.common.search.engine.MatchingTitle;
import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.RequestParams;
import com.valor.common.search.engine.SearchApiException;
import com.valor.common.search.engine.SearchApiResponse;
import com.valor.common.search.engine.SearchEngineConfig;
import com.valor.common.search.engine.WrappedSearchResponse;
import com.valor.common.search.engine.aggs.TermsAggregation;
import com.valor.common.search.engine.facade.BizContainerBuilder;
import com.valor.common.search.engine.facade.Condition;
import com.valor.common.search.engine.facade.FuzzinessQueryMode;
import com.valor.common.search.engine.facade.Statistics;
import com.valor.common.search.engine.filter.CompositeFilter;
import com.valor.common.search.engine.filter.Filter;
import com.valor.common.search.engine.filter.FilterFuncEnum;
import com.valor.common.search.engine.filter.GeneralFilter;
import com.valor.common.search.engine.filter.InlineFilter;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.FragmentProximity;
import com.valor.common.search.engine.util.SearchUtils;
import com.valor.common.search.engine.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeliplatBizFacade {
    private static final Logger logger = LoggerFactory.getLogger(PeliplatBizFacade.class);
    private static final Logger highlightLogger = LoggerFactory.getLogger((String)"HighlightLogger");
    private final RestHighLevelClient esClient;

    public PeliplatBizFacade(RestHighLevelClient esClient) {
        this.esClient = esClient;
    }

    private Map<Integer, List<String>> readMatcherQueries(SearchHit[] hits, int fromIndex, int length) {
        HashMap<Integer, List<String>> matcherQueriesMap = new HashMap<Integer, List<String>>();
        for (int index = fromIndex; index < fromIndex + length; ++index) {
            SearchHit hit = hits[index];
            matcherQueriesMap.put(index - fromIndex, Arrays.asList(hit.getMatchedQueries()));
        }
        return matcherQueriesMap;
    }

    private List<HighlightFieldInfo> covertHighlightInfo(SearchHit hit, String postTags, String preTags, RequestContext context, List<String> bizHighlightFieldNames) {
        Map<String, Set<String>> querySentenceMatchedFieldNamesMap = context.getQuerySentenceMatchedFieldNamesMap();
        HashSet<String> matchedFieldNameSet = new HashSet<String>();
        for (String queriesName : hit.getMatchedQueries()) {
            Set<String> currentQueriesNameMatchedFieldNameSet = querySentenceMatchedFieldNamesMap.get(queriesName);
            if (currentQueriesNameMatchedFieldNameSet == null) continue;
            matchedFieldNameSet.addAll(currentQueriesNameMatchedFieldNameSet);
        }
        return this.execFindHighlightSourceFieldInfo(hit, matchedFieldNameSet, preTags, postTags, bizHighlightFieldNames);
    }

    private List<HighlightFieldInfo> execFindHighlightSourceFieldInfo(SearchHit hit, Set<String> matchedFieldNameSet, String preTags, String postTags, List<String> bizHighlightFieldNames) {
        LinkedHashSet<HighlightFieldInfo> highlightList = new LinkedHashSet<HighlightFieldInfo>();
        for (Map.Entry entry : hit.getHighlightFields().entrySet()) {
            if (!matchedFieldNameSet.contains(entry.getKey())) continue;
            HighlightField item = (HighlightField)entry.getValue();
            boolean hitBizField = bizHighlightFieldNames.contains(item.getName());
            if (hitBizField) {
                for (Text highlightText : item.getFragments()) {
                    for (String fieldName : bizHighlightFieldNames) {
                        if (!item.getName().equalsIgnoreCase(fieldName)) continue;
                        Set<HighlightFieldInfo> curHitHighlightFieldInfos = this.findHighlightSourceByHitItem(hit, fieldName, true, highlightText, postTags, preTags, (String)entry.getKey());
                        if (CollectionUtils.isEmpty(curHitHighlightFieldInfos)) {
                            curHitHighlightFieldInfos = this.findHighlightSourceByHitItem(hit, fieldName, false, highlightText, postTags, preTags, (String)entry.getKey());
                        }
                        highlightList.addAll(curHitHighlightFieldInfos);
                    }
                }
                continue;
            }
            LinkedHashSet<HighlightFieldInfo> curHitHighlightFieldInfos = new LinkedHashSet<HighlightFieldInfo>();
            for (Text highlightText : item.getFragments()) {
                for (String fieldName : bizHighlightFieldNames) {
                    curHitHighlightFieldInfos.addAll(this.findHighlightSourceByHitItem(hit, fieldName, true, highlightText, postTags, preTags, (String)entry.getKey()));
                }
            }
            if (CollectionUtils.isEmpty(curHitHighlightFieldInfos)) {
                for (Text highlightText : item.getFragments()) {
                    for (String fieldName : bizHighlightFieldNames) {
                        curHitHighlightFieldInfos.addAll(this.findHighlightSourceByHitItem(hit, fieldName, false, highlightText, postTags, preTags, (String)entry.getKey()));
                    }
                }
            }
            highlightList.addAll(curHitHighlightFieldInfos);
        }
        return new ArrayList<HighlightFieldInfo>(highlightList);
    }

    private Set<HighlightFieldInfo> findHighlightSourceByHitItem(SearchHit hit, String sourceFieldName, boolean extractMatch, Text highlightText, String postTags, String preTags, String highlightedFieldName) {
        Object obj = hit.getSourceAsMap().get(sourceFieldName);
        String highlightSourceText = highlightText.toString().replaceAll(preTags, "").replaceAll(postTags, "");
        String mergedHighlightTagText = highlightText.toString().replaceAll(postTags + preTags, "");
        LinkedHashSet<HighlightFieldInfo> highlightList = new LinkedHashSet<HighlightFieldInfo>();
        if (obj instanceof List) {
            List targetFieldValues = (List)obj;
            for (int index = 0; index < targetFieldValues.size(); ++index) {
                HighlightFieldInfo highLightFieldInfo;
                if (extractMatch && ((String)targetFieldValues.get(index)).trim().equalsIgnoreCase(highlightSourceText)) {
                    highLightFieldInfo = new HighlightFieldInfo(sourceFieldName, mergedHighlightTagText, index, highlightSourceText, highlightedFieldName);
                    highlightList.add(highLightFieldInfo);
                    continue;
                }
                if (extractMatch || !((String)targetFieldValues.get(index)).trim().contains(highlightSourceText)) continue;
                try {
                    highLightFieldInfo = new HighlightFieldInfo(sourceFieldName, ((String)targetFieldValues.get(index)).replaceAll(highlightSourceText, mergedHighlightTagText), index, highlightSourceText, highlightedFieldName);
                    highlightList.add(highLightFieldInfo);
                    continue;
                }
                catch (Exception e) {
                    HighlightFieldInfo highLightFieldInfo2 = new HighlightFieldInfo(sourceFieldName, ((String)targetFieldValues.get(index)).replace(highlightSourceText, mergedHighlightTagText), index, highlightSourceText, highlightedFieldName);
                    highlightList.add(highLightFieldInfo2);
                }
            }
        } else {
            String targetFieldValue = (String)obj;
            if (extractMatch && targetFieldValue.trim().equalsIgnoreCase(highlightSourceText)) {
                HighlightFieldInfo highLightFieldInfo = new HighlightFieldInfo(sourceFieldName, mergedHighlightTagText, 0, highlightSourceText, highlightedFieldName);
                highlightList.add(highLightFieldInfo);
            } else if (!extractMatch && targetFieldValue.trim().contains(highlightSourceText)) {
                HighlightFieldInfo highLightFieldInfo = new HighlightFieldInfo(sourceFieldName, mergedHighlightTagText, 0, highlightSourceText, highlightedFieldName);
                highlightList.add(highLightFieldInfo);
            }
        }
        return highlightList;
    }

    private <T> SearchApiResponse<T> readRespData(WrappedSearchResponse wrappedResponse, int fromIndex, int dataSize, Class<T> indexDataClazz, RequestContext context, SearchEngineConfig config) throws SearchApiException {
        try {
            SearchApiResponse apiResponse = new SearchApiResponse();
            apiResponse.setHitTotal(SearchUtils.getTotalHitsSize(wrappedResponse.getHits()));
            apiResponse.setTookTime(wrappedResponse.getTook().getMillis());
            apiResponse.setHitCount(wrappedResponse.getHits().getHits().length);
            String postTag = context.getHighlightPostTag();
            String preTag = context.getHighlightPreTag();
            LinkedHashMap originalHighlightMap = new LinkedHashMap();
            for (int index = fromIndex; index < fromIndex + dataSize; ++index) {
                SearchHit hit = wrappedResponse.getHits().getHits()[index];
                Map sourceMap = hit.getSourceAsMap();
                sourceMap.put("docId", hit.getId());
                sourceMap.put("score", Float.valueOf(hit.getScore()));
                sourceMap.put("matcherQueries", hit.getMatchedQueries());
                List<HighlightFieldInfo> highlightList = this.covertHighlightInfo(hit, postTag, preTag, context, config.getHighlightFieldsName());
                this.readBizHighlightExtInfo(hit, highlightList, context);
                sourceMap.put("highlight", highlightList);
                List<MatchingTitle> matchingTitles = this.processMatchingTitle(context.getQ(), hit, config);
                sourceMap.put("matchingTitles", matchingTitles);
                Object item = JSONObject.parseObject((String)JSONObject.toJSONString((Object)sourceMap), indexDataClazz);
                apiResponse.getSource().add(item);
                if (!highlightLogger.isDebugEnabled()) continue;
                ArrayList highlightFields = new ArrayList(hit.getHighlightFields().size());
                for (Map.Entry highlightFieldEntry : hit.getHighlightFields().entrySet()) {
                    HashMap itemMap = new HashMap();
                    itemMap.put(highlightFieldEntry.getKey(), highlightFieldEntry.getValue());
                    highlightFields.add(itemMap);
                }
                originalHighlightMap.put(hit.getId(), highlightFields);
            }
            if (highlightLogger.isDebugEnabled()) {
                apiResponse.putAttachment("highlightFields", originalHighlightMap);
            }
            return apiResponse;
        }
        catch (Exception e) {
            throw new SearchApiException("Read elasticsearch data error.", e);
        }
    }

    private void readBizHighlightExtInfo(SearchHit hit, List<HighlightFieldInfo> highlightList, RequestContext context) {
        for (HighlightFieldInfo highlightFieldInfo : highlightList) {
            if (hit.getSourceAsMap().get(highlightFieldInfo.getHitFieldName()) instanceof List) {
                String key = highlightFieldInfo.getHitFieldName() + context.getHighlightExtFieldNameSuffix();
                List extFieldList = hit.getSourceAsMap().getOrDefault(key, new ArrayList());
                if (extFieldList.size() < highlightFieldInfo.getHitIndex() + 1) continue;
                String extInfo = (String)extFieldList.get(highlightFieldInfo.getHitIndex());
                highlightFieldInfo.setExtInfo(extInfo);
                continue;
            }
            highlightFieldInfo.setExtInfo(hit.getSourceAsMap().getOrDefault(highlightFieldInfo.getHitFieldName() + context.getHighlightExtFieldNameSuffix(), "").toString());
        }
    }

    private List<String> getListFromMap(Map<String, Object> sourceMap, String key) {
        Object value = sourceMap.getOrDefault(key, null);
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof String) {
            ArrayList<String> listValue = new ArrayList<String>();
            listValue.add(value.toString());
            return listValue;
        }
        return Collections.emptyList();
    }

    private List<MatchingTitle> processMatchingTitle(String queryInput, SearchHit hit, SearchEngineConfig config) {
        String ext;
        int i;
        ArrayList<MatchingTitle> listMatching = new ArrayList<MatchingTitle>();
        List<String> titles = this.getListFromMap(hit.getSourceAsMap(), "title");
        List<String> titlesExt = this.getListFromMap(hit.getSourceAsMap(), "title_ext");
        for (i = 0; i < titles.size(); ++i) {
            ext = i < titlesExt.size() ? titlesExt.get(i) : "";
            listMatching.add(new MatchingTitle("title", titles.get(i), i, ext, 0.0));
        }
        List<String> keywords = this.getListFromMap(hit.getSourceAsMap(), "keywords");
        List<String> keywordsExt = this.getListFromMap(hit.getSourceAsMap(), "keywords_ext");
        for (i = 0; i < keywords.size(); ++i) {
            ext = i < keywordsExt.size() ? keywordsExt.get(i) : "";
            listMatching.add(new MatchingTitle("keywords", keywords.get(i), i, ext, 0.0));
        }
        String q = queryInput.toLowerCase();
        listMatching.forEach(matchingInfo -> matchingInfo.setScore(FragmentProximity.distance(q, matchingInfo.getHitText().toLowerCase())));
        Collections.sort(listMatching);
        if (((MatchingTitle)listMatching.get(0)).getScore() == 0.0) {
            listMatching.forEach(matchingInfo -> matchingInfo.setScore(FragmentProximity.jaccardScore(q, matchingInfo.getHitText().toLowerCase())));
            Collections.sort(listMatching);
        }
        MatchingTitle.Verbosity verbosity = config.getMatchingTitleVerbosity();
        List<String> expectExts = config.getMatchingTitleExpectExts();
        if (verbosity == MatchingTitle.Verbosity.Top) {
            return listMatching.subList(0, 1);
        }
        if (verbosity == MatchingTitle.Verbosity.Closest) {
            if (expectExts == null) {
                return listMatching;
            }
            ArrayList<MatchingTitle> closestMatching = new ArrayList<MatchingTitle>(expectExts.size());
            block2: for (String ext2 : expectExts) {
                for (MatchingTitle matchingTitle : listMatching) {
                    if (!ext2.equals(matchingTitle.getExtInfo())) continue;
                    closestMatching.add(matchingTitle);
                    continue block2;
                }
            }
            return closestMatching;
        }
        return listMatching;
    }

    public <T> SearchApiResponse<T> matchSearch(int pageId, int pageSize, String keyword, List<String> marks, Class<T> indexDataClazz, SearchEngineConfig config, RequestParams requestParams) {
        return this.matchSearchImpl(pageId, pageSize, keyword, marks, indexDataClazz, config, "peliplat-search", requestParams);
    }

    public <T> SearchApiResponse<T> strictMatchSearch(int pageId, int pageSize, String keyword, List<String> marks, Class<T> indexDataClazz, SearchEngineConfig config, RequestParams requestParams) {
        return this.matchSearchImpl(pageId, pageSize, keyword, marks, indexDataClazz, config, "peliplat-search-strict-match", requestParams);
    }

    private <T> SearchApiResponse<T> matchSearchImpl(int pageId, int pageSize, String keyword, List<String> marks, Class<T> indexDataClazz, SearchEngineConfig config, String bizName, RequestParams requestParams) {
        SearchApiResponse.StageInfo stageInfo = new SearchApiResponse.StageInfo();
        stageInfo.setTsRecvReq(System.currentTimeMillis());
        if (StringUtils.isEmpty(keyword)) {
            return new SearchApiResponse();
        }
        ESPageInfo esPageInfo = this.convertMatchSearchPagingToEsPaging(pageSize, pageId, config);
        if (esPageInfo == null) {
            return new SearchApiResponse();
        }
        DefaultSearcher searcher = BizContainerBuilder.newInstance(config, this.esClient).build(bizName, keyword, esPageInfo.esFromIndex, esPageInfo.esSize);
        if (!CollectionUtils.isEmpty(requestParams.getExcludeConditions())) {
            this.prepareCondition(searcher, requestParams.getExcludeConditions(), FilterFuncEnum.NOTEQUAL, CompositeFilter.Func.OR);
        }
        if (!CollectionUtils.isEmpty(requestParams.getIncludeConditions())) {
            this.prepareCondition(searcher, requestParams.getIncludeConditions(), FilterFuncEnum.EQUAL, CompositeFilter.Func.AND);
        }
        this.prepareMarks(searcher, marks, config);
        try {
            FuzzinessQueryMode fuzzinessQueryMode = config.getFuzzinessQueryMode();
            if (FuzzinessQueryMode.NO.equals((Object)fuzzinessQueryMode) || FuzzinessQueryMode.AUTO.equals((Object)fuzzinessQueryMode)) {
                searcher.getRequestContext().disableFuzziness();
            } else {
                searcher.getRequestContext().enableFuzziness();
            }
            searcher.execute();
            stageInfo.firstQueryInfo(searcher.getRequestContext().getResponse().getTook().getMillis(), searcher.getStartQueryTime(), searcher.getEndQueryTime());
            if (FuzzinessQueryMode.AUTO.equals((Object)fuzzinessQueryMode)) {
                Statistics.matchSearchInvoked1st();
                if (!this.checkHasAllMatchData(searcher.getRequestContext().getResponse().getHits().getHits())) {
                    searcher = BizContainerBuilder.newInstance(config, this.esClient).build(bizName, keyword, esPageInfo.esFromIndex, esPageInfo.esSize);
                    searcher.getRequestContext().enableFuzziness();
                    if (!CollectionUtils.isEmpty(requestParams.getExcludeConditions())) {
                        this.prepareCondition(searcher, requestParams.getExcludeConditions(), FilterFuncEnum.NOTEQUAL, CompositeFilter.Func.OR);
                    }
                    if (!CollectionUtils.isEmpty(requestParams.getIncludeConditions())) {
                        this.prepareCondition(searcher, requestParams.getIncludeConditions(), FilterFuncEnum.EQUAL, CompositeFilter.Func.AND);
                    }
                    this.prepareMarks(searcher, marks, config);
                    stageInfo.setQuery2nd(true);
                    searcher.execute();
                    stageInfo.secondQueryInfo(searcher.getRequestContext().getResponse().getTook().getMillis(), searcher.getStartQueryTime(), searcher.getEndQueryTime());
                    Statistics.matchSearchInvoked2nd();
                }
            }
        }
        catch (Exception e) {
            throw new SearchApiException(e);
        }
        SearchApiResponse<T> apiResponse = this.buildSearchResponse(searcher, indexDataClazz, config, esPageInfo.esBatchLoad, esPageInfo.fromIndex, pageSize);
        apiResponse.setPredictions(searcher.getRequestContext().getPredictions());
        stageInfo.setPredictTook(searcher.getRequestContext().getPredictTookMillis());
        stageInfo.setTsSendResp(System.currentTimeMillis());
        apiResponse.setStageInfo(stageInfo);
        return apiResponse;
    }

    private boolean checkHasAllMatchData(SearchHit[] hits) {
        for (SearchHit hit : hits) {
            for (String matchedStr : hit.getMatchedQueries()) {
                if (!matchedStr.toLowerCase().startsWith("entiretymatcher")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMissingWordMatchData(SearchHit[] hits) {
        for (SearchHit hit : hits) {
            for (String matchedStr : hit.getMatchedQueries()) {
                if (!matchedStr.toLowerCase().startsWith("missingwordmatcher")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean needQuery2nd(SearchHit[] hits) {
        for (SearchHit hit : hits) {
            for (String matchedStr : hit.getMatchedQueries()) {
                if (!matchedStr.toLowerCase().startsWith("entiretymatcher") && !matchedStr.toLowerCase().startsWith("missingwordmatcher")) continue;
                return false;
            }
        }
        return true;
    }

    private <T> SearchApiResponse<T> buildSearchResponse(DefaultSearcher searcher, Class<T> indexDataClazz, SearchEngineConfig config, boolean esBatchLoad, int fromIndex, int pageSize) {
        WrappedSearchResponse wrappedResponse = (WrappedSearchResponse)searcher.getRequestContext().getResponse();
        SearchHit[] hits = wrappedResponse.getHits().getHits();
        if (esBatchLoad) {
            if (hits.length < fromIndex) {
                SearchApiResponse esDataResponse = new SearchApiResponse();
                esDataResponse.getSource().clear();
                esDataResponse.setHitCount(0L);
                if (highlightLogger.isDebugEnabled()) {
                    esDataResponse.putAttachment("matchFieldName", searcher.getRequestContext().getQueryMatcherMatchedFieldNameMap());
                }
                return esDataResponse;
            }
            int dataSize = Math.min(pageSize, hits.length - fromIndex);
            SearchApiResponse<T> esDataResponse = this.readRespData(wrappedResponse, fromIndex, dataSize, indexDataClazz, searcher.getRequestContext(), config);
            esDataResponse.setHitCount(dataSize);
            if (highlightLogger.isDebugEnabled()) {
                esDataResponse.putAttachment("matcherNames", this.readMatcherQueries(hits, fromIndex, dataSize));
                esDataResponse.putAttachment("querySentenceMatchedFieldNames", searcher.getRequestContext().getQueryMatcherMatchedFieldNameMap());
                esDataResponse.putAttachment("highlightFieldName", searcher.getRequestContext().getQueryMatcherMatchedFieldNameMap());
            }
            return esDataResponse;
        }
        SearchApiResponse<T> esDataResponse = this.readRespData(wrappedResponse, 0, hits.length, indexDataClazz, searcher.getRequestContext(), config);
        esDataResponse.setHitCount(hits.length);
        if (highlightLogger.isDebugEnabled()) {
            esDataResponse.putAttachment("matcherNames", this.readMatcherQueries(hits, 0, hits.length));
            esDataResponse.putAttachment("querySentenceMatchedFieldNames", searcher.getRequestContext().getQueryMatcherMatchedFieldNameMap());
            esDataResponse.putAttachment("highlightFieldName", searcher.getRequestContext().getQueryMatcherMatchedFieldNameMap());
        }
        return esDataResponse;
    }

    private <T> SearchApiResponse<T> instanceSearchImpl(int pageSize, String keyword, List<String> marks, Class<T> indexDataClazz, SearchEngineConfig config, String bizName, RequestParams requestParams) {
        if (StringUtils.isEmpty(keyword)) {
            return new SearchApiResponse();
        }
        if (pageSize > 100) {
            pageSize = 100;
        }
        if (pageSize <= 0) {
            pageSize = 10;
        }
        int esSize = 100;
        DefaultSearcher searcher = BizContainerBuilder.newInstance(config, this.esClient).build(bizName, keyword, 0, esSize);
        if (!CollectionUtils.isEmpty(requestParams.getExcludeConditions())) {
            this.prepareCondition(searcher, requestParams.getExcludeConditions(), FilterFuncEnum.NOTEQUAL, CompositeFilter.Func.OR);
        }
        if (!CollectionUtils.isEmpty(requestParams.getIncludeConditions())) {
            this.prepareCondition(searcher, requestParams.getIncludeConditions(), FilterFuncEnum.EQUAL, CompositeFilter.Func.AND);
        }
        searcher.disableHighlight();
        this.prepareMarksForInstanceSearch(marks, searcher, config);
        try {
            FuzzinessQueryMode fuzzinessQueryMode = config.getFuzzinessQueryMode();
            if (FuzzinessQueryMode.AUTO.equals((Object)fuzzinessQueryMode) || FuzzinessQueryMode.NO.equals((Object)fuzzinessQueryMode)) {
                searcher.getRequestContext().disableFuzziness();
            } else {
                searcher.getRequestContext().enableFuzziness();
            }
            searcher.execute();
            if (FuzzinessQueryMode.AUTO.equals((Object)fuzzinessQueryMode)) {
                Statistics.instantSearchInvoked1st();
                if (!this.checkHasAllMatchData(searcher.getRequestContext().getResponse().getHits().getHits())) {
                    searcher = BizContainerBuilder.newInstance(config, this.esClient).build(bizName, keyword, 0, esSize);
                    if (!CollectionUtils.isEmpty(requestParams.getExcludeConditions())) {
                        this.prepareCondition(searcher, requestParams.getExcludeConditions(), FilterFuncEnum.NOTEQUAL, CompositeFilter.Func.OR);
                    }
                    if (!CollectionUtils.isEmpty(requestParams.getIncludeConditions())) {
                        this.prepareCondition(searcher, requestParams.getIncludeConditions(), FilterFuncEnum.EQUAL, CompositeFilter.Func.AND);
                    }
                    searcher.disableHighlight();
                    this.prepareMarksForInstanceSearch(marks, searcher, config);
                    searcher.getRequestContext().enableFuzziness();
                    searcher.execute();
                    Statistics.instantSearchInvoked2nd();
                }
            }
        }
        catch (Exception e) {
            throw new SearchApiException(e);
        }
        WrappedSearchResponse wrappedResponse = (WrappedSearchResponse)searcher.getRequestContext().getResponse();
        SearchHit[] searchHits = wrappedResponse.getHits().getHits();
        SearchApiResponse esDataResponse = new SearchApiResponse();
        if (searchHits.length >= pageSize) {
            esDataResponse = this.readRespData(wrappedResponse, 0, pageSize, indexDataClazz, searcher.getRequestContext(), config);
            esDataResponse.setHitCount(pageSize);
        } else if (searchHits.length == 0) {
            esDataResponse.getSource().clear();
            esDataResponse.setHitCount(0L);
        } else {
            esDataResponse = this.readRespData(wrappedResponse, 0, searchHits.length, indexDataClazz, searcher.getRequestContext(), config);
            esDataResponse.setHitCount(searchHits.length);
        }
        return esDataResponse;
    }

    private void prepareMarksForInstanceSearch(List<String> marks, DefaultSearcher searcher, SearchEngineConfig config) {
        if (!CollectionUtils.isEmpty(marks)) {
            searcher.getRequestContext().putMarks(marks);
            ArrayList<InlineFilter> filters = new ArrayList<InlineFilter>();
            HashSet<String> workMarks = new HashSet<String>();
            workMarks.addAll(marks);
            if (marks.contains("meta")) {
                workMarks.add("movies");
                workMarks.add("series");
                workMarks.add("celebs");
                workMarks.remove("meta");
            }
            for (String m : workMarks) {
                if (StringUtils.isEmpty(m)) continue;
                filters.add(new GeneralFilter(config.getClassifyFieldName(), m, FilterFuncEnum.EQUAL, searcher.getRequestContext()));
            }
            if (!CollectionUtils.isEmpty(filters)) {
                searcher.filter(new CompositeFilter(CompositeFilter.Func.OR, filters));
            }
        }
    }

    public <T> SearchApiResponse<T> instanceSearch(int pageSize, String keyword, List<String> marks, Class<T> indexDataClazz, SearchEngineConfig config, RequestParams requestParams) {
        return this.instanceSearchImpl(pageSize, keyword, marks, indexDataClazz, config, "peliplat-search", requestParams);
    }

    public <T> SearchApiResponse<T> strictInstanceSearch(int pageSize, String keyword, List<String> marks, Class<T> indexDataClazz, SearchEngineConfig config, RequestParams requestParams) {
        return this.instanceSearchImpl(pageSize, keyword, marks, indexDataClazz, config, "peliplat-search-strict-match", requestParams);
    }

    public <T> SearchApiResponse<T> matchSearchForContentId(String keyword, List<String> marks, Class<T> indexDataClazz, SearchEngineConfig config, RequestParams requestParams) throws SearchApiException {
        if (StringUtils.isEmpty(keyword)) {
            return new SearchApiResponse();
        }
        DefaultSearcher searcher = BizContainerBuilder.newInstance(config, this.esClient).build("peliplat-search-by-content-id", keyword, 0, 20);
        if (!CollectionUtils.isEmpty(requestParams.getExcludeConditions())) {
            this.prepareCondition(searcher, requestParams.getExcludeConditions(), FilterFuncEnum.NOTEQUAL, CompositeFilter.Func.OR);
        }
        if (!CollectionUtils.isEmpty(requestParams.getIncludeConditions())) {
            this.prepareCondition(searcher, requestParams.getIncludeConditions(), FilterFuncEnum.EQUAL, CompositeFilter.Func.AND);
        }
        searcher.disableHighlight();
        if (!CollectionUtils.isEmpty(marks)) {
            searcher.getRequestContext().putMarks(marks);
            ArrayList<InlineFilter> filters = new ArrayList<InlineFilter>();
            for (String m : marks) {
                if (StringUtils.isEmpty(m)) continue;
                filters.add(new GeneralFilter(config.getClassifyFieldName(), m, FilterFuncEnum.EQUAL, searcher.getRequestContext()));
            }
            if (!CollectionUtils.isEmpty(filters)) {
                searcher.filter(new CompositeFilter(CompositeFilter.Func.OR, filters));
            }
        }
        try {
            searcher.execute();
        }
        catch (Exception e) {
            throw new SearchApiException(e);
        }
        WrappedSearchResponse wrappedResponse = (WrappedSearchResponse)searcher.getRequestContext().getResponse();
        return this.readRespData(wrappedResponse, 0, wrappedResponse.getHits().getHits().length, indexDataClazz, searcher.getRequestContext(), config);
    }

    private Map<String, Long> matchCountImpl(String keyword, SearchEngineConfig config, String bizName, RequestParams requestParams) throws SearchApiException {
        return this.matchCountImpl(keyword, config, bizName, config.getFuzzinessQueryMode(), null, requestParams);
    }

    private Map<String, Long> matchCountImpl(String keyword, SearchEngineConfig config, String bizName, FuzzinessQueryMode fuzzinessQueryMode, List<String> marks, RequestParams requestParams) throws SearchApiException {
        if (StringUtils.isEmpty(keyword)) {
            return new HashMap<String, Long>();
        }
        DefaultSearcher searcher = BizContainerBuilder.newInstance(config, this.esClient).build(bizName, keyword, 0, 0);
        if (!CollectionUtils.isEmpty(marks)) {
            ArrayList<Condition> marksConditions = new ArrayList<Condition>();
            marksConditions.add(new Condition("mark", marks));
            this.prepareCondition(searcher, marksConditions, FilterFuncEnum.EQUAL, CompositeFilter.Func.OR);
        }
        if (!CollectionUtils.isEmpty(requestParams.getExcludeConditions())) {
            this.prepareCondition(searcher, requestParams.getExcludeConditions(), FilterFuncEnum.NOTEQUAL, CompositeFilter.Func.OR);
        }
        if (!CollectionUtils.isEmpty(requestParams.getIncludeConditions())) {
            this.prepareCondition(searcher, requestParams.getIncludeConditions(), FilterFuncEnum.EQUAL, CompositeFilter.Func.AND);
        }
        if (fuzzinessQueryMode == FuzzinessQueryMode.NO) {
            searcher.getRequestContext().disableFuzziness();
        } else if (fuzzinessQueryMode == FuzzinessQueryMode.YES) {
            searcher.getRequestContext().enableFuzziness();
        } else {
            searcher.getRequestContext().disableFuzziness();
        }
        searcher.disableHighlight();
        TermsAggregation aggregation = new TermsAggregation(config.getClassifyFieldName(), 1000);
        try {
            return searcher.executeCountAggs(aggregation);
        }
        catch (Exception e) {
            throw new SearchApiException(e);
        }
    }

    public Map<String, Long> matchCount(String keyword, SearchEngineConfig config, RequestParams requestParams) throws SearchApiException {
        HashMap<String, Long> finalCountResult = new HashMap();
        FuzzinessQueryMode fuzzinessQueryMode = config.getFuzzinessQueryMode();
        if (FuzzinessQueryMode.AUTO == fuzzinessQueryMode) {
            Map<String, Long> entiretyMatcherCountResult = this.matchCountImpl(keyword, config, "peliplat-count-entirety-matcher-only", FuzzinessQueryMode.NO, null, requestParams);
            ArrayList<String> hasDataMarks = new ArrayList<String>();
            ArrayList<String> noneDataMarks = new ArrayList<String>();
            for (Map.Entry<String, Long> countItem : entiretyMatcherCountResult.entrySet()) {
                if (countItem.getValue() > 0L) {
                    hasDataMarks.add(countItem.getKey());
                    continue;
                }
                noneDataMarks.add(countItem.getKey());
            }
            Map<String, Long> noFuzzinessCountResult = null;
            Map<String, Long> fuzzinessCountResult = null;
            if (CollectionUtils.isEmpty(hasDataMarks) && CollectionUtils.isEmpty(noneDataMarks)) {
                fuzzinessCountResult = this.matchCountImpl(keyword, config, "peliplat-search", FuzzinessQueryMode.YES, null, requestParams);
                if (!CollectionUtils.isEmpty(fuzzinessCountResult)) {
                    finalCountResult.putAll(fuzzinessCountResult);
                }
            } else {
                if (!CollectionUtils.isEmpty(hasDataMarks) && !CollectionUtils.isEmpty(noFuzzinessCountResult = this.matchCountImpl(keyword, config, "peliplat-search", FuzzinessQueryMode.NO, hasDataMarks, requestParams))) {
                    for (String hasDataMark : hasDataMarks) {
                        finalCountResult.put(hasDataMark, noFuzzinessCountResult.get(hasDataMark));
                    }
                }
                if (!CollectionUtils.isEmpty(noneDataMarks) && !CollectionUtils.isEmpty(fuzzinessCountResult = this.matchCountImpl(keyword, config, "peliplat-search", FuzzinessQueryMode.YES, noneDataMarks, requestParams))) {
                    for (String noneDataMark : noneDataMarks) {
                        finalCountResult.put(noneDataMark, fuzzinessCountResult.get(noneDataMark));
                    }
                }
            }
            Statistics.matchCountByFuzzyAutoModeInvoked();
        } else {
            finalCountResult = this.matchCountImpl(keyword, config, "peliplat-search", fuzzinessQueryMode, null, requestParams);
        }
        return finalCountResult;
    }

    public Map<String, Long> strictMatchCount(String keyword, SearchEngineConfig config, RequestParams requestParams) throws SearchApiException {
        return this.matchCountImpl(keyword, config, "peliplat-search-strict-match", requestParams);
    }

    private void prepareMarks(DefaultSearcher searcher, List<String> marks, SearchEngineConfig config) {
        if (!CollectionUtils.isEmpty(marks)) {
            searcher.getRequestContext().putMarks(marks);
            HashSet<String> workMarks = new HashSet<String>();
            workMarks.addAll(marks);
            if (marks.contains("meta")) {
                workMarks.add("movies");
                workMarks.add("series");
                workMarks.add("celebs");
                workMarks.remove("meta");
            }
            ArrayList<InlineFilter> filters = new ArrayList<InlineFilter>();
            for (String m : workMarks) {
                if (StringUtils.isEmpty(m)) continue;
                filters.add(new GeneralFilter(config.getClassifyFieldName(), m, FilterFuncEnum.EQUAL, searcher.getRequestContext()));
            }
            if (!CollectionUtils.isEmpty(filters)) {
                searcher.filter(new CompositeFilter(CompositeFilter.Func.OR, filters));
            }
        }
    }

    private ESPageInfo convertMatchSearchPagingToEsPaging(int pageSize, int pageId, SearchEngineConfig config) {
        int fromIndex;
        int fixPageSize = config.getFixPageSize();
        if (pageSize < 1) {
            pageSize = 20;
        } else if (pageSize > 1000) {
            pageSize = 1000;
        }
        if (pageId < 1) {
            pageId = 1;
        }
        if ((fromIndex = (pageId - 1) * pageSize) > 10000) {
            return null;
        }
        if (fromIndex + pageSize > 10000) {
            return new ESPageInfo(fromIndex, 10000 - fromIndex, false, fromIndex);
        }
        if (fromIndex + pageSize <= fixPageSize) {
            return new ESPageInfo(0, fixPageSize, true, fromIndex);
        }
        return new ESPageInfo(fromIndex, pageSize, false, fromIndex);
    }

    private void prepareCondition(DefaultSearcher searcher, List<Condition> conditions, FilterFuncEnum op, CompositeFilter.Func func) {
        if (!CollectionUtils.isEmpty(conditions)) {
            ArrayList<GeneralFilter> filters = new ArrayList<GeneralFilter>();
            for (Condition condition : conditions) {
                filters.add(new GeneralFilter(condition.getFieldName(), condition.getValues().toArray(new String[0]), op, GeneralFilter.Func.valueOf(func.name())));
            }
            if (filters.size() > 1) {
                CompositeFilter compositeFilter = new CompositeFilter((InlineFilter)filters.get(0), func);
                for (int index = 1; index < filters.size(); ++index) {
                    compositeFilter.append((InlineFilter)filters.get(index));
                }
                searcher.filter(compositeFilter);
            } else {
                searcher.filter((Filter)filters.get(0));
            }
        }
    }

    public static class ESPageInfo {
        int esFromIndex;
        int esSize;
        boolean esBatchLoad;
        int fromIndex;

        public ESPageInfo(int esFromIndex, int esSize, boolean esBatchLoad, int fromIndex) {
            this.esFromIndex = esFromIndex;
            this.esSize = esSize;
            this.esBatchLoad = esBatchLoad;
            this.fromIndex = fromIndex;
        }
    }
}

