/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.facade;

import java.util.concurrent.atomic.AtomicLong;

public class Statistics {
    private static final Statistics instance = new Statistics();
    private final AtomicLong instantSearch1st = new AtomicLong(0L);
    private final AtomicLong instantSearch2nd = new AtomicLong(0L);
    private final AtomicLong matchSearch1st = new AtomicLong(0L);
    private final AtomicLong matchSearch2nd = new AtomicLong(0L);
    private final AtomicLong matchCountByFuzzyAutoMode = new AtomicLong(0L);

    private Statistics() {
    }

    public static Statistics getInstance() {
        return instance;
    }

    public static void instantSearchInvoked1st() {
        Statistics.instance.instantSearch1st.incrementAndGet();
    }

    public static void instantSearchInvoked2nd() {
        Statistics.instance.instantSearch2nd.incrementAndGet();
    }

    public static void matchSearchInvoked1st() {
        Statistics.instance.matchSearch1st.incrementAndGet();
    }

    public static void matchSearchInvoked2nd() {
        Statistics.instance.matchSearch2nd.incrementAndGet();
    }

    public static void matchCountByFuzzyAutoModeInvoked() {
        Statistics.instance.matchCountByFuzzyAutoMode.incrementAndGet();
    }

    public static FuzzinessAutoModeStats snapshot() {
        return new FuzzinessAutoModeStats(Statistics.instance.instantSearch1st.get(), Statistics.instance.instantSearch2nd.get(), Statistics.instance.matchSearch1st.get(), Statistics.instance.matchSearch2nd.get(), Statistics.instance.matchCountByFuzzyAutoMode.get());
    }

    public static class FuzzinessAutoModeStats {
        private long instantSearch1st;
        private long instantSearch2nd;
        private long matchSearch1st;
        private long matchSearch2nd;
        private long matchCountInvokedNum;

        FuzzinessAutoModeStats(long instantSearch1st, long instantSearch2nd, long matchSearch1st, long matchSearch2nd, long matchCount) {
            this.instantSearch1st = instantSearch1st;
            this.instantSearch2nd = instantSearch2nd;
            this.matchSearch1st = matchSearch1st;
            this.matchSearch2nd = matchSearch2nd;
            this.matchCountInvokedNum = matchCount;
        }

        public long getInstantSearch1st() {
            return this.instantSearch1st;
        }

        public long getInstantSearch2nd() {
            return this.instantSearch2nd;
        }

        public long getMatchSearch1st() {
            return this.matchSearch1st;
        }

        public long getMatchSearch2nd() {
            return this.matchSearch2nd;
        }

        public long getMatchCountInvokedNum() {
            return this.matchCountInvokedNum;
        }

        public void setInstantSearch1st(long instantSearch1st) {
            this.instantSearch1st = instantSearch1st;
        }

        public void setInstantSearch2nd(long instantSearch2nd) {
            this.instantSearch2nd = instantSearch2nd;
        }

        public void setMatchSearch1st(long matchSearch1st) {
            this.matchSearch1st = matchSearch1st;
        }

        public void setMatchSearch2nd(long matchSearch2nd) {
            this.matchSearch2nd = matchSearch2nd;
        }

        public void setMatchCountInvokedNum(long matchCountInvokedNum) {
            this.matchCountInvokedNum = matchCountInvokedNum;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FuzzinessAutoModeStats)) {
                return false;
            }
            FuzzinessAutoModeStats other = (FuzzinessAutoModeStats)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getInstantSearch1st() != other.getInstantSearch1st()) {
                return false;
            }
            if (this.getInstantSearch2nd() != other.getInstantSearch2nd()) {
                return false;
            }
            if (this.getMatchSearch1st() != other.getMatchSearch1st()) {
                return false;
            }
            if (this.getMatchSearch2nd() != other.getMatchSearch2nd()) {
                return false;
            }
            return this.getMatchCountInvokedNum() == other.getMatchCountInvokedNum();
        }

        protected boolean canEqual(Object other) {
            return other instanceof FuzzinessAutoModeStats;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $instantSearch1st = this.getInstantSearch1st();
            result = result * 59 + (int)($instantSearch1st >>> 32 ^ $instantSearch1st);
            long $instantSearch2nd = this.getInstantSearch2nd();
            result = result * 59 + (int)($instantSearch2nd >>> 32 ^ $instantSearch2nd);
            long $matchSearch1st = this.getMatchSearch1st();
            result = result * 59 + (int)($matchSearch1st >>> 32 ^ $matchSearch1st);
            long $matchSearch2nd = this.getMatchSearch2nd();
            result = result * 59 + (int)($matchSearch2nd >>> 32 ^ $matchSearch2nd);
            long $matchCountInvokedNum = this.getMatchCountInvokedNum();
            result = result * 59 + (int)($matchCountInvokedNum >>> 32 ^ $matchCountInvokedNum);
            return result;
        }

        public String toString() {
            return "Statistics.FuzzinessAutoModeStats(instantSearch1st=" + this.getInstantSearch1st() + ", instantSearch2nd=" + this.getInstantSearch2nd() + ", matchSearch1st=" + this.getMatchSearch1st() + ", matchSearch2nd=" + this.getMatchSearch2nd() + ", matchCountInvokedNum=" + this.getMatchCountInvokedNum() + ")";
        }
    }
}

