/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.filter;

import com.valor.common.search.engine.facade.config.InlineFilterConfig;
import com.valor.common.search.engine.filter.CompositeFilterBase;
import com.valor.common.search.engine.filter.InlineFilter;
import com.valor.common.search.engine.filter.InlineFilterBase;
import com.valor.common.search.engine.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class CompositeFilter
implements InlineFilter {
    private InlineFilter mainFilter;
    private List<InlineFilter> subFilterList = new ArrayList<InlineFilter>();
    private Func func = Func.OR;

    private CompositeFilter() {
    }

    public CompositeFilter(InlineFilter mainFilter) {
        if (mainFilter == null) {
            throw new RuntimeException("main filter must not null");
        }
        this.mainFilter = mainFilter;
    }

    public CompositeFilter(InlineFilter mainFilter, Func func) {
        if (mainFilter == null) {
            throw new RuntimeException("main filter must not null");
        }
        this.mainFilter = mainFilter;
        this.func = func;
    }

    public CompositeFilter(Func func, List<InlineFilter> filterList) {
        if (CollectionUtils.isEmpty(filterList)) {
            throw new RuntimeException("main filter must not null");
        }
        this.func = func;
        this.mainFilter = filterList.get(0);
        for (int index = 1; index < filterList.size(); ++index) {
            this.subFilterList.add(filterList.get(index));
        }
    }

    public static CompositeFilter from(InlineFilterBase inlineFilterBase) {
        CompositeFilterBase base = (CompositeFilterBase)inlineFilterBase;
        CompositeFilter compositeFilter = new CompositeFilter();
        compositeFilter.mainFilter = (InlineFilter)base.mainFilter.convertToInlineFilter();
        for (InlineFilterBase filter : base.subFilterList) {
            compositeFilter.subFilterList.add((InlineFilter)filter.convertToInlineFilter());
        }
        return compositeFilter;
    }

    public CompositeFilter append(InlineFilter subFilter) {
        if (subFilter != null) {
            this.subFilterList.add(subFilter);
        }
        return this;
    }

    @Override
    public String getFilterName() {
        return null;
    }

    @Override
    public QueryBuilder build(QueryBuilder targetQueryBuilder) {
        if (this.subFilterList.size() == 0 || this.mainFilter == null) {
            return targetQueryBuilder;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        return boolQueryBuilder.must(targetQueryBuilder).filter(this.build());
    }

    @Override
    public QueryBuilder build() {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        ArrayList<QueryBuilder> conditionList = new ArrayList<QueryBuilder>();
        conditionList.add(this.mainFilter.build());
        if (this.func.value == Func.OR.value) {
            for (QueryBuilder condition : conditionList) {
                boolQueryBuilder.should(condition);
            }
            for (InlineFilter filter : this.subFilterList) {
                boolQueryBuilder.should(filter.build());
            }
            boolQueryBuilder.minimumShouldMatch(0);
        } else {
            for (QueryBuilder condition : conditionList) {
                boolQueryBuilder.must(condition);
            }
            for (InlineFilter filter : this.subFilterList) {
                boolQueryBuilder.must(filter.build());
            }
        }
        return boolQueryBuilder;
    }

    @Override
    public void prepareByConfig(InlineFilterConfig config) {
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof CompositeFilter)) {
            return false;
        }
        CompositeFilter targetFilter = (CompositeFilter)o;
        if (this.func.value == targetFilter.func.value && this.mainFilter.equals(targetFilter.mainFilter)) {
            if (this.subFilterList == null && targetFilter.subFilterList == null) {
                return true;
            }
            if (this.subFilterList != null && targetFilter.subFilterList != null && this.subFilterList.size() == targetFilter.subFilterList.size()) {
                boolean same = false;
                for (InlineFilter curSubFilter : this.subFilterList) {
                    same &= targetFilter.subFilterList.contains(curSubFilter);
                }
                return same;
            }
        }
        return false;
    }

    public int hashCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getObjectHashCode((Object)this.func)).append(this.getObjectHashCode(this.mainFilter)).append(this.subFilterList.hashCode());
        return stringBuffer.toString().hashCode();
    }

    private int getObjectHashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Collection) {
            return obj.toString().hashCode();
        }
        return obj.hashCode();
    }

    public static enum Func {
        OR(1, "\u6216"),
        AND(2, "\u5e76\u4e14");

        private int value;
        private String desc;

        private Func(int index, String desc) {
            this.value = index;
            this.desc = desc;
        }
    }
}

