/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.matcher;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.facade.config.MatcherConfig;
import com.valor.common.search.engine.facade.config.MatcherParams;
import com.valor.common.search.engine.matcher.AbstractMatcher;
import com.valor.common.search.engine.matcher.EntiretyMatcher;
import com.valor.common.search.engine.matcher.Matcher;
import com.valor.common.search.engine.util.SearchUtils;
import com.valor.common.search.engine.util.StringUtils;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class GeneralTermMatcher
extends AbstractMatcher {
    private EntiretyMatcher.MatchType matchType;
    public static final String DEFAULT_MATCH_NAME = "GeneralTermMatcher";

    public GeneralTermMatcher() {
        this.matchName = DEFAULT_MATCH_NAME;
    }

    public GeneralTermMatcher(RequestContext context, String matchFieldName, String word) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.matchFieldName = matchFieldName;
        this.q = SearchUtils.rebuildQ(word);
        this.context = context;
        this.matchFieldName = context.fuzzySubIndexFieldName;
        this.init();
    }

    private void init() {
        this.context.saveMatcheNameandMatcheFieldNamePair(this.matchName, this.matchFieldName);
    }

    @Override
    public Matcher.MATCHER_TYPE getMatcherType() {
        return Matcher.MATCHER_TYPE.GENERAL_TERM;
    }

    @Override
    public Matcher assembly() {
        return this;
    }

    @Override
    public QueryBuilder buildBase() {
        return QueryBuilders.matchQuery((String)this.matchFieldName, (Object)this.q);
    }

    @Override
    public void prepareByConfig(MatcherConfig config) {
        this.matcherConfig = config;
        MatcherParams matcherParams = this.matcherConfig.getMatcherParams();
        this.matchType = EntiretyMatcher.MatchType.valueOf(matcherParams.getMatchType());
        if (!StringUtils.isEmpty(matcherParams.getMatchFieldName())) {
            this.setMatchFieldName(matcherParams.getMatchFieldName());
        } else {
            this.setMatchFieldName(this.context.KEY_MAIN_INDEX_FIELD);
        }
        super.prepareByConfig(this.matcherConfig);
        this.init();
    }

    public void setMatchFieldName(String matchFieldName) {
        if (this.inited) {
            return;
        }
        this.matchFieldName = matchFieldName;
    }
}

