/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.ranker;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.ranker.AbstractPostScoreRanker;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.SearchUtils;
import com.valor.common.search.engine.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTunningAllMatchRanker
extends AbstractPostScoreRanker {
    private static Logger logger = LoggerFactory.getLogger(SimpleTunningAllMatchRanker.class);
    public static final String DEFAULT_THRESHOLD_TYPE_NAME = "default";
    private RequestContext context;
    private String searchName;
    private List<String> willRankedFieldNames = new ArrayList<String>();

    public SimpleTunningAllMatchRanker(RequestContext context, String searchName, String willRankedFieldNames) {
        this.context = context;
        this.searchName = searchName;
        this.willRankedFieldNames.add(willRankedFieldNames);
    }

    public SimpleTunningAllMatchRanker(RequestContext context) {
        this.context = context;
        this.searchName = "EntiretyMatcher";
        this.willRankedFieldNames.add(context.KEY_MAIN_INDEX_FIELD);
    }

    public SimpleTunningAllMatchRanker(RequestContext context, String ... willRankedFieldNames) {
        this.context = context;
        this.searchName = "EntiretyMatcher";
        this.willRankedFieldNames.addAll(Arrays.asList(willRankedFieldNames));
    }

    @Override
    public void execute() throws RuntimeException {
        SearchResponse response = this.context.getResponse();
        SearchHits hits = response.getHits();
        SearchHit[] hitDocs = hits.getHits();
        ArrayList<SearchHit> otherMatchHitList = new ArrayList<SearchHit>();
        ArrayList finalHits = new ArrayList();
        ArrayList<SearchHit> willSortingDataList = new ArrayList<SearchHit>();
        String q = this.context.getQ().toLowerCase();
        SearchHit topHit = null;
        for (SearchHit hit : hitDocs) {
            if (this.hasAllMatchQuery(hit.getMatchedQueries())) {
                willSortingDataList.add(hit);
                continue;
            }
            otherMatchHitList.add(hit);
        }
        ArrayList notSortDataList = new ArrayList();
        for (String sortingFieldName : this.willRankedFieldNames) {
            ArrayList<SearchHit> hasSameWordAndPosList = new ArrayList<SearchHit>();
            ArrayList<SearchHit> hasSameWordList = new ArrayList<SearchHit>();
            ArrayList<SearchHit> extraAllMatchHitList = new ArrayList<SearchHit>();
            for (SearchHit hit : willSortingDataList) {
                Object obj = this.parseHitFieldValue(hit.getSourceAsMap(), sortingFieldName);
                if (obj == null) continue;
                ArrayList<String> titleList = null;
                if (obj instanceof String) {
                    titleList = new ArrayList<String>();
                    titleList.add(obj.toString());
                } else {
                    titleList = (ArrayList<String>)obj;
                }
                boolean isExtraAllMatch = false;
                boolean isHasSameWordandPos = false;
                String extraAliasQ = this.context.queryExecuteExtraWordAlias;
                if (!StringUtils.isEmpty(extraAliasQ)) {
                    extraAliasQ = extraAliasQ.toLowerCase(Locale.ROOT).trim();
                }
                for (String s : titleList) {
                    if ((s = s.toLowerCase().trim()).equals(q)) {
                        isExtraAllMatch = true;
                        continue;
                    }
                    if (isExtraAllMatch || s.indexOf(q) < 0 && (StringUtils.isEmpty(extraAliasQ) || s.indexOf(extraAliasQ) < 0)) continue;
                    isHasSameWordandPos = true;
                }
                if (isExtraAllMatch) {
                    extraAllMatchHitList.add(hit);
                    continue;
                }
                if (isHasSameWordandPos) {
                    hasSameWordAndPosList.add(hit);
                    continue;
                }
                hasSameWordList.add(hit);
            }
            extraAllMatchHitList.sort(new ScoreDescComparator());
            hasSameWordAndPosList.sort(new ScoreDescComparator());
            ArrayList<SearchHit> sameWordSortedList = new ArrayList<SearchHit>();
            sameWordSortedList.addAll(extraAllMatchHitList);
            sameWordSortedList.addAll(hasSameWordAndPosList);
            sameWordSortedList.sort(new ScoreDescComparator());
            if (topHit == null) {
                topHit = !CollectionUtils.isEmpty(extraAllMatchHitList) && !((SearchHit)extraAllMatchHitList.get(0)).equals(sameWordSortedList.get(0)) ? (SearchHit)extraAllMatchHitList.get(0) : this.getTopHitDoc(willSortingDataList, q, sortingFieldName);
            }
            willSortingDataList.clear();
            willSortingDataList.addAll(notSortDataList);
            notSortDataList.clear();
            sameWordSortedList.sort(new ScoreDescComparator());
            hasSameWordList.sort(new ScoreDescComparator());
            finalHits.addAll(sameWordSortedList);
            finalHits.addAll(hasSameWordList);
        }
        otherMatchHitList.addAll(willSortingDataList);
        otherMatchHitList.sort(new ScoreDescComparator());
        finalHits.addAll(otherMatchHitList);
        if (topHit != null) {
            finalHits.remove(topHit);
            finalHits.add(0, topHit);
        }
        try {
            SearchUtils.replaceHits(hits, finalHits.toArray());
        }
        catch (Exception e) {
            logger.error("Error while repalce hits into response. Exception:", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Object parseHitFieldValue(Map<String, Object> hittedMap, String hitFieldName) {
        ArrayList<String> retVal = "";
        String[] fieldNames = hitFieldName.split("\\.");
        if (fieldNames.length > 1) {
            Object obj = hittedMap.get(fieldNames[0]);
            if (obj == null) {
                return obj;
            }
            if (obj instanceof ArrayList) {
                ArrayList<String> objList = new ArrayList<String>();
                ArrayList tmpR = (ArrayList)obj;
                for (Map item : tmpR) {
                    String curStr = (String)item.get(fieldNames[1]);
                    if (StringUtils.isEmpty(curStr)) continue;
                    objList.add(curStr);
                }
                retVal = objList;
            } else {
                HashMap tmpItem = (HashMap)obj;
                retVal = tmpItem.get(fieldNames[1]);
            }
        } else {
            retVal = hittedMap.get(fieldNames[0]);
        }
        return retVal;
    }

    private float getCurrentScore(SearchHit hit) {
        return 1.0f;
    }

    private SearchHit getTopHitDoc(List<SearchHit> soureHitsList, String qStr, String sourceFieldName) {
        float maxScore = -10.0f;
        SearchHit topHit = null;
        block0: for (SearchHit hit : soureHitsList) {
            Object obj = this.parseHitFieldValue(hit.getSourceAsMap(), sourceFieldName);
            if (obj == null) continue;
            ArrayList<String> titleList = null;
            if (obj instanceof String) {
                titleList = new ArrayList<String>();
                titleList.add(obj.toString());
            } else {
                titleList = (ArrayList<String>)obj;
            }
            for (String s : titleList) {
                if (!(s = s.toLowerCase()).trim().equals(qStr)) continue;
                if (!(maxScore < hit.getScore())) continue block0;
                topHit = hit;
                maxScore = hit.getScore();
                continue block0;
            }
        }
        return topHit;
    }

    @Override
    public List<String> sortFieldNames() {
        return this.willRankedFieldNames;
    }

    private boolean hasAllMatchQuery(String[] matchQueries) {
        boolean retVal = false;
        for (String str : matchQueries) {
            if (str.indexOf(this.searchName) == -1) continue;
            return true;
        }
        return retVal;
    }

    private static class ScoreDescComparator
    implements Comparator<SearchHit>,
    Serializable {
        private ScoreDescComparator() {
        }

        @Override
        public int compare(SearchHit o1, SearchHit o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1 == o2) {
                return 0;
            }
            if (o1.getScore() == o2.getScore()) {
                return 0;
            }
            if (o1.getScore() > o2.getScore()) {
                return -1;
            }
            return 1;
        }
    }
}

