/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.ranker.comparator;

import com.valor.common.search.engine.facade.config.ComputeExpressConfig;
import com.valor.common.search.engine.ranker.comparator.AbstractRankerComparator;
import com.valor.common.search.engine.util.CollectionUtils;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.SearchHit;

public class ScoreWeightDescComparator
extends AbstractRankerComparator
implements Comparator<SearchHit> {
    private ComputeExpressConfig computeExpressConfig;
    private Map<String, Number> bizParams = new HashMap<String, Number>();

    public ScoreWeightDescComparator() {
        this.bizParams.put("scoreWeightModel.01.scoreScale".replaceFirst("scoreWeightModel.01.", ""), Float.valueOf(75.0f));
        this.bizParams.put("scoreWeightModel.01.weightRate".replaceFirst("scoreWeightModel.01.", ""), Float.valueOf(1.5f));
    }

    @Override
    public void appendSysParams(Map<String, Object> sysParams) {
        if (CollectionUtils.isEmpty(sysParams)) {
            return;
        }
        this.bizParams.put("scoreWeightModel.01.weightRate".replaceFirst("scoreWeightModel.01.", ""), Float.valueOf(Float.parseFloat(sysParams.getOrDefault("scoreWeightModel.01.weightRate", Float.valueOf(1.5f)).toString())));
        this.bizParams.put("scoreWeightModel.01.scoreScale".replaceFirst("scoreWeightModel.01.", ""), Float.valueOf(Float.parseFloat(sysParams.getOrDefault("scoreWeightModel.01.scoreScale", Float.valueOf(75.0f)).toString())));
    }

    @Override
    public void prepareByConfig(List<ComputeExpressConfig> computeExpressMapList) {
        if (!CollectionUtils.isEmpty(computeExpressMapList)) {
            this.computeExpressConfig = computeExpressMapList.get(0);
        }
    }

    @Override
    public float computeScore(SearchHit hit) {
        HashMap<String, Number> jepParams = new HashMap<String, Number>();
        for (String name : this.computeExpressConfig.getParamsName()) {
            String objValue = hit.getSourceAsMap().getOrDefault(name, "0");
            double val = objValue == null ? 0.0 : (double)((float)Math.ceil(Double.parseDouble(objValue.toString()) * 100.0) / 100.0f);
            val = val < 0.0 ? 0.0 : val;
            jepParams.put(name, val);
        }
        jepParams.putAll(this.bizParams);
        jepParams.put("score", Double.valueOf(hit.getScore()));
        float item1newScore = this.getNewScore(jepParams, this.computeExpressConfig.getScoreExpress());
        hit.getSourceAsMap().put("newScore", Float.valueOf(item1newScore));
        hit.getSourceAsMap().put("computeScoreBy", "ScoreWeight");
        return item1newScore;
    }

    @Override
    public int compare(SearchHit o1, SearchHit o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        if (o1 == o2) {
            return 0;
        }
        Float o1Score = Float.valueOf(Float.parseFloat(o1.getSourceAsMap().get("newScore").toString()));
        Float o2Score = Float.valueOf(Float.parseFloat(o2.getSourceAsMap().get("newScore").toString()));
        o1Score = Float.valueOf(o1Score.isNaN() ? 0.0f : o1Score.floatValue());
        o2Score = Float.valueOf(o2Score.isNaN() ? 0.0f : o2Score.floatValue());
        o1.getSourceAsMap().put("sortBy", "ScoreWeight");
        o2.getSourceAsMap().put("sortBy", "ScoreWeight");
        float o1Weight = Float.parseFloat(((Object)o1.getSourceAsMap().getOrDefault("weight", 0)).toString());
        float o2Weight = Float.parseFloat(((Object)o2.getSourceAsMap().getOrDefault("weight", 0)).toString());
        double newScore1 = o1Score.floatValue() * o1Weight;
        double newScore2 = o2Score.floatValue() * o2Weight;
        if (o1Weight > o2Weight) {
            return -1;
        }
        if (o1Weight == o2Weight) {
            if (newScore1 > newScore2) {
                return -1;
            }
            if (newScore1 < newScore2) {
                return 1;
            }
            return 0;
        }
        return 1;
    }
}

