/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.util;

import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.ObjectUtils;
import com.valor.common.search.engine.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.elasticsearch.Version;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import sun.misc.Unsafe;

public class SearchUtils {
    public static final String REGEXP_SPACE_PATTERN = "([\\s\\p{Zs}])+";
    private static final Unsafe unsafe;

    private static Unsafe getUnsafe() {
        return unsafe;
    }

    public static void replaceHits(SearchHits target, Object[] newHits) throws NoSuchFieldException {
        Field hitsField = SearchHits.class.getDeclaredField("hits");
        long histFieldOffset = unsafe.objectFieldOffset(hitsField);
        unsafe.putObject(target, histFieldOffset, newHits);
    }

    public static void replaceHits(SearchHits target, SearchHit[] newHits) throws NoSuchFieldException {
        Field hitsField = SearchHits.class.getDeclaredField("hits");
        long histFieldOffset = unsafe.objectFieldOffset(hitsField);
        unsafe.putObject(target, histFieldOffset, newHits);
    }

    public static void putObject(Object target, String fieldName, Object newValue) throws NoSuchFieldException {
        Field targetField = target.getClass().getDeclaredField(fieldName);
        long histFieldOffset = unsafe.objectFieldOffset(targetField);
        unsafe.putObject(target, histFieldOffset, newValue);
    }

    public static void putLong(Object target, String fieldName, long newValue) throws NoSuchFieldException {
        Field targetField = target.getClass().getDeclaredField(fieldName);
        long histFieldOffset = unsafe.objectFieldOffset(targetField);
        unsafe.putLong(target, histFieldOffset, newValue);
    }

    public static void putInt(Object target, String fieldName, int newValue) throws NoSuchFieldException {
        Field targetField = target.getClass().getDeclaredField(fieldName);
        long histFieldOffset = unsafe.objectFieldOffset(targetField);
        unsafe.putInt(target, histFieldOffset, newValue);
    }

    public static Object getObject(Object target, String fieldName) throws NoSuchFieldException {
        Field targetField = target.getClass().getDeclaredField(fieldName);
        long histFieldOffset = unsafe.objectFieldOffset(targetField);
        return unsafe.getObject(target, histFieldOffset);
    }

    public static long getLong(Object target, String fieldName) throws NoSuchFieldException {
        Field targetField = target.getClass().getDeclaredField(fieldName);
        long histFieldOffset = unsafe.objectFieldOffset(targetField);
        return unsafe.getLong(target, histFieldOffset);
    }

    public static int getInt(Object target, String fieldName) throws NoSuchFieldException {
        Field targetField = target.getClass().getDeclaredField(fieldName);
        long histFieldOffset = unsafe.objectFieldOffset(targetField);
        return unsafe.getInt(target, histFieldOffset);
    }

    public static void replaceTotalHitsSize(SearchHits hits, long newTotalHits) throws NoSuchFieldException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        long totalHitsFieldOffset;
        Field totalHitsField;
        if (Version.CURRENT.onOrAfter(Version.fromString((String)"7.14.1"))) {
            totalHitsField = Class.forName("org.apache.lucene.search.TotalHits").getDeclaredField("value");
            totalHitsFieldOffset = unsafe.objectFieldOffset(totalHitsField);
            Method method = hits.getClass().getDeclaredMethod("getTotalHits", new Class[0]);
            Object targetObject = method.invoke((Object)hits, new Object[0]);
            unsafe.putLong(targetObject, totalHitsFieldOffset, newTotalHits);
        }
        if (Version.CURRENT.before(Version.fromString((String)"6.8.60"))) {
            totalHitsField = Class.forName("org.elasticsearch.search.SearchHits").getDeclaredField("totalHits");
            totalHitsFieldOffset = unsafe.objectFieldOffset(totalHitsField);
            unsafe.putLong(hits, totalHitsFieldOffset, newTotalHits);
        }
    }

    public static long getTotalHitsSize(SearchHits hits) throws NoSuchFieldException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (Version.CURRENT.onOrAfter(Version.fromString((String)"7.14.1"))) {
            Field totalHitsField = Class.forName("org.apache.lucene.search.TotalHits").getDeclaredField("value");
            long totalHitsFieldOffset = unsafe.objectFieldOffset(totalHitsField);
            Method method = hits.getClass().getDeclaredMethod("getTotalHits", new Class[0]);
            Object targetObject = method.invoke((Object)hits, new Object[0]);
            return unsafe.getLong(targetObject, totalHitsFieldOffset);
        }
        if (Version.CURRENT.before(Version.fromString((String)"6.8.60"))) {
            Field totalHitsField = Class.forName("org.elasticsearch.search.SearchHits").getDeclaredField("totalHits");
            long totalHitsFieldOffset = unsafe.objectFieldOffset(totalHitsField);
            return unsafe.getLong(hits, totalHitsFieldOffset);
        }
        return 0L;
    }

    public static void replaceMaxScore(SearchHits target, float newMaxScore) throws NoSuchFieldException {
        Field maxScoreField = SearchHits.class.getDeclaredField("maxScore");
        long maxScoreFieldOffset = unsafe.objectFieldOffset(maxScoreField);
        unsafe.putFloat(target, maxScoreFieldOffset, newMaxScore);
    }

    public static Set<String> findMatchStr(String hitWord, String startTag, String endTag) {
        HashSet<String> retVal = new HashSet<String>();
        int startIndex = hitWord.indexOf(startTag);
        int endIndex = hitWord.indexOf(endTag);
        if (startIndex == -1) {
            return retVal;
        }
        String operatedWord = hitWord;
        while (true) {
            String sub = operatedWord.substring(startIndex, endIndex);
            String nextSubWord = operatedWord.substring(endIndex + endTag.length());
            sub = sub.replaceAll(startTag, "");
            sub = sub.replaceAll(endTag, "");
            sub = sub.toLowerCase();
            retVal.add(sub);
            if (!nextSubWord.contains(startTag)) break;
            operatedWord = nextSubWord;
            startIndex = operatedWord.indexOf(startTag);
            endIndex = operatedWord.indexOf(endTag);
        }
        return retVal;
    }

    public static SearchResponse search(RestHighLevelClient client, SearchRequest request) throws IOException, ClassNotFoundException, NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (Version.CURRENT.before(Version.fromString((String)"6.8.60"))) {
            Class<?> searchRequestClz = Class.forName("org.elasticsearch.action.search.SearchRequest");
            Method method = client.getClass().getDeclaredMethod("search", searchRequestClz, Header[].class);
            return (SearchResponse)method.invoke((Object)client, request, new Header[0]);
        }
        Class<?> param2Clz = Class.forName("org.elasticsearch.client.RequestOptions");
        Object param2 = param2Clz.getField("DEFAULT").get(param2Clz);
        Class<?> searchRequestClz = Class.forName("org.elasticsearch.action.search.SearchRequest");
        Method method = client.getClass().getDeclaredMethod("search", searchRequestClz, param2Clz);
        return (SearchResponse)method.invoke((Object)client, request, param2);
    }

    public static BulkResponse bulk(RestHighLevelClient client, BulkRequest request) throws IOException, ClassNotFoundException, NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (Version.CURRENT.before(Version.fromString((String)"6.8.60"))) {
            Class<?> bulkRequestClz = Class.forName("org.elasticsearch.action.bulk.BulkRequest");
            Method method = client.getClass().getDeclaredMethod("bulk", bulkRequestClz, Header[].class);
            return (BulkResponse)method.invoke((Object)client, request, new Header[0]);
        }
        Class<?> param2Clz = Class.forName("org.elasticsearch.client.RequestOptions");
        Object param2 = param2Clz.getField("DEFAULT").get(param2Clz);
        Class<?> bulkRequestClz = Class.forName("org.elasticsearch.action.bulk.BulkRequest");
        Method method = client.getClass().getDeclaredMethod("bulk", bulkRequestClz, param2Clz);
        return (BulkResponse)method.invoke((Object)client, request, param2);
    }

    public static String rebuildQ(String q) {
        if (StringUtils.isEmpty(q)) {
            return q;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : q.trim().split(REGEXP_SPACE_PATTERN)) {
            sb.append(s).append(" ");
        }
        return sb.toString().trim();
    }

    public static String tryToMissWord(String q) {
        q = q.replaceAll("-", " ").trim();
        String[] newQs = q.split(REGEXP_SPACE_PATTERN);
        int willRemovedIndex = -1;
        int totalCharsLen = 0;
        for (String k : newQs) {
            totalCharsLen += k.length();
        }
        for (int index = 1; index < newQs.length - 1; ++index) {
            if (newQs[index].length() > 2 || !newQs[index].endsWith(".")) continue;
            willRemovedIndex = index;
        }
        StringBuilder buffer = new StringBuilder();
        if (totalCharsLen >= 10) {
            for (int index = 0; index < newQs.length; ++index) {
                if (index == willRemovedIndex) continue;
                buffer.append(newQs[index]).append(" ");
            }
            q = buffer.toString();
        }
        return q;
    }

    public static String tryToMissWordByLooseRule(String q) {
        q = q.replaceAll("-", " ").trim();
        String[] newQs = q.split(REGEXP_SPACE_PATTERN);
        int len = 100;
        int minLenIndex = -1;
        int totalCharsLen = 0;
        String tempStr = "";
        for (int index = 0; index < newQs.length; ++index) {
            tempStr = StringUtils.delPunct(newQs[index]);
            if (tempStr.length() < len && (newQs[index].length() <= 2 || (float)tempStr.length() >= (float)len * 0.75f && newQs[index].length() <= 3)) {
                len = tempStr.length();
                minLenIndex = index;
            }
            totalCharsLen += newQs[index].length();
        }
        if (minLenIndex >= 0 && totalCharsLen >= 7) {
            StringBuilder sb = new StringBuilder();
            for (int index = 0; index < newQs.length; ++index) {
                if (index == minLenIndex) continue;
                sb.append(newQs[index]).append(" ");
            }
            q = sb.toString().trim();
        }
        return q;
    }

    public static String tryToMissWordBak(String q) {
        q = q.replaceAll("-", " ").trim();
        String[] newQs = q.split(REGEXP_SPACE_PATTERN);
        int len = 100;
        int minLenIndex = -1;
        int totalCharsLen = 0;
        String tempStr = "";
        for (int index = 0; index < newQs.length; ++index) {
            tempStr = StringUtils.delPunct(newQs[index]);
            if (tempStr.length() < len && (newQs[index].length() <= 2 || (float)tempStr.length() >= (float)len * 0.75f && newQs[index].length() <= 3)) {
                len = tempStr.length();
                minLenIndex = index;
            }
            totalCharsLen += newQs[index].length();
        }
        if (minLenIndex >= 0 && totalCharsLen >= 7) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int index = 0; index < newQs.length; ++index) {
                if (index == minLenIndex) continue;
                stringBuilder.append(newQs[index]).append(" ");
            }
            q = stringBuilder.toString().trim();
        }
        return q;
    }

    public static String takeAliasStr(String sourceStr, int mainWordMinLen) {
        String[] newQs = sourceStr.trim().split(REGEXP_SPACE_PATTERN);
        if (newQs.length < 2) {
            return "";
        }
        String newStr = SearchUtils.delNumTerm(sourceStr);
        if (newStr.length() >= mainWordMinLen) {
            return newStr;
        }
        return "";
    }

    private static String delNumTerm(String sourceStr) {
        String[] newQs = sourceStr.trim().split(REGEXP_SPACE_PATTERN);
        Object[] number = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "\u2160", "\u2161", "\u2162", "\u2163", "\u2164", "\u2165", "\u2166", "\u2167", "\u2168", "\u2169", "\u216a", "\u216b", "\u2170", "\u2171", "\u2172", "\u2173", "\u2174", "\u2175", "\u2176", "\u2177", "\u2178", "\u2179", "\u217a", "\u217b", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "X", "x", "IX", "\u216a", "\u216b", "XIII", "XIV", "XV", "XVI", "XVII", "XVIII"};
        StringBuilder sb = new StringBuilder();
        for (String s : newQs) {
            if (ObjectUtils.containsElement(number, s)) continue;
            sb.append(s).append(" ");
        }
        return sb.toString().trim();
    }

    private static InputStream getConfigStream(String resource, Class<?> clazz) throws Exception {
        InputStream configStream = clazz.getResourceAsStream(resource);
        if (configStream == null) {
            configStream = clazz.getClassLoader().getParent().getResourceAsStream(resource);
        }
        if (configStream == null) {
            throw new Exception("Cannot find " + resource + " !!!");
        }
        return configStream;
    }

    public static Properties initFromConfig(String configResource, Class<?> clazz) throws Exception {
        try (InputStream stream = SearchUtils.getConfigStream(configResource, clazz);){
            Properties properties = SearchUtils.initFromConfig(stream);
            return properties;
        }
    }

    private static Properties initFromConfig(InputStream stream) throws Exception {
        Properties properties = new Properties();
        properties.load(stream);
        return properties;
    }

    public static Map<String, List<String>> splitByYear(String q) {
        HashMap<String, List<String>> values = new HashMap<String, List<String>>();
        if (StringUtils.isEmpty(q)) {
            return values;
        }
        String yearAnyWhereRegexp = "(19|[2-9][0-9])\\d+";
        Matcher matcher = Pattern.compile(yearAnyWhereRegexp).matcher(q);
        HashSet<String> yearList = new HashSet<String>();
        ArrayList<String> keywords = new ArrayList<String>();
        while (matcher.find()) {
            String mayYear = matcher.group();
            if (mayYear.length() != 4) continue;
            yearList.add(mayYear);
        }
        if (yearList.isEmpty()) {
            return values;
        }
        for (String year : yearList) {
            q = q.replaceAll(year, "");
        }
        if (q.trim().length() <= 1) {
            return values;
        }
        keywords.add(q.trim());
        values.put("keywords", keywords);
        values.put("years", new ArrayList(yearList));
        return values;
    }

    public static boolean isLatin(String chars) {
        if (null == chars || StringUtils.isEmpty(chars)) {
            return true;
        }
        return StandardCharsets.ISO_8859_1.newEncoder().canEncode(chars);
    }

    public static String takeStrByPrefixLimit(String str, int prefixLimit) {
        if (StringUtils.isEmpty(str) || str.length() <= prefixLimit) {
            return str;
        }
        return str.substring(0, prefixLimit);
    }

    public static String delPunctuationChars(String str) {
        String regEx = "[\\\\`~!@#$%^&*()\\-+=_|{}':;\",\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&\u00d7\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }

    public static int keywordsTermCount(String q) {
        q = q.replaceAll("-", " ").trim();
        String[] newQs = q.split(REGEXP_SPACE_PATTERN);
        return newQs.length;
    }

    public static List<String> toLowercase(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        return list.stream().map(a -> a.toLowerCase()).collect(Collectors.toList());
    }

    public static String[] toLowercase(String[] list) {
        if (list == null || list.length == 0) {
            return list;
        }
        return (String[])Arrays.asList(list).stream().map(a -> a.toLowerCase()).collect(Collectors.toList()).toArray();
    }

    static {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            unsafe = (Unsafe)theUnsafe.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new Error(e);
        }
    }
}

